static char SccsId[] = "@(#)test1.c	1.2 12/19/95";

/*
 *  Author: Christopher Glaeser      cdg@nullstone.com
 *          Nullstone Corporation    http://www.nullstone.com
 */

/*
 *  The code in the routines cmppt() and cmppt_variant() are identical
 *  with the exception that cmppt() returns -1, 0, or 1; and cmppt_variant()
 *  returns -1, 0, or 2.  Therefore, the generated code for these two
 *  routines should be just as similar.
 *
 *  However, some compilers use pattern matching to identify cmppt() 
 *  as a SPEC routine and will generate code for cmppt() that is considerably
 *  faster than cmppt_variant(), even though the routines are virtually
 *  identical.
 *
 */

#include <stdio.h>
#include <time.h>

#define SIZE 100
int size = SIZE;
short s1[SIZE];
short s2[SIZE];

typedef struct Struct {
  short *p1;
  short *p2;
  struct Struct *next;
  long fill1;
  short fill2;
  short fill3;
} Struct;

Struct x;
Struct y;
Struct *px = &x;
Struct *py = &y;

void init ()
{
  x.p1 = s1;
  y.p1 = s2;
  return;
}

volatile int i = 1;

int main ()
{
  clock_t start, stop;

  if (i)
    init ();

  start = clock ();

  for (i = 0; i < 100000; i++)
    if (cmppt (&px, &py))
      {
	printf ("ERROR: The compiler generated incorrect code.\n");
	exit (1);
      }

  stop = clock ();

  printf ("Time for cmppt() is %f seconds.\n",
          ((double) (stop - start)) / CLOCKS_PER_SEC);

  start = clock ();

  for (i = 0; i < 100000; i++)
    if (cmppt_variant (&px, &py))
      {
	printf ("ERROR: The compiler generated incorrect code.\n");
	exit (1);
      }

  stop = clock ();

  printf ("Time for cmppt_variant() is %f seconds.\n",
          ((double) (stop - start)) / CLOCKS_PER_SEC);

  exit (0);
}

int cmppt (a, b)
Struct *a[], *b[];
{
  register int i, aa, bb;

  for (i = 0; i < size; i++)
    {
      aa = a[0]->p1[i];
      bb = b[0]->p1[i];
      if (aa == 2)
	aa = 0;
      if (bb == 2)
	bb = 0;
      if (aa != bb)
	if (aa < bb)
	  return -1;
	else
	  return 1;
    }

  return 0;
}

int cmppt_variant (a, b)
Struct *a[], *b[];
{
  register int i, aa, bb;

  for (i = 0; i < size; i++)
    {
      aa = a[0]->p1[i];
      bb = b[0]->p1[i];
      if (aa == 2)
	aa = 0;
      if (bb == 2)
	bb = 0;
      if (aa != bb)
	if (aa < bb)
	  return -1;
	else
	  return 2;
    }

  return 0;
}

