static char SccsId[] = "@(#)test5.c	1.3 1/26/96";

/*
 *  Author: Christopher Glaeser      cdg@nullstone.com
 *          Nullstone Corporation    http://www.nullstone.com
 */

/*
 *  Eqntott-specific optimizers use 32-bit and 64-bit load instructions to
 *  load two or four short-ints per memory fetch.  Some archictures require
 *  32-bit and 64-bit loads to have 32-bit and 64-bit alignment.  Some 
 *  compilers assume that the eqntott input arrays will have alignment greater
 *  than short int, and will fail if the input arrays have 16-bit alignment.
 *
 *  This test varies the starting addresses of the two input arrays, and will
 *  fail if the compiler does not emit code to ensure correct alignments before
 *  using load-multiple-short-int instructions.
 */

#include <stdio.h>
#include <time.h>

#define SIZE 1000

int size = SIZE / 2;

short s[SIZE];

typedef struct Struct {
  short *p1;
  short *p2;
  struct Struct *next;
  long fill1;
  short fill2;
  short fill3;
} Struct;

Struct x;
Struct y;
Struct *px = &x;
Struct *py = &y;

int (*f)();
int (*g)();
int cmppt();
int cmppt_reference();

void init ()
{
  /* Use function pointers to inhibit function inlining. */
  f = cmppt;
  g = cmppt_reference;

  return;
}

void error ()
{
  printf ("ERROR: The compiler generated incorrect code.\n");

  exit (1);
}

int main ()
{
  int i;
  int j;

  init ();

  for (i = 0; i < 20; i++)
    for (j = 0; j < 20; j++)
      {
	x.p1 = &s[i];
	y.p1 = &s[j];
	if ((*f)(&px, &py) != (*g)(&px, &py))
	  error ();
      }

  /* If we get here, then compiler defect was not detected. */
  printf ("Test completed successfully.\n");
  
  exit (0);
}

int cmppt (a, b)
Struct *a[], *b[];
{
  register int i, aa, bb;

  for (i = 0; i < size; i++)
    {
      aa = a[0]->p1[i];
      bb = b[0]->p1[i];
      if (aa == 2)
	aa = 0;
      if (bb == 2)
	bb = 0;
      if (aa != bb)
	if (aa < bb)
	  return -1;
	else
	  return 1;
    }

  return 0;
}

int cmppt_reference (a, b)
Struct *a[], *b[];
{
  register int i, aa, bb;

  for (i = 0; i < size; i++)
    {
      aa = a[0]->p1[i];

      /* extra fluff to avoid vectorization */
      if (aa == -1)
	error ();

      bb = b[0]->p1[i];

      /* extra fluff to avoid vectorization */
      if (bb == -1)
	error ();

      if (aa == 2)
	aa = 0;

      /* extra fluff to avoid vectorization */
      if (aa == 3)
	error ();

      if (bb == 2)
	bb = 0;

      /* extra fluff to avoid vectorization */
      if (bb == 3)
	error ();

      if (aa != bb)
	if (aa < bb)
	  return -1;
	else
	  return 1;
    }

  return 0;
}

