static char SccsId[] = "@(#)test2.c	1.2 12/19/95";

/*
 *  Author: Christopher Glaeser      cdg@nullstone.com
 *          Nullstone Corporation    http://www.nullstone.com
 */

/*
 *
 *  Some compilers use pattern matching to recognize the cmppt routine
 *  in the SPEC eqntott benchmark.  However, they sometimes recognize
 *  slight variations of this routine, but still emit the code for
 *  the original, thus generating incorrect code.  In the test below,
 *  the induction variable in the FOR loop runs from 1 to size, instead
 *  of from 0 to size as in the eqntott benchmark.  The test will fail
 *  if the compiler pattern matches this routine with the real cmppt()
 *  routine, since they are semantically different.
 *
 */

#include <stdio.h>

#define SIZE 100
int size = SIZE;
short s1[SIZE];
short s2[SIZE];

typedef struct Struct {
  short *p1;
  short *p2;
  struct Struct *next;
  long fill1;
  short fill2;
  short fill3;
} Struct;

Struct x;
Struct y;
Struct *px = &x;
Struct *py = &y;

void init ()
{
  x.p1 = s1;
  y.p1 = s2;
  s1[0] = 1;

  return;
}

volatile int i = 1;

int main ()
{
  if (i)
    init ();

  if (cmppt (&px, &py))
    {
      printf ("ERROR: The compiler generated incorrect code.\n");
      exit (1);
    }
  else
    {
      printf ("Test passed.\n");
      exit (0);
    }

  return;
}

int cmppt (a, b)
Struct *a[], *b[];
{
  register int i, aa, bb;

  /*
   *  In the real cmppt() routine, the FOR loops starts at 0.
   *  In this routine, we start the FOR loop at 1.  If the
   *  compiler incorrectly pattern matches to this routine
   *  and generates code that starts the FOR loop at 0, this
   *  program will emit an error message.
   */

  for (i = 1; i < size; i++)
    {
      aa = a[0]->p1[i];
      bb = b[0]->p1[i];
      if (aa == 2)
	aa = 0;
      if (bb == 2)
	bb = 0;
      if (aa != bb)
	if (aa < bb)
	  return -1;
	else
	  return 1;
    }

  return 0;
}

