! Optional additional character generators

! High Quality Character Generators
!
!   Decode routine for Gimm's alphabet characters
!
!   Crawford Currie and Gordon Hughes     October 1982
!   Character mirroring added, JGH        June    1988
!

%const %string (15) Font File = "EDWIN_FONT_FILE"

%routine DRAW CHAR (%integer CHARACTER, FONT, SIZE, ROT, Mirror)
   %record %format LIMS FORM (%integer START, FINISH)

   %constant %integer YES =  1,  NO  = 0

   %constant %integer EMPTY ALPHABET     = 0
   %constant %integer DEFAULT ALPHABET   = 0
   %constant %integer END OF DESCRIPTION = 9999
   %constant %integer UNIT RANGE         = 6000

   %integer BASE, LENGTH

   %own %integer START  = 0, FINISH = 0

   %own %integer NO OF ADDRESSES, NO OF ALPHABETS

   %own %real INTERNAL SCALING = 1
   %own %integer CURRENT ALPHABET = DEFAULT ALPHABET
   %own %integer START OF CURRENT ALPHABET = 1
   %own %integer INITIALISED = NO

   %integer POINTER
   %integer N, X Mirror, Y Mirror
   %integer RAISE PEN, NEGATIVE X
   %integer CHAN
   %integer I

   %long %real SinR, CosR, X, Y, Z, RANGE, CX, CY

   %integer %map CONTENTS (%integer WORD)
      %integer reference
      reference = start + (word-1) * 4
      %signal 14, 6 %if reference > finish
      %result == integer (reference)
   %end

   %routine initialise
      %on 9 %start
         UPDATE
         print string ("Connect fails on file ".Translate(font file));   NEWLINE
         %stop
      %finish
      connect file (Translate(font file), read only, base, length )
      start  = base
      finish = base + length

      no of addresses = contents (24)
      no of alphabets = contents (29)
      initialised = yes
   %end

   %integer %function START OF CHARACTER (%byte CHARACTER)
      %result = 0 %if current alphabet = 0
      %result = contents (start of current alphabet + character)
   %end

   %routine SELECT ALPHABET (%integer NEW ALPHABET)
      %return %if new alphabet = current alphabet
      %signal 14, 6 %if new alphabet > no of alphabets
      current alphabet = new alphabet
      start of current alphabet = contents (150 + new alphabet)
      %signal 14, 6 %if start of current alphabet = empty alphabet
   %end

   !
   !   Code of the routine
   !
   !   Set up code
   BASE = 0
   LENGTH = 0
   RAISE PEN = NO;   NEGATIVE X = NO;   RANGE = UNIT RANGE/SIZE
   %if Mirror & Mirror in X Axis # 0 %then Y Mirror = -1 %else Y Mirror = 1
   %if Mirror & Mirror in Y Axis # 0 %then X Mirror = -1 %else X Mirror = 1
   initialise %if initialised = no

   %return %unless 1 <= character <= 127
   %return %if (character=95 %and font<60) %or (font=63 %and 16<=character<32); ! Ignore these

   select alphabet (font)
   internal scaling = contents (start of current alphabet)
   internal scaling = internal scaling / range

   %if CHARACTER=' ' %start
       %if ROT=0 %then MOVE REL (X Mirror*SIZE, 0) %else %start
           MOVE REL (X Mirror * int (SIZE*Cos(ROT/DtoR)),
                     Y Mirror * int (SIZE*Sin(ROT/DtoR)))
       %finish
       %return
   %finish

   pointer = start of character (character)
   %return %if pointer = 0; ! Blank

   INQUIRE POSITION (I, N)
   CX = I;   CY = N
   %if ROT # 0 %start
       SinR = SIN (ROT/DtoR)
       CosR = COS (ROT/DtoR)
   %finish
   %cycle
      i = contents (pointer)
      N = i // 10000
      i = i - ( N * 10000 )
      %if N = 2 %start
         %if i = 0 %start
            raise pen = yes
         %finish %else %if i = 1 %start
            negative x = yes
         %finish %else %if i = end of description %start
            %return
         %finish
      %finish %else %start
         X = (i // 1000) * 10
         i = i - (int(X) * 100)
         Y = i // 100
         X = X + Y
         Y = i - (int(Y) * 100)
         X = X * internal scaling
         Y = Y * internal scaling
         %if negative X = yes %then negative X = no %and X = -X
         Y = -Y %if N = 1
         X = X Mirror * X
         Y = Y Mirror * Y
         Z = X*CosR - Y*SinR %and Y = X*SinR + Y*CosR %and X=Z %if ROT#0
         %if raise pen = no %start
            line abs (int(cx + x), int(cy + y))
         %finish %else %start
            raise pen = no
            move abs (int(cx + x), int(cy + y))
         %finish
      %finish
      pointer = pointer + 1
   %repeat %until pointer = 100097
%end

! PDF of software characters and marker deffinitions.
%end %of %list
%const %short %integer %array CHAR PDF (1:2000) = %c
    19,     0,    12,    20,   253,    19,   256,    19,   514,    19,
     2,    19,  -510,    19,  -512,    19,  -258,    19,   254,    19,
   766,    19,   256,    20,     3,    12,    20,  -515,    19,     6,
    19,  1536,    19,   250,    19, -1536,    20,   771,    12,    20,
     3,    19,  -518,    19,  1536,    19,  -762,    20,   253,    12,
    20,   771,    19, -1286,    20,     6,    19,  1786,    20,  -765,
    12,    20,     3,    19,   250,    20,  -765,    19,  1536,    20,
  -515,    19,   256,    19,   514,    19,     2,    19,  -510,    19,
  -512,    19,  -258,    19,   254,    19,   766,    19,   256,    20,
     3,    12,    20,     3,    19,   250,    20,  -765,    19,  1536,
    20,  -768,    12,    20, -1536,    19,  1536,    19,  -510,    20,
   252,    19,   514,    12,    20,  1536,    19, -1536,    19,   514,
    20,   252,    19,  -510,    12,    20,   250,    19,     6,    19,
   766,    20, -1024,    19,   514,    12,    20,     6,    19,   250,
    19,   514,    20, -1024,    19,   766,    12,    20,  3072,    12,
    20,  1794,    19,  -512,    19,   254,    19,   512,    19,     2,
    20,     2,    19,  -512,    19,     9,    19,   512,    19,   247,
    20,  1532,    12,    20,  1290,    19,  -256,    19,     3,    19,
   256,    19,   253,    20,   768,    19,  -256,    19,     3,    19,
   256,    19,   253,    20,  1270,    12,    20,   516,    19,  2048,
    20,  -260,    19,    13,    20,   764,    19, -2048,    20,   516,
    19,   243,    20,  2048,    12,    20,   770,    19,   511,    19,
  1024,    19,   257,    19,     2,    19, -1531,    19,     2,    19,
   257,    19,  1024,    19,   511,    20,  -766,    19,   243,    20,
  1536,    12,    20,   512,    19,  2061,    20, -1536,    19,  -512,
    19,   254,    19,   512,    19,     2,    20,  1781,    19,  -512,
    19,   254,    19,   512,    19,     2,    20,   766,    12,    20,
  2562,    19,  -258,    19, -1024,    19,  -510,    19,     2,    19,
  1286,    19,     2,    19,  -255,    19,  -512,    19,    -1,    19,
   254,    19,  2038,    20,   512,    12,    20,  1546,    19,  -256,
    19,     3,    19,   256,    19,   253,    20,  1782,    12,    20,
  2061,    19,  -512,    19,  -260,    19,   251,    19,   764,    19,
   512,    20,  1024,    12,    20,  1037,    19,   512,    19,   764,
    19,   251,    19,  -260,    19,  -512,    20,  2048,    12,    20,
  2306,    19, -1528,    20,  1536,    19, -1288,    20,  -252,    19,
  2048,    20,   762,    12,    20,  1538,    19,     8,    20,  -772,
    19,  2048,    20,   762,    12,    20,  2048,    19,     2,    19,
  -512,    19,   254,    19,   512,    19,  -258,    20,  1538,    12,
    20,   518,    19,  2048,    20,   762,    12,    20,  1536,    19,
     2,    19,   512,    19,   254,    19,  -512,    20,  1536,    12,
    20,   512,    19,  2061,    20,   755,    12,    20,   512,    19,
  2061,    20,   254,    19,   247,    19,  -258,    19, -1024,    19,
  -510,    19,     9,    19,   514,    19,  1024,    19,   766,    20,
   757,    12,    20,  1035,    19,   514,    19,   243,    20,  -512,
    19,  1024,    20,  1024,    12,    20,   523,    19,   514,    19,
  1024,    19,   766,    19,   254,    19, -1800,    19,   255,    19,
  2048,    20,   512,    12,    20,   525,    19,  2048,    19,   255,
    19,  -772,    19,   512,    19,   766,    19,   252,    19,  -258,
    19, -1024,    19,  -510,    20,  2814,    12,    20,  2048,    19,
    13,    19, -1290,    19,  2048,    20,   765,    12,    20,   514,
    19,   766,    19,  1024,    19,   514,    19,     4,    19,  -510,
    19, -1536,    19,     5,    19,  2048,    20,   755,    12,    20,
   518,    19,   514,    19,  1024,    19,   766,    19,   252,    19,
  -258,    19, -1024,    19,  -510,    19,     9,    19,   514,    19,
  1024,    19,   766,    20,   757,    12,    20,   525,    19,  2048,
    19, -1805,    20,  2560,    12,    20,  1031,    19,  -510,    19,
     2,    19,   514,    19,  1024,    19,   766,    19,   254,    19,
  -258,    19, -1024,    19,  -258,    19,   253,    19,   766,    19,
  1024,    19,   514,    19,     3,    19,  -510,    20,  1273,    12,
    20,   514,    19,   766,    19,  1024,    19,   514,    19,     9,
    19,  -510,    19, -1024,    19,  -258,    19,   253,    19,   766,
    19,  1024,    19,   514,    20,   760,    12,    20,  1542,    19,
     2,    19,   512,    19,   254,    19,  -512,    20,   764,    19,
  -512,    19,     2,    19,   512,    19,   254,    20,  1278,    12,
    20,  1542,    19,     2,    19,   512,    19,   254,    19,  -512,
    20,   250,    19,   514,    19,     2,    19,  -512,    19,   254,
    19,   512,    20,  1278,    12,    20,  2572,    19, -1798,    19,
  2298,    20,   512,    12,    20,  2568,    19, -2048,    20,   252,
    19,  2048,    20,   764,    12,    20,   524,    19,  2298,    19,
 -1798,    20,  2560,    12,    20,   779,    19,   514,    19,   512,
    19,   766,    19,   254,    19,  -515,    19,   254,    20,   508,
    19,  -512,    19,     2,    19,   512,    19,   254,    20,  1280,
    12,    20,  2560,    19, -1536,    19,  -510,    19,     9,    19,
   514,    19,  1024,    19,   766,    19,   249,    19,  -258,    19,
  -512,    19,  -510,    19,     3,    19,   514,    19,   512,    19,
   766,    20,   761,    12,    20,   519,    19,  2048,    20, -1799,
    19,    11,    19,   514,    19,  1024,    19,   766,    19,   245,
    20,   512,    12,    20,   512,    19,    13,    19,  1536,    19,
   766,    19,   254,    19,  -258,    19, -1536,    20,  1536,    19,
   766,    19,   253,    19,  -258,    19, -1536,    20,  2560,    12,
    20,  2571,    19,  -510,    19, -1024,    19,  -258,    19,   247,
    19,   766,    19,  1024,    19,   514,    20,   766,    12,    20,
  2048,    19, -1536,    19,    13,    19,  1536,    19,   766,    19,
   247,    19,  -258,    20,  1024,    12,    20,   519,    19,  1536,
    20,   518,    19, -2048,    19,   243,    19,  2048,    20,   512,
    12,    20,   512,    19,    13,    19,  2048,    20, -1798,    19,
  1536,    20,  1273,    12,    20,  2571,    19,  -510,    19, -1024,
    19,  -258,    19,   247,    19,   766,    19,  1024,    19,   514,
    19,     4,    19,  -512,    20,  1274,    12,    20,   512,    19,
    13,    20,  2298,    19, -2048,    20,  2054,    19,   243,    20,
   512,    12,    20,  1037,    19,  1024,    20,  -269,    19,    13,
    20,  -269,    19,  1024,    20,  1024,    12,    20,   514,    19,
   766,    19,  1024,    19,   514,    19,    11,    19,  -768,    20,
  1523,    12,    20,   512,    19,    13,    20,  2048,    19, -1798,
    19,  2297,    20,   512,    12,    20,   525,    19,   243,    19,
  2048,    20,   512,    12,    20,   512,    19,    13,    19,  1275,
    19,  1029,    19,   243,    20,   512,    12,    20,   512,    19,
    13,    19,  2291,    19,    13,    20,   755,    12,    20,  2048,
    19, -1024,    19,  -510,    19,     9,    19,   514,    19,  1024,
    19,   766,    19,   247,    19,  -258,    20,  1024,    12,    20,
   512,    19,    13,    19,  1536,    19,   766,    19,   254,    19,
  -258,    19, -1536,    20,  2809,    12,    20,  2048,    19, -1024,
    19,  -510,    19,     9,    19,   514,    19,  1024,    19,   766,
    19,   247,    19,  -258,    20,  -508,    19,  1276,    20,   512,
    12,    20,   512,    19,    13,    19,  1536,    19,   766,    19,
   254,    19,  -258,    19, -1536,    20,  1024,    19,  1273,    20,
   512,    12,    20,   514,    19,   766,    19,  1024,    19,   514,
    19,     3,    19,  -510,    19, -1024,    19,  -510,    19,     2,
    19,   514,    19,  1024,    19,   766,    20,   757,    12,    20,
  1536,    19,    13,    20, -1024,    19,  2048,    20,   755,    12,
    20,   525,    19,   245,    19,   766,    19,  1024,    19,   514,
    19,    11,    20,   755,    12,    20,   525,    19,  1267,    19,
  1037,    20,   755,    12,    20,   525,    19,   249,    19,   762,
    19,   518,    19,   762,    19,   518,    19,     7,    20,   755,
    12,    20,   512,    19,  2061,    20, -2048,    19,  2291,    20,
   512,    12,    20,  1536,    19,     7,    19, -1018,    20,  2048,
    19,  -774,    20,  1785,    12,    20,   525,    19,  2048,    19,
 -1805,    19,  2048,    20,   512,    12,    20,  2061,    19, -1024,
    19,   243,    19,  1024,    20,  1024,    12,    20,   525,    19,
  2291,    20,   512,    12,    20,  1037,    19,  1024,    19,   243,
    19, -1024,    20,  2048,    12,    20,   778,    19,   771,    19,
  1021,    20,  1014,    12,    20,   251,    19,  3072,    20,     5,
    12,    20,  2058,    19,  -765,    19,  -256,    19,  1021,    19,
   256,    20,  1270,    12,    20,  2562,    19,  -258,    19, -1024,
    19,  -510,    19,     3,    19,   514,    19,  1024,    19,   766,
    20,     2,    19,   249,    20,   512,    12,    20,   525,    19,
   243,    19,  1536,    19,   514,    19,     3,    19,  -510,    19,
 -1536,    20,  2809,    12,    20,  2565,    19,  -510,    19, -1024,
    19,  -258,    19,   253,    19,   766,    19,  1024,    19,   514,
    20,   766,    12,    20,  2562,    19,  -258,    19, -1024,    19,
  -510,    19,     3,    19,   514,    19,  1024,    19,   766,    20,
     8,    19,   243,    20,   512,    12,    20,   516,    19,  2048,
    19,     1,    19,  -510,    19, -1024,    19,  -258,    19,   253,
    19,   766,    19,  1024,    19,   514,    20,   766,    12,    20,
   768,    19,    11,    19,   514,    19,   512,    19,   766,    20,
 -1284,    19,   768,    20,  1785,    12,    20,   766,    19,   766,
    19,  1024,    19,   514,    19,     7,    19,  -510,    19, -1024,
    19,  -258,    19,   253,    19,   766,    19,  1024,    19,   514,
    20,   766,    12,    20,   512,    19,    13,    20,   248,    19,
   514,    19,  1024,    19,   766,    19,   251,    20,   512,    12,
    20,  1034,    19,     0,    20,   254,    19,   250,    19,   766,
    19,   512,    20,  1024,    12,    20,   766,    19,   766,    19,
  1024,    19,   514,    19,    10,    20,     2,    19,     0,    20,
   758,    12,    20,   512,    19,    13,    20,  1786,    19, -1283,
    19,  2300,    20,   512,    12,    20,  1037,    19,   245,    19,
   766,    19,   512,    20,  1024,    12,    20,  2560,    19,     5,
    19,  -510,    19,  -258,    19,  -510,    19,  -258,    20,     2,
    19,   249,    20,  1029,    19,   251,    20,  1536,    12,    20,
   512,    19,     7,    20,   254,    19,   514,    19,  1024,    19,
   766,    19,   251,    20,   512,    12,    20,  2562,    19,     3,
    19,  -510,    19, -1024,    19,  -258,    19,   253,    19,   766,
    19,  1024,    19,   514,    20,   766,    12,    20,   764,    19,
    11,    20,   254,    19,   514,    19,  1024,    19,   766,    19,
   253,    19,  -258,    19, -1024,    19,  -510,    20,  2814,    12,
    20,  2562,    19,  -258,    19, -1024,    19,  -510,    19,     3,
    19,   514,    19,  1024,    19,   766,    20,     2,    19,   245,
    20,   516,    12,    20,   512,    19,     7,    20,   254,    19,
   514,    19,  1024,    19,   766,    20,   763,    12,    20,   514,
    19,   766,    19,  1024,    19,   514,    19,     2,    19, -2048,
    19,     1,    19,   514,    19,  1024,    19,   767,    20,   762,
    12,    20,   778,    19,  1024,    20,  -509,    19,   245,    19,
   766,    19,   512,    20,   768,    12,    20,   519,    19,   251,
    19,   766,    19,  1024,    19,   514,    20,     5,    19,   249,
    20,   512,    12,    20,   519,    19,  1273,    19,  1031,    20,
   761,    12,    20,   519,    19,   251,    19,   766,    19,   514,
    20,     2,    19,   254,    19,   766,    19,   514,    19,     5,
    20,   761,    12,    20,   512,    19,  2055,    20, -2048,    19,
  2297,    20,   512,    12,    20,   766,    19,   766,    19,  1024,
    19,   514,    19,     9,    20, -2048,    19,   251,    19,   766,
    19,  1024,    19,   514,    20,   766,    12,    20,   519,    19,
  2048,    19, -1799,    19,  2048,    20,   512,    12,    20,  2317,
    19,  -512,    19,  -258,    19,   252,    19,  -257,    19,   767,
    19,   253,    19,   766,    19,   512,    20,   768,    12,    20,
  1549,    19,   250,    20,   255,    19,   250,    20,  1536,    12,
    20,   781,    19,   512,    19,   766,    19,   252,    19,   767,
    19,  -257,    19,   253,    19,  -258,    19,  -512,    20,  2304,
    12,    20,   523,    19,   258,    19,   256,    19,  1278,    19,
   256,    19,   258,    20,   755,    12,    12,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   127,  1777,   126,  1762,
   125,  1741,   124,  1730,   123,  1709,   122,  1698,   121,  1675,
   120,  1664,   119,  1643,   118,  1634,   117,  1617,   116,  1602,
   115,  1579,   114,  1564,   113,  1541,   112,  1518,   111,  1497,
   110,  1480,   109,  1457,   108,  1446,   107,  1433,   106,  1416,
   105,  1401,   104,  1384,   103,  1357,   102,  1340,   101,  1317,
   100,  1294,    99,  1275,    98,  1258,    97,  1235,    96,  1222,
    95,  1215,    94,  1206,    93,  1195,    92,  1188,    91,  1177,
    90,  1166,    89,  1153,    88,  1142,    87,  1125,    86,  1116,
    85,  1101,    84,  1090,    83,  1063,    82,  1042,    81,  1017,
    80,  1000,    79,   979,    78,   968,    77,   955,    76,   946,
    75,   933,    74,   918,    73,   903,    72,   888,    71,   865,
    70,   852,    69,   837,    68,   820,    67,   801,    66,   774,
    65,   755,    64,   722,    63,   695,    62,   686,    61,   675,
    60,   666,    59,   641,    58,   618,    57,   591,    56,   556,
    55,   547,    54,   520,    53,   499,    52,   488,    51,   465,
    50,   446,    49,   433,    48,   408,    47,   401,    46,   388,
    45,   381,    44,   366,    43,   355,    42,   340,    41,   325,
    40,   310,    39,   297,    38,   270,    37,   243,    36,   216,
    35,   197,    34,   174,    33,   151,    32,   148,    10,   137,
     9,   126,     8,   115,     7,   104,     6,    93,     5,    62,
     4,    51,     3,    40,     2,    27,     1,     4,     0,     1

%list

%end %of %file
