/* Masscomp Graphics Processor -  EDWIN c interface */

/* #include <errno.h> */
#include <stdio.h>
/* #include <sgtty.h> */

extern char *getenv();

/* Local vars */
static  char    Font;
static  int     Highlight = 0 ;
static  int     GrMode    = 0 ;
static  int     Viewno    = 2 ;
static  int     CurrX = 0;
static  int     CurrY = 0;
static  int     CurrS = 0;

/* Cursor Details */
static short proto_cross_image [16] = {
   0x0080, 0x0080, 0x0080, 0x0080,
   0x0080, 0x0080, 0x0080, 0x0080,
   0x7FFF, 0x0080, 0x0080, 0x0080,
   0x0080, 0x0080, 0x0080, 0x0080     };
#define CURSOR_X_OFFSET 8
#define CURSOR_Y_OFFSET 8

/* Colour modes */
static int FillModes [] = {0, 1, 3, 4, 5};
static int ColTable  [] = {0, 15, 4, 1, 2, 6, 8, 5,
                          10, 3, 7, 9, 11, 12, 13, 14};
static int Colours [] = {        0, 0x00A000, 0xA00000, 0x606000,
                          0x0000A0, 0x006080, 0x500080, 0x305050,
                          0xE0E000, 0x00F000, 0xF00000, 0xA0A010,
                          0x3030F0, 0x60C0A0, 0xC060A0, 0xF0F0F0 };

static int CCol = 15;

button (x, y, s)
   unsigned int x, y, s;
{
   CurrX = x;
   CurrY = y;
   CurrS = s;
}

EDWIN_DD_INIT (maxx, maxy)
        int *maxx, *maxy;
{
   int xl, xr, yb, yt, place;
   mgiasngp (0, 0);
   mgigetv (&Viewno);
   mgigetvcoor (Viewno, &xl, &yb, &xr, &yt, &place);
   mgiclearpln (2, -1, 0);
   *maxx = xr;
   *maxy = yt;
   Font = getenv ("LATTICE_FONT");
   if (Font == NULL) Font = "/usr/lib/font/5x7";
   mgifetchgf (0, Font);
   mgicms (1, 15, Colours[1]);
   mgiloadcurs (CURSOR_X_OFFSET, CURSOR_Y_OFFSET, 31, proto_cross_image);
   mgicursmode (7);
   mgibuttonint (button);
}

EDWIN_DD_TERM ()
{
   mgideagp ();
}

EDWIN_DD_UPDATE ()
{
}

EDWIN_DD_CLEAR ()
{
   mgiclearpln (2, -1, 0);
}

EDWIN_DD_DOT (x, y)
        int x, y;
{
   /* Draw a dot at the point */
   mgil (x, y, x, y);
}

EDWIN_DD_LINE (ox,oy,nx,ny)
        int ox,oy,nx,ny;
{
   /* draw a line */
   mgil (ox, oy, nx, ny);
}

EDWIN_DD_RECT(lx,ly,nx,ny)
        int lx,ly,nx,ny;
{
   /* draw a rectangle */
   mgibox (lx, ly, nx, ny);
}

EDWIN_DD_CIRCLE(x, y, rad)
        int x, y, rad;
{
   mgic (x, y, rad);
}

EDWIN_DD_POLY(count,xs,ys)
        int count;
        int xs[], ys[];
{
   /* draw a polygon */
   mgipoly (count, xs, ys);
}

EDWIN_DD_TEXT(sx,sy,ch)
        int sx,sy;
        char *ch;
{
   /* write some text out */
   mgigfc (sx, sy, ch);
}


EDWIN_DD_COL (Colnum)
        int Colnum;
{
   mgihue (ColTable[Colnum]);
}

EDWIN_DD_MODE (Mode)
        int Mode;
{
   /* Setting the raster operation mode */
   mgimodfunc (3, FillModes[Mode], 3);
}

EDWIN_DD_FILL(Mode)
        int Mode;
{
}

EDWIN___B_SAM (state,x,y)
        int *state, *x, *y;
{
   /* sample cursor events etc. */
   *state = CurrS;
   *x     = CurrX;
   *y     = CurrY;
}

EDWIN___B_REQ (state,x,y)
        int *state, *x, *y;
{
   while (1) {
     if (CurrS) {
        *state = CurrS;
        *x     = CurrX;
        *y     = CurrY;
        return;
     }
   }
}

EDWIN_SCREEN_TTGET ()
{
   int i;
   i = TTGET ();
   return (i);
}
