#include "fontlist.h"
#include <sgtty.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/gfxsw.h>

static  long  Pid;
static  int   DeviceModel = 'W';
static  int   Highlight = 0;
static  int   GrMode    = 0;
static  char  Product   = '?';
static  struct timeval poll = {0};

struct pixwin *Paper;
struct pixfont *font;
struct gfxsubwindow mygfx;

extern char *APPLICATIONTITLE();

#define MAXSTIPPLE 10
typedef struct pixrect PIXRECT;

#define	CMS_NAME        "mapname"
#define	CMS_SIZE	8

#define cms_rgbsetup(r,g,b) \
   (r)[0]  = 0;    (g)[0]  = 0;    (b)[0] = 0; \
   (r)[1]  = 0;    (g)[1]  = 255;  (b)[1] = 0; \
   (r)[2]  = 255;  (g)[2]  = 0;    (b)[2] = 0; \
   (r)[3]  = 255;  (g)[3]  = 255;  (b)[3] = 0; \
   (r)[4]  = 0;    (g)[4]  = 0;    (b)[4] = 255; \
   (r)[5]  = 0;    (g)[5]  = 255;  (b)[5] = 255; \
   (r)[6]  = 255;  (g)[6]  = 0;    (b)[6] = 255; \
   (r)[7]  = 255;  (g)[7]  = 255;  (b)[7] = 255; \
 
DEFINE_CURSOR(edcursor, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

static PIXRECT *stipple [MAXSTIPPLE + 1];
static PIXRECT *memraster;
 
static Event eventw , *LLEvent = &eventw;
static int EdWinX = 0;
static int EdNewX = 100;
static int EdWinY = 0;
static int EdNewY = 100;
extern int CharX;
extern int CharY;
extern int OffY;
static int OpMap [] = {PIX_SRC, PIX_SRC&PIX_DST, PIX_SRC|PIX_DST,
                       PIX_SRC^PIX_DST, PIX_NOT(PIX_DST)};
static int ColMap [] = {0,7,4,1,2,6,3,5};
static int RasterOp = PIX_SRC;
static int CCol = 1;
static int PixelDepth = 1;
static int FillMode = 0;
static int GraphicsActive = 0;
static int ScreenDirty = 0;
       struct gfxsubwindow *gfx;
static Frame frame;
static Canvas canvas;
static int canvasfd;
static int framefd;
static int first = 0;
static int flag = 0;

static short d_ic_image[258] = {
#include "draft.icon"
};
mpr_static(gfxic_mpr_d, 64, 64, 1, d_ic_image);

static short a_ic_image[258] = {
#include "artview.icon"
};
mpr_static(gfxic_mpr_a, 64, 64, 1, a_ic_image);

/* Design the stipple patterns. Maybe quicker this way than with IconTool.
   Stipple patterns try to match the JGH/Versatec definitions
*/

#define line(x1,y1,x2,y2) pr_vector(pr,x1,y1,x2,y2,PIX_SET,1)

horizline(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 32; i = i + 4) line(0,i,31,i);
}

vertline(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 32; i = i + 4) line(i,0,i,31);
}

backdiagonal(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 32 ; i = i + 4) {
      line(0,i,32 - i,32);
      line(i,0,32,32 - i);
   }
}

solid(pr)
   PIXRECT *pr;
{
   pr_rop(pr,0,0,32,32,PIX_SET,NULL,0,0);
}

diagonal(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 32; i = i + 4) {
      line(0,i,i,0);
      line(i,32,32,i);
   }
}

crosshatch(pr)
   PIXRECT *pr;
{
   diagonal(pr);
   backdiagonal(pr);
   /* maybe should do a pixrect copy ? */
}

grid(pr)
   PIXRECT *pr;
{
   horizline(pr);
   vertline(pr);
}

stipplep(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 32; i = i + 4) line(0,i,31,i);
   for (i = 0; i != 32; i = i + 4) pr_vector(pr,i,0,i,31,PIX_CLR,0);
   for (i = 0; i != 32; i = i + 4) pr_vector(pr,0,i,31,i,PIX_NOT(PIX_DST),1);
}   
   
brick(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 12; i = i + 4) line(0,i,31,i);
   for (i = 0;i != 32; i = i + 8) {
      line(i,0,i,4);
      line(i + 4,4,i + 4,8);
   }
   for (i = 8; i != 32; i = i + 8) {
      if ((pr_rop(pr,0,i,32,8,PIX_SRC,pr,0,0)) == PIX_ERR)
         fprintf("brick pr_rop failed\n");
   }
}

checker(pr)
   PIXRECT *pr;
{
   int i;

   for (i = 0; i != 32; i = i + 8) pr_rop(pr,0,i,32,4,PIX_SET,NULL,0,0);
   for (i = 0; i != 32; i = i + 8) pr_rop(pr,i,0,4,32,PIX_NOT(PIX_DST),NULL,0,0);
}

/* build up all the stipple patterns */

EDWIN_BUILD_STIPPLE ()
{
   int i;

   for (i = 0 ; i <= MAXSTIPPLE ; i ++) stipple[i] = mem_create(32,32,1);
   solid(stipple[0]);
   solid(stipple[1]);
   horizline(stipple[2]);
   vertline(stipple[3]);
   backdiagonal(stipple[4]);
   diagonal(stipple[5]);
   crosshatch(stipple[6]);
   grid(stipple[7]);
   stipplep(stipple[8]);
   checker(stipple[9]);
   brick(stipple[10]);
}

EDWIN_DD_UPDATE ()
{
   pw_reset(Paper);
   GraphicsActive = 0;
}

WindowCheck ()
{ 
   ScreenDirty = 0;
   USERREFRESH ();
}

EDWIN_DD_TERM()
{
   if (DeviceModel == 'S') {
   	wmgr_close(framefd,framefd);
	notify_dispatch();
   } else {
        gfxsw_done(gfx);
   }
}

EDWIN_DD_CLEAR ()
{
   pw_write (Paper, 0, 0, EdWinX, EdWinY, PIX_CLR, NULL, 0, 0);
   ScreenDirty = 0;
   SETDEVICEVIEWPORT(EdWinX,EdWinY);
}

EDWIN_DD_COL (ColNum)
   int ColNum;
{
   int planes;

   if (PixelDepth != 1) {
      if (CCol > 7) { CCol = 1; }
      CCol = ColMap[ColNum];
      if (RasterOp != OpMap[3]) {
         planes = 7;
      } else {
         planes = CCol;
      }
      pw_putattributes (Paper, &planes);
   } else {
      CCol = ColNum;
      if (CCol > 1) CCol = 1;
   }
   if (ScreenDirty != 0) WindowCheck();
}

EDWIN_DD_MODE (Mode)
   int Mode;
{
   int planes;

   RasterOp = OpMap[Mode];
   if (PixelDepth != 1) {
      if (Mode != 3) {
         planes = 7;
      } else {
         planes = CCol;
      }
      pw_putattributes(Paper, &planes);
   }
   if (ScreenDirty != 0) WindowCheck ();
}

EDWIN_DD_FILL (Mode)
   int Mode;
{
   FillMode = Mode;
   if (FillMode > MAXSTIPPLE) FillMode = 1;
   if (ScreenDirty != 0) WindowCheck();
}

EDWIN_DD_DOT (x, y)
      int x, y;
{
   GraphicsActive = 1;
   pw_put (Paper, x, y, PIX_COLOR(CCol)|RasterOp);
}

#define dddrawline(lx,ly,nx,ny)                         \
pw_vector(Paper,lx,EdWinY - ly, nx, EdWinY - ny, PIX_COLOR(CCol)|RasterOp, CCol)

EDWIN_DD_LINE (ox, oy, nx, ny)
   int ox, oy, nx, ny;
{
   GraphicsActive = 1;
   dddrawline(ox,oy,nx,ny);
   if (ScreenDirty != 0) WindowCheck ();
}

EDWIN_DD_RECT (lx, ly, nx, ny)
   int lx, ly, nx, ny;
{
   GraphicsActive = 1;
   if (RasterOp == PIX_NOT(PIX_DST)) {
      pw_write (Paper, lx, EdWinY-ny, nx-lx, ny-ly+1,
                PIX_COLOR(CCol)|RasterOp, NULL, 0, 0);
   } else {
      if (CCol == 0) {
         pw_write (Paper, lx, EdWinY-ny, nx-lx, ny-ly+1, PIX_CLR, NULL, 0, 0);
      } else {
         pw_replrop(Paper, lx, EdWinY-ny, nx-lx, ny-ly+1,
              PIX_COLOR(CCol) | RasterOp, stipple[FillMode], lx, (EdWinY-ny));
         /* give it a boundary */
         dddrawline(lx,ly,nx,ly);
         dddrawline(nx,ly,nx,ny);
         dddrawline(nx,ny,lx,ny);
         dddrawline(lx,ny,lx,ly);
      }
   }
   if (ScreenDirty != 0) WindowCheck ();
}

static u_char red[CMS_SIZE], green[CMS_SIZE], blue[CMS_SIZE];
 
EDWIN_DD_TEXT (sx, sy, ch)
   int sx, sy;
   char *ch;
{
   GraphicsActive = 1;
   if (PixelDepth == 1) {
      pw_text(Paper,sx,EdWinY-sy,PIX_SRC,font,ch);
   } else {
      pw_text(Paper,sx,EdWinY-sy,PIX_COLOR(CCol)|PIX_SRC,font,ch);
   }
   if (ScreenDirty != 0) WindowCheck ();
}

EDWIN_DD_POLY (n, x, y)
   int n;
   int x[], y[];
{
   struct pr_pos vlist [255];
   int npts[1];
   int MinX, MinY;
   int i;

   GraphicsActive = 1;
   MinX = x[1];
   MinY = y[1];
   for (i=0; i<n; i++) {
     vlist[i].x = x[i];
     vlist[i].y = EdWinY - y[i];
     if (MinX > x[i]) MinX = x[i];
     if (MinY > y[i]) MinY = EdWinY - y[i];
   }
   npts[0] = n-1;
   pw_polygon_2 (Paper, 0, 0, 1, npts, vlist, PIX_COLOR(CCol) | RasterOp, 
                 stipple[FillMode], 0, 0);
   for (i=1; i<n; i++) { dddrawline (x[i-1], y[i-1], x[i], y[i]); }
   if (ScreenDirty != 0) WindowCheck ();
}

extern int errno;
static InputInit  = 0;

EDWIN___B_SAM (state, x, y)
         int *state, *x, *y;
{
   struct inputevent  LLEvent;
   struct inputmask   Mask;

   if (DeviceModel == 'S') {
     DFT_SAM (state, x, y);
   } else {
      input_imnull (&Mask);
      Mask.im_flags = IM_ASCII;
      win_setinputcodebit (&Mask, MS_LEFT);
      win_setinputcodebit (&Mask, MS_RIGHT);
      win_setinputcodebit (&Mask, MS_MIDDLE);
      /*win_setinputcodebit  (&Mask, LOC_MOVE);*/
      win_set_kbd_mask (gfx->gfx_windowfd, &Mask);
      win_set_pick_mask (gfx->gfx_windowfd, &Mask);
      InputInit = 1;
      while (input_readevent(gfx->gfx_windowfd,&LLEvent) != -1) {}
      while (1) {
         if (input_readevent(gfx->gfx_windowfd,&LLEvent) == -1) {
            if (errno != EWOULDBLOCK) {
               EDWIN_DD_UPDATE();
               printf ("input_readevent fails ! %d \n", errno);
               break;
            }
         } else break;
      }
      if (ScreenDirty != 0) WindowCheck ();
      if (LLEvent.ie_code == LOC_MOVE )         *state = 0;
      else if (LLEvent.ie_code == MS_LEFT )     *state = 4;
      else if (LLEvent.ie_code == MS_RIGHT )    *state = 2;
      else if (LLEvent.ie_code == MS_MIDDLE )   *state = 1;
      else *state = LLEvent.ie_code;
      *x = LLEvent.ie_locx;
      *y = EdWinY - LLEvent.ie_locy;
   }
}

EDWIN___B_REQ (state, x, y)
         int *state, *x, *y;
{
   *state = 0;
   while (*state == 0) EDWIN___B_SAM (state, x, y);
}

EDWIN_DD_INTERRUPT(state)
   int *state;
{
      int ibits, nfds;

      *state = 0;
      if(DeviceModel != 'S') return;
      ibits = 1<<framefd;
      ibits |= 1<<canvasfd;
      nfds = select(8*sizeof(ibits),&ibits,(int *)0,(int *)0,&poll);

      if (nfds ==-1) {
         if (errno != EINTR){
               fprintf(stderr,"select failed\n");
               window_done(canvas);
               exit(1);
			}
      } else if (nfds > 0) {
     		*state = event_id(LLEvent);
      }
}

EDWIN___B_TTGET ()
{
   struct inputevent TTEvent;
   char ch;
	int state, x, y;

   if (DeviceModel == 'S') {
	state = 0;
        window_set(canvas,WIN_CONSUME_PICK_EVENT, WIN_NO_EVENTS,0);
        while (1) {
	   EDWIN___B_SAM(&state, &x, &y);
           if (event_id(LLEvent) == MS_LEFT)   continue;
           if (event_id(LLEvent) == MS_RIGHT)  continue;
           if (event_id(LLEvent) == MS_MIDDLE) continue;
           break;
        }
        if (state >= 128) state = 0;
	return(state);
   } else {
   	while (1) {
           if (ScreenDirty != 0) WindowCheck ();
      	   if (input_readevent(gfx->gfx_windowfd, &TTEvent) == -1) {
              if (errno == EWOULDBLOCK) {
                 read (1, &ch, 1);
           	if (ch == 10) { ch = 13; }
           	return (ch);
              }
              fprintf (stderr, "input_readevent fails ! %d \n", errno);
              EDWIN_DD_TERM();
      	   }
           if (TTEvent.ie_code > 0 && TTEvent.ie_code < 128) break;
           return (0);
   	}
   	return (TTEvent.ie_code);
   }
}

EDWIN_DD_REINIT()
{
   void redraw();

   if (DeviceModel == 'S') {
     notify_dispatch();
     wmgr_open(framefd,framefd);
     notify_dispatch();
     if (Product == 'D') redraw(); else EDWIN_DD_CLEAR();
   }
   ScreenDirty = 0;
   flag = 0;
}

EDWIN_DD_INIT (argc , argv, dev)
   int argc ;
   char **argv ;
{
   int ibits, nfds;
   Cursor dftcursor;
   Pixwin  *pw;
   struct pr_subregion bound ;
   struct inputmask Mask ;
   char *name;
   Icon Draft_Icon;
   void repaint_proc(), event_proc(), resize_proc();
   static Notify_value my_notice_destroy();
   int Edsigwinch ();

   DeviceModel = dev;
   if (dev == 'W') {
      /* This section is if we are in a GFXTOOL */
      gfx = gfxsw_init (0, argv);
      if (gfx == (struct gfxsubwindow *)0) {
         fprintf(stderr, "open failed !\n") ;
         exit(1) ; }
      Paper = gfx -> gfx_pixwin;   /* Paper is used by Edsigwinch */
      signal (SIGWINCH, Edsigwinch);

      Pid = getpid() ;
      win_setowner(gfx->gfx_windowfd, Pid) ;

      win_getcursor(gfx->gfx_windowfd, &edcursor);
      edcursor.cur_function = PIX_SRC^PIX_DST;
      win_setcursor(gfx->gfx_windowfd, &edcursor);

   } else {
      /* This section is if we are from SUNTOOLS (DRAFT) */
      char * Chartest;
      Draft_Icon  = 0;
      if ((Chartest = APPLICATIONTITLE ()) != NULL ) {
         Product = *(Chartest);
         if (Product == 'A') {
            Draft_Icon  = icon_create(ICON_IMAGE, &gfxic_mpr_a, 0);
         } else if (Product == 'D') {
            Draft_Icon  = icon_create(ICON_IMAGE, &gfxic_mpr_d, 0);
         }
      }
      frame = window_create(NULL, FRAME,
                            FRAME_LABEL, APPLICATIONTITLE(),
                            FRAME_SHOW_LABEL, TRUE,
                            WIN_WIDTH, 1147,
                            WIN_HEIGHT, 895,
                            WIN_X, 3,
                            WIN_Y, 0,
                            FRAME_ICON,  Draft_Icon,
                            WIN_ERROR_MSG, "cant create frame",0);
      canvas = window_create(frame,CANVAS,
                             CANVAS_FIXED_IMAGE, FALSE,
                             CANVAS_RETAINED, FALSE,
                             CANVAS_AUTO_CLEAR, FALSE,
                             CANVAS_AUTO_EXPAND, TRUE,
                             CANVAS_AUTO_SHRINK, TRUE,
                             WIN_EVENT_PROC, event_proc,
                             CANVAS_REPAINT_PROC, repaint_proc,
                             CANVAS_RESIZE_PROC, resize_proc,
                             WIN_ERROR_MSG, "cant create canvas",0);
      window_set(frame, WIN_SHOW, TRUE, 0);
      (void) notify_dispatch();
      window_set(canvas,WIN_CONSUME_PICK_EVENT, WIN_NO_EVENTS,0);
      window_set(canvas,WIN_CONSUME_KBD_EVENT, WIN_ASCII_EVENTS,0);
      (void) notify_do_dispatch();
      (void) notify_interpose_destroy_func(frame, my_notice_destroy);
      framefd = (int)window_get(frame, WIN_FD);
      canvasfd = (int)window_get(canvas, WIN_FD);

      dftcursor = window_get(canvas,WIN_CURSOR);
      cursor_set(dftcursor,CURSOR_OP, PIX_SRC^PIX_DST, 0);
      window_set(canvas,WIN_CURSOR,dftcursor,0);

      window_set(canvas,WIN_INPUT_DESIGNEE,window_get(canvas,WIN_DEVICE_NUMBER),
                 0);

      EdWinX = (int)window_get(canvas, CANVAS_WIDTH);
      EdWinY = (int)window_get(canvas, CANVAS_HEIGHT);

      gfx = &mygfx;
      gfx->gfx_pixwin = canvas_pixwin(canvas);
      Paper = gfx -> gfx_pixwin;
   }

   /* find out the depth of colour */
   PixelDepth = Paper->pw_pixrect->pr_depth;
   if (PixelDepth != 1) {
      SETMAXCOLOURS (8);
      cms_rgbsetup(red,green,blue);
      pw_setcmsname(Paper,CMS_NAME);
      pw_putcolormap(Paper,0,CMS_SIZE,red,green,blue);
   } else {
      SETMAXCOLOURS (0);
   }

   /* Set up the Stipple Styles */
   EDWIN_BUILD_STIPPLE();

   /* Check on the Font file */
   if ((font = pf_default()) == NULL) {
      fprintf(stderr, "Unable to access default font file.\n") ; }
   pf_textbound(&bound, 1, font, "A") ;
   CharX = bound.size.x ;
   CharY = bound.size.y ;
   OffY  = CharY + bound.pos.y  ;

   pw_write (Paper, 0, 0, EdWinX, EdWinY, PIX_CLR, NULL, 0, 0);
}

Edsigwinch ()
{
   pw_damaged (Paper);
   pw_donedamaged (Paper);
   EdNewX = win_getwidth (gfx->gfx_windowfd);
   EdNewY = win_getheight (gfx->gfx_windowfd);
   ScreenDirty = 1;
   if (EdNewX != EdWinX || EdNewY != EdWinY) {
      SETDEVICEVIEWPORT (EdNewX, EdNewY);
      EdWinX = EdNewX;
      EdWinY = EdNewY;
   }
   pw_write(Paper, 0, 0, EdWinX, EdWinY, PIX_CLR, NULL, 0, 0);
   if (GraphicsActive == 0) {
     WindowCheck();
   }
}

/* The following interface is for DRAFT support on Suns (only) */

DDInitEvents()
{
        window_set(canvas, WIN_CONSUME_PICK_EVENTS, WIN_NO_EVENTS,
                           WIN_MOUSE_BUTTONS, LOC_MOVE, 0, 0);
        window_set(canvas, WIN_IGNORE_PICK_EVENT, WIN_UP_EVENTS,0);
}

GET_NEW_FONT(NewWidth, NewHeight)
int NewWidth, NewHeight;
{
        struct pr_subregion bound;
        extern int CharX, CharY, OffY;
        static int currentfont = 0;
        int NewCharX, NewCharY, fontselect, n = 65, m = 50;

        NewCharX = NewWidth/n;
        NewCharY = NewHeight/m;
 
        for (fontselect = 0;fontselect<max_no_fonts;++fontselect) {
            if((font_list[fontselect].width <= NewCharX) &&
               (font_list[fontselect].height <= NewCharY)) break;
        } 
 
        if(fontselect==max_no_fonts) fontselect--;
        /*printf("newwidth = %d newheight = %d\n",NewWidth,NewHeight);
        printf("newfont = %d oldfont = %d\n",fontselect,currentfont);
        printf("newx = %d fontx = %d\n",NewCharX,font_list[fontselect].width);*/
        if (fontselect == currentfont) return;
        pf_close(font);
        currentfont = fontselect;
        if ((font = pf_open(font_list[currentfont].name)) == NULL ) {
        fprintf(stderr, "Unable to access default font file.\n") ; }

        pf_textbound(&bound, 1, font, "A") ;

        CharX = bound.size.x ;
        CharY = bound.size.y ;
        OffY  = CharY + bound.pos.y  ;
}
        

DFT_SAM (state, x, y)
   int *state, *x, *y;
{
   void redraw();
   
   DDInitEvents();

   while (1) {
      int ibits, nfds;

      while(flag == 1) redraw();
      if (ScreenDirty == 1) {
         WindowCheck ();
         *state = 0;
         *x = 0;
         *y = 0;
         return;
      }

      ibits = 1<<framefd;
      ibits |= 1<<canvasfd;
      nfds = select(8*sizeof(ibits),&ibits,(int *)0,(int *)0,
                                         (struct timeval *)0);

      if (nfds ==-1) {
          if (errno == EINTR) continue;
          else {
               fprintf(stderr,"select failed\n");
               window_done(canvas);
               exit(1);}
      }

      if (ibits & (1<<canvasfd)) { 
         switch (event_id(LLEvent)) {

         case LOC_MOVE    : /*fprintf(stderr,"locmove\n"); */ *state = 0; break;
         case MS_LEFT     : /*fprintf(stderr,"msleft\n");  */ *state = 4; break;
         case MS_RIGHT    : /*fprintf(stderr,"right\n");   */ *state = 2; break;
         case MS_MIDDLE   : /*fprintf(stderr,"middle\n");  */ *state = 1; break;
         case WIN_REPAINT : /*fprintf(stderr,"repaint\n"); */ continue;
         case WIN_RESIZE  : /*fprintf(stderr,"resize\n");  */ continue;
         case KBD_REQUEST : /*fprintf(stderr,"req\n");     */ continue;
         case KBD_USE     : /*fprintf(stderr,"use\n");     */ *state = 0; break;
         case KBD_DONE    : /*fprintf(stderr,"done\n");  */ *state=32515; break;
                
         default : *state = event_id(LLEvent);/* fprintf(stderr,
                                                     "DEFAULT %d\n",state);*/
         }

         *x = event_x(LLEvent);
         *y = EdWinY - event_y(LLEvent);
         break;
      }

    }
    window_set(canvas, WIN_CONSUME_PICK_EVENT, WIN_NO_EVENTS,0);
}

static Notify_value
my_notice_destroy(frame,status)
    Frame frame;
    Destroy_status status;
{
   if (status == DESTROY_CLEANUP) {
      (void) notify_stop();
      exit(1);
   }
   return (notify_next_destroy_func (frame, status));
}

void
repaint_proc( canvas, pixwin,repaint_area)
  Canvas canvas;
  Pixwin *pixwin;
  Rectlist *repaint_area;
{
  char *prompt = "PLEASE WAIT";
  if (first == 0) {
     first = 1;
     return;
     /* Avoids spurious repaint when window first is created */
  }
  if (Product != 'D') {
     ScreenDirty = 1;
     return;
  }
  pw_writebackground(pixwin,0,0,EdWinX,EdWinY,PIX_CLR);
  GET_NEW_FONT(EdWinX, EdWinY);
  pw_text(pixwin,CharX,CharY,PIX_COLOR(CCol)|PIX_SRC, font, prompt);
  flag = 1;
}

void
resize_proc(canvas,width,height)
   Canvas  canvas;
   int width;
   int height;
{
   EdWinX = width; 
   EdWinY = height;
}

void
event_proc( window, event, arg)
   Window window;
   Event *event;
   caddr_t  arg;
{
   if (window == canvas) { *LLEvent = *event; }
   else { window_default_event_proc(window,event,arg);}
}

void
redraw()
{
   flag = 0;
   window_set(canvas,WIN_CONSUME_PICK_EVENT, WIN_NO_EVENTS,0);
   SETDEVICEVIEWPORT(EdWinX, EdWinY);
   WindowCheck();
   DDInitEvents();
}
