#include <errno.h>
#include <stdio.h>
#include "/usr/local/bpdev/X11/Xlib.h"

static Display* dpy;
static Window window;

EDWIN_DDX_INIT ()
{
   dpy = XOpenDisplay (NULL);
   XGetWindowAttributes (dpy, window, XWinfo);
}

EDWIN_DDX_TERM ()
{
   XCloseDisplay (dpy);
}

EDWIN_DDX_UPDATE ()
{
   XFlush (dpy);
}

EDWIN_DDX_CLEAR ()
{
   XClearWindow (dpy, window);
}

EDWIN_DDX_COL (ColNum)
   int ColNum;
{
}

EDWIN_DDX_MODE (Mode)
   int Mode;
{
}

EDWIN_DDX_FILL (Mode)
   int Mode;
{
}

EDWIN_DDX_DOT (x, y)
      int x, y;
{
   XDrawPoint (dpy, window, edgegc, x, y);
}

EDWIN_DDX_LINE (ox, oy, nx, ny)
   int ox, oy, nx, ny;
{
   XDrawLine (dpy, window, edgec, ox, oy, nx, ny);
}

EDWIN_DDX_RECT (lx, ly, nx, ny)
   int lx, ly, nx, ny;
{
   XFillRectangle (dpy, window, fillgc, lx, ny, nx-lx, yn-ly);
}

EDWIN_DDX_TEXT (sx, sy, ch)
   int sx, sy;
   char *ch;
{
}

EDWIN_DDX_POLY (n, x, y)
   int n;
   int x[], y[];
{
   int i;
   XFillPolygon (dpy, window, fillgc, vlist, n-1, complex, CoordModeOrigin);
   for (i=1; i<n; i++) { XDrawLine (dpy, window, edgegc, 
                                    x[i-1], y[i-1], x[i], y[i]); }
}

EDWIN_DRAW_DOTS (lx, ly, hx, hy, gap)
         int lx, ly, hx, hy, gap;
{
}   /* end of the edwin draw dots routine for the schematics */


extern int errno;
static FromCursor = 0;
static InputInit  = 0;

EDWIN___B_SAM (state, x, y)
         int *state, *x, *y;
{
   *x = 0;
   *y = 0;
   *state = 1;
}

EDWIN___B_REQ (state, x, y)
         int *state, *x, *y;
{
   FromCursor = 1;
   *state = 0;
   while (*state == 0) EDWIN___B_SAM (state, x, y);
   FromCursor = 0;
}
