{ EDWIN internal procedures for device driver support }       %end %of %list

%external %string (255) %fn %spec UINFS %alias "EDWIN_UINFS"   (%integer EP)

%external %integer %spec VIEWING        %alias "EDWIN___VIEWING"
%external %routine %spec TEK INPUT      %alias "EDWIN___TEK_INPUT" (%integer %name State, X, Y, %integer INVOKE CURSOR)

%record %format DEV DATA FM (%integer DEV NO   { logical device number },
   %string (31) NAME         { Text name for the device                },
   %integer TYPE             { Model number of the device              },
   %integer ARF              { Aspect Rationing Factor as a percentage },
   %integer DVX, DVY         { Default Viewport X and Y                },
   %integer MVX, MVY         { Maximum Viewport X and Y                },
   %real    UNITS PER CM     { Units per Centimeter ( =0 => interacts) },
   %byte    MAX COLOUR       { Maximum number of colours available     },
   %byte    MAX STYLES       { Maximum number of line styles available },
   %byte    MAX SPEED        { Maximum speed (cm/s)                    },
   %byte    NUM CHAR SIZES   { Number of character sizes (255 => any)  },
   %byte    NUM CHAR FONTS   { Number of character fonts available     },
   %byte    NUM CHAR SLANTS  { Number of character slant positions 0/* },
   %byte    NUM CHAR ROTS    { Number of rotations of chars 0, 4, 8, * },
   %real    X UNITS PER CM   { Units per Centimeter ( =0 => interacts) },
   %real    Y UNITS PER CM   { Units per Centimeter ( =0 => interacts) })
%external %record (DEV DATA FM) %spec DEV DATA %alias "EDWIN___DEVICE_DATA"

%external %routine %spec OPER MESSAGE  %alias "EDWIN_OPER_MESSAGE"  (%string (255) MESS)
%external %routine %spec OPER INTERACT %alias "EDWIN_OPER_INTERACT" (%string (255) MESS)
%external %routine %spec TTMODE        %alias "EDWIN_TTMODE"  (%integer MODE)
%external %routine %spec TTPUT         %alias "EDWIN_TTPUT"   (%integer CH)
%external %routine %spec FLUSH OUTPUT  %alias "EDWIN_FLUSH"
%external %integer %fn %spec TTGET     %alias "EDWIN_TTGET"
%external %integer %fn %spec TTREAD    %alias "EDWIN_TTREAD"
%external %routine %spec SET DEVICE    %alias "EDWIN_SET_DEVICE" (%string(255) TERM)

%const %integer NON TERMINAL DEFAULT = 13 { For Viewing }
