!
! this is the new graphics include file for the MG-1.
! it includes the imp_include:sysparam and graphics include files of old
!
!%include "imp_include:sysparam.inc"
%const %integer NOFILE  = 20              { max open files per process }
%const %integer CANBSIZ = 256             { max size of typewriter line }
%const %integer MSGBUFS = 128             { Characters saved from error messages }
%const %integer NCARGS  = 10240           { # characters in exec arglist }
%const %integer PGSIZE  = 512             { bytes per addressable disk sector }

!
! Magic system offsets
!
%const %integer UPAGES  = 6               { No. of pages for _u (mult. of MCPAGES) }
%const %integer USIZE   = (UPAGES*PGSIZE) { Size of _u (in bytes) }
%const %integer SSIZE   = (PGSIZE)        { Stack size }
%const %integer P1PAGES = 2               { Pages for pte1 page tables (h/w set) }
%const %integer P1SIZE  = (P1PAGES*PGSIZE){ size of level 1 page tables }

%const %integer TOPUSER = ((128*256-2)*PGSIZE)    { end of user virtual address space }
%const %integer KERNELSTACK =     256     { space to leave for kernel stack }
%const %integer SWAPLO  = 0               { beginning of swap area in blocks }
%const %integer USERCORE=  TOPUSER        { Abs. max user proc size }

%const %integer TOPPHYMEM  = 16_400000        { Max size of physical mem (4 Mb) }
%const %integer MEMCHUNK   = 16_40000         { "Quantum" amt of physical memory }
%const %integer MEMOFFSET  = 16_3ffff
%const %integer MEMSHIFT   =      18              { LOG2(MEMCHUNK) }
%const %integer MEMCHKS = (TOPPHYMEM/MEMCHUNK)    { Maximum physical memory quanta }

!
! priorities
! probably should not be
! altered too much
!
%const %integer PSWP    = 0
%const %integer PINOD   = 10
%const %integer PRIBIO  = 20
%const %integer PZERO   = 25
%const %integer NZERO   = 20
%const %integer PPIPE   = 26
%const %integer PWAIT   = 30
%const %integer PSLEP   = 40
%const %integer PUSER   = 50

!
! fundamental constants of the implementation--
! cannot be changed easily
!
%const %integer NBPW    = 4               { number of bytes in an integer }
%const %integer NBPG    = PGSIZE          { size of basic MMU unit (one page) }
%const %integer PGOFSET = (NBPG-1)        { byte offset into page }

%const %integer MCPAGES = 2               { pages in a memory cluster (min allocation) }
%const %integer MCSHIFT = 10              { shift from address to memory cluster }
%const %integer MCSIZE  = ((PGSIZE) * (MCPAGES))  { bytes in a memory cluster }
%const %integer MCOFSET = ((MCSIZE) - 1)  { maximum offset in a cluster }

%const %integer BSIZE   = 1024            { size of secondary block (bytes) }
                        { BSLOP can be 0 unless you have a TIU/Spider }
%const %integer BSLOP   = 0               { In case some device needs bigger buffers }
%const %integer BMASK   = 8_1777          { BSIZE-1 }
%const %integer BSHIFT  = 10              { LOG2(BSIZE) }
%const %integer NMASK   = 8_377            { NINDIR-1 }
%const %integer NSHIFT  = 8               { LOG2(NINDIR) }

%const %integer NULL    = 0
%const %integer CMASK   = 0               { default mask for file creation }
%const %integer NODEV   = -1
%const %integer ROOTINO = 2               { i number of all roots }
%const %integer SUPERB  = 1               { block number of the super block }
%const %integer DIRSIZ  = 14              { max characters per directory }

%const %integer NICINOD = 100             { number of superblock inodes }
%const %integer NICFREE = 178             { number of superblock free blocks }

%const %integer CBSIZE  = 28              { number of chars in a clist block }
%const %integer CROUND  = 16_1f            { clist rounding: sizeof(int *) + CBSIZE - 1}

%const %integer PGSHIFT = 9               { LOG2(PGSIZE) }

!
! Machine-dependent bits and macros
!
%const %integer UMODE   = 16_100           { usermode bits }
%const %integer INTPRI  = 16_800           { Interrupt  bit }

!
! Graphics.Inc
!
! IMP version of #include <raster.h>
!            and #include <windows.h>
!

%record %format RPos Fm ( %integer X, Y )    {position within a raster}

%record %format RSize Fm ( %integer W, H )   {size of a raster image}

%record %format RBox fm  (%record(RPos fm) pos,
                          %record(RSize fm) size)

%record %format Raster Fm ( -
        %record(RSize Fm)         Size,
        %integer                  RStride,     {bit distance between vertically}
                                               {contiguous pixels}
        %byte %name               RBuff,       {buffer containing raster}
        %integer                  RBuffOffs )  {offset of raster origin in
                                               {RBuff}

!
! This format holds the decription of individual characters
!
%record %format ch tab fm (%short nbytes,      { bytes in the bitmap }
                           %byte up, down, left, right,
                           %short width,
                           %byte bits)

%record %format RFont Fm ( -
        %byte fixed, fast,
        %short ascent,maxx,maxy,
        %record(chtab fm) %name chars)   ;! points to first in array

%dynamic %record(raster fm) %map %spec new raster %alias "NewRaster" ( -
                                        %integer w,h)
%dynamic %record(raster fm) %map %spec sub raster %alias "SubRaster" ( -
                                        %record(raster fm) %name parent,
                                        %integer x,y,w,h)
%dynamic %routine %spec free raster %alias "FreeRaster" ( -
                                        %record(raster fm) %name raster)


%record %format ERFont Fm ( -
        %record(Raster Fm) %name %array RF Char ( 0: 255 ) )

%dynamic %routine %spec G Line %alias "GLine" ( -
         %record(RPos   Fm) %name Line End,
         %byte                    Op,
         %record(RPos   Fm) %name Brush,
         %record(Raster Fm) %name Paper )

%dynamic %routine %spec G Move %alias "GMove" ( -
         %record(RPos   Fm) %name Line End,
                                  Brush )

%dynamic %routine %spec G Put C %alias "GPutC" ( -
         %byte                    C,
                                  Op,
         %record(RPos   Fm) %name Brush,
         %record(RFont  Fm) %name CSet,
         %record(Raster Fm) %name Paper )

%dynamic %routine %spec G Put String %alias "GPutString" ( -
         %record(Raster Fm) %name Paper,
         %record(RPos   Fm) %name Brush,
         %integer                 Rule,
         %record(Rfont  Fm) %name CSet,
         %byte %name              String)

%dynamic %record(RFont Fm) %map %spec G Read Font %alias "GReadFont" ( -
         %byte              %name File )

%dynamic %routine %spec Raster Op %alias "RasterOp" ( -
         %short                   Op,
         %record(Raster Fm) %name Source,
         %record(RPos   Fm) %name SPos,
         %record(RSize  Fm) %name SSize,
         %record(Raster Fm) %name Dest,
         %record(RPos   Fm) %name DPos,
         %record(RSize  Fm) %name DSize )

!
! Easy call of the more difficult routines
!
%external %record(RFont Fm) %map %spec Imp Read Font %alias "IMP_READ_FONT" ( -
         %string(255) File )

!
! Raster operation codes
!
%const %integer F 0     = 0,
                F NOR   = 1,
                F NDS   = 2,
                F NOTD  = 3,
                F DNS   = 4,
                F NOTS  = 5,
                F XOR   = 6,
                F NAND  = 7,
                F AND   = 8,
                F NXOR  = 9,
                F S     = 10,
                F NDORS = 11,
                F D     = 12,
                F NSORD = 13,
                F OR    = 14,
                F 1     = 15

%dynamic %integer %function %spec Panel Create %alias "PanelCreate" ( -
                                         %integer parent,
                                         %record(rpos fm) %name origin,
                                         %record(rsize fm) %name size,
                                         %integer type)
%dynamic %integer %fn %spec Panel Delete %alias "PanelDelete" (%integer panel)
%dynamic %integer %fn %spec Panel Pop %alias "PanelPop" (%integer panel)
%dynamic %integer %fn %spec Panel Push %alias "PanelPush" (%integer panel)

%dynamic %routine %spec Page Define %alias "PageDefine" ( -
                                         %integer panel,
                                         %integer page,
                                         %record(raster fm) %name page raster,
                                                                  mask raster,
                                         %record(rpos fm) %name origin)

%dynamic %integer %fn %spec Page Select %alias "PageSelect" ( -
                                         %integer panel,
                                                  page)
%dynamic %integer %function %spec Region Define %alias "RegionDefine" ( -
                                         %integer Panel,
                                                  Page,
                                         %record(rbox fm) %name region list,
                                         %integer nregions)

%dynamic %routine %spec panel update %alias "PanelUpdate" ( -
                                         %integer panel,
                                         %record(rbox fm) %name changedboxes,
                                         %integer nchanged)

!
! event data structure
!

%record %format eumk fm (%short x,y,
                         %short mbuttons, mclicks,mregion,
                         %byte kchar, kshift,k scan)

%record %format eupan fm(%short sw, sh, child)

%record %format euipc fm(%short pid,uid,txlen,rxlen)

%record %format eun fm  (%record(eumk fm) mouse %or -
                         %record(eupan fm) size %or -
                         %record(euipc fm) ipc %or -
                         %short %array euuser(0:5))

%record %format wevent fm (%integer e time stamp,
                           %short eclass,
                           %short etype,
                           %short epanel,
                           %short etag,
                           %record(eun fm) event)

%dynamic %routine %spec Panel Flush %alias "PanelFlush" (%integer panel)

%dynamic %integer %fn %spec panel read %alias "PanelRead" ( -
                                         %integer panel,
                                         %record(wevent fm) %name events,
                                         %integer nevents)
%dynamic %routine %spec panel poll %alias "PanelPoll" ( -
                                         %integer panel,
                                         %record(wevent fm) %name eventp)


%const %integer NWI           =  1

{ window states }
%const %integer WI OPEN       =  1
%const %integer WI MAPPED     =  2

{ window types }
%const %integer WI T PHYSICAL =  0

%const %integer MAX PAGES     =  4


!!!   struct winargs {
!!!       caddr_t     w_bfu;
!!!       int         w_cnt,
!!!                   w_yu;
!!!   };
!!!   
!!!   struct window   {               { Very provisional. }
!!!       int         wi_n,           { Window number. }
!!!                   wi_type,
!!!                   wi_state;
!!!       union {
!!!           struct {
!!!               int         pwi_y,  { Physical window y position. }
!!!                           pwi_cnt;{    "       "    count. }
!!!               caddr_t     pwi_buf[MAX_PAGES];{ User's buffer address
!!!                                               * (user space).
!!!                                               }
!!!           } pwi;
!!!           struct {
!!!               int         vwi_filler;{ Not yet defined. }
!!!           } vwi;
!!!       } wu;
!!!   };

%const %integer PAN ROOT    = 0
%const %integer P PHYS TYPE = 1,
                P FULL TYPE = 0,
                P SHARE = 16_100   ;! inherited panel

{ IOCTLs used by the panel library. }
%const %integer PIOCKA      =    (('p'<<8)!1)    { KeyboardAttach       }
%const %integer PIOCKD      =    (('p'<<8)!2)    { KeyboardDetach       }
%const %integer PIOCGE      =    (('p'<<8)!3)    { GetEventMask         }
%const %integer PIOCSE      =    (('p'<<8)!4)    { SetEventMask         }
%const %integer PIOCPR      =    (('p'<<8)!5)    { PanelRead            }
%const %integer PIOCPA      =    (('p'<<8)!6)    { PanelAlarm           }
%const %integer PIOCCD      =    (('p'<<8)!7)    { CursorDefine         }
%const %integer PIOCCS      =    (('p'<<8)!8)    { CursorSelect         }
%const %integer PIOCGC      =    (('p'<<8)!9)    { GetCursorPosition    }
%const %integer PIOCSC      =    (('p'<<8)!10)   { SetCursorPosition    }
%const %integer PIOCMS      =    (('p'<<8)!11)   { MakeSound            }
%const %integer PIOCMAP     =    (('p'<<8)!12)   { map screen           }
%const %integer PIOCUP      =    (('p'<<8)!13)   { panel update         }
%const %integer PIOCPP      =    (('p'<<8)!14)   { PanelPoll            }

!
! support for the mg cursor
!

%constant %integer  NO CURSOR = 16,
                    CURSOR STRIDE = 64,
                    CURSOR WIDTH = 64,
                    CURSOR HEIGHT = 64,
                    CURSOR BYTES = 512,
                    CURSOR MAGIC NO = 8_723

%constant %integer  CURSOR NEW = -1

%record %format cursor fm (%record(raster fm) CPicture,
                           %record(rpos fm) CHotSpot)

%record %format cursor header fm (%short cursmagic,   { must = cursor magic no }
                                  %short curcount)    { no of cursors in file }
!
! Mouse Keyboard events
!
%constant %integer E NULL           = 0,
                   E CURSOR MOVES   = (('M'<<8)!0),    {Mouse moved}
                   E CURSOR CROSS   = (('M'<<8)!1),    {mouse crossed boundary}
                   E BUTTON         = (('M'<<8)!2),    {Mouse button state chn}
                   E CLICK          = (('M'<<8)!3),    {Mouse button clicked}
                   E ENTER          = (('M'<<8)!4),    {Mouse entered panel}
                   E LEAVE          = (('M'<<8)!5)     {mouse left panel}

%constant %integer E SYNC           = (('T'<<8)!0),    {Sync event}
                   E TIMER          = (('T'<<8)!1)     {Timeout event}

%constant %integer E KEYPRESS       = (('K'<<8)!0),    {Keypressed}
                   E KEYBREAK       = (('K'<<8)!1),    {Key released}
                   E KEYATTACH      = (('K'<<8)!2),    {K/B attached to panel}
                   E KEYREMOVE      = (('K'<<8)!3),    {K/B removed from panel}
                   E KEYRAW         = (('K'<<8)!4)     {Raw K/B event}

!
! backwards compatibility
!
%constant %integer E KEYSTROKE = E KEYPRESS,
                   E KEYLISTEN = E KEYATTACH,
                   E KEYDEAF   = E KEYREMOVE

%constant %integer E KILLED         = (('P'<<8)!0),    {Child panel died}
                   E UPDATED        = (('P'<<8)!1),    {Invisible child update}
                   E RESIZED        = (('P'<<8)!2),    {Panel has changed size}
                   E SELECT         = (('P'<<8)!5)     {Secondary selection made

%constant %integer E NOISE ENDS     = (('N'<<8)!0)     {Noise has finished}

%constant %integer E SEND           = (('I'<<8)!0),    {IPC send requested}
                   E CONVERSE       = (('I'<<8)!1)     {IPC converse requested}

%constant %integer E NULL GROUP     = 0,
                   E MOUSE GROUP    = 'M',
                   E TIME GROUP     = 'T',
                   E KEYBD GROUP    = 'K',
                   E PANEL GROUP    = 'P',
                   E NOISE GROUP    = 'N',
                   E IPC GROUP      = 'I'

!
! event classes (for masking)
!
%constant %integer E MOVE CLASS = 1,
                   E CROSS CLASS = 2,
                   E BUTTON CLASS = 4,
                   E UNUSED1 = 16_8,
                   E RAWKEY CLASS = 16_10,
                   E NOISE CLASS = 16_20,
                   E SYNC CLASS = 16_40,
                   E KEY CLASS = 16_80

%constant %integer E TIMER CLASS = 16_100,
                   E BREAK CLASS = 16_200,
                   E PANEL CLASS = 16_400,
                   E CLICK CLASS = 16_800,
                   E CHANGE CLASS = 16_1000,
                   E IPC CLASS = 16_8000,
                   E IOP MASK = 16_95

!
! mouse button definitions
!
%constant %integer BUTTON LEFT = 4,
                   BUTTON MIDDLE = 1,
                   BUTTON RIGHT = 2,
                   CLICK LEFT = 16_40,
                   CLICK MIDDLE = 16_10,
                   CLICK RIGHT = 16_20

%constant %integer KEY ALPHA SHIFT = 1,
                   KEY CAPS SHIFT = 2,
                   KEY CTRL SHIFT = 4,
                   KEY ALT SHIFT = 8,
                   KEY NUM SHIFT = 16_10,
                   KEY UP = 16_80

%dynamic %integer %function %spec cursor define %alias "CursorDefine" ( -
    %integer panel,
    %integer cur no,
    %integer mix op,
    %record(cursor fm) %name cursor)

%dynamic %integer %function %spec cursor select %alias "CursorSelect" ( -
    %integer panel id,
             page no,
             reg no,
             cur no)

%dynamic %integer %fn %spec Panel Set Mask %alias "PanelSetMask" ( -
    %integer panel id, mask)

%dynamic %integer %function %spec PanelListening %alias "PanelListening" ( -
     %integer newpanel)

%dynamic %routine %spec Panel Set No Wait %alias "PanelSetNoWait" ( -
    %integer Panel)

%dynamic %routine %spec Panel Set Wait %alias "PanelSetWait" ( -
    %integer Panel)

%dynamic %routine %spec Panel Get Mask %alias "PanelGetMask" ( - 
    %integer panel,
    %integer %name maskp)

%dynamic %routine %spec gplot %alias "GPlot" (%byte                    op,
                                              %record(RPos fm) %name   brush,
                                              %record(Raster fm) %name raster)

%dynamic %routine %spec gcircle %alias "GCircle" (%byte                   op,
                                                  %integer                rad,
                                                  %record(RPos fm) %name  brush,
                                                  %record(raster fm) %name pap,
                                                  %integer clip)
%end %of %file
