{ EDWIN routine specs added }                          %end %of %list

! Routines for initialisation and termination
%external %routine %spec OPEN GRAPHICS      %alias "EDWIN_OPEN_GRAPHICS" (%integer DEVICE, %string (255) FILE)
%external %routine %spec INITIALISE FOR     %alias "EDWIN_INIT"          (%integer DEVICE TYPE)
%external %routine %spec INITIALISE EDWIN   %alias "EDWIN_SINI"          (%string (255) DEVICE)
%external %routine %spec TERMINATE EDWIN    %alias "EDWIN_TERM"
%external %routine %spec CLOSE GRAPHICS     %alias "EDWIN_CLOSE_GRAPHICS"

! Output primitives
%external %routine %spec MOVE ABS           %alias "EDWIN_MOVE_ABS"      (%integer X, Y)
%external %routine %spec MOVE REL           %alias "EDWIN_MOVE_REL"      (%integer DX, DY)
%external %routine %spec LINE ABS           %alias "EDWIN_LINE_ABS"      (%integer X, Y)
%external %routine %spec LINE REL           %alias "EDWIN_LINE_REL"      (%integer DX, DY)
%external %routine %spec MARKER ABS         %alias "EDWIN_MARK_ABS"      (%integer N, X, Y)
%external %routine %spec MARKER REL         %alias "EDWIN_MARK_REL"      (%integer N, DX, DY)
%external %routine %spec CHARACTER          %alias "EDWIN_CHAR"          (%integer SYM)

! Text output
%external %routine %spec TEXT               %alias "EDWIN_TEXT"          (%string (255) ST)
%external %routine %spec TEXT COLOUR ESCAPE %alias "EDWIN_TEXT_COL_ESC"  (%integer CH)
%external %routine %spec TEXT FONT ESCAPE   %alias "EDWIN_TEXT_FONT_ESC" (%integer CH)

! Control
%external %routine %spec NEW FRAME          %alias "EDWIN_NEW_FRAME"
%external %routine %spec UPDATE             %alias "EDWIN_UPDATE"
%external %routine %spec CLIP ON            %alias "EDWIN_CLIP_ON"
%external %routine %spec CLIP OFF           %alias "EDWIN_CLIP_OFF"
%external %routine %spec STORE ON           %alias "EDWIN_STORE_ON"      (%integer STREAM)
%external %routine %spec STORE OFF          %alias "EDWIN_STORE_OFF"
%external %routine %spec VIEW ON            %alias "EDWIN_VIEW_ON"       (%integer STREAM)
%external %routine %spec VIEW OFF           %alias "EDWIN_VIEW_OFF"
%external %routine %spec ASPECT RATIOING    %alias "EDWIN_ASPECT_RATIO"  (%integer MODE)
%external %routine %spec WINDOW             %alias "EDWIN_WINDOW"        (%integer XL, XR, YB, YT)
%external %routine %spec VIEWPORT           %alias "EDWIN_VIEWPORT"      (%integer XL, XR, YB, YT)

! Attributes
%external %routine %spec SET COLOUR         %alias "EDWIN_SET_COLOUR"    (%integer COLOUR)
%external %routine %spec SET COLOUR MODE    %alias "EDWIN_SET_COL_MODE"  (%integer MODE)
%external %routine %spec SET MARKER SIZE    %alias "EDWIN_SET_MARK_SIZE" (%integer S)
%external %routine %spec SET LINE STYLE     %alias "EDWIN_SET_STYLE"     (%integer STYLE)
%external %routine %spec SET CHAR SIZE      %alias "EDWIN_SET_CHAR_SIZE" (%integer SIZE)
%external %routine %spec SET CHAR ROT       %alias "EDWIN_SET_CHAR_ROT"  (%integer ROT)
%external %routine %spec SET CHAR QUALITY   %alias "EDWIN_SET_CHAR_QUAL" (%integer WHICH)
%external %routine %spec SET CHAR FONT      %alias "EDWIN_SET_CHAR_FONT" (%integer WHICH)
%external %routine %spec SET CHAR SLANT     %alias "EDWIN_SET_CHAR_SLANT"(%integer ANGLE)
%external %routine %spec SET CHAR MIRROR    %alias "EDWIN_SET_CHAR_MIR"  (%integer Axis)
%external %routine %spec SET SPEED          %alias "EDWIN_SET_SPEED"     (%integer SPEED)
%external %routine %spec SET CHORD STEP     %alias "EDWIN_SET_CHORD_STEP"(%integer NUM)
%external %routine %spec SET SHADE MODE     %alias "EDWIN_SET_SHADE_MODE"(%integer MODE)
%external %routine %spec Set Polygon Rendering %alias "EDWIN_SET_POLY_RENDER" (%integer TO)

! Miscellaneous routines
%external %routine %spec SET COLOUR MAP     %alias "EDWIN_SET_COLOUR_MAP" (%integer ADR, RED, BLUE, GREEN)
%external %routine %spec REVIEW             %alias "EDWIN_REVIEW"
%external %routine %spec INQUIRE POSITION   %alias "EDWIN_INQ_POSITION"  (%integer %name X, Y)
%external %routine %spec INQUIRE TEXT SIZE  %alias "EDWIN_INQ_TEXT_SIZE" (%string (255) T, %integer %name X, Y)
%external %routine %spec INQUIRE WINDOW     %alias "EDWIN_INQ_WINDOW"    (%integer %name XL, XR, YB, YT)
%external %routine %spec INQUIRE VIEWPORT   %alias "EDWIN_INQ_VIEWPORT"  (%integer %name XL, XR, YB, YT)
%external %routine %spec MAP TO DEVICE COORDS  %alias "EDWIN_MAP_TO_DCS" (%integer %name X, Y)
%external %routine %spec MAP TO VIRTUAL COORDS %alias "EDWIN_MAP_TO_VCS" (%integer %name X, Y)
%external %string (63) %fn %spec EDWIN ERROR   %alias "EDWIN_ERROR"      (%integer X)
%external %string (63) %fn %spec EDWIN VERSION %alias "EDWIN_VERSION"

! Shape drawing routines
%external %routine %spec ARC            %alias "EDWIN_ARC"        (%integer OX, OY, RAD, START ANG, END AND)
%external %routine %spec SECTOR         %alias "EDWIN_SECTOR"     (%integer OX, OY, RAD, START ANG, END AND)
%external %routine %spec CIRCLE         %alias "EDWIN_CIRCLE"     (%integer RAD)
%external %routine %spec RECTANGLE      %alias "EDWIN_RECTANGLE"  (%integer XL, YL, XU, YU)

! Input primitives
%external %routine %spec REQUEST INPUT         %alias "EDWIN_REQUEST"    (%integer %name STATE, X, Y)
%external %routine %spec SAMPLE INPUT          %alias "EDWIN_SAMPLE"     (%integer %name STATE, X, Y)
%external %routine %spec AREA INPUT            %alias "EDWIN_AREA"       (%integer %name XL, YB, XR, YT)

! Device specifics
%external %routine %spec REQUEST DEVICE     %alias "EDWIN_REQUEST_DEV"   (%integer %name STATE, X, Y)
%external %routine %spec SAMPLE DEVICE      %alias "EDWIN_SAMPLE_DEV"    (%integer %name STATE, X, Y)
%external %routine %spec AREA DEVICE        %alias "EDWIN_AREA_DEV"      (%integer %name XL, YB, XR, YT)
%external %routine %spec DRIVE DEVICE       %alias "EDWIN_DRIVE_DEV"     (%integer COM, X, Y)
%external %predicate   %spec PLOTTER DEVICE %alias "EDWIN_PLOTTER_DEVICE"(%string (255) Name)
%external %integer %fn %spec EDWIN NUMBER   %alias "EDWIN_NUMBER"        (%string (255) DEV)
%external %integer %fn %spec DEFAULT DEVICE %alias "EDWIN_DEFAULT_DEV"
%record %format DEVICE DATA FM (%integer DEV NO { logical device number },
   %string (31) NAME          { Text name for the device                },
   %integer TYPE              { Model number of the device              },
   %integer ARF               { Aspect Rationing Factor as a percentage },
   %integer DVX, DVY          { Default Viewport X and Y                },
   %integer MVX, MVY          { Maximum Viewport X and Y                },
   %real    UNITS PER CM      { Units per Centimeter ( =0 => interacts) },
   %byte    MAX COLOUR        { Maximum number of colours available     },
   %byte    MAX STYLES        { Maximum number of line styles available },
   %byte    MAX SPEED         { Maximum speed (cm/s)                    },
   %byte    NUM CHAR SIZES    { Number of character sizes (255 => any)  },
   %byte    NUM CHAR FONTS    { Number of character fonts available     },
   %byte    NUM CHAR SLANTS   { Number of character slant positions 0/* },
   %byte    NUM CHAR ROTS    { Number of rotations of chars 0, 4, 8, * },
   %real    X UNITS PER CM   { Units per Centimeter ( =0 => interacts) },
   %real    Y UNITS PER CM   { Units per Centimeter ( =0 => interacts) })
%external %record (DEVICE DATA FM) %map %spec DEVICE DATA %alias "EDWIN_DEVICE_DATA"
