      SUBROUTINE AUTHOR(ITEXT,NC)
C
C     NAME:  AUTHOR
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     AUTHOR - ACCEPT AUTHOR STRING FROM CALLER
C
C     SUBROUTINE AUTHOR ALLOWS THE INCLUSION OF AN ARBITRARY TEXT
C     STRING DESCRIBING THE PLOT AUTHORSHIP.  THE TEXT STRING IS
C     OUTPUT WITH THE VRF AUTHOR COMMAND AT THE BEGINNING OF EVERY
C     PLOT FRAME.
C
C     NOTE:  AUTHOR MUST BE CALLED BEFORE SUBROUTINE PLOTS IS
C            CALLED TO OUTPUT A USER TEXT STRING FOR THE FIRST
C            PLOT FRAME.  IF NO USER CALL IS MADE, SUBROUTINE
C            PLOTS CALLS AUTHOR WITH THE DEFAULT AUTHOR STRING
C            "aaaaaa VERSAPLOT COLOR RANDOM 2.n", WHERE aaaaaa
C            IS THE COMPUTER/OPERATING SYSTEM NAME AND n IS THE
C            REVISION LEVEL OF THE VERSAPLOT SOFTWARE.
C
C            TO CHANGE THE AUTHOR TEXT STRING FOR SUBSEQUENT PLOT
C            FRAMES, THE AUTHOR CALL MUST BE MADE PRIOR TO THE
C            END-OF-PLOT (-999,+-23) CALL.
C
C     ENTRY:  CALL AUTHOR (ITEXT,NC)
C
C            ITEXT - TEXT STRING BEING PASSED, MAY BE AN ARRAY
C            NC    - NUMBER OF CHARACTERS IN THE TEXT STRING.
C                   MUST BE AN EVEN NUMBER, MAXIMUM OF 60
C                   CHARACTERS ALLOWED.  NC GREATER THAN 60
C                   IS TRUNCATED TO 60.  A NEGATIVE OR ZERO
C                   NC IS FLAGGED AS AN ERROR AND THE CALL
C                   IS IGNORED.
C
C     EXIT:  RETURN
C
C     CALLS:  IRAM
C
C     CALLED BY:  PLOTS,USER
C
C     /DVCOM/
C            I IAUTXT()- ARRAY TO HOLD AUTHOR TEXT STRING
C            I ITFLAG  - FLAG TO INDICATE SUBROUTINE AUTHOR CALLED
C            I NCH     - NUMBER OF CHARACTERS IN AUTHOR TEXT STRING
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C
C     LOCAL VARIABLES USED:
C            I I     - DO LOOP INDEX
C            I KNT   - NUMBER OF WORDS IN CHARACTER COUNT(NC)
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
      DIMENSION ITEXT(1)
C
C
C
C
C...  CHECK IF VALID CHARACTER COUNT
      IF (NC .LE. 0)  GO TO 900
C
C...  CHECK FOR MAXIMUM NUMBER OF CHARACTERS TO BE ALLOWED
      NCH = NC
      IF (NCH .GT. 60)  NCH = 60
C
C...  COMPUTE NUMBER OF WORDS TO PROCESS
      KNT = (NCH+3) / 4
C
C...  MOVE TEXT TO COMMON
      DO 10 I = 1,KNT
      IAUTXT(I) = ITEXT(I)
   10 CONTINUE
C
C...  SET FLAG TO INDICATE AUTHOR CALLED
      ITFLAG = -88
      RETURN
C-E
C...  PROCESS ERROR BAD CHARACTER COUNT
 900  INTARG(1)=NC
        CALL MSGLG1(1)
C
      RETURN
C-E
      END
