      SUBROUTINE AXIS (X,Y,LABEL,NCHAR,AXLEN,ANGLE,FVAL,DV)
C
C      NAME: AXIS
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     AXIS - DRAWS AN AXIS AND ANNOTATES IT
C
C     SUBROUTINE AXIS COMPUTES AN EXPONENT FOR THE ANNOTATION WHICH
C     IT DRAWS AS PART OF THE AXIS LABEL.  IT DRAWS AN ANNOTATION
C     VALUE CENTERED AT EACH TIC MARK, DRAWS THE USER SUPPLIED LABEL,
C     CENTERED ON THE REQUESTED SIDE OF THE AXIS, AND THEN DRAWS THE
C     AXIS AND THE TIC MARKS.
C
C     NOTE THAT AXIS LINE AND SCALE ARE DESIGNED TO WORK IN
C     CONJUNCTION. THE VALUES OF THE FVAL AND DV PARAMETERS ARE
C     NORMALLY COMPUTED BYSCALE.
C
C        ENTRY: CALL AXIS (X,Y,LABEL,NCHAR,AXLEN,ANGLE,FVAL,DV)
C
C            (X,Y) - STARTING COORDINATES FOR AXIS GENERATION (REAL)
C            LABEL - IS AN ALPHANUMERIC TEXT STRING WHICH WILL BE
C                   CENTEREDAND USED TO LABEL THE GENERATED AXIS.
C            NCHAR - DEFINES THE NUMBER OF CHARACTERS (ABSOLUTE) IN
C                   THE ALPHANUMERIC TEXT, LABEL.
C                   + = INDICATES THAT ALL LABELING, ANNOTATIONS,
C                       AND TICK MARKS ARE TO BE GENERATED ABOVE
C                       THE AXIS LINE(THAT IS, COUNTER CLOCKWISE)
C                       AS IS NORMALLY USED FOR THE Y-AXIS.
C                   - = INDICATES THAT ALL LABELING, ANNOTATIONS,
C                       AND TICK MARKS ARE TO BE GENERATED BELOW
C                       THE AXIS LINE(THAT IS, CLOCKWISE) AS IN
C                       NORMALLY USED FOR THE X-AXIS.
C            AXLEN - AXIS LENGTH IN INCHES (REAL)
C            ANGLE - IS THE ANGLE, IN DEGREES, AT WHICH THE AXIS IS
C                   TO BE DRAWN.  NORMALLY, 0.0 DEGREES IS USED FOR
C                   GENERATING THE X-AXIS; 90.0 DEGREES IS USED FOR
C                   GENERATING THE Y-AXIS.
C            FVAL  - IS THE FIRST VALUE (EITHER MINIMUM OR MAXIMUM)
C                   WHICH WILL BE USED FOR ANNOTATING THE AXIS AT
C                   UNIT(FOR EXAMPLE: INCH) INTERVALS.
C            DV    - REPRESENTS THE NO. OF DATA UNITS PER AXIS UNIT.
C                   THIS 'DELTA' VALUE WILL BE ADDED TO THE FVAL
C                   STARTING VALUE FOR GENERATING SCALE ANNOTATIONS
C                   AT EACH SUCCEEDING INTERVAL ALONG THE AXIS LINE.
C                   NORMALLY COMPUTED BY THE SCALE SUBROUTINE.
C
C        EXIT: RETURN
C
C        CALLS:  PLOT ,NUMBER, SYMBOL
C
C        CALLED BY:  USER
C
C        COMMON USED:
C     /DVCOM/
C            I RADN    - DEGREES TO RADIAN ANGLE CONVERSION FACTOR
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C     LOCAL:
C
C           R   ADV   - ABS. VALUE OF DV OR A NORMALIZED VALUE OF DV.
C           R   COSA  - TEMPORARY FOR COSINE OF ANGLE.
C           R   DV    - ARGUMENT - DELTA VAL. BETWEEN TIC MARK VALUES.
C                     NORMALLY COMPUTED BY THE SCALE SUBROUTINE.
C           R   DX    - TEMPORARY FOR OFFSETS MEASURED IN DIR. OF AXIS
C           R   DY    - TEMPORARY FOR OFFSETS MEASURED PERPENDICULAR
C                     TO DIRECTION OF AXIS
C           R   EXP   - THE POWER OF 10 IN DV.
C           I   I     - DO LOOP PARAMETER.
C           I   NC    - WORKING CHARACTER COUNT.
C           I   NTIC  - NUMBER OF TIC MARKS ON AXIS.
C           R   RADN  - NUMBER OF RADIANS PER DEGREE.
C           R   SIDE  - AN OFFSET USED TO PUT ANNOTATION AND TIC
C                     MARKS ON REQUESTED SIDE OF AXIS LINE.
C           R   SINA  - TEMPORARY FOR SINE OF ANGLE
C           R   T2    - TEMPORARY
C           R   TICDX - X COORDINATE OFFSET FOR TIC MARK ENDPOINT.
C           R   TICDY - Y COORDINATE OFFSET FOR TIC MARK ENDPOINT.
C           R   VAL   - NORMALIZED FVAL
C           R   XTIC  - X COORDINATE OF STARTING POINT OF TIC MARK.
C           R   YTIC  - Y COORDINATE OF STARTING POINT OF TIC MARK.
C           R   XX    -    WORKING X COORDINATE.
C           R   YY    - WORKING Y COORDINATE.
C
C
      DIMENSION LABEL(1)
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C
C-D   DEBUG MESSAGE
C      RELARG(1)=X
C      RELARG(2)=Y
C      INTARG(1)=LABEL(1)
C      INTARG(2)=NCHAR
C      RELARG(3)=AXLEN
C      RELARG(4)=ANGLE
C      RELARG(5)=FVAL
C      RELARG(6)=DV
C      CALL MSGLG1(2)
C-D
C
C
C
C...  LOCATE WHICH SIDE OF AXIS TO ANNOTATE AND LABEL.
C     PICK A TRIAL SIDE OFFSET FOR ANNOTATION AND SET A WORKING
C     CHARACTER COUNT.
      SIDE = +1.
      NC = NCHAR
C
C...  NON-NEGATIVE NCHAR?
C     IF THE CALL SPECIFIES ANNOTATION FOR THE OTHER SIDE(NEG. NCHAR),
C     THE WORKING CHARACTER COUNT AND THE SIDE OFFSET ARE REVISED.
      IF (NC.GE.0) GO TO 10
      NC = -NC
      SIDE = -1.
C
C..   DETERMINE VALUE OF 'DV' EXPONENT.
C     THE EXPONENT FOR THE ANNOTATION VALUES IS INITIALIZED AND THE
C     ABS. VALUE OF THE DELTA VALUE (BETWEEN ANNOTATION VALUES) IS
C     SET.
   10 EXP = 0.0
      ADV = ABS (DV)
C
C...  ZERO DELTA ANNOTATION VALUE?
      IF (ADV.EQ.0.) GO TO 50
C
C...  'DV' EXPONENT CALCULATION COMPLETED?THIS LOOP DETERMINES THE
C     DELTA VALUE EXPONENT FOR LARGE DV.
   20 IF (ADV.LT.99.) GO TO 40
      ADV = ADV/10.
      EXP = EXP + 1.
      GO TO 20
C
C...  THIS LOOP DETERMINES THE DELTA VALUE(NEGATIVE) EXPONENT FOR
C     SMALL DV.
   30 ADV = ADV*10.
      EXP = EXP - 1.
C
C...  'DV' EXPONENT CALCULATION COMPLETED?
   40 IF (ADV.LT.0.01) GO TO 30
C
C...  COMPUTE NORMALIZED 'FVAL' AND 'DV'
C     SINCE ADV IS NORMALIZED AT THIS POINT, JUST GET THE RIGHT SIGN.
   50 VAL = FVAL*(10.**(-EXP))
      IF (DV.LT.0.0) ADV = -ADV
C
C...  THE AXIS ANGLE IS CONVERTED TO RADIANS AND THE SINE
C     AND COSINE ARE OBTAINED FOR USE IN ROTATING THE AXIS AND
C     ANNOTATION COORDINATES.
      T2 = ANGLE*RADN
      SINA = SIN (T2)
      COSA = COS (T2)
C
C
C...  THE STARTING COORDINATES FOR THE NUMERIC ANNOTATIONS AT THE TIC
C     MARKS ARE COMPUTED.  DX IS AN OFFSET TO MORE OR LESS CENTER THE
C     ANNOTATION ON THE TIC MARK.  DY OFFSETS THE ANNOTATION FROM THE
C     AXIS LINE.
      DX = -0.1
      DY = 0.15*SIDE - 0.05
      XX = X + DX*COSA - DY*SINA
      YY = Y + DY*COSA + DX*SINA
C
C...  COMPUTE TIC MARK ENDPOINT OFFSETS. DRAW TIC MARKS AND
C...  LABEL THEM.
      XTIC = X
      YTIC = Y
      TICDX = -0.07*SIDE*SINA
      TICDY = +0.07*SIDE*COSA
      NTIC = AXLEN + 1.0
      DO 60 I = 1,NTIC
         CALL NUMBER (XX,YY,0.105,VAL,ANGLE,2)
         VAL = VAL + ADV
         CALL PLOT (XTIC,YTIC,3)
         CALL PLOT (XTIC+TICDX,YTIC+TICDY,2)
         XTIC = XTIC + COSA
         YTIC = YTIC + SINA
         XX = XX + COSA
         YY = YY + SINA
   60 CONTINUE
C
C...  THE NUMBER OF CHARACTERS IN THE AXIS LABEL IS SET INTO A
C     TEMPORARY.  IF THERE IS AN EXPONENT, 6 ADDITIONAL CHARACTERS
C     WILL BE IN THE LABEL.
      T2 = NC
C
C...  DOES 'DV' EXPONENT EXIST?
      IF (EXP.NE.0.) T2 = NC + 6
C
C...  THE STARTING COORDINATES FOR THE LABEL ARE COMPUTED.
C     DX IS AN OFFSET TO APPROXIMATELY CENTER THE LABEL.  DY OFFSETS
C     THE LABEL FROM THE AXIS LINE.
      DX = -0.07*T2 + 0.5*AXLEN
      DY = 0.325*SIDE - 0.075
      XX = X + DX*COSA - DY*SINA
      YY = Y + DY*COSA + DX*SINA
C
C...  THE USER DEFINED LABEL IS PLOTTED
      CALL SYMBOL (XX,YY,0.14,LABEL,ANGLE,NC)
C
C...  NO 'DV' EXPONENT TO PLOT?  JUMP OVER EXPONENT PLOTTING
      IF (EXP.EQ.0.) GO TO 70
C
C...  PLOT THE "*10" AND COMPUTE THE COORDINATES FOR THE
C     SUPERSCRIPTED EXPONENT.  PLOT THE EXPONENT.
      CALL SYMBOL (999.,999.,0.14,5H  *10,ANGLE,5)
      T2 = NC + 5
      XX = XX + (T2*COSA - 0.8*SINA)*0.14
      YY = YY + (T2*SINA + 0.8*COSA)*0.14
      CALL NUMBER (XX,YY,0.07,EXP,ANGLE,-1)
C
C...  DRAW THE AXIS
C...  DRAW AXIS LINE
70    CALL PLOT (X,Y,3)
      CALL PLOT (X+(AXLEN*COSA),Y+(AXLEN*SINA),2)
C
      RETURN
C
      END
