      BLOCK DATA BLKDTA
C
C     NAME: NONE
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C
C     BLOCKD - BLOCK DATA SUBROUTINE FOR INITIALIZING PHASE 1
C             COMMON VARIABLES.
C
C     *NOTE:  IF YOUR SYSTEM ALLOWS DATA STATEMENTS TO INITIALIZE
C             COMMON VARIABLES, THE FOLLOWING DATA STATEMENTS MAY
C             BE MOVED TO SUBROUTINE PLOTS AND THIS BLOCK DATA
C            SUBROUTINE CAN BE IGNORED.
C
C
C     /DVCOM/
C            I ICWTV   - SUBROUTINE CWTV FIRST CALL FLAG
C            I ICXPTS  - MAXIMUM NUMBER OF POLYGON ELEMENTS ALLOWED
C            I IEOJ    - END-OF-JOB IPEN CODE
C            I IEOP()  - END-OF-PLOT IPEN CODE
C            I IHBUF() - VERSATEC DATA STANDARD HEADER WORDS
C            I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C            I ISORT   - PHASE II SORT FLAG SET BY SUBROUTINE PLOT
C                        = 0 - NO PARTITIONING REQUIRED
C                        = 1 - REP PARTITIONING REQUIRED
C                        = 2 - RPM PARTITIONING REQUIRED
C                        = 3 - REP AND RPM PARTITIONING REQUIRED
C            I ITFLAG  - FLAG TO INDICATE SUBROUTINE AUTHOR CALLED
C            I JPEN    - THE CURRENT PEN NUMBER
C            I MAXPAT  - MAXIMUM NUMBER OF FILL PATTERNS DEFINABLE
C            I MSKALL  - WORD MASK USED IN IRAM CALL TO 'AND' BITS
C            I NPLOT   - NUMBER OF CURRENT PLOT
C            I PXMAX   - PAPER MAXIMUM 'X' DIMENSION
C            I PXMIN   - PAPER MINIMUM 'X' DIMENSION
C            I PYMAX   - PAPER MAXIMUM 'Y' DIMENSION
C            I PYMIN   - PAPER MINIMUM 'Y' DIMENSION
C
C     /PRMCOM/
C            I CMODEL  - DEFAULT COLOR PLOTTER MODEL.
C            I CDEN    - DEFAULT COLOR PLOTTER NIBS/INCH.
C            I CBYTES  - DEFAULT COLOR PLOTTER BYTES/SCAN.
C            I IBYTES  - DEFAULT PLOTTER BYTES/SCAN (8-BIT BYTES).
C            I IFONT   - DEFAULT FONT PATTERN NUMBER.
C            I JBYTES()- ARRAY OF ALL POSSIBLE BYTES/SCAN FOR
C                       CURRENTLY SUPPORTED PLOTTER MODELS.
C            I KREP    - TARGET OUTPUT CONTROLLER
C                       = 0 - UNKNOWN
C                        = 1 - REP CONTROLLER
C                        = 4 - RPM CONTROLLER
C            I MODEL   - DEFAULT PLOTTER MODEL.
C            I MODL()  - ARRAY OF VERSATEC PLOTTER MODELS.
C            I MXPEN   - MAXIMUM PEN NUMBER TO BE ACTIVATED BY USER
C            I NMODL   - NUMBER OF PLOTTER MODELS IN MODL().
C            R RDEN    - DEFAULT PLOTTER NIBS/INCH VALUE.
C            R RDENS() - ARRAY OF ALL POSSIBLE DENSITIES FOR
C                       CURRENTLY SUPPORTED PLOTTER MODELS.
C            R UNITS   - DEFAULT UNITS MEASURE EXPRESSED
C                       IN UNITS/INCH.
C            R XFACT   - DEFAULT X SCALING FACTOR.
C            R YFACT   - DEFAULT Y SCALING FACTOR.
C            R XSTART  - DEFAULT STARTING X COORDINATE.
C            R YSTART  - DEFAULT STARTING Y COORDINATE.
C     /VRFCOM/
C            R RMXELM  - MAXIMUM ELEMENT COUNT FOR BANDING
C            I IREC()  - CURRENT RECORD POINTER
C            I NREC    - NEXT RECORD POINTER
C            I NHEAD   - POINTER TO NEXT FRAME HEADER BLOCK
C            I ICOMD() - INTEGER ARRAY TO HOLD 16/32 BIT VRF
C                        COMMANDS, INITIALIZED IN PLOTS
C            I NBYTS   - NUMBER OF BYTES IN A 'OBUF' WORD
C            I NCHUNK  - N0. OF 16-BIT CHUNKS IN A 'OBUF' WORD
C            I PRECIS  - COORDINATE PRECISION FOR THE VRF
C                        OUTPUT FILE (16 OR 32-BIT PRECISION)
C     /IOCOM/
C            I LUNIT   - LOGICAL UNIT NUMBER OF LISTING DEVICE
C            I IUNIT   - LOGICAL UNIT NUMBER OF VERSAPLOT DATA FILE
C            I LREC    - LENGTH OF DATA FILE RECORD IN WORDS
C            I IOTYPE  - INDICATES TYPE OF OUTPUT (PRINT OR PLOT)
C     /KLCOM/
C            I KSIZE   - VARIABLE DEFINING 13.65' IN SCANS, USED TO
C                        DETERMINE IF ELEMENT CROSSES A 13.65' PAGE
C                        BOUNDARY.
C       /CLRCOM/
C               I ICLRDF()- ARRAY CONTAINING COLOR DEFINITIONS
C            I ITNCLR  - CURRENT TONE COLOR INDEX
C            I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C            I IVCFLG  - FLAG TO INDICATE COLOR MODE SET
C            I NCPASS  - NUMBER OF COLOR PASSES
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /PRMCOM/ - DEFAULT PLOTTING PARAMETERS
C
      INTEGER PENTBL,BMODEL,BBYTES,CMODEL,CBYTES
      LOGICAL VSTRP
      COMMON /PRMCOM/
     *    IBYTES,      IDISK,       IFFAP,       LASTFF,
     *    IJPEN,       INHNCE,      INITFF,      INVERS,
     *    IRDT,        ISPACE,      ISPEED,      ISFLAG,
     *    IUSER,       JBYTES(75),  KREP,        IFONT,
     *    MIRROR,      MODEL,       MODL(75),    MXPEN,
     *    NCOPY,       NMODL,       PENTBL(64,2), RDEN,
     *    RDENS(75),   SCALE,       UNITS,       XFACT,
     *    YFACT,       XSTART,      YSTART,
     *    VXMIN,       VXMAX,       VYMIN,       VYMAX,
     *    WXMIN,       WXMAX,       WYMIN,       WYMAX,
     *    BMODEL,      BDEN,        BBYTES,
     *    CMODEL,      CDEN,        CBYTES,
     *    IDEFLG(256), IUCLR,       MODE1,       IPRISM(61),
     *    MUXOUT,      PMSIZE,      MAXPEN,      KTWO,
     *         LTNFLG,      LTNCLR,      MTAPE,       VSTRP,
     *         JSORT,       JCPCMD,      JCUT,        KDISK
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /IOCOM/ - INPUT/OUTPUT VARIABLES
C
      COMMON /IOCOM/
     *    IUNIT, LUNIT, LREC, IOTYPE
C
C...  COMMON /KLCOM/ - X STRIPPING VARIABLES
C
      LOGICAL KFLAG
      COMMON /KLCOM/ KFLAG, KSIZE
C
C...  COMMON /CLRCOM/ - COLOR VARIABLES
C
      INTEGER PCOLOR, CURPEN
      LOGICAL PENCHG
      COMMON /CLRCOM/
     *    ICLMAX,  ITNCLR,  ITNFLG,  IVCFLG,  NCPASS,  PENCHG,
     *         CURPEN(4), ICLRDF(4,512), IDASRT(4), ITNSEQ(4),
     *         PCOLOR(64)
C
C...  /VRFCOM/ COMMON
      DATA ICOMD(1)/36099/, ICOMD(2)/35586/
      DATA NBYTS/4/
      DATA NCHUNK/2/, PRECIS/16/
      DATA DRWELM/1.0/, RMXELM/20000.0/,  VRFMAX/50000.0/
C
C...  /IOCOM/ COMMON
        DATA IUNIT/1/, LUNIT/6/, LREC/128/, IOTYPE/256/
C
C...  /KLCOM/ COMMON
      DATA KSIZE/32768/
C
C
C...  /DVCOM/ COMMON
      DATA ROT90/.FALSE./, IOPEN/0/, ITFLAG/0/, JPEN/0/
      DATA ICWTV/0/, ISORT/0/, NPLOT/1/, MAXPAT/255/
      DATA MSKALL/-1/, ICXPTS/127/
C
C     IEOP(1 THRU 4) CORRESPOND TO IEND1 THRU IEND4
C     AND IEOJ CORRESPONDS TO ICLOSE AS USED IN CHANGE OR
C     PARAMETERS.
      DATA IEOP(1)/+999/, IEOP(2)/-999/, IEOP(3)/+23/, IEOP(4)/-23/
      DATA IEOJ/+999/
C
C...  CANSTX, INIT-VRF, BEGIN-BAND COMMANDS
      DATA ICNSTX/ 6146 /, IHBUF/ 33536, 33025/
C
C...  DEFINE THE DEFAULT PAPER COORDINATES.  THE DEFAULT VALUES
C     WILL RESULT IN A PLOTTING SURFACE WITH PXMAX AND PYMAX
C     EQUAL TO THE PLOTTER WIDTH.
      DATA PXMIN/0./, PXMAX/-99999.0/
      DATA PYMIN/0./, PYMAX/-99999.0/
C
C...  /PRMCOM/ COMMON
      DATA IFONT/0/,   SCALE/1.0/, NCOPY/1/, IJPEN/1/, JCUT/0/
      DATA ISFLAG/0/,  ISPEED/-1/, IUSER/0/, MAXPEN/31/
      DATA INITFF/-1/,  LASTFF/-1/, IFFAP/-1/, ISPACE/-1/
      DATA XFACT/1.0/, YFACT/1.0/, XSTART/0.0/, YSTART/0.0/
      DATA INHNCE/0/,  INVERS/0/,  MIRROR/0/, IRDT/0/
      DATA WXMIN/-99999.0/, WXMAX/-99999.0/
      DATA WYMIN/-99999.0/, WYMAX/-99999.0/
      DATA VXMIN/-99999.0/, VXMAX/-99999.0/
      DATA VYMIN/-99999.0/, VYMAX/-99999.0/
      DATA IUCLR/256/, LTNCLR/1/, LTNFLG/0/
C
C-W   *****  INSTALLATION DEPENDENT VARIABLES  *****
      DATA MXPEN/7/, UNITS/1.0/, KREP/1/, IDISK/1/
      DATA PMSIZE/4.0/, MODE1/0/, JCPCMD/0/, JSORT/2/
      DATA MTAPE/0/, MUXOUT/0/, VSTRP/.FALSE./, KDISK/1/
C
C     MODEL, RDEN, AND IBYTES SPECIFY THE DEFAULT PLOTTER MODEL
C     (A 80 IS SET FOR 200.0 NIBS PER INCH AT 264
C     BYTES PER SCAN).  IF A NEW VERSATEC PLOTTER MODEL WHICH
C     IS NOT ALREADY IN THE MODL TABLE/ARRAY IS TO BE SPECIFIED
C     THEN MODEL MUST BE SET TO 9999 FOR THE NEW RDEN AND IBYTES
C     TO BE IN EFFECT.
C
C     BMODEL, BDEN, AND BBYTES SPECIFY THE DEFAULT PLOTTER MODEL
C     FOR BLACK AND WHITE PLOTTING.  CMODEL, CDEN, AND CBYTES
C     SPECIFY THE DEFAULT PLOTTER MODEL FOR COLOR PLOTTING.
C
C     MODEL, RDEN, AND IBYTES ARE NORMALLY THE SAME AS BMODEL,
C     BDEN, AND BBYTES, UNLESS THE USER CHANGES THE DEFAULT TO
C     COLOR MODE, IN WHICH CASE THEY ARE THE SAME AS CMODEL,
C     CDEN, AND CBYTES.
C
      DATA MODEL/80/,  RDEN/200.0/, IBYTES/264/
      DATA BMODEL/80/, BDEN/200.0/, BBYTES/264/
      DATA CMODEL/9242/, CDEN/200.0/, CBYTES/1000/
C-W   *****
C
C...  INITIALIZE THE 800 SERIES CONTROLLER CONTROL ARRAY
C     THE FIRST WORD INDICATES HOW MANY ENTRIES IN THE ARRAY
C     ARE CURRENTLY USED.
C     NOTE: ON OUTPUT, WORDS 2-5 MUST BE 32 BIT WORDS, ALL OTHER
C           WORDS ARE OUTPUT AS 16 BIT VALUES.
C
C...                                'PCA1'
      DATA IPRISM(1)/60/, IPRISM(2)/1346584881/
      DATA IPRISM( 3)/ -1 /, IPRISM( 4)/ -1 /
      DATA IPRISM( 5)/ -1 /, IPRISM( 6)/ -1 /
      DATA IPRISM( 7)/ -1 /, IPRISM( 8)/ -1 /
      DATA IPRISM( 9)/ -1 /, IPRISM(10)/ -1 /
      DATA IPRISM(11)/ -1 /, IPRISM(12)/ -1 /
      DATA IPRISM(13)/ -1 /, IPRISM(14)/ -1 /
      DATA IPRISM(15)/ -1 /, IPRISM(16)/ -1 /
      DATA IPRISM(17)/ -1 /, IPRISM(18)/ -1 /
      DATA IPRISM(19)/ -1 /, IPRISM(20)/ -1 /
      DATA IPRISM(21)/ -1 /, IPRISM(22)/ -1 /
      DATA IPRISM(23)/ -1 /, IPRISM(24)/ -1 /
      DATA IPRISM(25)/ -1 /, IPRISM(26)/ -1 /
      DATA IPRISM(27)/ -1 /, IPRISM(28)/ -1 /
      DATA IPRISM(29)/ -1 /, IPRISM(30)/ -1 /
      DATA IPRISM(31)/ -1 /, IPRISM(32)/ -1 /
      DATA IPRISM(33)/ -1 /, IPRISM(34)/ -1 /
      DATA IPRISM(35)/ -1 /, IPRISM(36)/ -1 /
      DATA IPRISM(37)/ -1 /, IPRISM(38)/ -1 /
      DATA IPRISM(39)/ -1 /, IPRISM(40)/ -1 /
      DATA IPRISM(41)/ -1 /, IPRISM(42)/ -1 /
      DATA IPRISM(43)/ -1 /, IPRISM(44)/ -1 /
      DATA IPRISM(45)/ -1 /, IPRISM(46)/ -1 /
      DATA IPRISM(47)/ -1 /, IPRISM(48)/ -1 /
      DATA IPRISM(49)/ -1 /, IPRISM(50)/ -1 /
      DATA IPRISM(51)/ -1 /, IPRISM(52)/ -1 /
      DATA IPRISM(53)/ -1 /, IPRISM(54)/ -1 /
      DATA IPRISM(55)/ -1 /, IPRISM(56)/ -1 /
      DATA IPRISM(57)/ -1 /, IPRISM(58)/ -1 /
      DATA IPRISM(59)/ -1 /, IPRISM(60)/ -1 /
      DATA IPRISM(61)/ -1 /
C
C
C     TABLE OF CURRENTLY SUPPORTED PLOTTER MODELS
C
C     VERSATEC PLOTTER MODELS, NIBS/INCH, BYTES/SCAN
C
      DATA NMODL/54/
      DATA MODL( 1)/ 800/, RDENS( 1)/100./, JBYTES( 1)/100/
      DATA MODL( 2)/ 900/, RDENS( 2)/200./, JBYTES( 2)/200/
      DATA MODL( 3)/1100/, RDENS( 3)/100./, JBYTES( 3)/128/
      DATA MODL( 4)/1110/, RDENS( 4)/100./, JBYTES( 4)/128/
      DATA MODL( 5)/1200/, RDENS( 5)/200./, JBYTES( 5)/264/
      DATA MODL( 6)/1600/, RDENS( 6)/160./, JBYTES( 6)/200/
      DATA MODL( 7)/2000/, RDENS( 7)/100./, JBYTES( 7)/232/
      DATA MODL( 8)/2030/, RDENS( 8)/100./, JBYTES( 8)/232/
      DATA MODL( 9)/2160/, RDENS( 9)/160./, JBYTES( 9)/360/
      DATA MODL(10)/8122/, RDENS(10)/100./, JBYTES(10)/264/
      DATA MODL(11)/8222/, RDENS(11)/200./, JBYTES(11)/528/
      DATA MODL(12)/8124/, RDENS(12)/100./, JBYTES(12)/288/
      DATA MODL(13)/8224/, RDENS(13)/200./, JBYTES(13)/576/
      DATA MODL(14)/8136/, RDENS(14)/100./, JBYTES(14)/440/
      DATA MODL(15)/8236/, RDENS(15)/200./, JBYTES(15)/880/
      DATA MODL(16)/8142/, RDENS(16)/100./, JBYTES(16)/512/
      DATA MODL(17)/8242/, RDENS(17)/200./, JBYTES(17)/1024/
      DATA MODL(18)/8172/, RDENS(18)/100./, JBYTES(18)/896/
      DATA MODL(19)/8272/, RDENS(19)/200./, JBYTES(19)/1792/
      DATA MODL(20)/8244/, RDENS(20)/200./, JBYTES(20)/1076/
      DATA MODL(21)/8252/, RDENS(21)/200./, JBYTES(21)/1304/
      DATA MODL(22)/8259/, RDENS(22)/200./, JBYTES(22)/1462/
      DATA MODL(23)/  80/, RDENS(23)/200./, JBYTES(23)/264/
      DATA MODL(24)/  81/, RDENS(24)/100./, JBYTES(24)/128/
      DATA MODL(25)/  82/, RDENS(25)/100./, JBYTES(25)/132/
      DATA MODL(26)/9242/, RDENS(26)/200./, JBYTES(26)/1000/
      DATA MODL(27)/7222/, RDENS(27)/200./, JBYTES(27)/528/
      DATA MODL(28)/7422/, RDENS(28)/400./, JBYTES(28)/1056/
      DATA MODL(29)/7224/, RDENS(29)/200./, JBYTES(29)/576/
      DATA MODL(30)/7424/, RDENS(30)/400./, JBYTES(30)/1152/
      DATA MODL(31)/7225/, RDENS(31)/200./, JBYTES(31)/588/
      DATA MODL(32)/7425/, RDENS(32)/400./, JBYTES(32)/1176/
      DATA MODL(33)/7236/, RDENS(33)/200./, JBYTES(33)/880/
      DATA MODL(34)/7436/, RDENS(34)/400./, JBYTES(34)/1760/
      DATA MODL(35)/7244/, RDENS(35)/200./, JBYTES(35)/1076/
      DATA MODL(36)/7444/, RDENS(36)/400./, JBYTES(36)/2152/
      DATA MODL(37)/3224/, RDENS(37)/200./, JBYTES(37)/564/
      DATA MODL(38)/3236/, RDENS(38)/200./, JBYTES(38)/856/
      DATA MODL(39)/3424/, RDENS(39)/400./, JBYTES(39)/1128/
      DATA MODL(40)/3436/, RDENS(40)/400./, JBYTES(40)/1712/
      DATA MODL(41)/3244/, RDENS(41)/200./, JBYTES(41)/1052/
      DATA MODL(42)/3444/, RDENS(42)/400./, JBYTES(42)/2104/
      DATA MODL(43)/2552/, RDENS(43)/200./, JBYTES(43)/264/
      DATA MODL(44)/2554/, RDENS(44)/254./, JBYTES(44)/336/
      DATA MODL(45)/2556/, RDENS(45)/300./, JBYTES(45)/396/
      DATA MODL(46)/2558/, RDENS(46)/400./, JBYTES(46)/528/
      DATA MODL(47)/2562/, RDENS(47)/200./, JBYTES(47)/284/
      DATA MODL(48)/2564/, RDENS(48)/254./, JBYTES(48)/360/
      DATA MODL(49)/2566/, RDENS(49)/300./, JBYTES(49)/424/
      DATA MODL(50)/2568/, RDENS(50)/400./, JBYTES(50)/568/
      DATA MODL(51)/2592/, RDENS(51)/200./, JBYTES(51)/412/
      DATA MODL(52)/2594/, RDENS(52)/254./, JBYTES(52)/524/
      DATA MODL(53)/2596/, RDENS(53)/300./, JBYTES(53)/620/
      DATA MODL(54)/2598/, RDENS(54)/400./, JBYTES(54)/824/
      DATA MODL(55)/   0/, RDENS(55)/  0./, JBYTES(55)/0/
      DATA MODL(56)/   0/, RDENS(56)/  0./, JBYTES(56)/0/
      DATA MODL(57)/   0/, RDENS(57)/  0./, JBYTES(57)/0/
      DATA MODL(58)/   0/, RDENS(58)/  0./, JBYTES(58)/0/
      DATA MODL(59)/   0/, RDENS(59)/  0./, JBYTES(59)/0/
      DATA MODL(60)/   0/, RDENS(60)/  0./, JBYTES(60)/0/
      DATA MODL(61)/   0/, RDENS(61)/  0./, JBYTES(61)/0/
      DATA MODL(62)/   0/, RDENS(62)/  0./, JBYTES(62)/0/
      DATA MODL(63)/   0/, RDENS(63)/  0./, JBYTES(63)/0/
      DATA MODL(64)/   0/, RDENS(64)/  0./, JBYTES(64)/0/
      DATA MODL(65)/   0/, RDENS(65)/  0./, JBYTES(65)/0/
      DATA MODL(66)/   0/, RDENS(66)/  0./, JBYTES(66)/0/
      DATA MODL(67)/   0/, RDENS(67)/  0./, JBYTES(67)/0/
      DATA MODL(68)/   0/, RDENS(68)/  0./, JBYTES(68)/0/
      DATA MODL(69)/   0/, RDENS(69)/  0./, JBYTES(69)/0/
      DATA MODL(70)/   0/, RDENS(70)/  0./, JBYTES(70)/0/
      DATA MODL(71)/   0/, RDENS(71)/  0./, JBYTES(71)/0/
      DATA MODL(72)/   0/, RDENS(72)/  0./, JBYTES(72)/0/
      DATA MODL(73)/   0/, RDENS(73)/  0./, JBYTES(73)/0/
      DATA MODL(74)/   0/, RDENS(74)/  0./, JBYTES(74)/0/
      DATA MODL(75)/   0/, RDENS(75)/  0./, JBYTES(75)/0/
C
C...  NOTE: IF MODEL 7444 IS CHOSEN, PAPER MAXIMUM Y MUST BE
C     SET LESS THAN 40.9 INCHES.  (MAX. X FOR ROTATED PLOTS.)
C
C...  SET DEFAULT PEN COLOR/WIDTH
      DATA PENTBL(1,1)/1/, PENTBL(1,2)/0/
      DATA PENTBL(2,1)/1/, PENTBL(2,2)/1/
      DATA PENTBL(3,1)/1/, PENTBL(3,2)/2/
      DATA PENTBL(4,1)/1/, PENTBL(4,2)/3/
      DATA PENTBL(5,1)/1/, PENTBL(5,2)/4/
      DATA PENTBL(6,1)/1/, PENTBL(6,2)/5/
      DATA PENTBL(7,1)/1/, PENTBL(7,2)/6/
      DATA PENTBL(8,1)/1/, PENTBL(8,2)/7/
      DATA PENTBL(9,1)/1/, PENTBL(9,2)/8/
      DATA PENTBL(10,1)/1/, PENTBL(10,2)/9/
      DATA PENTBL(11,1)/1/, PENTBL(11,2)/10/
      DATA PENTBL(12,1)/1/, PENTBL(12,2)/11/
      DATA PENTBL(13,1)/1/, PENTBL(13,2)/12/
      DATA PENTBL(14,1)/1/, PENTBL(14,2)/13/
      DATA PENTBL(15,1)/1/, PENTBL(15,2)/14/
      DATA PENTBL(16,1)/1/, PENTBL(16,2)/15/
      DATA PENTBL(17,1)/1/, PENTBL(17,2)/16/
      DATA PENTBL(18,1)/1/, PENTBL(18,2)/17/
      DATA PENTBL(19,1)/1/, PENTBL(19,2)/18/
      DATA PENTBL(20,1)/1/, PENTBL(20,2)/19/
      DATA PENTBL(21,1)/1/, PENTBL(21,2)/20/
      DATA PENTBL(22,1)/1/, PENTBL(22,2)/21/
      DATA PENTBL(23,1)/1/, PENTBL(23,2)/22/
      DATA PENTBL(24,1)/1/, PENTBL(24,2)/23/
      DATA PENTBL(25,1)/1/, PENTBL(25,2)/24/
      DATA PENTBL(26,1)/1/, PENTBL(26,2)/25/
      DATA PENTBL(27,1)/1/, PENTBL(27,2)/26/
      DATA PENTBL(28,1)/1/, PENTBL(28,2)/27/
      DATA PENTBL(29,1)/1/, PENTBL(29,2)/28/
      DATA PENTBL(30,1)/1/, PENTBL(30,2)/29/
      DATA PENTBL(31,1)/1/, PENTBL(31,2)/30/
      DATA PENTBL(32,1)/1/, PENTBL(32,2)/31/
      DATA PENTBL(33,1)/1/, PENTBL(33,2)/31/
      DATA PENTBL(34,1)/1/, PENTBL(34,2)/31/
      DATA PENTBL(35,1)/1/, PENTBL(35,2)/31/
      DATA PENTBL(36,1)/1/, PENTBL(36,2)/31/
      DATA PENTBL(37,1)/1/, PENTBL(37,2)/31/
      DATA PENTBL(38,1)/1/, PENTBL(38,2)/31/
      DATA PENTBL(39,1)/1/, PENTBL(39,2)/31/
      DATA PENTBL(40,1)/1/, PENTBL(40,2)/31/
      DATA PENTBL(41,1)/1/, PENTBL(41,2)/31/
      DATA PENTBL(42,1)/1/, PENTBL(42,2)/31/
      DATA PENTBL(43,1)/1/, PENTBL(43,2)/31/
      DATA PENTBL(44,1)/1/, PENTBL(44,2)/31/
      DATA PENTBL(45,1)/1/, PENTBL(45,2)/31/
      DATA PENTBL(46,1)/1/, PENTBL(46,2)/31/
      DATA PENTBL(47,1)/1/, PENTBL(47,2)/31/
      DATA PENTBL(48,1)/1/, PENTBL(48,2)/31/
      DATA PENTBL(49,1)/1/, PENTBL(49,2)/31/
      DATA PENTBL(50,1)/1/, PENTBL(50,2)/31/
      DATA PENTBL(51,1)/1/, PENTBL(51,2)/31/
      DATA PENTBL(52,1)/1/, PENTBL(52,2)/31/
      DATA PENTBL(53,1)/1/, PENTBL(53,2)/31/
      DATA PENTBL(54,1)/1/, PENTBL(54,2)/31/
      DATA PENTBL(55,1)/1/, PENTBL(55,2)/31/
      DATA PENTBL(56,1)/1/, PENTBL(56,2)/31/
      DATA PENTBL(57,1)/1/, PENTBL(57,2)/31/
      DATA PENTBL(58,1)/1/, PENTBL(58,2)/31/
      DATA PENTBL(59,1)/1/, PENTBL(59,2)/31/
      DATA PENTBL(60,1)/1/, PENTBL(60,2)/31/
      DATA PENTBL(61,1)/1/, PENTBL(61,2)/31/
      DATA PENTBL(62,1)/1/, PENTBL(62,2)/31/
      DATA PENTBL(63,1)/1/, PENTBL(63,2)/31/
      DATA PENTBL(64,1)/1/, PENTBL(64,2)/31/
C
C...  USER DEFINED COLOR FLAG.  IF A USER COLOR n, IS DEFINED
C     AT INSTALLATION TIME, THE IDEFLG(n-256) ENTRY MUST BE
C     INITIALIZED TO -1 TO INDICATE THAT THE COLOR HAS BEEN
C     PREDEFINED.
C
      DATA IDEFLG(  1)/ 0/, IDEFLG(  2)/ 0/, IDEFLG(  3)/ 0/
      DATA IDEFLG(  4)/ 0/, IDEFLG(  5)/ 0/, IDEFLG(  6)/ 0/
      DATA IDEFLG(  7)/ 0/, IDEFLG(  8)/ 0/, IDEFLG(  9)/ 0/
      DATA IDEFLG( 10)/ 0/, IDEFLG( 11)/ 0/, IDEFLG( 12)/ 0/
      DATA IDEFLG( 13)/ 0/, IDEFLG( 14)/ 0/, IDEFLG( 15)/ 0/
      DATA IDEFLG( 16)/ 0/, IDEFLG( 17)/ 0/, IDEFLG( 18)/ 0/
      DATA IDEFLG( 19)/ 0/, IDEFLG( 20)/ 0/, IDEFLG( 21)/ 0/
      DATA IDEFLG( 22)/ 0/, IDEFLG( 23)/ 0/, IDEFLG( 24)/ 0/
      DATA IDEFLG( 25)/ 0/, IDEFLG( 26)/ 0/, IDEFLG( 27)/ 0/
      DATA IDEFLG( 28)/ 0/, IDEFLG( 29)/ 0/, IDEFLG( 30)/ 0/
      DATA IDEFLG( 31)/ 0/, IDEFLG( 32)/ 0/, IDEFLG( 33)/ 0/
      DATA IDEFLG( 34)/ 0/, IDEFLG( 35)/ 0/, IDEFLG( 36)/ 0/
      DATA IDEFLG( 37)/ 0/, IDEFLG( 38)/ 0/, IDEFLG( 39)/ 0/
      DATA IDEFLG( 40)/ 0/, IDEFLG( 41)/ 0/, IDEFLG( 42)/ 0/
      DATA IDEFLG( 43)/ 0/, IDEFLG( 44)/ 0/, IDEFLG( 45)/ 0/
      DATA IDEFLG( 46)/ 0/, IDEFLG( 47)/ 0/, IDEFLG( 48)/ 0/
      DATA IDEFLG( 49)/ 0/, IDEFLG( 50)/ 0/, IDEFLG( 51)/ 0/
      DATA IDEFLG( 52)/ 0/, IDEFLG( 53)/ 0/, IDEFLG( 54)/ 0/
      DATA IDEFLG( 55)/ 0/, IDEFLG( 56)/ 0/, IDEFLG( 57)/ 0/
      DATA IDEFLG( 58)/ 0/, IDEFLG( 59)/ 0/, IDEFLG( 60)/ 0/
      DATA IDEFLG( 61)/ 0/, IDEFLG( 62)/ 0/, IDEFLG( 63)/ 0/
      DATA IDEFLG( 64)/ 0/, IDEFLG( 65)/ 0/, IDEFLG( 66)/ 0/
      DATA IDEFLG( 67)/ 0/, IDEFLG( 68)/ 0/, IDEFLG( 69)/ 0/
      DATA IDEFLG( 70)/ 0/, IDEFLG( 71)/ 0/, IDEFLG( 72)/ 0/
      DATA IDEFLG( 73)/ 0/, IDEFLG( 74)/ 0/, IDEFLG( 75)/ 0/
      DATA IDEFLG( 76)/ 0/, IDEFLG( 77)/ 0/, IDEFLG( 78)/ 0/
      DATA IDEFLG( 79)/ 0/, IDEFLG( 80)/ 0/, IDEFLG( 81)/ 0/
      DATA IDEFLG( 82)/ 0/, IDEFLG( 83)/ 0/, IDEFLG( 84)/ 0/
      DATA IDEFLG( 85)/ 0/, IDEFLG( 86)/ 0/, IDEFLG( 87)/ 0/
      DATA IDEFLG( 88)/ 0/, IDEFLG( 89)/ 0/, IDEFLG( 90)/ 0/
      DATA IDEFLG( 91)/ 0/, IDEFLG( 92)/ 0/, IDEFLG( 93)/ 0/
      DATA IDEFLG( 94)/ 0/, IDEFLG( 95)/ 0/, IDEFLG( 96)/ 0/
      DATA IDEFLG( 97)/ 0/, IDEFLG( 98)/ 0/, IDEFLG( 99)/ 0/
      DATA IDEFLG(100)/ 0/, IDEFLG(101)/ 0/, IDEFLG(102)/ 0/
      DATA IDEFLG(103)/ 0/, IDEFLG(104)/ 0/, IDEFLG(105)/ 0/
      DATA IDEFLG(106)/ 0/, IDEFLG(107)/ 0/, IDEFLG(108)/ 0/
      DATA IDEFLG(109)/ 0/, IDEFLG(110)/ 0/, IDEFLG(111)/ 0/
      DATA IDEFLG(112)/ 0/, IDEFLG(113)/ 0/, IDEFLG(114)/ 0/
      DATA IDEFLG(115)/ 0/, IDEFLG(116)/ 0/, IDEFLG(117)/ 0/
      DATA IDEFLG(118)/ 0/, IDEFLG(119)/ 0/, IDEFLG(120)/ 0/
      DATA IDEFLG(121)/ 0/, IDEFLG(122)/ 0/, IDEFLG(123)/ 0/
      DATA IDEFLG(124)/ 0/, IDEFLG(125)/ 0/, IDEFLG(126)/ 0/
      DATA IDEFLG(127)/ 0/, IDEFLG(128)/ 0/, IDEFLG(129)/ 0/
      DATA IDEFLG(130)/ 0/, IDEFLG(131)/ 0/, IDEFLG(132)/ 0/
      DATA IDEFLG(133)/ 0/, IDEFLG(134)/ 0/, IDEFLG(135)/ 0/
      DATA IDEFLG(136)/ 0/, IDEFLG(137)/ 0/, IDEFLG(138)/ 0/
      DATA IDEFLG(139)/ 0/, IDEFLG(140)/ 0/, IDEFLG(141)/ 0/
      DATA IDEFLG(142)/ 0/, IDEFLG(143)/ 0/, IDEFLG(144)/ 0/
      DATA IDEFLG(145)/ 0/, IDEFLG(146)/ 0/, IDEFLG(147)/ 0/
      DATA IDEFLG(148)/ 0/, IDEFLG(149)/ 0/, IDEFLG(150)/ 0/
      DATA IDEFLG(151)/ 0/, IDEFLG(152)/ 0/, IDEFLG(153)/ 0/
      DATA IDEFLG(154)/ 0/, IDEFLG(155)/ 0/, IDEFLG(156)/ 0/
      DATA IDEFLG(157)/ 0/, IDEFLG(158)/ 0/, IDEFLG(159)/ 0/
      DATA IDEFLG(160)/ 0/, IDEFLG(161)/ 0/, IDEFLG(162)/ 0/
      DATA IDEFLG(163)/ 0/, IDEFLG(164)/ 0/, IDEFLG(165)/ 0/
      DATA IDEFLG(166)/ 0/, IDEFLG(167)/ 0/, IDEFLG(168)/ 0/
      DATA IDEFLG(169)/ 0/, IDEFLG(170)/ 0/, IDEFLG(171)/ 0/
      DATA IDEFLG(172)/ 0/, IDEFLG(173)/ 0/, IDEFLG(174)/ 0/
      DATA IDEFLG(175)/ 0/, IDEFLG(176)/ 0/, IDEFLG(177)/ 0/
      DATA IDEFLG(178)/ 0/, IDEFLG(179)/ 0/, IDEFLG(180)/ 0/
      DATA IDEFLG(181)/ 0/, IDEFLG(182)/ 0/, IDEFLG(183)/ 0/
      DATA IDEFLG(184)/ 0/, IDEFLG(185)/ 0/, IDEFLG(186)/ 0/
      DATA IDEFLG(187)/ 0/, IDEFLG(188)/ 0/, IDEFLG(189)/ 0/
      DATA IDEFLG(190)/ 0/, IDEFLG(191)/ 0/, IDEFLG(192)/ 0/
      DATA IDEFLG(193)/ 0/, IDEFLG(194)/ 0/, IDEFLG(195)/ 0/
      DATA IDEFLG(196)/ 0/, IDEFLG(197)/ 0/, IDEFLG(198)/ 0/
      DATA IDEFLG(199)/ 0/, IDEFLG(200)/ 0/, IDEFLG(201)/ 0/
      DATA IDEFLG(202)/ 0/, IDEFLG(203)/ 0/, IDEFLG(204)/ 0/
      DATA IDEFLG(205)/ 0/, IDEFLG(206)/ 0/, IDEFLG(207)/ 0/
      DATA IDEFLG(208)/ 0/, IDEFLG(209)/ 0/, IDEFLG(210)/ 0/
      DATA IDEFLG(211)/ 0/, IDEFLG(212)/ 0/, IDEFLG(213)/ 0/
      DATA IDEFLG(214)/ 0/, IDEFLG(215)/ 0/, IDEFLG(216)/ 0/
      DATA IDEFLG(217)/ 0/, IDEFLG(218)/ 0/, IDEFLG(219)/ 0/
      DATA IDEFLG(220)/ 0/, IDEFLG(221)/ 0/, IDEFLG(222)/ 0/
      DATA IDEFLG(223)/ 0/, IDEFLG(224)/ 0/, IDEFLG(225)/ 0/
      DATA IDEFLG(226)/ 0/, IDEFLG(227)/ 0/, IDEFLG(228)/ 0/
      DATA IDEFLG(229)/ 0/, IDEFLG(230)/ 0/, IDEFLG(231)/ 0/
      DATA IDEFLG(232)/ 0/, IDEFLG(233)/ 0/, IDEFLG(234)/ 0/
      DATA IDEFLG(235)/ 0/, IDEFLG(236)/ 0/, IDEFLG(237)/ 0/
      DATA IDEFLG(238)/ 0/, IDEFLG(239)/ 0/, IDEFLG(240)/ 0/
      DATA IDEFLG(241)/ 0/, IDEFLG(242)/ 0/, IDEFLG(243)/ 0/
      DATA IDEFLG(244)/ 0/, IDEFLG(245)/ 0/, IDEFLG(246)/ 0/
      DATA IDEFLG(247)/ 0/, IDEFLG(248)/ 0/, IDEFLG(249)/ 0/
      DATA IDEFLG(250)/ 0/, IDEFLG(251)/ 0/, IDEFLG(252)/ 0/
      DATA IDEFLG(253)/ 0/, IDEFLG(254)/ 0/, IDEFLG(255)/ 0/
      DATA IDEFLG(256)/ 0/
C
C...  /CLRCOM/ COMMON
      DATA ICLMAX/512/
      DATA IVCFLG/0/, NCPASS/1/, ITNSEQ/1,0,0,0/
C
C
C...  DEFINE THE DEFAULT COLORS AS 4 DOT PATTERNS,
C     EACH PATTERN CORRESPONDING TO A COLOR TONER.
C     THE DOT PATTERNS ARE OVERLAYED TO PRODUCE THE COLOR.
C
C...  COLORS 1-256 ARE PREDEFINED HERE.
C     COLORS 257-512 ARE USER-DEFINABLE.  IF THEY ARE USED
C     WITHOUT BEING DEFINED, COLOR 1 (BLACK) IS USED INSTEAD.
C
C...  THE IDEFLG(256) ARRAY INDICATES WHETHER COLORS 257-512
C     HAVE BEEN DEFINED.  IF ANY OF THE COLORS 257-512 IS
C     PREDEFINED AT INSTALLATION TIME, A DATA STATEMENT SHOULD
C     BE ADDED HERE FOR THE COLOR, AND THE CORRESPONDING ENTRY
C     IN THE IDEFLG ARRAY SHOULD BE INITIALIZED TO -1.
C     NOTE THAT IDEFLG(N) CORRESPONDS TO COLOR N+256.
C
      DATA ICLRDF(1,001),ICLRDF(2,001)/00,63/
      DATA ICLRDF(3,001),ICLRDF(4,001)/63,63/
      DATA ICLRDF(1,002),ICLRDF(2,002)/63,00/
      DATA ICLRDF(3,002),ICLRDF(4,002)/63,63/
      DATA ICLRDF(1,003),ICLRDF(2,003)/63,63/
      DATA ICLRDF(3,003),ICLRDF(4,003)/00,63/
      DATA ICLRDF(1,004),ICLRDF(2,004)/63,63/
      DATA ICLRDF(3,004),ICLRDF(4,004)/63,00/
      DATA ICLRDF(1,005),ICLRDF(2,005)/63,00/
      DATA ICLRDF(3,005),ICLRDF(4,005)/00,63/
      DATA ICLRDF(1,006),ICLRDF(2,006)/63,63/
      DATA ICLRDF(3,006),ICLRDF(4,006)/00,00/
      DATA ICLRDF(1,007),ICLRDF(2,007)/63,00/
      DATA ICLRDF(3,007),ICLRDF(4,007)/63,00/
      DATA ICLRDF(1,008),ICLRDF(2,008)/63,00/
      DATA ICLRDF(3,008),ICLRDF(4,008)/00,00/
      DATA ICLRDF(1,009),ICLRDF(2,009)/63,63/
      DATA ICLRDF(3,009),ICLRDF(4,009)/63,63/
      DATA ICLRDF(1,010),ICLRDF(2,010)/48,63/
      DATA ICLRDF(3,010),ICLRDF(4,010)/63,63/
      DATA ICLRDF(1,011),ICLRDF(2,011)/51,63/
      DATA ICLRDF(3,011),ICLRDF(4,011)/63,63/
      DATA ICLRDF(1,012),ICLRDF(2,012)/53,63/
      DATA ICLRDF(3,012),ICLRDF(4,012)/63,63/
      DATA ICLRDF(1,013),ICLRDF(2,013)/59,63/
      DATA ICLRDF(3,013),ICLRDF(4,013)/63,63/
      DATA ICLRDF(1,014),ICLRDF(2,014)/62,63/
      DATA ICLRDF(3,014),ICLRDF(4,014)/63,63/
      DATA ICLRDF(1,015),ICLRDF(2,015)/00,63/
      DATA ICLRDF(3,015),ICLRDF(4,015)/63,63/
      DATA ICLRDF(1,016),ICLRDF(2,016)/63,48/
      DATA ICLRDF(3,016),ICLRDF(4,016)/48,63/
      DATA ICLRDF(1,017),ICLRDF(2,017)/63,53/
      DATA ICLRDF(3,017),ICLRDF(4,017)/53,63/
      DATA ICLRDF(1,018),ICLRDF(2,018)/63,59/
      DATA ICLRDF(3,018),ICLRDF(4,018)/59,63/
      DATA ICLRDF(1,019),ICLRDF(2,019)/63,62/
      DATA ICLRDF(3,019),ICLRDF(4,019)/62,63/
      DATA ICLRDF(1,020),ICLRDF(2,020)/63,00/
      DATA ICLRDF(3,020),ICLRDF(4,020)/00,63/
      DATA ICLRDF(1,021),ICLRDF(2,021)/49,00/
      DATA ICLRDF(3,021),ICLRDF(4,021)/00,63/
      DATA ICLRDF(1,022),ICLRDF(2,022)/54,00/
      DATA ICLRDF(3,022),ICLRDF(4,022)/00,63/
      DATA ICLRDF(1,023),ICLRDF(2,023)/57,00/
      DATA ICLRDF(3,023),ICLRDF(4,023)/00,63/
      DATA ICLRDF(1,024),ICLRDF(2,024)/59,00/
      DATA ICLRDF(3,024),ICLRDF(4,024)/00,63/
      DATA ICLRDF(1,025),ICLRDF(2,025)/63,53/
      DATA ICLRDF(3,025),ICLRDF(4,025)/51,63/
      DATA ICLRDF(1,026),ICLRDF(2,026)/63,59/
      DATA ICLRDF(3,026),ICLRDF(4,026)/56,63/
      DATA ICLRDF(1,027),ICLRDF(2,027)/63,62/
      DATA ICLRDF(3,027),ICLRDF(4,027)/60,63/
      DATA ICLRDF(1,028),ICLRDF(2,028)/63,00/
      DATA ICLRDF(3,028),ICLRDF(4,028)/62,63/
      DATA ICLRDF(1,029),ICLRDF(2,029)/49,00/
      DATA ICLRDF(3,029),ICLRDF(4,029)/62,63/
      DATA ICLRDF(1,030),ICLRDF(2,030)/54,00/
      DATA ICLRDF(3,030),ICLRDF(4,030)/62,63/
      DATA ICLRDF(1,031),ICLRDF(2,031)/57,00/
      DATA ICLRDF(3,031),ICLRDF(4,031)/62,63/
      DATA ICLRDF(1,032),ICLRDF(2,032)/63,53/
      DATA ICLRDF(3,032),ICLRDF(4,032)/50,63/
      DATA ICLRDF(1,033),ICLRDF(2,033)/63,59/
      DATA ICLRDF(3,033),ICLRDF(4,033)/53,63/
      DATA ICLRDF(1,034),ICLRDF(2,034)/63,62/
      DATA ICLRDF(3,034),ICLRDF(4,034)/56,63/
      DATA ICLRDF(1,035),ICLRDF(2,035)/63,00/
      DATA ICLRDF(3,035),ICLRDF(4,035)/59,63/
      DATA ICLRDF(1,036),ICLRDF(2,036)/49,00/
      DATA ICLRDF(3,036),ICLRDF(4,036)/59,63/
      DATA ICLRDF(1,037),ICLRDF(2,037)/54,00/
      DATA ICLRDF(3,037),ICLRDF(4,037)/59,63/
      DATA ICLRDF(1,038),ICLRDF(2,038)/57,00/
      DATA ICLRDF(3,038),ICLRDF(4,038)/59,63/
      DATA ICLRDF(1,039),ICLRDF(2,039)/63,53/
      DATA ICLRDF(3,039),ICLRDF(4,039)/48,63/
      DATA ICLRDF(1,040),ICLRDF(2,040)/63,59/
      DATA ICLRDF(3,040),ICLRDF(4,040)/51,63/
      DATA ICLRDF(1,041),ICLRDF(2,041)/63,62/
      DATA ICLRDF(3,041),ICLRDF(4,041)/52,63/
      DATA ICLRDF(1,042),ICLRDF(2,042)/63,00/
      DATA ICLRDF(3,042),ICLRDF(4,042)/53,63/
      DATA ICLRDF(1,043),ICLRDF(2,043)/49,00/
      DATA ICLRDF(3,043),ICLRDF(4,043)/53,63/
      DATA ICLRDF(1,044),ICLRDF(2,044)/54,00/
      DATA ICLRDF(3,044),ICLRDF(4,044)/53,63/
      DATA ICLRDF(1,045),ICLRDF(2,045)/57,00/
      DATA ICLRDF(3,045),ICLRDF(4,045)/53,63/
      DATA ICLRDF(1,046),ICLRDF(2,046)/63,53/
      DATA ICLRDF(3,046),ICLRDF(4,046)/46,63/
      DATA ICLRDF(1,047),ICLRDF(2,047)/63,59/
      DATA ICLRDF(3,047),ICLRDF(4,047)/50,63/
      DATA ICLRDF(1,048),ICLRDF(2,048)/63,62/
      DATA ICLRDF(3,048),ICLRDF(4,048)/50,63/
      DATA ICLRDF(1,049),ICLRDF(2,049)/63,00/
      DATA ICLRDF(3,049),ICLRDF(4,049)/51,63/
      DATA ICLRDF(1,050),ICLRDF(2,050)/49,00/
      DATA ICLRDF(3,050),ICLRDF(4,050)/51,63/
      DATA ICLRDF(1,051),ICLRDF(2,051)/54,00/
      DATA ICLRDF(3,051),ICLRDF(4,051)/51,63/
      DATA ICLRDF(1,052),ICLRDF(2,052)/58,00/
      DATA ICLRDF(3,052),ICLRDF(4,052)/51,63/
      DATA ICLRDF(1,053),ICLRDF(2,053)/63,53/
      DATA ICLRDF(3,053),ICLRDF(4,053)/45,63/
      DATA ICLRDF(1,054),ICLRDF(2,054)/63,59/
      DATA ICLRDF(3,054),ICLRDF(4,054)/46,63/
      DATA ICLRDF(1,055),ICLRDF(2,055)/63,62/
      DATA ICLRDF(3,055),ICLRDF(4,055)/47,63/
      DATA ICLRDF(1,056),ICLRDF(2,056)/63,00/
      DATA ICLRDF(3,056),ICLRDF(4,056)/48,63/
      DATA ICLRDF(1,057),ICLRDF(2,057)/49,00/
      DATA ICLRDF(3,057),ICLRDF(4,057)/48,63/
      DATA ICLRDF(1,058),ICLRDF(2,058)/54,00/
      DATA ICLRDF(3,058),ICLRDF(4,058)/48,63/
      DATA ICLRDF(1,059),ICLRDF(2,059)/57,00/
      DATA ICLRDF(3,059),ICLRDF(4,059)/48,63/
      DATA ICLRDF(1,060),ICLRDF(2,060)/63,48/
      DATA ICLRDF(3,060),ICLRDF(4,060)/63,63/
      DATA ICLRDF(1,061),ICLRDF(2,061)/63,53/
      DATA ICLRDF(3,061),ICLRDF(4,061)/63,63/
      DATA ICLRDF(1,062),ICLRDF(2,062)/63,59/
      DATA ICLRDF(3,062),ICLRDF(4,062)/63,63/
      DATA ICLRDF(1,063),ICLRDF(2,063)/63,62/
      DATA ICLRDF(3,063),ICLRDF(4,063)/63,63/
      DATA ICLRDF(1,064),ICLRDF(2,064)/63,00/
      DATA ICLRDF(3,064),ICLRDF(4,064)/63,63/
      DATA ICLRDF(1,065),ICLRDF(2,065)/49,00/
      DATA ICLRDF(3,065),ICLRDF(4,065)/63,63/
      DATA ICLRDF(1,066),ICLRDF(2,066)/54,00/
      DATA ICLRDF(3,066),ICLRDF(4,066)/63,63/
      DATA ICLRDF(1,067),ICLRDF(2,067)/57,00/
      DATA ICLRDF(3,067),ICLRDF(4,067)/63,63/
      DATA ICLRDF(1,068),ICLRDF(2,068)/59,00/
      DATA ICLRDF(3,068),ICLRDF(4,068)/63,63/
      DATA ICLRDF(1,069),ICLRDF(2,069)/63,53/
      DATA ICLRDF(3,069),ICLRDF(4,069)/63,48/
      DATA ICLRDF(1,070),ICLRDF(2,070)/63,59/
      DATA ICLRDF(3,070),ICLRDF(4,070)/63,51/
      DATA ICLRDF(1,071),ICLRDF(2,071)/63,62/
      DATA ICLRDF(3,071),ICLRDF(4,071)/63,52/
      DATA ICLRDF(1,072),ICLRDF(2,072)/63,00/
      DATA ICLRDF(3,072),ICLRDF(4,072)/63,53/
      DATA ICLRDF(1,073),ICLRDF(2,073)/49,00/
      DATA ICLRDF(3,073),ICLRDF(4,073)/63,53/
      DATA ICLRDF(1,074),ICLRDF(2,074)/54,00/
      DATA ICLRDF(3,074),ICLRDF(4,074)/63,53/
      DATA ICLRDF(1,075),ICLRDF(2,075)/57,00/
      DATA ICLRDF(3,075),ICLRDF(4,075)/63,53/
      DATA ICLRDF(1,076),ICLRDF(2,076)/63,53/
      DATA ICLRDF(3,076),ICLRDF(4,076)/63,51/
      DATA ICLRDF(1,077),ICLRDF(2,077)/63,59/
      DATA ICLRDF(3,077),ICLRDF(4,077)/63,55/
      DATA ICLRDF(1,078),ICLRDF(2,078)/63,62/
      DATA ICLRDF(3,078),ICLRDF(4,078)/63,59/
      DATA ICLRDF(1,079),ICLRDF(2,079)/63,00/
      DATA ICLRDF(3,079),ICLRDF(4,079)/63,61/
      DATA ICLRDF(1,080),ICLRDF(2,080)/49,00/
      DATA ICLRDF(3,080),ICLRDF(4,080)/63,61/
      DATA ICLRDF(1,081),ICLRDF(2,081)/54,00/
      DATA ICLRDF(3,081),ICLRDF(4,081)/63,61/
      DATA ICLRDF(1,082),ICLRDF(2,082)/57,00/
      DATA ICLRDF(3,082),ICLRDF(4,082)/63,61/
      DATA ICLRDF(1,083),ICLRDF(2,083)/63,48/
      DATA ICLRDF(3,083),ICLRDF(4,083)/63,48/
      DATA ICLRDF(1,084),ICLRDF(2,084)/63,53/
      DATA ICLRDF(3,084),ICLRDF(4,084)/63,53/
      DATA ICLRDF(1,085),ICLRDF(2,085)/63,59/
      DATA ICLRDF(3,085),ICLRDF(4,085)/63,59/
      DATA ICLRDF(1,086),ICLRDF(2,086)/63,62/
      DATA ICLRDF(3,086),ICLRDF(4,086)/63,62/
      DATA ICLRDF(1,087),ICLRDF(2,087)/63,00/
      DATA ICLRDF(3,087),ICLRDF(4,087)/63,00/
      DATA ICLRDF(1,088),ICLRDF(2,088)/49,00/
      DATA ICLRDF(3,088),ICLRDF(4,088)/63,00/
      DATA ICLRDF(1,089),ICLRDF(2,089)/54,00/
      DATA ICLRDF(3,089),ICLRDF(4,089)/63,00/
      DATA ICLRDF(1,090),ICLRDF(2,090)/57,00/
      DATA ICLRDF(3,090),ICLRDF(4,090)/63,00/
      DATA ICLRDF(1,091),ICLRDF(2,091)/59,00/
      DATA ICLRDF(3,091),ICLRDF(4,091)/63,00/
      DATA ICLRDF(1,092),ICLRDF(2,092)/63,51/
      DATA ICLRDF(3,092),ICLRDF(4,092)/63,53/
      DATA ICLRDF(1,093),ICLRDF(2,093)/63,56/
      DATA ICLRDF(3,093),ICLRDF(4,093)/63,59/
      DATA ICLRDF(1,094),ICLRDF(2,094)/63,60/
      DATA ICLRDF(3,094),ICLRDF(4,094)/63,62/
      DATA ICLRDF(1,095),ICLRDF(2,095)/63,62/
      DATA ICLRDF(3,095),ICLRDF(4,095)/63,00/
      DATA ICLRDF(1,096),ICLRDF(2,096)/49,62/
      DATA ICLRDF(3,096),ICLRDF(4,096)/63,00/
      DATA ICLRDF(1,097),ICLRDF(2,097)/54,62/
      DATA ICLRDF(3,097),ICLRDF(4,097)/63,00/
      DATA ICLRDF(1,098),ICLRDF(2,098)/57,62/
      DATA ICLRDF(3,098),ICLRDF(4,098)/63,00/
      DATA ICLRDF(1,099),ICLRDF(2,099)/63,50/
      DATA ICLRDF(3,099),ICLRDF(4,099)/63,53/
      DATA ICLRDF(1,100),ICLRDF(2,100)/63,53/
      DATA ICLRDF(3,100),ICLRDF(4,100)/63,59/
      DATA ICLRDF(1,101),ICLRDF(2,101)/63,56/
      DATA ICLRDF(3,101),ICLRDF(4,101)/63,62/
      DATA ICLRDF(1,102),ICLRDF(2,102)/63,59/
      DATA ICLRDF(3,102),ICLRDF(4,102)/63,00/
      DATA ICLRDF(1,103),ICLRDF(2,103)/49,59/
      DATA ICLRDF(3,103),ICLRDF(4,103)/63,00/
      DATA ICLRDF(1,104),ICLRDF(2,104)/54,59/
      DATA ICLRDF(3,104),ICLRDF(4,104)/63,00/
      DATA ICLRDF(1,105),ICLRDF(2,105)/57,59/
      DATA ICLRDF(3,105),ICLRDF(4,105)/63,00/
      DATA ICLRDF(1,106),ICLRDF(2,106)/63,48/
      DATA ICLRDF(3,106),ICLRDF(4,106)/63,53/
      DATA ICLRDF(1,107),ICLRDF(2,107)/63,51/
      DATA ICLRDF(3,107),ICLRDF(4,107)/63,59/
      DATA ICLRDF(1,108),ICLRDF(2,108)/63,52/
      DATA ICLRDF(3,108),ICLRDF(4,108)/63,62/
      DATA ICLRDF(1,109),ICLRDF(2,109)/63,53/
      DATA ICLRDF(3,109),ICLRDF(4,109)/63,00/
      DATA ICLRDF(1,110),ICLRDF(2,110)/49,53/
      DATA ICLRDF(3,110),ICLRDF(4,110)/63,00/
      DATA ICLRDF(1,111),ICLRDF(2,111)/54,53/
      DATA ICLRDF(3,111),ICLRDF(4,111)/63,00/
      DATA ICLRDF(1,112),ICLRDF(2,112)/57,53/
      DATA ICLRDF(3,112),ICLRDF(4,112)/63,00/
      DATA ICLRDF(1,113),ICLRDF(2,113)/63,46/
      DATA ICLRDF(3,113),ICLRDF(4,113)/63,53/
      DATA ICLRDF(1,114),ICLRDF(2,114)/63,50/
      DATA ICLRDF(3,114),ICLRDF(4,114)/63,59/
      DATA ICLRDF(1,115),ICLRDF(2,115)/63,50/
      DATA ICLRDF(3,115),ICLRDF(4,115)/63,62/
      DATA ICLRDF(1,116),ICLRDF(2,116)/63,51/
      DATA ICLRDF(3,116),ICLRDF(4,116)/63,00/
      DATA ICLRDF(1,117),ICLRDF(2,117)/49,51/
      DATA ICLRDF(3,117),ICLRDF(4,117)/63,00/
      DATA ICLRDF(1,118),ICLRDF(2,118)/54,51/
      DATA ICLRDF(3,118),ICLRDF(4,118)/63,00/
      DATA ICLRDF(1,119),ICLRDF(2,119)/58,51/
      DATA ICLRDF(3,119),ICLRDF(4,119)/63,00/
      DATA ICLRDF(1,120),ICLRDF(2,120)/63,45/
      DATA ICLRDF(3,120),ICLRDF(4,120)/63,53/
      DATA ICLRDF(1,121),ICLRDF(2,121)/63,46/
      DATA ICLRDF(3,121),ICLRDF(4,121)/63,59/
      DATA ICLRDF(1,122),ICLRDF(2,122)/63,47/
      DATA ICLRDF(3,122),ICLRDF(4,122)/63,62/
      DATA ICLRDF(1,123),ICLRDF(2,123)/63,48/
      DATA ICLRDF(3,123),ICLRDF(4,123)/63,00/
      DATA ICLRDF(1,124),ICLRDF(2,124)/49,48/
      DATA ICLRDF(3,124),ICLRDF(4,124)/63,00/
      DATA ICLRDF(1,125),ICLRDF(2,125)/54,48/
      DATA ICLRDF(3,125),ICLRDF(4,125)/63,00/
      DATA ICLRDF(1,126),ICLRDF(2,126)/57,48/
      DATA ICLRDF(3,126),ICLRDF(4,126)/63,00/
      DATA ICLRDF(1,127),ICLRDF(2,127)/63,63/
      DATA ICLRDF(3,127),ICLRDF(4,127)/63,48/
      DATA ICLRDF(1,128),ICLRDF(2,128)/63,63/
      DATA ICLRDF(3,128),ICLRDF(4,128)/63,53/
      DATA ICLRDF(1,129),ICLRDF(2,129)/63,63/
      DATA ICLRDF(3,129),ICLRDF(4,129)/63,59/
      DATA ICLRDF(1,130),ICLRDF(2,130)/63,63/
      DATA ICLRDF(3,130),ICLRDF(4,130)/63,62/
      DATA ICLRDF(1,131),ICLRDF(2,131)/63,63/
      DATA ICLRDF(3,131),ICLRDF(4,131)/63,00/
      DATA ICLRDF(1,132),ICLRDF(2,132)/49,63/
      DATA ICLRDF(3,132),ICLRDF(4,132)/63,00/
      DATA ICLRDF(1,133),ICLRDF(2,133)/54,63/
      DATA ICLRDF(3,133),ICLRDF(4,133)/63,00/
      DATA ICLRDF(1,134),ICLRDF(2,134)/57,63/
      DATA ICLRDF(3,134),ICLRDF(4,134)/63,00/
      DATA ICLRDF(1,135),ICLRDF(2,135)/59,63/
      DATA ICLRDF(3,135),ICLRDF(4,135)/63,00/
      DATA ICLRDF(1,136),ICLRDF(2,136)/63,63/
      DATA ICLRDF(3,136),ICLRDF(4,136)/45,53/
      DATA ICLRDF(1,137),ICLRDF(2,137)/63,63/
      DATA ICLRDF(3,137),ICLRDF(4,137)/46,59/
      DATA ICLRDF(1,138),ICLRDF(2,138)/63,63/
      DATA ICLRDF(3,138),ICLRDF(4,138)/47,62/
      DATA ICLRDF(1,139),ICLRDF(2,139)/63,63/
      DATA ICLRDF(3,139),ICLRDF(4,139)/48,00/
      DATA ICLRDF(1,140),ICLRDF(2,140)/49,63/
      DATA ICLRDF(3,140),ICLRDF(4,140)/48,00/
      DATA ICLRDF(1,141),ICLRDF(2,141)/54,63/
      DATA ICLRDF(3,141),ICLRDF(4,141)/48,00/
      DATA ICLRDF(1,142),ICLRDF(2,142)/57,63/
      DATA ICLRDF(3,142),ICLRDF(4,142)/48,00/
      DATA ICLRDF(1,143),ICLRDF(2,143)/63,63/
      DATA ICLRDF(3,143),ICLRDF(4,143)/46,53/
      DATA ICLRDF(1,144),ICLRDF(2,144)/63,63/
      DATA ICLRDF(3,144),ICLRDF(4,144)/50,59/
      DATA ICLRDF(1,145),ICLRDF(2,145)/63,63/
      DATA ICLRDF(3,145),ICLRDF(4,145)/50,62/
      DATA ICLRDF(1,146),ICLRDF(2,146)/63,63/
      DATA ICLRDF(3,146),ICLRDF(4,146)/51,00/
      DATA ICLRDF(1,147),ICLRDF(2,147)/49,63/
      DATA ICLRDF(3,147),ICLRDF(4,147)/51,00/
      DATA ICLRDF(1,148),ICLRDF(2,148)/54,63/
      DATA ICLRDF(3,148),ICLRDF(4,148)/51,00/
      DATA ICLRDF(1,149),ICLRDF(2,149)/58,63/
      DATA ICLRDF(3,149),ICLRDF(4,149)/51,00/
      DATA ICLRDF(1,150),ICLRDF(2,150)/63,63/
      DATA ICLRDF(3,150),ICLRDF(4,150)/48,53/
      DATA ICLRDF(1,151),ICLRDF(2,151)/63,63/
      DATA ICLRDF(3,151),ICLRDF(4,151)/51,59/
      DATA ICLRDF(1,152),ICLRDF(2,152)/63,63/
      DATA ICLRDF(3,152),ICLRDF(4,152)/52,62/
      DATA ICLRDF(1,153),ICLRDF(2,153)/63,63/
      DATA ICLRDF(3,153),ICLRDF(4,153)/53,00/
      DATA ICLRDF(1,154),ICLRDF(2,154)/49,63/
      DATA ICLRDF(3,154),ICLRDF(4,154)/53,00/
      DATA ICLRDF(1,155),ICLRDF(2,155)/54,63/
      DATA ICLRDF(3,155),ICLRDF(4,155)/53,00/
      DATA ICLRDF(1,156),ICLRDF(2,156)/57,63/
      DATA ICLRDF(3,156),ICLRDF(4,156)/53,00/
      DATA ICLRDF(1,157),ICLRDF(2,157)/63,63/
      DATA ICLRDF(3,157),ICLRDF(4,157)/50,53/
      DATA ICLRDF(1,158),ICLRDF(2,158)/63,63/
      DATA ICLRDF(3,158),ICLRDF(4,158)/53,59/
      DATA ICLRDF(1,159),ICLRDF(2,159)/63,63/
      DATA ICLRDF(3,159),ICLRDF(4,159)/56,62/
      DATA ICLRDF(1,160),ICLRDF(2,160)/63,63/
      DATA ICLRDF(3,160),ICLRDF(4,160)/59,00/
      DATA ICLRDF(1,161),ICLRDF(2,161)/49,63/
      DATA ICLRDF(3,161),ICLRDF(4,161)/59,00/
      DATA ICLRDF(1,162),ICLRDF(2,162)/54,63/
      DATA ICLRDF(3,162),ICLRDF(4,162)/59,00/
      DATA ICLRDF(1,163),ICLRDF(2,163)/57,63/
      DATA ICLRDF(3,163),ICLRDF(4,163)/59,00/
      DATA ICLRDF(1,164),ICLRDF(2,164)/63,63/
      DATA ICLRDF(3,164),ICLRDF(4,164)/51,53/
      DATA ICLRDF(1,165),ICLRDF(2,165)/63,63/
      DATA ICLRDF(3,165),ICLRDF(4,165)/56,59/
      DATA ICLRDF(1,166),ICLRDF(2,166)/63,63/
      DATA ICLRDF(3,166),ICLRDF(4,166)/60,62/
      DATA ICLRDF(1,167),ICLRDF(2,167)/63,63/
      DATA ICLRDF(3,167),ICLRDF(4,167)/62,00/
      DATA ICLRDF(1,168),ICLRDF(2,168)/49,63/
      DATA ICLRDF(3,168),ICLRDF(4,168)/62,00/
      DATA ICLRDF(1,169),ICLRDF(2,169)/54,63/
      DATA ICLRDF(3,169),ICLRDF(4,169)/62,00/
      DATA ICLRDF(1,170),ICLRDF(2,170)/57,63/
      DATA ICLRDF(3,170),ICLRDF(4,170)/62,00/
      DATA ICLRDF(1,171),ICLRDF(2,171)/63,63/
      DATA ICLRDF(3,171),ICLRDF(4,171)/48,48/
      DATA ICLRDF(1,172),ICLRDF(2,172)/63,63/
      DATA ICLRDF(3,172),ICLRDF(4,172)/53,53/
      DATA ICLRDF(1,173),ICLRDF(2,173)/63,63/
      DATA ICLRDF(3,173),ICLRDF(4,173)/59,59/
      DATA ICLRDF(1,174),ICLRDF(2,174)/63,63/
      DATA ICLRDF(3,174),ICLRDF(4,174)/62,62/
      DATA ICLRDF(1,175),ICLRDF(2,175)/63,63/
      DATA ICLRDF(3,175),ICLRDF(4,175)/00,00/
      DATA ICLRDF(1,176),ICLRDF(2,176)/49,63/
      DATA ICLRDF(3,176),ICLRDF(4,176)/00,00/
      DATA ICLRDF(1,177),ICLRDF(2,177)/54,63/
      DATA ICLRDF(3,177),ICLRDF(4,177)/00,00/
      DATA ICLRDF(1,178),ICLRDF(2,178)/57,63/
      DATA ICLRDF(3,178),ICLRDF(4,178)/00,00/
      DATA ICLRDF(1,179),ICLRDF(2,179)/59,63/
      DATA ICLRDF(3,179),ICLRDF(4,179)/00,00/
      DATA ICLRDF(1,180),ICLRDF(2,180)/63,63/
      DATA ICLRDF(3,180),ICLRDF(4,180)/53,48/
      DATA ICLRDF(1,181),ICLRDF(2,181)/63,63/
      DATA ICLRDF(3,181),ICLRDF(4,181)/59,51/
      DATA ICLRDF(1,182),ICLRDF(2,182)/63,63/
      DATA ICLRDF(3,182),ICLRDF(4,182)/62,52/
      DATA ICLRDF(1,183),ICLRDF(2,183)/63,63/
      DATA ICLRDF(3,183),ICLRDF(4,183)/00,53/
      DATA ICLRDF(1,184),ICLRDF(2,184)/49,63/
      DATA ICLRDF(3,184),ICLRDF(4,184)/00,53/
      DATA ICLRDF(1,185),ICLRDF(2,185)/54,63/
      DATA ICLRDF(3,185),ICLRDF(4,185)/00,53/
      DATA ICLRDF(1,186),ICLRDF(2,186)/57,63/
      DATA ICLRDF(3,186),ICLRDF(4,186)/00,53/
      DATA ICLRDF(1,187),ICLRDF(2,187)/63,63/
      DATA ICLRDF(3,187),ICLRDF(4,187)/48,63/
      DATA ICLRDF(1,188),ICLRDF(2,188)/63,63/
      DATA ICLRDF(3,188),ICLRDF(4,188)/53,63/
      DATA ICLRDF(1,189),ICLRDF(2,189)/63,63/
      DATA ICLRDF(3,189),ICLRDF(4,189)/59,63/
      DATA ICLRDF(1,190),ICLRDF(2,190)/63,63/
      DATA ICLRDF(3,190),ICLRDF(4,190)/62,63/
      DATA ICLRDF(1,191),ICLRDF(2,191)/63,63/
      DATA ICLRDF(3,191),ICLRDF(4,191)/00,63/
      DATA ICLRDF(1,192),ICLRDF(2,192)/49,63/
      DATA ICLRDF(3,192),ICLRDF(4,192)/00,63/
      DATA ICLRDF(1,193),ICLRDF(2,193)/54,63/
      DATA ICLRDF(3,193),ICLRDF(4,193)/00,63/
      DATA ICLRDF(1,194),ICLRDF(2,194)/57,63/
      DATA ICLRDF(3,194),ICLRDF(4,194)/00,63/
      DATA ICLRDF(1,195),ICLRDF(2,195)/59,63/
      DATA ICLRDF(3,195),ICLRDF(4,195)/00,63/
      DATA ICLRDF(1,196),ICLRDF(2,196)/63,45/
      DATA ICLRDF(3,196),ICLRDF(4,196)/53,63/
      DATA ICLRDF(1,197),ICLRDF(2,197)/63,46/
      DATA ICLRDF(3,197),ICLRDF(4,197)/59,63/
      DATA ICLRDF(1,198),ICLRDF(2,198)/63,47/
      DATA ICLRDF(3,198),ICLRDF(4,198)/62,63/
      DATA ICLRDF(1,199),ICLRDF(2,199)/63,48/
      DATA ICLRDF(3,199),ICLRDF(4,199)/00,63/
      DATA ICLRDF(1,200),ICLRDF(2,200)/49,48/
      DATA ICLRDF(3,200),ICLRDF(4,200)/00,63/
      DATA ICLRDF(1,201),ICLRDF(2,201)/54,48/
      DATA ICLRDF(3,201),ICLRDF(4,201)/00,63/
      DATA ICLRDF(1,202),ICLRDF(2,202)/57,48/
      DATA ICLRDF(3,202),ICLRDF(4,202)/00,63/
      DATA ICLRDF(1,203),ICLRDF(2,203)/63,46/
      DATA ICLRDF(3,203),ICLRDF(4,203)/53,63/
      DATA ICLRDF(1,204),ICLRDF(2,204)/63,50/
      DATA ICLRDF(3,204),ICLRDF(4,204)/59,63/
      DATA ICLRDF(1,205),ICLRDF(2,205)/63,50/
      DATA ICLRDF(3,205),ICLRDF(4,205)/62,63/
      DATA ICLRDF(1,206),ICLRDF(2,206)/63,51/
      DATA ICLRDF(3,206),ICLRDF(4,206)/00,63/
      DATA ICLRDF(1,207),ICLRDF(2,207)/49,51/
      DATA ICLRDF(3,207),ICLRDF(4,207)/00,63/
      DATA ICLRDF(1,208),ICLRDF(2,208)/54,51/
      DATA ICLRDF(3,208),ICLRDF(4,208)/00,63/
      DATA ICLRDF(1,209),ICLRDF(2,209)/58,51/
      DATA ICLRDF(3,209),ICLRDF(4,209)/00,63/
      DATA ICLRDF(1,210),ICLRDF(2,210)/63,48/
      DATA ICLRDF(3,210),ICLRDF(4,210)/53,63/
      DATA ICLRDF(1,211),ICLRDF(2,211)/63,51/
      DATA ICLRDF(3,211),ICLRDF(4,211)/59,63/
      DATA ICLRDF(1,212),ICLRDF(2,212)/63,52/
      DATA ICLRDF(3,212),ICLRDF(4,212)/62,63/
      DATA ICLRDF(1,213),ICLRDF(2,213)/63,53/
      DATA ICLRDF(3,213),ICLRDF(4,213)/00,63/
      DATA ICLRDF(1,214),ICLRDF(2,214)/49,53/
      DATA ICLRDF(3,214),ICLRDF(4,214)/00,63/
      DATA ICLRDF(1,215),ICLRDF(2,215)/54,53/
      DATA ICLRDF(3,215),ICLRDF(4,215)/00,63/
      DATA ICLRDF(1,216),ICLRDF(2,216)/57,53/
      DATA ICLRDF(3,216),ICLRDF(4,216)/00,63/
      DATA ICLRDF(1,217),ICLRDF(2,217)/63,50/
      DATA ICLRDF(3,217),ICLRDF(4,217)/53,63/
      DATA ICLRDF(1,218),ICLRDF(2,218)/63,53/
      DATA ICLRDF(3,218),ICLRDF(4,218)/59,63/
      DATA ICLRDF(1,219),ICLRDF(2,219)/63,56/
      DATA ICLRDF(3,219),ICLRDF(4,219)/62,63/
      DATA ICLRDF(1,220),ICLRDF(2,220)/63,59/
      DATA ICLRDF(3,220),ICLRDF(4,220)/00,63/
      DATA ICLRDF(1,221),ICLRDF(2,221)/49,59/
      DATA ICLRDF(3,221),ICLRDF(4,221)/00,63/
      DATA ICLRDF(1,222),ICLRDF(2,222)/54,59/
      DATA ICLRDF(3,222),ICLRDF(4,222)/00,63/
      DATA ICLRDF(1,223),ICLRDF(2,223)/57,59/
      DATA ICLRDF(3,223),ICLRDF(4,223)/00,63/
      DATA ICLRDF(1,224),ICLRDF(2,224)/63,51/
      DATA ICLRDF(3,224),ICLRDF(4,224)/53,63/
      DATA ICLRDF(1,225),ICLRDF(2,225)/63,56/
      DATA ICLRDF(3,225),ICLRDF(4,225)/59,63/
      DATA ICLRDF(1,226),ICLRDF(2,226)/63,60/
      DATA ICLRDF(3,226),ICLRDF(4,226)/62,63/
      DATA ICLRDF(1,227),ICLRDF(2,227)/63,62/
      DATA ICLRDF(3,227),ICLRDF(4,227)/00,63/
      DATA ICLRDF(1,228),ICLRDF(2,228)/49,62/
      DATA ICLRDF(3,228),ICLRDF(4,228)/00,63/
      DATA ICLRDF(1,229),ICLRDF(2,229)/54,62/
      DATA ICLRDF(3,229),ICLRDF(4,229)/00,63/
      DATA ICLRDF(1,230),ICLRDF(2,230)/57,62/
      DATA ICLRDF(3,230),ICLRDF(4,230)/00,63/
      DATA ICLRDF(1,231),ICLRDF(2,231)/63,48/
      DATA ICLRDF(3,231),ICLRDF(4,231)/48,48/
      DATA ICLRDF(1,232),ICLRDF(2,232)/63,51/
      DATA ICLRDF(3,232),ICLRDF(4,232)/51,51/
      DATA ICLRDF(1,233),ICLRDF(2,233)/63,53/
      DATA ICLRDF(3,233),ICLRDF(4,233)/53,53/
      DATA ICLRDF(1,234),ICLRDF(2,234)/63,59/
      DATA ICLRDF(3,234),ICLRDF(4,234)/59,59/
      DATA ICLRDF(1,235),ICLRDF(2,235)/63,62/
      DATA ICLRDF(3,235),ICLRDF(4,235)/62,62/
      DATA ICLRDF(1,236),ICLRDF(2,236)/63,00/
      DATA ICLRDF(3,236),ICLRDF(4,236)/00,00/
      DATA ICLRDF(1,237),ICLRDF(2,237)/63,44/
      DATA ICLRDF(3,237),ICLRDF(4,237)/42,53/
      DATA ICLRDF(1,238),ICLRDF(2,238)/63,44/
      DATA ICLRDF(3,238),ICLRDF(4,238)/53,53/
      DATA ICLRDF(1,239),ICLRDF(2,239)/63,42/
      DATA ICLRDF(3,239),ICLRDF(4,239)/53,44/
      DATA ICLRDF(1,240),ICLRDF(2,240)/63,53/
      DATA ICLRDF(3,240),ICLRDF(4,240)/53,44/
      DATA ICLRDF(1,241),ICLRDF(2,241)/63,53/
      DATA ICLRDF(3,241),ICLRDF(4,241)/44,42/
      DATA ICLRDF(1,242),ICLRDF(2,242)/63,53/
      DATA ICLRDF(3,242),ICLRDF(4,242)/44,53/
      DATA ICLRDF(1,243),ICLRDF(2,243)/63,53/
      DATA ICLRDF(3,243),ICLRDF(4,243)/54,43/
      DATA ICLRDF(1,244),ICLRDF(2,244)/44,53/
      DATA ICLRDF(3,244),ICLRDF(4,244)/54,43/
      DATA ICLRDF(1,245),ICLRDF(2,245)/63,39/
      DATA ICLRDF(3,245),ICLRDF(4,245)/40,38/
      DATA ICLRDF(1,246),ICLRDF(2,246)/44,39/
      DATA ICLRDF(3,246),ICLRDF(4,246)/40,38/
      DATA ICLRDF(1,247),ICLRDF(2,247)/41,63/
      DATA ICLRDF(3,247),ICLRDF(4,247)/46,51/
      DATA ICLRDF(1,248),ICLRDF(2,248)/45,63/
      DATA ICLRDF(3,248),ICLRDF(4,248)/48,50/
      DATA ICLRDF(1,249),ICLRDF(2,249)/46,63/
      DATA ICLRDF(3,249),ICLRDF(4,249)/49,51/
      DATA ICLRDF(1,250),ICLRDF(2,250)/48,63/
      DATA ICLRDF(3,250),ICLRDF(4,250)/53,59/
      DATA ICLRDF(1,251),ICLRDF(2,251)/50,63/
      DATA ICLRDF(3,251),ICLRDF(4,251)/54,59/
      DATA ICLRDF(1,252),ICLRDF(2,252)/56,63/
      DATA ICLRDF(3,252),ICLRDF(4,252)/62,57/
      DATA ICLRDF(1,253),ICLRDF(2,253)/60,63/
      DATA ICLRDF(3,253),ICLRDF(4,253)/62,38/
      DATA ICLRDF(1,254),ICLRDF(2,254)/63,63/
      DATA ICLRDF(3,254),ICLRDF(4,254)/51,56/
      DATA ICLRDF(1,255),ICLRDF(2,255)/48,63/
      DATA ICLRDF(3,255),ICLRDF(4,255)/56,62/
      DATA ICLRDF(1,256),ICLRDF(2,256)/39,63/
      DATA ICLRDF(3,256),ICLRDF(4,256)/62,38/
C
      END
