      SUBROUTINE CARC(XC,YC,RADIUS,START,END)
C
C      NAME:  CARC
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C      CARC PLOTS A CIRCULAR ARC WITH CENTER AT (XC,YC) AND A RADIUS
C      OF RADIUS. THE ARC BETWEEN THE ANGLES START AND END. THE ARC
C      IS PLOTTED  BETWEEN THE ANGLES START AND END IN A COUNTER-
C      CLOCKWISE DIRECTION.
C
C      ENTRY: CALL CARC(X,Y,RADIUS,START,END)
C                 X,Y       - COORDINATES OF CENTER OF CIRCULAR ARC
C                 RADIUS    - DISTANCE FROM CENTER TO ARC SEGMENT
C                 START,END - ANGLES OF START AND END POINTS OF ARC
C                           IN DEGREES.
C
C      EXIT:  RETURNS WITH THE CURRENT POSITION AT CENTER OF ARC
C
C      CALLS:
C          COS, SIN, MAX1, PLOT
C
C      CALLED BY:  USER
C
C      COMMON USED:
C     /DVCOM/
C            I RADN    - DEGREES TO RADIAN ANGLE CONVERSION FACTOR
C
C     /MSGCOM/
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C      LOCAL VARIABLES USED:
C
C      ANGINC  =  ANGULAR INCREMENT FOR EACH POINT ON THE ARC.
C      COSINC  =  COSINE OF THE ANGULAR INCREMENT.
C      IA      =  LOOP COUNTER, WHOSE RANGE IS 1 TO NPTS.
C      NPTS    =  NUMBER OF POINTS FOR THE ARC.
C      SININC  =  SINE OF THE ANGULAR INCREMENT.
C      STRTRN  =  STARTING ANGLE (START), IN RADIANS.
C      X0      =  X-COORDINATE OF THE LAST POSITION ON THE ARC.
C      X1      =  X-COORDINATE OF THE PRESENT POSITION ON THE ARC.
C      Y0      =  Y-COORDINATE OF THE LAST POSITION ON THE ARC.
C      Y1      =  Y-COORDINATE OF THE PRESENT POSITION ON THE ARC.
C
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C-D   DEBUG MESSAGE
C      RELARG(1)=XC
C      RELARG(2)=YC
C      RELARG(3)=RADIUS
C      RELARG(4)=START
C      RELARG(5)=END
C      CALL MSGLG1(3)
C-D
C
C
C
C  RETURN TO CALLING PROGRAM IF THE RADIUS IS ZERO.
C
      IF (RADIUS .LE. 0.0)  GO TO 9999
C
C  SET THE DEFAULT NUMBER OF POINTS PER ARC TO 60.
C
      NPTS = 60
C  CALCULATE THE ANGULAR INCREMENT (  IN RADIANS ).
C
      XTEMP = END - START
 50   IF (XTEMP .GT. 360.0) XTEMP = XTEMP - 360.0
      IF (XTEMP .LT. 0.0) XTEMP = XTEMP + 360.0
      IF (XTEMP .GE. 0.0 .AND. XTEMP .LE. 360.0) GO TO 55
      GO TO 50
C
C  XTEMP IS NOW BETWEEN 0.0 AND 360.0 FOR ARCS TO BE DRAWN
C  IN A COUNTER CLOCKWISE DIRECTION OR IN A POSITIVE ANGLE MOVEMENT.
C  NOW SEE HOW MANY POINTS ARE ON THE ARC.
C  IF LESS THAN 60*2 FOR SEGMENTS 2 NIBS LONG, THEN SET THE
C  NUMBER OF POINTS FOR DRAWING 2 NIB VECTORS AND MAKE SURE
C  THERE IS AT LEAST ONE SEGMENT.
C
 55   CTEMP = 6.28319 * RADIUS * (XTEMP/360.0) * (XDEN/2.0)
      IF (CTEMP .LT. 60.0) NPTS = MAX1 (CTEMP,1.0)
      ANGINC = (XTEMP*RADN) / FLOAT (NPTS)
C
C  CALCULATE THE SINE AND COSINE OF THE ANGULAR INCREMENT.
C
      SININC = SIN( ANGINC )
      COSINC = COS( ANGINC )
C
C  CONVERT THE STARTING ANGLE TO RADIANS FROM DEGREES.
C
      STRTRN = AMOD (START,360.0) * RADN
C
C  DETERMINE THE INITIAL POINT ON THE ARC AND MOVE THERE.
C
      X0 = XC + RADIUS * COS( STRTRN )
      Y0 = YC + RADIUS * SIN( STRTRN )
      CALL PLOT ( X0, Y0, 3 )
C
C  CALCULATE EACH POINT ON THE CURVE AND DRAW A LINE TO EACH POINT.
C
      DO 100 IA=1,NPTS
C
C       CALCULATE THE NEW X AND Y COORDINATES ON THE ARC.
C
        X1 = XC + ( X0 - XC ) * COSINC - ( Y0 - YC ) * SININC
        Y1 = YC + ( X0 - XC ) * SININC + ( Y0 - YC ) * COSINC
C
C       DRAW TO THE NEW POINT ON THE CIRCULAR ARC.
C
        CALL PLOT ( X1, Y1, 2 )
C
C       REPLACE THE OLD X,Y COORDINATES WITH THE NEW X,Y.
C
        X0 = X1
        Y0 = Y1
  100 CONTINUE
C
C     MOVE BACK TO CENTER OF ARC
C
      CALL PLOT (XC,YC,3)
C
 9999 CONTINUE
      RETURN
      END
