      SUBROUTINE CONVX (IX,IY,NPT,OUTLIN)
C
C     NAME: CONVX
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY
C            REV. C
C            2/19/85        THIS SUBROUTINE CREATED TO DO THE
C                          X-STRIPPING AND OUTPUT THAT WAS
C                          PREVIOUSLY DONE IN SUBROUTINE CONVEX.
C
C            CHANGES FOR PRISM:
C
C                          A BYTE COUNT IS NOW KEPT.
C
C                          THE CALCULATION OF IBXMAX NOW USES
C                          THE LINE WIDTH EVEN IF X-STRIPPING
C                          IS NOT BEING DONE.
C
C                          X-STRIPPING IS NOT DONE IF THE OUTPUT
C                          IS GOING TO A PRISM (KREP=4) AND THE
C                          POLYGON IS LESS THAN KSIZE IN LENGTH.
C
C            ERRORS CORRECTED:
C
C                          NULL POLYGONS ARE NOT OUTPUT ANYMORE
C                          WHEN TONE COLORS ARE USED.
C
C                          TONE COLORS ARE NOW DONE CORRECTLY FOR
C                          X-STRIPPED POLYGONS.
C
C                          IF ONLY ONE VERTEX OF A STRIPPED POLYGON
C                          LIES IN THE LAST STRIP, THIS PART OF THE
C                          STRIPPED POLYGON IS NOW OUTPUT.
C
C     CONVX - OUTPUT CONVEX POLYGONS TO VRF FILE
C
C     SUBROUTINE CONVX IS CALLED BY SUBROUTINE CONVEX TO OUTPUT
C     POLYGONS THAT HAVE ALREADY BEEN CLIPPED, ARE IN VIEWPORT
C     COORDINATES, AND HAVE BEEN STRIPPED IN THE Y-DIRECTION.
C     CONVX CHECKS TO SEE IF THE POLYGON NEEDS TO BE STRIPPED IN
C     THE X-DIRECTION (AT MULTIPLES OF 13.65') AND BREAKS THE
C     POLYGON INTO MULTIPLE POLYGONS IF NECESSARY.  EACH POLYGON
C     IS THEN OUTPUT TO THE VRF FILE.
C
C     ENTRY: CALL CONVX (IX,IY,NPT,OUTLIN)
C
C            IX,IY - THE INTEGER COORDINATE ARRAYS
C                    DEFINING THE POLYGON
C            NPT - THE NUMBER OF ELEMENTS DEFINING THE POLYGON
C                  IF NPT < 0, OUTLINE THE POLYGON
C                  THE MAXIMUM NUMBER OF ELEMENTS DEFINING THE
C                  POLYGON ARE:
C
C                   PRECISION = 16:  127 ELEMENTS
C                   PRECISION = 32:   63 ELEMENTS
C
C                  IF A POLYGON IS STRIPPED, IT IS POSSIBLE TO
C                  GENERATE AN ADDITIONAL ELEMENT.  IN THIS CASE,
C                  POLYGON PROCESSING WILL CEASE AND A MESSAGE
C                  WILL BE OUTPUT.  HOWEVER, SOME OF THE STRIPPED
C                  POLYGON MAY HAVE ALREADY BEEN OUTPUT.
C            OUTLIN - LOGICAL VARIABLE TO BE SET TO TRUE IF CONVX
C                    OUTLINES THE POLYGON
C
C     EXIT: RETURN
C
C     CALLS: MSGLG1,OCHUNK
C
C     CALLED BY: CONVEX
C
C     COMMON USED:
C     /DVCOM/
C            L DASHPN  - .TRUE. IFF THE CURRENT PEN IS DEFINED AS
C                        AN ON-OFF-ON-OFF PATTERN
C            I ICXPTS  - MAXIMUM NUMBER OF POLYGON ELEMENTS ALLOWED
C            I ILWP    - (LINE WIDTH - 1)/2
C            I ILWM    - LINE WIDTH/2
C            I KPAT    - NUMBER OF CURRENTLY ACTIVE TONE PATTERN
C            I MSB     - WORD TO SET HIGH ORDER BIT DETERMINED BY
C                        PRECISION (16/32) SELECTED.
C
C     /PRMCOM/
C            I IFONT   - DEFAULT FONT PATTERN NUMBER.
C            I KREP    - TARGET OUTPUT CONTROLLER
C                       = 0 - UNKNOWN
C                        = 1 - REP CONTROLLER
C                        = 4 - RPM CONTROLLER
C     /VRFCOM/
C            R BYTKNT()- BYTE COUNT FOR EACH COLOR
C            R DRWKNT  - BYTE COUNT FOR A DRAW COMMAND
C            I IBXMAX  - MAXIMUM X VALUE (USED FOR BANDING)
C            R VRFKNT()- COUNTER FOR RANDOM ELEMENTS
C            R OBJKNT()- NUMBER OF EACH TYPE OF OBJECT OUTPUT
C                       OBJKNT(1) - VECTORS
C                       OBJKNT(2) - POLYGONS
C                       OBJKNT(3) - CIRCLES
C                       OBJKNT(4) - CHARACTERS
C            I PRECIS  - COORDINATE PRECISION FOR THE VRF
C                        OUTPUT FILE (16 OR 32-BIT PRECISION)
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C       /CLRCOM/
C               I ICLRDF()- ARRAY CONTAINING COLOR DEFINITIONS
C            I ITNCLR  - CURRENT TONE COLOR INDEX
C            I ITNFLG  - USE PEN OR TONE COLOR FOR AREAS
C            I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C            I NCPASS  - NUMBER OF COLOR PASSES
C     /KLCOM/
C            L KFLAG   - FLAG INDICATING REP OUTPUT AND .GT. 13.65'
C                        PLOTTING REQUIRED.
C            I KSIZE   - VARIABLE DEFINING 13.65' IN SCANS, USED TO
C                        DETERMINE IF ELEMENT CROSSES A 13.65' PAGE
C                        BOUNDARY.
C
C     LOCAL VARIABLES USED:
C
C     I  BPTR    - POINTER TO THE LAST POINT OF THE CURRENT POLYGON
C                 (USED IN X-STRIPPING)
C     I  FPTR    - POINTER TO THE FIRST POINT OF THE CURRENT POLYGON
C                 (USED IN X-STRIPPING)
C     I  IBND    - POINTER TO CURRENT TONER BAND
C     I  ICNT    - FLAG FOR TONE ONLY POLYGONS
C     I  ICOM    - POLYGON COMMAND TO BE OUTPUT TO THE VRF FILE
C     I  IN      - INDEX INTO COORDINATE ARRAYS OF THE POLYGON
C     I  IPAGE   - CURRENT PAGE OF EXTENDED BANDING PROCESSING
C     I  IPAGE1  - FIRST PAGE OF EXTENDED BANDING PROCESSING
C     I  IPAGE2  - LAST PAGE OF EXTENDED BANDING PROCESSING
C     I  IXX     - X VALUE OF POINT TO BE OUTPUT
C     I  IYY     - Y VALUE OF POINT TO BE OUTPUT
C     I  JX(),JY() - COORDINATE ARRAYS OF THE POLYGON USED DURING
C        KX(),KY()   THE STRIPPING PROCESS
C     I  MAXPT   - INDEX OF COORDINATE POINT WITH MAXIMUM X-VALUE
C     I  MINPT   - INDEX OF COORDINATE POINT WITH MINIMUM X-VALUE
C     I  MAXX    - MAXIMUM X-VALUE OF THE POLYGON
C     I  MINX    - MINIMUM X-VALUE OF THE POLYGON
C     I  MOVDRW  - FLAG INDICATING IF POLYGON SHOULD BE OUTLINED
C     I  NP1     - NUMBER OF VERTICES IN THE POLYGON
C     I  NP2     - NUMBER OF DATA WORDS NEEDED FOR THE POLYGON COMMAND
C     I  NTNSEQ()- NTNSEQ(,1) - SAVED VALUE OF ITNSEQ()
C                 NTNSEQ(,2) - TURNED ON IFF AN OUTLINE IS TO BE DONE
C                 NTNSEQ(,3) - TURNED ON IFF A FILL IS TO BE DONE
C     I  NWORD   - NUMBER OF DATA WORDS PER COORDINATE IN THE POLYGON
C                 COMMAND
C     I  NX1     - INDEX OF THE NEXT VERTEX
C     I  OUT     - INDEX INTO COORDINATE ARRAYS OF STRIPPED POLYGON
C     I  POLYGN  - POLYGON COMMAND
C     I  SLOPE1  - SLOPE OF ONE EDGE OF THE POLYGON
C     I  SLOPE2  - SLOPE OF ANOTHER EDGE OF THE POLYGON
C     I  SVBPTR  - SAVED VALUE OF BPTR
C     I  YY1,YY2 - INTERSECTION POINTS WITH STRIPPING BOUNDARY
C
      LOGICAL OUTLIN
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /PRMCOM/ - DEFAULT PLOTTING PARAMETERS
C
      INTEGER PENTBL,BMODEL,BBYTES,CMODEL,CBYTES
      LOGICAL VSTRP
      COMMON /PRMCOM/
     *    IBYTES,      IDISK,       IFFAP,       LASTFF,
     *    IJPEN,       INHNCE,      INITFF,      INVERS,
     *    IRDT,        ISPACE,      ISPEED,      ISFLAG,
     *    IUSER,       JBYTES(75),  KREP,        IFONT,
     *    MIRROR,      MODEL,       MODL(75),    MXPEN,
     *    NCOPY,       NMODL,       PENTBL(64,2), RDEN,
     *    RDENS(75),   SCALE,       UNITS,       XFACT,
     *    YFACT,       XSTART,      YSTART,
     *    VXMIN,       VXMAX,       VYMIN,       VYMAX,
     *    WXMIN,       WXMAX,       WYMIN,       WYMAX,
     *    BMODEL,      BDEN,        BBYTES,
     *    CMODEL,      CDEN,        CBYTES,
     *    IDEFLG(256), IUCLR,       MODE1,       IPRISM(61),
     *    MUXOUT,      PMSIZE,      MAXPEN,      KTWO,
     *         LTNFLG,      LTNCLR,      MTAPE,       VSTRP,
     *         JSORT,       JCPCMD,      JCUT,        KDISK
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C...  COMMON /CLRCOM/ - COLOR VARIABLES
C
      INTEGER PCOLOR, CURPEN
      LOGICAL PENCHG
      COMMON /CLRCOM/
     *    ICLMAX,  ITNCLR,  ITNFLG,  IVCFLG,  NCPASS,  PENCHG,
     *         CURPEN(4), ICLRDF(4,512), IDASRT(4), ITNSEQ(4),
     *         PCOLOR(64)
C
C...  COMMON /KLCOM/ - X STRIPPING VARIABLES
C
      LOGICAL KFLAG
      COMMON /KLCOM/ KFLAG, KSIZE
C
C
      DIMENSION NTNSEQ(4,3)
      DIMENSION IX(1),IY(1)
      DIMENSION JX(132),JY(132)
      DIMENSION KX(132),KY(132)
      INTEGER FPTR,BPTR,SVBPTR
      INTEGER IN,OUT
      INTEGER POLYGN
C
      DATA POLYGN/34817/
C
C
C...  CHECK IF OUTLINE WANTED
      IF (DASHPN) NPT = IABS(NPT)
      MOVDRW = 0
      NP1 = NPT
      IF (NP1.GE.0) GO TO 50
      MOVDRW = MSB
      NP1 = -NP1
   50 CONTINUE
C
C...  CHECK FOR A NULL POLYGON (NO OUTLINE AND A NULL FILL)
      IF (NPT.GT.0 .AND. ITNFLG.EQ.0 .AND. KPAT.EQ.63) GO TO 9999
C
C...  FIND POINT WITH MINIMUM AND MAXIMUM X-VALUES,
C     FIND THE LONGEST SIDE IN TERMS OF DELTA X.
      MINX = IX(1)
      MINPT = 1
      MAXX = IX(1)
      MAXPT = 1
      DO 700 IN=2,NP1
         IF (IX(IN).GE.MINX) GO TO 650
           MINX = IX(IN)
           MINPT = IN
           GO TO 700
  650    IF (IX(IN).LE.MAXX) GO TO 700
           MAXX = IX(IN)
           MAXPT = IN
  700 CONTINUE
C
C...  UPDATE IBXMAX
      IF (NPT .LT. 0) GO TO 710
C
          IF (MAXX.GT.IBXMAX) IBXMAX = MAXX
          GO TO 720
C
C...      ACCOUNT FOR THE WIDTH OF THE OUTLINE
  710     IF ( (MAXX+ILWP) .GT. IBXMAX) IBXMAX = MAXX+ILWP
C
  720 CONTINUE
C
      IF (ITNFLG .EQ. 0) GO TO 730
C
C...  SET UP NTNSEQ
      DO 725 IBND=1,NCPASS,1
C
C...     SAVE CURRENT VALUE
           NTNSEQ(IBND,1) = ITNSEQ(IBND)
C
C...     IF AN OUTLINE IS TO BE DRAWN WITH THIS
C        TONER, NTNSEQ(IBND,2) IS TURNED ON.
           NTNSEQ(IBND,2) = ITNSEQ(IBND)
           IF (NPT .GT. 0) NTNSEQ(IBND,2) = IABS(NTNSEQ(IBND,2))
C
C...     IF THE TONE COLOR HAS A PATTERN FOR THIS
C        TONER, NTNSEQ(IBND,3) IS TURNED ON.
           NTNSEQ(IBND,3) = IABS(ITNSEQ(IBND))
           IF ( ICLRDF( NTNSEQ(IBND,3), ITNCLR ) .NE. 63 )
     *                NTNSEQ(IBND,3) = -NTNSEQ(IBND,3)
C
  725 CONTINUE
C
  730 CONTINUE
C
C...  CHECK EXTENDED-BANDING FLAG
      IF (.NOT.KFLAG) GO TO 800
C
      IF ( (KREP.EQ.4) .AND. ((MAXX-MINX).LT.KSIZE) ) GO TO 800
C
C...  CALCULATE STARTING AND ENDING PAGES
      IPAGE1 = (MINX + 8)/KSIZE
      IPAGE2 = (MAXX + 8)/KSIZE
C
C...  CHECK IF EXTENDED BANDING REQUIRED
      IF (IPAGE1.NE.IPAGE2) GO TO 2000
C
C...  THE FILL AREA DOES NOT CROSS THE STRIPPING BOUNDARY.
C     WE MUST CHECK WHETHER THE OUTLINE CROSSES THE BOUNDARY.
C     IF SO, WE DON'T OUTLINE.
      IF (NPT .GT. 0) GO TO 800
      IPAGE1 = (MINX - ILWM + 8)/KSIZE
      IPAGE2 = (MAXX + ILWP + 8)/KSIZE
      IF (IPAGE1 .EQ. IPAGE2) GO TO 800
C
C...      THE FILL AREA CROSSES THE BOUNDARY
          MOVDRW = 0
          DO 790 IBND=1,NCPASS
  790        NTNSEQ(IBND,2) = IABS(NTNSEQ(IBND,2))
C
C...  IF A TONE COLOR, SET ITNSEQ SO THAT ONLY THOSE TONERS THAT
C     ARE PART OF THE OUTLINE OR FILL ARE TURNED ON.
  800 IF (ITNFLG .EQ. 0) GO TO 820
      DO 810 IBND=1,NCPASS
         ITNSEQ(IBND) = IABS(ITNSEQ(IBND))
         IF (NTNSEQ(IBND,2) .LT. 0 .OR. NTNSEQ(IBND,3) .LT. 0)
     *              ITNSEQ(IBND) = -ITNSEQ(IBND)
  810 CONTINUE
  820 CONTINUE
C
C...  MOVE TO THE FIRST POINT
      CALL OCHUNK (IX(1),-1)
      CALL OCHUNK (IY(1),-1)
C
C...  CALCULATE THE NUMBER OF DATA WORDS PER POINT, NWORD, AND
C     THE TOTAL NUMBER OF DATA WORDS, NP2.
      NWORD = 2
      IF (PRECIS .EQ. 32) NWORD = 4
      NP2 = NP1
      NP2 = NWORD * NP2
C
C...  CHECK IF DOING TONE COLORS
      IF (ITNFLG .EQ. 0) GO TO 860
C
C...  ** TONE COLOR **
C
C...  TURN OFF ITNSEQ FOR ALL TONERS
      DO 835 IBND=1,NCPASS,1
         ITNSEQ(IBND) = IABS(ITNSEQ(IBND))
  835 CONTINUE
C
C...  FOR EACH TONER, OUTPUT THE DRAW POLYGON COMMAND
C     AND THE ASSOCIATED PATTERN
      DO 850 IBND=1,NCPASS,1
C
C...     CHECK IF THE POLYGON IS BEING
C        OUTLINED OR FILLED WITH THIS COLOR
         IF (NTNSEQ(IBND,2).GE.0 .AND. NTNSEQ(IBND,3).GE.0) GO TO 850
C
C...        TURN ON THIS TONER, OUTPUT THE POLYGON COMMAND, OUTPUT
C           THE PATTERN, AND TURN OFF THE TONER
C
            ITNSEQ(IBND) = -ITNSEQ(IBND)
            ICOM = POLYGN + NP2
C
C...        IF THE POLYGON IS ONLY BEING FILLED WITH THIS COLOR,
C           WE OUTPUT ONE LESS MOVE (SINCE THE LAST MOVE IS IMPLIED)
C
            IF (NTNSEQ(IBND,2).GE.0) ICOM = ICOM - NWORD
C
            CALL OCHUNK (ICOM,0)
            CALL OCHUNK( ICLRDF( -ITNSEQ(IBND), ITNCLR ), 0)
            ITNSEQ(IBND) = -ITNSEQ(IBND)
C
C...        COUNT BYTES FOR THIS TONER
            VRFKNT(IBND) = VRFKNT(IBND) + NP1 + 1.0
            BYTKNT(IBND) = BYTKNT(IBND) + 4.0 * NP1 + 8.0
            IF ( NTNSEQ(IBND,2) .LT. 0 )
     *               BYTKNT(IBND) = BYTKNT(IBND) + DRWKNT * NP1
C
  850 CONTINUE
C
C...  SET ITNSEQ SO THAT ONLY THOSE TONERS THAT ARE PART OF THE
C     OUTLINE ARE SET ACTIVE.
      ICNT = 0
      DO 855 IBND=1,NCPASS,1
         ITNSEQ(IBND) = NTNSEQ(IBND,2)
         IF (ITNSEQ(IBND) .LT. 0) ICNT = 1
  855        CONTINUE
C
C...  CHECK IF ANY TONERS SET ACTIVE
      IF (ICNT .EQ. 0) GO TO 1025
C
      GO TO 870
C
C...  ** HATCH PATTERN AND PEN COLOR **
C
C...  OUTPUT THE DRAW-POLYGON COMMAND
  860 IF (MOVDRW .EQ. 0) NP2 = NP2 - NWORD
      ICOM = POLYGN + NP2
      CALL OCHUNK (ICOM,0)
C
C...  OUTPUT FILL-PATTERN INDEX
      CALL OCHUNK (KPAT,0)
C
C...  COUNT BYTES
      DO 865 IBND = 1,NCPASS
C
C...     CHECK IF POLYGON BEING DONE FOR THIS TONER
         IF (ITNSEQ(IBND) .GE. 0) GO TO 865
C
         VRFKNT(IBND) = VRFKNT(IBND) + NP1 + 1.0
         BYTKNT(IBND) = BYTKNT(IBND) + 4.0 * NP1 + 8.0
         IF (MOVDRW .NE. 0)
     *               BYTKNT(IBND) = BYTKNT(IBND) + DRWKNT * NP1
  865 CONTINUE
C
C...  OUTPUT THE POLYGON TO THE VRF FILE FOR EACH PEN COLOR
C
  870 CONTINUE
      DO 1000 IN=2,NP1
         IYY = OR(IY(IN),MOVDRW)
         CALL OCHUNK (IX(IN),-1)
         CALL OCHUNK (IYY,-1)
 1000 CONTINUE
C
C...  IF THE POLYGON IS OUTLINED, WE MUST OUTPUT THE LAST DRAW
      IF (MOVDRW .EQ. 0) GO TO 1010
          IYY = OR(IY(1),MOVDRW)
          CALL OCHUNK (IX(1),-1)
          CALL OCHUNK (IYY,-1)
 1010 CONTINUE
C
      IF (ITNFLG .EQ. 0) GO TO 1085
C
C...  IF A TONER IS NOT ONE OF THE OUTLINE COLORS BUT IS ONE OF THE
C     FILL COLORS, WE MUST OUTPUT A (NON-OUTLINED) POLYGON
C     USING THAT TONER.  WE SET ITNSEQ TO CATCH THESE TONERS.
 1025 ICNT = 0
      DO 1050 IBND = 1,NCPASS
         ITNSEQ(IBND) = IABS(ITNSEQ(IBND))
         IF (NTNSEQ(IBND,2).LT.0 .OR. NTNSEQ(IBND,3).GE.0) GO TO 1050
            ITNSEQ(IBND) = -ITNSEQ(IBND)
            ICNT = 1
 1050 CONTINUE
C
C...  CHECK IF ANY TONERS SET ACTIVE
      IF (ICNT .EQ. 0) GO TO 1065
C
C...  OUTPUT A NON-OUTLINED POLYGON FOR THE SPECIFIED TONERS
      DO 1060 IN=2,NP1
         CALL OCHUNK (IX(IN),-1)
         CALL OCHUNK (IY(IN),-1)
 1060 CONTINUE
C
C...  RESET ITNSEQ TO ORIGINAL VALUES (PEN COLORS)
 1065 DO 1080 IBND=1,NCPASS,1
         ITNSEQ(IBND) = NTNSEQ(IBND,1)
 1080 CONTINUE
C
C...  CHECK IF OUTLINE DONE
 1085 IF (MOVDRW .NE. 0) OUTLIN = .TRUE.
C
C...  COUNT ANOTHER POLYGON
      OBJKNT(2) = OBJKNT(2) + 1.0
      GO TO 9999
C
C
C...  CHECK FOR A NULL FILL
 2000 IF (ITNFLG .EQ. 0 .AND. KPAT .EQ. 63) GO TO 9999
C
C...  REORDER POINTS STARTING WITH MINIMUM POINT
      J = MINPT
      DO 2200 I = 1,NP1
         IF (J.GT.NP1) J = 1
         JX(I) = IX(J)
         JY(I) = IY(J)
         J = J + 1
 2200 CONTINUE
C
C...  SET UP ITNSEQ SO THAT ONLY THOSE TONERS THAT ARE PART OF
C     THE FILL PATTERN ARE SET ACTIVE
      IF (ITNFLG .EQ. 0) GO TO 2400
      DO 2300 IBND=1,NCPASS
          ITNSEQ(IBND) = NTNSEQ(IBND,3)
 2300 CONTINUE
 2400 CONTINUE
C
C
C...  CONVEX POLYGON EXTENDED-BANDING
C
C     STARTING WITH FIRST POINT IN ARRAY, OUTPUT POINTS
C     UNTIL POINT LIES OUTSIDE CURRENT PAGE. THEN OUTPUT INTERSECTION
C     POINT. NEXT, STARTING WITH LAST POINT IN ARRAY CHECK TO SEE THAT
C     EACH PRECEDING POINT LIES ON SAME PAGE. WHEN ONE DOES NOT, THEN
C     OUTPUT INTERSECTION POINT AND SUBSEQUENT POINTS.
C     REPEAT FOR ALL SUBSEQUENT PAGES.
C
C
C...  INITIALIZE POINTERS
      FPTR = 1
      BPTR = NP1
      IPAGE = IPAGE1
      OUT = 1
      GO TO 3110
C
C...  OUTPUT INTERSECTION POINTS WITH TOP OF PAGE
 3000 KX(1) = IXX + 1
      KY(1) = YY1 + SLOPE1 + 0.5
      KX(2) = IXX + 1
      KY(2) = YY2 + SLOPE2 + 0.5
      IPAGE = IPAGE + 1
      OUT = 3
C
C...  CHECK IF POINT LIES ON CURRENT PAGE
 3100 IF ((JX(FPTR)+8)/KSIZE.NE.IPAGE) GO TO 3200
C
C...  OUTPUT POINT
 3110 KX(OUT) = JX(FPTR)
      KY(OUT) = JY(FPTR)
      OUT = OUT + 1
C
C...  CHECK FOR LAST POINT
      IF (FPTR.EQ.BPTR) GO TO 3600
C
      FPTR = FPTR + 1
      GO TO 3100
C
C...  CALCULATE INTERSECTION POINT
 3200 IXX = (IPAGE + 1) * KSIZE - 9
      SLOPE2 = FLOAT(JY(FPTR)-JY(FPTR-1))/FLOAT(JX(FPTR)-JX(FPTR-1))
      YY2 = (IXX - JX(FPTR))*SLOPE2 + JY(FPTR)
      IYY = YY2 + 0.5
C
C...  OUTPUT THE INTERSECTION POINT
      KX(OUT) = IXX
      KY(OUT) = IYY
      OUT = OUT + 1
C
C...  NOW LOOK BACKWARDS THRU THE ARRAY
C     SAVE CURRENT POINTER
 3300 SVBPTR = BPTR
C
C...  CHECK IF POINT IS ON CURRENT PAGE
 3310 IF ((JX(BPTR)+8)/KSIZE.NE.IPAGE) GO TO 3400
      BPTR = BPTR - 1
      GO TO 3310
C
C...  CALCULATE INTERSECTION POINT
 3400 NX1 = BPTR + 1
      IF (NX1.GT.NP1) NX1 = 1
      SLOPE1 = FLOAT(JY(BPTR)-JY(NX1))/FLOAT(JX(BPTR)-JX(NX1))
C
      YY1 = (IXX - JX(BPTR))*SLOPE1 + JY(BPTR)
      IYY = YY1 + 0.5
C
C...  OUTPUT THE INTERSECTION POINT
      KX(OUT) = IXX
      KY(OUT) = IYY
      OUT = OUT + 1
C
C...  OUTPUT POINTS 'BPTR+1' TO 'SVBPTR'
      I = BPTR + 1
 3500 IF (I.GT.SVBPTR) GO TO 3600
      KX(OUT) = JX(I)
      KY(OUT) = JY(I)
      OUT = OUT + 1
      I = I + 1
      GO TO 3500
C
C...  OUTPUT THE POLYGON
C
C...  CHECK FOR TOO MANY POINTS GENERATED
 3600 IF ( (OUT-1) .LE. ICXPTS ) GO TO 3610
C
C         MESSAGE - ILLEGAL NUMBER OF ELEMENTS
          INTARG(1)=OUT-1
          CALL MSGLG1(8)
          RETURN
C
C...  OUTPUT FIRST POINT AS A MOVE
 3610 CALL OCHUNK (KX(1),-1)
      CALL OCHUNK (KY(1),-1)
C
C...  CALCULATE NUMBER OF DATA WORDS
      OUT = OUT - 1
      NP2 = 4 * (OUT-1)
C
C...  OUTPUT DRAW-POLYGON HEADER
      ICOM = POLYGN + NP2
      CALL OCHUNK (ICOM,0)
C
C...  CHECK IF DOING TONE COLORS
      IF (ITNFLG .EQ. 0) GO TO 3700
C
C...  ** TONE COLOR **
C
C...  TURN OFF ITNSEQ FOR ALL TONERS
      DO 3625 IBND=1,NCPASS,1
         ITNSEQ(IBND) = IABS(ITNSEQ(IBND))
 3625 CONTINUE
C
C...  FOR EACH TONER, OUTPUT THE ASSOCIATED PATTERN
      DO 3650 IBND=1,NCPASS,1
C
C...     CHECK IF THE POLYGON IS BEING FILLED WITH THIS TONER
         IF (NTNSEQ(IBND,3) .GE. 0) GO TO 3650
C
C...        TURN ON THIS TONER, OUTPUT THE PATTERN,
C                AND TURN OFF THE TONER
            ITNSEQ(IBND) = -ITNSEQ(IBND)
            CALL OCHUNK( ICLRDF( -ITNSEQ(IBND), ITNCLR ), 0)
            ITNSEQ(IBND) = -ITNSEQ(IBND)
C
C...        COUNT BYTES FOR THIS TONER
            VRFKNT(IBND) = VRFKNT(IBND) + OUT + 1.0
            BYTKNT(IBND) = BYTKNT(IBND) + 4.0 * OUT + 8.0
C
 3650 CONTINUE
C
C...  SET ITNSEQ SO THAT THE TONERS THAT ARE PART OF THE
C     FILL PATTERN ARE SET ACTIVE.
      DO 3675 IBND=1,NCPASS,1
         ITNSEQ(IBND) = NTNSEQ(IBND,3)
 3675        CONTINUE
C
      GO TO 3750
C
C...  ** HATCH PATTERN AND PEN COLOR **
C
C...  OUTPUT FILL-PATTERN INDEX
 3700 CALL OCHUNK (KPAT,0)
C
C...  COUNT BYTES
      DO 3725 IBND = 1,NCPASS
C
C...     CHECK IF POLYGON BEING DONE FOR THIS TONER
         IF (ITNSEQ(IBND) .GE. 0) GO TO 3725
C
         VRFKNT(IBND) = VRFKNT(IBND) + OUT + 1.0
         BYTKNT(IBND) = BYTKNT(IBND) + 4.0 * OUT + 8.0
 3725 CONTINUE
C
 3750 CONTINUE
C
C...  OUTPUT THE POLYGON TO THE VRF FILE
      DO 3800 I=2,OUT
         CALL OCHUNK (KX(I),-1)
         CALL OCHUNK (KY(I),-1)
 3800 CONTINUE
C
C...  COUNT ANOTHER POLYGON
      OBJKNT(2) = OBJKNT(2) + 1.0
C
C...  CHECK IF DONE
      IF (IPAGE .NE. IPAGE2) GO TO 3000
C
C...  RESET ITNSEQ
      IF (ITNFLG .EQ. 0) GO TO 3900
      DO 3850 IBND=1,NCPASS
          ITNSEQ(IBND) = NTNSEQ(IBND,1)
 3850 CONTINUE
 3900 CONTINUE
C
 9999 RETURN
      END
