      SUBROUTINE COPIES (KCOPY)
C
C     NAME:  COPIES
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY:
C     COPIES - ACCEPTS CURRENT PLOT COPY COUNT FROM CALLER
C
C     SUBROUTINE COPIES ALLOWS THE CALLER TO SPECIFY THE NUMBER OF
C     COPIES TO OUTPUT FOR EACH PLOT IN PHASE II.
C
C     NOTE:
C            1) COPIES MUST BE CALLED AFTER THE CALL TO SUBROUTINE
C               PLOTS AND BEFORE THE END-OF-PLOT (+-23,+-999) CALL
C               IS MADE TO SPECIFY A COUNT FOR THE CURRENT PLOT.
C               COPY COUNT IS RESET TO KCOPY AFTER AN END-OF-PLOT
C               CALL.
C            2) THIS FEATURE IS NOT SUPPORTED FOR ON-LINE OUTPUT
C               FROM PHASE I.
C            3) THE USER SHOULD NOT USE THIS FEATURE IF CONFIGURED
C               FOR MAGTAPE OUTPUT.
C
C     ENTRY:  CALL COPIES (KCOPY)
C
C                   KCOPY - NUMBER OF PLOT COPIES TO OUTPUT, MUST
C                          GREATER THAN ZERO(0).  KCOPY LESS THAN
C                          OR EQUAL TO ZERO WILL BE SET TO ONE(1).
C
C     EXIT:  RETURN
C
C     CALLED BY: USER
C
C     CALLS:  NONE
C
C     /VRFCOM/
C            I ICOPY   - PHASE II PLOT COPY COUNT
C
C     /PRMCOM/
C            I IDISK   - CONTROLLER WITH DISK FLAG.
C                       = 0 - NO DISK [DEFAULT]
C                       = 1 - DISK INSTALLED IN REP CONTROLLER
C                       = 2 - DISK INSTALLED IN RPM CONTROLLER
C                       = 3 - DISK INSTALLED IN BOTH REP AND
C                             RPM CONTROLLER
C            I IFONT   - DEFAULT FONT PATTERN NUMBER.
C            I KREP    - TARGET OUTPUT CONTROLLER
C                       = 0 - UNKNOWN
C                        = 1 - REP CONTROLLER
C                        = 4 - RPM CONTROLLER
C            I KTWO    - REP/RPM CONFIGURATION FLAG
C                       = 0 - ONLY ONE TYPE OF CONTROLLER AVAILABLE
C                       # 0 - REP & RPM SERIES CONTROLLER AVAILABLE
C
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /PRMCOM/ - DEFAULT PLOTTING PARAMETERS
C
      INTEGER PENTBL,BMODEL,BBYTES,CMODEL,CBYTES
      LOGICAL VSTRP
      COMMON /PRMCOM/
     *    IBYTES,      IDISK,       IFFAP,       LASTFF,
     *    IJPEN,       INHNCE,      INITFF,      INVERS,
     *    IRDT,        ISPACE,      ISPEED,      ISFLAG,
     *    IUSER,       JBYTES(75),  KREP,        IFONT,
     *    MIRROR,      MODEL,       MODL(75),    MXPEN,
     *    NCOPY,       NMODL,       PENTBL(64,2), RDEN,
     *    RDENS(75),   SCALE,       UNITS,       XFACT,
     *    YFACT,       XSTART,      YSTART,
     *    VXMIN,       VXMAX,       VYMIN,       VYMAX,
     *    WXMIN,       WXMAX,       WYMIN,       WYMAX,
     *    BMODEL,      BDEN,        BBYTES,
     *    CMODEL,      CDEN,        CBYTES,
     *    IDEFLG(256), IUCLR,       MODE1,       IPRISM(61),
     *    MUXOUT,      PMSIZE,      MAXPEN,      KTWO,
     *         LTNFLG,      LTNCLR,      MTAPE,       VSTRP,
     *         JSORT,       JCPCMD,      JCUT,        KDISK
C
C
C
      ITEMP = KCOPY
C
C...  CHECK FOR ILLEGAL VALUES
      IF (ITEMP .LE. 0)  ITEMP = 1
      ICOPY = ITEMP
      RETURN
      END
