      SUBROUTINE DASHLN (X,Y,NPTS,ONLTH,OFFLTH)
C
C     NAME: DASHLN
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     DASHLN - SUBROUTINE DASHLN MAY BE USED TO CONNECT POINTS FROM
C             COORDINATE DATA ARRAYS X AND Y WITH DASHED LINES.  THE
C             VISIBLE PORTION OF THE DASHED LINE IS CONSIDERED 'ON'
C             WHILE THE REMAINING PORTION IS 'OFF'.  IF THE END OF
C             THE DASHED LINE IS THE 'OFF' SEGMENT THEN A DOT WILL BE
C             PLOTTED TO SIGINFY THE END OF THE DASHED LINE.
C
C     ENTRY: CALL DASHLN (X,Y,NPTS,ONLTH,OFFLTH)
C
C        X     - IS AN ARRAY CONTAINING ABSCISSA (X) VALUES.
C        Y     - IS AN ARRAY CONTAINING ORDINATE (Y) VALUES.
C        NPTS  - IS THE NUMBER OF DATA VALUES IN EACH OF THE X AND Y
C               ARRAYS.
C        ONLTH - THE LENGTH OF EACH 'ON' SEGMENT.
C        OFFLTH- THE LENGTH OF EACH 'OFF' SEGMENT.
C
C     EXIT: RETURN
C
C     CALLS: PLOT,SQRT
C
C     CALLED BY: USER
C
C     COMMON USED:
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C     LOCAL VARIABLES:
C
C          DY     - DELTA Y MOVE FROM Y(I) TO Y(I+1)
C          DX     - DELTA X MOVE FROM X(I) TO X(I+1)
C          DLTXON - MEASURE OF UNITS ON IN THE X DIRECTION
C          DLTYON - MEASURE OF UNITS ON IN THE Y DIRECTION.
C          DLTYOFF - MEASURE OF UNITS OFF IN THE Y DIRECTION
C          DLTXOFF - MEASURE OF UNITS OFF IN THE X DIRECTION
C          C       - THE HYPOTENEUS OF THE TRIANGLE FORMED BY DX,DY
C                   USED TO FORM THE RATIO OF THE 'ON' AND 'OFF' LTH.
C          SX,SY   - PLOT CALL PARAMETERS
C            X(I),Y(I) - THE X,Y COORDINATES OF THE DASHED LINE BEING
C            X(I+1),Y(I+1)  GENERATED.
C          X1,Y1,X2,Y2 - THE X,Y COORDINATES OF THE DASHED LINE BEING
C                   GENERATED.
C          REM     - THE REMAINDER OF A DASHED LINE NOT EVENLY
C                   COMPLETED
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
      DIMENSION X(NPTS),Y(NPTS)
C-D  DEBUG MESSAGE
C
C      RELARG(1)=X(1)
C      RELARG(2)=Y(1)
C      INTARG(1)=NPTS
C      RELARG(3)=ONLTH
C      RELARG(4)=OFFLTH
C      CALL MSGLG1(10)
C-D
C
C
C
C
C...  CHECK FOR ILLEGAL VALUES
      IF (ONLTH .LE. 0.0 .OR. OFFLTH .LT. 0.0)  GO TO 900
      IF (NPTS .LT. 2)  GO TO 900
C
      K = NPTS - 1
      DO 50 I = 1,K
      REM = 1.
C
      DX = X(I+1) - X(I)
      DY = Y(I+1) - Y(I)
C
      C = SQRT(DX**2 + DY**2)
C
C     IF X1,Y1 .EQ. X2,Y2 GET THE NEXT ORDERED PAIR
      IF (C .EQ. 0.0)  GO TO 50
      CALL PLOT (X(I),Y(I),3)
C
      DLTXON = ONLTH * DX/C
      DLTXOF = OFFLTH * DX/C
      DLTYON = ONLTH * DY/C
      DLTYOF = OFFLTH * DY/C
      N = C * 1/(ONLTH + OFFLTH)
      REM = C - N*(ONLTH+OFFLTH)
      IF (REM .LT. ONLTH) REM = -1.
      SX = X(I)
      SY = Y(I)
C
      IF (N .LT. 1) GO TO 45
      DO 40 J = 1,N
         SX = SX + DLTXON
         SY = SY + DLTYON
         CALL PLOT (SX,SY,2)
C
         SX = SX + DLTXOF
         SY = SY + DLTYOF
         CALL PLOT (SX,SY,3)
C
   40 CONTINUE
C
C     IS THERE ROOM FOR AN 'ON' SEGMENT TO FINISH AND AN 'OFF'
C     SEGMENT TO START?
   45 IF (REM .LT. 0) GO TO 48
      SX = SX + DLTXON
      SY = SY + DLTYON
      CALL PLOT (SX,SY,2)
C
C     MOVE OUT TO DRAW A POINT
      CALL PLOT (X(I+1),Y(I+1),3)
   48 CALL PLOT (X(I+1),Y(I+1),2)
C
   50 CONTINUE
      RETURN
C
C-E
C     MESSAGE - ILLEGAL NPTS/ONLTH/OFFLTH VALUES
  900 INTARG(1)=NPTS
      RELARG(1)=ONLTH
      RELARG(2)=OFFLTH
      CALL MSGLG1(11)
      RETURN
C-E
      END
