      SUBROUTINE FACTOR(FACTR)
C
C     NAME:FACTOR
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY:
C
C     REV. C   8/22/85     IGNORE THE CALLS WITH THE RATIO OF ZERO
C                          AND LESS, AND NOTIFY THE USER WITH A
C                          MESSAGE.
C     FACTOR - SET DRAWING FACTOR
C
C     SUBROUTINE FACTOR ALLOWS THE PROGRAMMER TO ENLARGE OR REDUCE
C     THE CLIPPING WINDOW BY SPECIFYING THE RATIO OF THE DESIRED
C     WINDOW TO THE NORMAL CLIPPING WINDOW.
C
C     ENTRY: CALL FACTOR(FACTR)
C
C             FACTR - RATIO OF DESIRED SIZE TO 'NORMAL' SIZE
C                   (FOR EXAMPLE:
C                    =2.0 GIVES A DOUBLE SIZE PLOT,
C                    =0.5 GIVES A HALF SIZE PLOT.)
C                    THIS RATIO MUST BE GREATER THAN ZERO, OTHERWISE
C                    THE CALL WILL BE IGNORED AND A MESSAGE WILL NOTIFY
C                    THE USER.
C
C     EXIT: RETURN
C
C     CALLS: CWTV, MSGLG1
C
C     CALLED BY: USER
C
C     COMMON USED:
C     /DVCOM/
C            R FACT    - CURRENT SCALING FACTOR. USED BY *FACTOR*
C            R VCP()   - CURRENT POINT IN COMPUTATIONAL COORDINATES
C            R WIN()   - THE CURRENT VIEW WINDOW IN COMPUTATIONAL
C                        COORDINATES
C            R WX()    - ARRAY OF X ORDINATES FOR REPRESENTING THE
C                        VIEW WINDOW AS POLYGONS.
C            R WY()    - ARRAY OF Y ORDINATES FOR REPRESENTING THE
C                        VIEW WINDOW AS POLYGONS.
C
C     /MSGCOM/
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C-D  DEBUG MESSAGE
C      RELARG(1)=FACTR
C      CALL MSGLG1(26)
C-D
C
C...  CHECK THE VALIDITY OF THE NEW FACTOR
C
      IF( FACTR. LE. 0 ) GO TO 20
C
C...  CORRECTION FACTOR COMPUTED FROM NEW FACTOR AND OLD FACTOR
      ALMT = FACT/FACTR
C
C...  ADJUST WINDOW FOR NEW FACTOR
      DO 10 I=1,4
      WIN(I) = WIN(I) * ALMT
      WX(I) = WX(I) * ALMT
      WY(I) = WY(I) * ALMT
   10 CONTINUE
C
C...  ADJUST REORIGIN POINT/CURRENT POSITION FOR NEW FACTOR
      DO 15 I=1,2
      RORG(I) = RORG(I)*ALMT
      VCP(I) = VCP(I)*ALMT
   15 CONTINUE
C
C...  ADJUST WTV TRANSFORMATION FOR NEW FACTOR
      CALL CWTV
C
C...  FACTOR SAVED
      FACT = FACTR
C
      RETURN
C
C...  INVALID FACTOR REQUEST, INFORM THE USER AND RETURN.
C
   20 RELARG( 1 ) = FACTR
       CALL MSGLG1( 138 )
      RETURN
C
      END
