      SUBROUTINE IBCHNK (IDATA,NWRDS,IFLAG)
C
C     NAME:  IBCHNK
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     IBCHNK - INPUT A BUFFER OF WORDS FROM VRF DATA FILE
C
C     SUBROUTINE IBCHNK IS USED TO INPUT A BUFFER OF 16 OR 32-BIT
C     WORDS (DEPENDING ON PRECISION AND IFLAG) FROM THE VRF DATA FILE.
C     IF END-OF-FILE IS ENCOUNTERED, VARIABLE "EOF" IS SET.
C
C
C     ENTRY:  CALL IBCHNK (IDATA,NWRDS,IFLAG)
C                   IDATA - DATA BUFFER INPUT
C                       NWRDS - NUMBER OF WORDS IN THE BUFFER
C                   IFLAG - INDICATES 16 OR 32 BIT WORD INPUT
C                       0 - INPUT 16 BIT WORD
C                      -1 - INPUT 32 BIT WORD
C
C     EXIT:  RETURNS A DATA WORD IN "IDATA"
C
C     CALLS:  IRAM,RREAD,RWAIT,SETFRE
C
C     CALLED BY:  BAND
C
C     COMMON USED:
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C     /BSORT/
C            L EOF     - FLAG INDICATING END-OF-DATA IN BAND
C                        HAS BEEN REACHED
C            I IBUF    - VRF INPUT BUFFER
C            I MSKALL  - MASK WITH ALL BITS TURNED ON
C            I MAXI    - POINTER TO END OF INPUT BUFFER
C            I NEXTI   - POINTER TO INPUT BUFFER
C            I PRECIS  - VRF PRECISION (16 OR 32-BIT)
C
C     LOCAL VARIABLES USED:
C
C               I  IPREC  - FLAG FOR BIT PRECISION 0 = 16 BIT
C            I  IRTN   - FLAG INDICATING PROGRAM LOCATION REQUIRING
C                        INPUT OF A DATA RECORD
C            I  ITEMP  - TEMPORARY VARIABLE USED TO BUILD DATA WORD
C            I  JREC   - INDEX OF NEXT RECORD TO READ
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C...  COMMON /BSORT/ -  BANDING VARIABLES
C
      INTEGER NEXTI,PRECIS,CANSTX,BYTCNT,FREMAX,FRENXT
      INTEGER BEGIN,NEXTO,MAX,NXDREC,MAXI,NCHUNK,MSKALL
      INTEGER IBUF,IVBUF
      LOGICAL EOF
C
      COMMON /BSORT/
     *    NEXTI, PRECIS, EOF, CANSTX, BYTCNT,
     *    MAXI,  NCHUNK, FREMAX, FRENXT, IWRD, NBYTS, KPTR,
     *    ISIZE, MSKALL, BEGIN(74), NEXTO(74), MAX(74),
     *    NXDREC(74), IST2, IBUF(128), IVBUF(9600)
C
C
C
C
C
C
      DIMENSION IDATA(1)
C
      ITEMP = 0
C
C...  DETERMINE WHETHER TO READ ONE OR TWO CHUNKS
      IPREC = 0
      IF ((PRECIS .EQ. 16) .OR. (IFLAG .EQ. 0)) IPREC = 1
C
      DO 10 I = 1, NWRDS
         IF (IPREC .EQ. 1) GO TO 150
         IRTN = 1
C
C...  CHECK FOR EMPTY BUFFER
         IF (NEXTI .GT. MAXI) GOTO 1000
C
  100    CALL GET16 (IBUF(1),NEXTI-1,ITEMP)
         ITEMP = IRAM(ITEMP,-16,MSKALL)
         NEXTI = NEXTI + 1
C
C...  CHECK FOR EMPTY BUFFER
  150    IRTN = 2
         IF (NEXTI .GT. MAXI) GO TO 1000
  200    CALL GET16 (IBUF(1),NEXTI-1,ITEMP2)
         IDATA(I) = OR(ITEMP,ITEMP2)
         NEXTI = NEXTI + 1
         GO TO 10
C
C
C
C...    CHECK FOR END OF CHAIN
 1000   JREC = IBUF(1)
        IF (JREC .NE. 0) GO TO 1100
        EOF = .TRUE.
        IDATA(I) = 0
        RETURN
C
C...    READ NEXT DATA RECORD
 1100   CALL RWAIT
        CALL RREAD (IBUF(1),JREC)
        NEXTI = NCHUNK + 3
        CALL SETFRE (JREC)
        CALL RWAIT
        GO TO (100,200),IRTN
C
  10    CONTINUE
      RETURN
C
      END
