      SUBROUTINE LINE (XARRAY,YARRAY,NPTS,INC,LINTYP,INTEQ)
C
C      NAME: LINE
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     LINE - PLOT A LINE OF POINTS
C
C     SUBROUTINE LINE PLOTS A SET OF DATA POINTS BY USING A SYMBOL AT
C     SPECIFIED POINTS AND/OR BY CONNECTING THE POINTS WITH A LINE.
C     THE ARRAYS OF POINTS ARE ASSUMED TO INCLUDE SCALING PARAMETERS
C     AS THE LAST TWO ITEMS.  THESE SCALING PARAMETERS ARE NORMALLY
C     GENERATED BY THE SCALE SUBROUTINE.  LINE CALLS THE SYMBOL
C     ROUTINE INTERNALLY TO PLOT A SYMBOL AT THE SPECIFIED DATA
C     POINTS, IF ANY. SYMBOL ALSO WILL DRAW THE LINE TO THE DATA POINT
C     IF BOTH LINE AND SYMBOLS ARE PLOTTED.  IF ONLY THE LINE IS BEING
C     PLOTTED, THE PLOT ROUTINE IS CALLED TO DO THIS.
C
C     NOTE THAT LINE, SCALE, AND AXIS ARE DESIGNED TO WORK IN
C     CONJUNCTION.
C
C        ENTRY: CALL LINE (XARRAY,YARRAY,NPTS,INC,LINTYP,INTEQ)
C
C            XARRAY- AN ARRAY CONTAINING ABSCISSA(X) VALUES WITH
C                   SCALING PARAMETERS FOR THE X-ARRAY.(REAL)
C            YARRAY- AN ARRAY CONTAINING ORDINATE(Y) VALUES WITH
C                   SCALING PARAMETERS FOR THE Y-ARRAY.(REAL)
C            NPTS  - IS THE NUMBER OF DATA VALUES IN EACH OF THE TWO
C                   X,Y ARRAYS.  THIS NUMBER DOES NOT INCLUDE VALUES
C                   SKIPPED BY INC NOR THE EXTRA TWO LOCATIONS
C                   CONTAINING THE SCALING PARAMETERS. (INTEGER)
C            INC   - IS THE INCREMENT USED IN GATHERING DATA VALUES
C                   FROM THE TWO ARRAYS (FOR EXAMPLE:
C                     INC=1 WILL INDEX EACH DATA ELEMENT,
C                     INC=2 WILL INDEX EVERY OTHER DATA ELEMENT,
C                     INC=3 WILL INDEX EVERY THIRD DATA ELEMENT,
C                          AND SO FORTH). (INTEGER)
C            LINTYP- DEFINES THE LINE TYPE/SYMBOL TO BE USED BY
C                   SUBROUTINE LINE.  IF SYMBOLS ARE PLOTTED, THE
C                   MAGNITUDE OF LINTYP(ABSOLUTE) DETERMINES THE
C                   SYMBOL PLOT FREQUENCY; (FOR EXAMPLE:
C                       LINTYP=4 INDICATES THAT A SPECIAL SYMBOL IS
C                               TO BE PLOTTED AT EVERY FOURTH DATA
C                               POINT).
C                   < 0 - INDICATES THAT NO LINES ARE TO BE DRAWN;
C                        ONLY THE SYMBOLS PLOTTED.
C                   = 0 - INDICATES THAT DATA POINTS ARE TO BE
C                        CONNECTED BY STRAIGHT LINES ONLY; NO
C                        SYMBOLS PLOTTED.
C                   > 0 - INDICATES THAT DATA POINTS ARE TO BE
C                        CONNECTED BY STRAIGHT LINES IN CONJUNCTION
C                        WITH PLOTTING SYMBOLS.
C            INTEQ - AN INTEGER EQUIVALENT(THAT IS, SYMBOL NUMBER)
C                   DEFINING THE CHARACTER/SYMBOL TO BE USED WHEN
C                   SYMBOL PLOTTING (THAT IS, LINTYP NOT EQUAL TO 0)
C
C        EXIT: RETURN
C
C        CALLS:  SYMBOL, PLOT
C
C        CALLED BY: USER
C
C        COMMON USED:
C
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C     LOCAL:
C
C           R   DELTAX - X DATA DELTA VALUE (FROM SCALE).
C           R   DELTAY - Y DATA DELTA VALUE (FROM SCALE).
C           R   FIRSTX - X DATA FIRST VALUE (OFFSET) (FROM SCALE)
C           R   FIRSTY - Y DATA FIRST VALUE (OFFSET) (FROM SCALE).
C           I   ICODE  - SYMBOL CALLING PARAMETER FOR SPECIFYING
C                      CENTERED SYMBOL TYPE OF CALL (-) AND WHETHER
C                      PEN IS UP (-1) OR DOWN (-2) DURING MOVE TO
C                      SYMBOL LOCATION.
C
C           I   ICODEA - ALTERNATE ICODE VALUE FOR ALL BUT FIRST DATA
C                      POINT
C           I   IPEN   - PLOT CALLING PARAMETER FOR SPECIFYING
C                      LINE (2) OR NO LINE (3).
C           I   IPENA  - ALTERNATE IPEN VALUE FOR ALL BUT FIRST DATA
C                      POINT.
C           R   LDX    - SUBSCRIPT OF DELTA VALUE.
C           R   LMIN   - SUBCRIPT OF FIRST VALUE (OFFSET).
C           I   NA     - SYMBOL INTERVAL COUNTER.
C           I   NT     - INTERVAL BETWEEN SYMBOLS.
C           R   XN     - WORKING X COORDINATE.
C           R   YN     - WORKING Y COORDINATE.
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C
      DIMENSION XARRAY(1),YARRAY(1)
C
C
C-D   DEBUG MESSAGE
C      RELARG(1)=XARRAY(1)
C      RELARG(2)=YARRAY(1)
C      INTARG(1)=NPTS
C      INTARG(2)=INC
C      INTARG(3)=LINTYP
C      INTARG(4)=INTEQ
C      CALL MSGLG1(29)
C-D
C
C
C...  INITIALIZE SUBSCRIPTS
      LMIN = NPTS*INC + 1
      LDX = LMIN + INC
C
C...  SET MAXS/MINS AND SCALING FACTORS
      FIRSTX = XARRAY(LMIN)
      DELTAX = XARRAY(LDX)
      FIRSTY = YARRAY(LMIN)
      DELTAY = YARRAY(LDX)
      IPEN = 3
      ICODE = -1
      NT = IABS (LINTYP)
C
C...  NO SYMBOLS PLOTTED?
      IF (LINTYP.EQ.0) NT = 1
C
C
C...  SET FOR ASCENDING ORDER DATA
      NA = NT
C
C...  SYMBOLS, LINES, OR BOTH?  S, L, B
   20 IF (LINTYP)              30,40,50
C
C...  PARAMETERS SET FOR SYMBOLS ONLY.  PLOT PARAMETER SET FOR PEN
C     UP; SYMBOL PARAMETER SET FOR PEN-UP; LINE SWITCH SET FOR NO
C     LINE.
   30 IPENA = 3
      ICODEA = -1
      GO TO 60
C
C...  NUMBER OF POINTS TO FIRST SYMBOL POINT SET BEYOND LAST
C     DATA POINT SUBSCRIPT SO ONLY A LINE WILL BE DRAWN
   40 NA = LDX
C
C...  PARAMETERS SET FOR LINE (AND SYMBOLS IF 40 NOT EXECUTED).
C     PLOT PARAMETER SET FOR PEN DOWN;
C     SYMBOL PARAMETER SET FOR PEN DOWN;
C     LINE SWITCH SET TO DRAW A LINE.
   50 IPENA = 2
      ICODEA = -2
C
C...  PLOT DATA. X AND Y COORDINATES COMPUTED FROM DATA VALUES AND
C     SCALING PARAMETERS.
   60 INCNPT = NPTS * INC
      DO 120 I = 1,INCNPT,INC
         XN = (XARRAY(I) - FIRSTX)/DELTAX
         YN = (YARRAY(I) - FIRSTY)/DELTAY
C
C...  TIME TO PLOT A SYMBOL?
C     IF NA<NT, A DATA POINT FOR A SYMBOL HAS
C     NOT BEEN REACHED.  IF NA=NT, A SYMBOL IS TO BE PLOTTED AT THE
C     CURRENT DATA POINT.  IF NA>NT, A LINE ONLY IS BEING DRAWN.
         IF (NA.NE.NT)GOTO 80
C
C...     YES, PLOT SYMBOL.
         CALL SYMBOL (XN,YN,0.08,INTEQ,0.0,ICODE)
C
C...  THE COUNTER TO THE NEXT SYMBOL POINT IS REINITIALIZED
C     CONTROL SKIPS TO UPDATE SUBSCRIPTS
         NA = 1
         GO TO 100
C
C...  NO, DON'T PLOT SYMBOL
C     PLOT LINE? IF YES PLOT IS CALLED TO DRAW A LINE.
C     IPEN IS 3 FOR THE FIRST DATA POINT FOR A PEN UP MOVE
C     TO THE START OF THE LINE.  ON LATER CALLS, IPEN WILL BE 2
C     IF A LINE IS BEING DRAWN.
   80 IF(LINTYP.GE.0)  CALL PLOT (XN,YN,IPEN)
C
C...     COUNT DATA POINT
   90 NA = NA + 1
C
C...  SYMBOL AND PLOT PARAMETERS SET TO THEIR LOOP VALUES
C     (REDUNDANT EXCEPT FOR FIRST EXECUTION WHERE PARAMETERS ARE
C     SWITCHED FROM THOSE NEEDED TO GET TO THE BEGINNING OF THE
C     LINE).
  100 ICODE = ICODEA
         IPEN = IPENA
  120 CONTINUE
C
      RETURN
C
      END
