      SUBROUTINE OCHUNK (IARG,IFLAG)
C
C     NAME: OCHUNK
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C
C
C     OCHUNK - OUTPUT 16-BIT CHUNK
C
C     SUBROUTINE OCHUNK IS USED TO OUTPUT A 16-BIT DATA CHUNK TO
C     THE VERSAPLOT RANDOM OUTPUT FILE.
C
C     ENTRY: CALL OCHUNK (IARG,IFLAG)
C                   IARG - WORD TO BE OUTPUT.  IF PRECISION IS
C                          32 BITS, TWO CHUNKS ARE OUTPUT.
C                   IFLAG- FLAG INDICATING 16 OR 32 BIT OUTPUT FOR
C                          32 BIT PRECISION.
C                      0 = OUTPUT 16 BITS
C                     -1 = OUTPUT 32 BITS
C
C     EXIT: RETURN
C
C     CALLS: RWRIT,IRAM,STOR16
C
C     CALLED BY: EVERYBODY
C
C     COMMON VARIABLES USED:
C     /DVCOM/
C            I MSKALL  - WORD MASK USED IN IRAM CALL TO 'AND' BITS
C     /VRFCOM/
C            I IREC()  - CURRENT RECORD POINTER
C            I NREC    - NEXT RECORD POINTER
C            I IHDCNT  - VDS HEADER RECORD BYTE COUNT
C            I ICNSTX  - WORD CONTAINING 'CAN-STX' HEADER
C            I IBEGIN()- THE INDEX POINTER INTO THE OBUF ARRAY
C                        OF THE START OF THE CURRENT VRF OUTPUT
C                        BUFFER
C            I MAX()   - THE END OF BUFFER POINTER OF THE
C                        CURRENT VRF OUTPUT BUFFER
C            I MIN     - THE INDEX POINTER INTO THE OBUF ARRAY
C                        OF THE START OF THE SECOND VRF OUTPUT
C                        BUFFER
C            I NCHUNK  - N0. OF 16-BIT CHUNKS IN A 'OBUF' WORD
C            I NEXTO() - CURRENT OUTPUT POINTER FOR THE VRF
C                        OUTPUT BUFFER
C            I OBUF()  - ARRAY FOR VRF OUTPUT BUFFERS (LREC*5)
C            I PRECIS  - COORDINATE PRECISION FOR THE VRF
C                        OUTPUT FILE (16 OR 32-BIT PRECISION)
C     /IOCOM/
C            I LREC    - LENGTH OF DATA FILE RECORD IN WORDS
C       /CLRCOM/
C               I IDASRT()- POINTER TO FIRST DATA RECORD IN A BAND
C            I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C            I NCPASS  - NUMBER OF COLOR PASSES
C
C     LOCAL VARIABLES USED:
C               I IBND  - POINTER TO WHERE THE CURRENT CHUNK IS GOING
C            I ITEMP - WORD TO BE OUTPUT ROTATED RIGHT 16 BITS, FOR
C                      32 BIT PRECISION OUTPUT ONLY.
C            I IRTN  - USED FOR COMPUTED GO-TO RETURN OF IN-LINE
C                      SUBROUTINE.
C            I MSKLO - MASK FOR LOWER 16 BITS OF 32 BIT WORD
C            I MSKUP - MASK FOR UPPER 16 BITS OF 32 BIT WORD
C
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /IOCOM/ - INPUT/OUTPUT VARIABLES
C
      COMMON /IOCOM/
     *    IUNIT, LUNIT, LREC, IOTYPE
C
C...  COMMON /CLRCOM/ - COLOR VARIABLES
C
      INTEGER PCOLOR, CURPEN
      LOGICAL PENCHG
      COMMON /CLRCOM/
     *    ICLMAX,  ITNCLR,  ITNFLG,  IVCFLG,  NCPASS,  PENCHG,
     *         CURPEN(4), ICLRDF(4,512), IDASRT(4), ITNSEQ(4),
     *         PCOLOR(64)
C
C
C
C...  DO FOR EACH BAND THAT NEEDS THE CHUNK
      DO 100 IBND=1,NCPASS,1
        IF (ITNSEQ(IBND) .GE. 0) GO TO 100
C
C
C...  CHECK IF OUTPUT TWO CHUNKS
        IF ((IFLAG.EQ.0) .OR. (PRECIS.EQ.16)) GO TO 20
C
C...  BUFFER FULL?
        IF (NEXTO(IBND) .LE. MAX(IBND))  GO TO 10
            IRTN = 1
            GO TO 40
C
C...  OUTPUT UPPER 16 BITS
   10   CALL STOR16 (OBUF(IBEGIN(IBND)),
     *                 NEXTO(IBND)-1,IRAM(IARG,16,MSKALL))
        NEXTO(IBND) = NEXTO(IBND) + 1
C
C...  IS BUFFER FULL?
   20   IF (NEXTO(IBND) .LE. MAX(IBND)) GO TO 30
            IRTN = 2
            GO TO 40
C
C...  CHECK LOWER 16 BITS
C
C...  MOVE/OUTPUT LOWER 16 BITS TO BUFFER
   30   CALL STOR16 (OBUF(IBEGIN(IBND)),NEXTO(IBND)-1,IARG)
        NEXTO(IBND) = NEXTO(IBND) + 1
      GO TO 100
C
C...  BUFFER FULL - INSERT LINK TO NEXT RECORD
   40   OBUF(IBEGIN(IBND)) = NREC
C
C...  OUTPUT BUFFER
        CALL RWAIT
        CALL RWRIT (OBUF(IBEGIN(IBND)),IREC(IBND))
C
C...  UPDATE CURRENT RECORD FOR THIS BAND
        IREC(IBND) = NREC
        NREC = NREC + 1
C
C...  SWAP BUFFER POINTERS FOR DOUBLE BUFFERING
        I = IBEGIN(IBND)
        IBEGIN(IBND) = MIN
        MIN = I
C
C...  INSERT VDS HEADERS
        CALL STOR16 (OBUF(IBEGIN(IBND)),2,ICNSTX)
        CALL STOR16 (OBUF(IBEGIN(IBND)),3,IHDCNT)
C
C...  SET POINTER TO NEW BUFFER
        NEXTO(IBND) = NCHUNK + 3
C
C...  RETURN FROM INLINE SUBROUTINE
        GO TO (10,30),IRTN
  100 CONTINUE
      RETURN
      END
