      SUBROUTINE OCODE(X,Y,ICODE)
C
C     NAME: OCODE
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     OCODE - RETURN A POINT'S OUT CODE RELATIVE TO A CLIPPING WINDOW
C
C     OCODE RECEIVES A POINT AND RETURNS A FOUR BIT OUT CODE WHICH
C     SPECIFIES THE LOCATION OF THE POINT RELATIVE TO THE WINDOW.
C
C     THE WORLD COORDINATE SYSTEM CAN BE DIVIDED INTO 9 REGIONS BY
C     EXTENDING THE EDGES OF THE CLIPPING WINDOW AS SHOWN BELOW. EACH
C     OF THESE REGIONS HAS A 4-BIT CODE.
C
C                     !               !
C                     !               !
C            1001       !     1000      !       1010
C                     !               !
C       --------------------------------------------------
C                     !               !
C                     !               !
C            0001       !     0000      !       0010
C                     !               !
C                     !               !
C       --------------------------------------------------
C                     !               !
C            0101       !     0100      !       0110
C                     !               !
C                     !               !
C
C     THE FOUR BITS OF THE OUT CODE MEAN THE FOLLOWING IF SET:
C            FIRST BIT:    POINT IS TO THE LEFT OF THE LEFT EDGE
C            SECOND BIT:   POINT IS TO THE RIGHT OF THE RIGHT EDGE
C            THIRD BIT:    POINT IS BELOW THE BOTTOM EDGE
C            FOURTH BIT:   POINT IS ABOVE THE TOP EDGE
C
C     ENTRY: CALL OCODE(X,Y,ICODE)
C
C            X,Y       - COORDINATE OF POINT
C            ICODE    - OUT CODE RETURN VARIABLE
C
C     EXIT: ICODE = FOUR BIT OUT CODE FOR X,Y WITH RESPECT TO WINDOW
C
C     CALLS: NONE
C
C     CALLED BY: CLIP,TONE
C
C     COMMON USED:
C     /DVCOM/
C            R WIN()   - THE CURRENT VIEW WINDOW IN COMPUTATIONAL
C                        COORDINATES
C
C     LOCAL: NONE
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C
      ICODE = 0
C
      IF (X .GE. WIN(1)) GO TO 10
C
C...     POINT TO THE LEFT OF LEFT WINDOW EDGE
         ICODE = 1
         GO TO 20
C
   10 IF (X .LE. WIN(3)) GO TO 20
C
C...     POINT TO THE RIGHT OF RIGHT WINDOW EDGE
         ICODE = 2
C
   20 IF (Y .GE. WIN(2)) GO TO 30
C
C...     POINT BELOW BOTTOM WINDOW EDGE
         ICODE = ICODE + 4
         GO TO 999
C
   30 IF (Y .LE. WIN(4)) GO TO 999
C
C...     POINT ABOVE TOP WINDOW EDGE
         ICODE = ICODE + 8
C
  999 RETURN
      END
