/* output.c - output from phase 2 of the Versaplot Random package */
/*                                                                */
/* First Produced by Lattice Logic, April 1986                    */
/* Calling procedures defined by Via to do the actual output      */
/* Revised: JGH  03-Jul-86 : Lattice & Via code merged            */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <sys/file.h>
#include <sys/vcmd.h>

extern char *getenv();

#define  VERS_DEV "/dev/vp0"                   /* versatec 'file' */
#define  MAX_BUF_SIZ 8*1024                /* max versatec buffer */
#define  REST_TIME       20                            /* seconds */
#define  VPC_BUSY   0400000

static  int  vfd;                 /* file descriptor for Versatec */

/******************************************************************/
/*                                                                */
/*   Function Name:  void attach ()                               */
/*                                                                */
/*   Purpose:        Opens the Versatec controller for I/O        */
/*                                                                */
/*   Parameters:     None                                         */
/*   Returns:        only if successful open                      */
/*                                                                */

void attach_ () {

   char *DevNam;

   /* Environmental variable VEROUT can be used to select an      */
   /* alternative device name, such as the Magtape drive          */
   DevNam = getenv ("VEROUT");
   if (DevNam == NULL) DevNam = VERS_DEV;

   vfd = open( DevNam, O_WRONLY, 0 );      /* open for write only */
   if (vfd == -1)  {
      perror ("VERSAPLOT ATTACH fails");
      exit (-1);
   }
}

/******************************************************************/
/*                                                                */
/*   Function Name: int get_vers_status()                         */
/*                                                                */
/*   Purpose:       Returns the current status of the hardware    */
/*                  interface to the Versatec color plotter       */
/*                  (VCP-42)                                      */
/*                                                                */
/*   Parameters:    None                                          */
/*   Returns:       an integer whose value is encoded as follows: */
/*                  > 0  interface is ready to accept more data   */
/*                  = 0  interface is not ready                   */
/*                  < 0  interface is ready but that there was    */
/*                       an error in the previous transmission    */
/*   Precondition:  The plotter must first be successfully opened */
/*                                                                */

int get_vers_status() {

   int error, flag;
   int status;

   error = ioctl( vfd, VGETSTATE, &status, flag );
   if (error == -1)  { return( -1 ); }
   if (VPC_BUSY & flag)  { return( 0 ); }
   return( 1 );
}

/******************************************************************/
/*                                                                */
/*   Function Name: void output (buffer, bytcnt)                  */
/*                                                                */
/*   Purpose:       Sends a user supplied buffer to the Versatec  */
/*                                                                */
/*   Parameters:    buffer - an address pointer to the start      */
/*                           of the user supplied buffer          */
/*                  bytcnt - an integer whose value is the        */
/*                           length of the buffer in bytes        */
/*   Parameters:    None                                          */
/*   Returns:       NA                                            */
/*   Precondition:  The plotter must first be successfully opened */
/*                                                                */
/*   Note:           No sanity checking of the contents of the    */
/*                   buffer is performed by this routine.         */
/*                                                                */

void output_ (buffer,bytcnt)
   char *buffer;
   int  *bytcnt;
{
   write( vfd, buffer, *bytcnt);
}

/******************************************************************/
/*                                                                */
/*   Function Name: void detach ()                                */
/*                                                                */
/*   Purpose:       Closes the versatec controller for I/O and    */
/*                  frees it for use by others                    */
/*                                                                */
/*   Parameters:    None                                          */
/*   Returns:       NA                                            */
/*   Precondition:  The plotter must first be successfully opened */
/*                                                                */

void detach_ () {
   while( !get_vers_status() )  { sleep( REST_TIME ); }
   close( vfd );         
}

/******************************************************************/
/*                                                                */
/*   Function Name: void oeof ()                                  */
/*                                                                */
/*   Purpose:       Write a tape mark to the tape drive           */
/*                                                                */
/*   Parameters:    None                                          */
/*   Returns:       NA                                            */
/*   Precondition:  The plotter must first be successfully opened */
/*                                                                */

void oeof_ () {

   int error, flag;
   struct mtop mtcom;

   mtcom.mt_op = MTWEOF;
   mtcom.mt_count = 1;
   error = ioctl( vfd, MTIOCTOP, &mtcom, flag );
}
