      SUBROUTINE OUTVEC
C
C     NAME:  OUTVEC
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY
C            REV. C
C            2/20/85        THIS SUBROUTINE WAS WRITTEN FOR THIS
C                          REVISION.  IT INCLUDES CODE TO UPDATE
C                          IBXMAX AND CODE TO COUNT BYTES FOR
C                          THE PRISM.
C
C     OUTVEC - OUTPUT A VECTOR TO THE VRF FILE.  THE VECTOR STORED
C             IN COMMON AS IX1,IY1,IX2,IY2 IS OUTPUT.  IF PMOVE
C             IS TRUE, THEN A MOVE IS OUTPUT TO IX1,IY1 AND A DRAW
C             IS OUTPUT TO IX2,IY2.  OTHERWISE, ONLY THE DRAW IS
C             OUTPUT.
C
C     CALLS: RWAIT, RWRIT
C
C     CALLED BY:  PLOT,DRWPEN,VSTRIP,XSTRIP
C
C     COMMON USED:
C     /DVCOM/
C            I ILWP    - (LINE WIDTH - 1)/2
C            I ILWM    - LINE WIDTH/2
C            I IX1,IX2
C              IY1,IY2 - WORKING STORAGE FOR CURRENT VECTOR
C            I MSB     - WORD TO SET HIGH ORDER BIT DETERMINED BY
C                        PRECISION (16/32) SELECTED.
C            I MSKALL  - WORD MASK USED IN IRAM CALL TO 'AND' BITS
C            L PMOVE   - STATUS OF LAST PLOT CALL (.TRUE.=MOVE)
C            L XMAJOR  - INDICATES IF XMAJOR MOVE VECTOR
C     /VRFCOM/
C            R BYTKNT()- BYTE COUNT FOR EACH COLOR
C            R DRWELM  - ELEMENT COUNT FOR A DRAW COMMAND
C            R DRWKNT  - BYTE COUNT FOR A DRAW COMMAND
C            I IBXMAX  - MAXIMUM X VALUE (USED FOR BANDING)
C            I IREC()  - CURRENT RECORD POINTER
C            I NREC    - NEXT RECORD POINTER
C            R VRFKNT()- COUNTER FOR RANDOM ELEMENTS
C            I IHDCNT  - VDS HEADER RECORD BYTE COUNT
C            I ICNSTX  - WORD CONTAINING 'CAN-STX' HEADER
C            I IBEGIN()- THE INDEX POINTER INTO THE OBUF ARRAY
C                        OF THE START OF THE CURRENT VRF OUTPUT
C                        BUFFER
C            I MAX()   - THE END OF BUFFER POINTER OF THE
C                        CURRENT VRF OUTPUT BUFFER
C            I MIN     - THE INDEX POINTER INTO THE OBUF ARRAY
C                        OF THE START OF THE SECOND VRF OUTPUT
C                        BUFFER
C            I NEXTO() - CURRENT OUTPUT POINTER FOR THE VRF
C                        OUTPUT BUFFER
C            R OBJKNT()- NUMBER OF EACH TYPE OF OBJECT OUTPUT
C                       OBJKNT(1) - VECTORS
C                       OBJKNT(2) - POLYGONS
C                       OBJKNT(3) - CIRCLES
C                       OBJKNT(4) - CHARACTERS
C            I OBUF()  - ARRAY FOR VRF OUTPUT BUFFERS (LREC*5)
C            I PRECIS  - COORDINATE PRECISION FOR THE VRF
C                        OUTPUT FILE (16 OR 32-BIT PRECISION)
C     /IOCOM/
C            I LREC    - LENGTH OF DATA FILE RECORD IN WORDS
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C       /CLRCOM/
C               I IDASRT()- POINTER TO FIRST DATA RECORD IN A BAND
C            I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C            I NCPASS  - NUMBER OF COLOR PASSES
C
C     LOCAL:
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /IOCOM/ - INPUT/OUTPUT VARIABLES
C
      COMMON /IOCOM/
     *    IUNIT, LUNIT, LREC, IOTYPE
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C...  COMMON /CLRCOM/ - COLOR VARIABLES
C
      INTEGER PCOLOR, CURPEN
      LOGICAL PENCHG
      COMMON /CLRCOM/
     *    ICLMAX,  ITNCLR,  ITNFLG,  IVCFLG,  NCPASS,  PENCHG,
     *         CURPEN(4), ICLRDF(4,512), IDASRT(4), ITNSEQ(4),
     *         PCOLOR(64)
C
C-D
C...  OUTPUT CURRENT VECTOR MESSAGE
C     INTARG(1) = IX1
C     INTARG(2) = IY1
C     INTARG(3) = IX2
C     INTARG(4) = IY2
C     CALL MSGLG1(121)
C-D
C
C...  OUTPUT THE VECTOR
      IF (.NOT. PMOVE) GO TO 117
C
C...     OUTPUT THE MOVE
         ITEMPL = IX1
         KRTN = 1
         GO TO 800
  116    ITEMPL = IY1
         KRTN = 2
         GO TO 800
C
C...  OUTPUT THE DRAW
  117 ITEMPL = IX2
      KRTN = 3
      GO TO 800
  118 ITEMPL = OR(IY2,MSB)
      KRTN = 4
      GO TO 800
  119 CONTINUE
C
C...  DETERMINE MAXIMUM X-VALUE
      MAXX = IX2
      IF (IX1 .GT. IX2) MAXX = IX1
C
C...  ACCOUNT FOR LINE WIDTH
      IF (.NOT. XMAJOR) MAXX = MAXX + ILWP
C
C...  UPDATE IBXMAX
      IF (MAXX .GT. IBXMAX) IBXMAX = MAXX
C
C...  UPDATE ELEMENT COUNT
      DO 130 IBND = 1,NCPASS
         IF (ITNSEQ(IBND) .GE. 0) GO TO 130
         VRFKNT(IBND) = VRFKNT(IBND) + DRWELM
         BYTKNT(IBND) = BYTKNT(IBND) + DRWKNT
  130 CONTINUE
C
C...  COUNT ANOTHER VECTOR
      OBJKNT(1) = OBJKNT(1) + 1.0
C
C...  INDICATE DRAW COMMAND
      PMOVE = .FALSE.
C
C...  DONE
      RETURN
C
C
C...    DO FOR EACH BAND THAT NEEDS THE CHUNK
  800   DO 900 IBND=1,NCPASS,1
         IF (ITNSEQ(IBND) .GE. 0) GO TO 900
C
C...  CHECK IF OUTPUT TWO CHUNKS
        IF (PRECIS.EQ.16) GO TO 820
C
C...  BUFFER FULL?
        IF (NEXTO(IBND) .LE. MAX(IBND))  GO TO 810
            IRTN = 1
            GO TO 840
C
C...  OUTPUT UPPER 16 BITS
  810   CALL STOR16 (OBUF(IBEGIN(IBND)),
     *               NEXTO(IBND)-1,IRAM(ITEMPL,16,MSKALL))
        NEXTO(IBND) = NEXTO(IBND) + 1
C
C...  IS BUFFER FULL?
  820   IF (NEXTO(IBND) .LE. MAX(IBND)) GO TO 830
            IRTN = 2
            GO TO 840
C
C...  MOVE/OUTPUT LOWER 16 BITS TO BUFFER
  830   CALL STOR16 (OBUF(IBEGIN(IBND)),NEXTO(IBND)-1,ITEMPL)
        NEXTO(IBND) = NEXTO(IBND) + 1
      GO TO 900
C
C...  BUFFER FULL - INSERT LINK TO NEXT RECORD
  840   OBUF(IBEGIN(IBND)) = NREC
C
C...  OUTPUT BUFFER
        CALL RWAIT
        CALL RWRIT (OBUF(IBEGIN(IBND)),IREC(IBND))
C
C...  UPDATE CURRENT RECORD FOR THIS BAND
        IREC(IBND) = NREC
        NREC = NREC + 1
C
C...  SWAP BUFFER POINTERS FOR DOUBLE BUFFERING
        I = IBEGIN(IBND)
        IBEGIN(IBND) = MIN
        MIN = I
C
C...  INSERT VDS HEADERS
        CALL STOR16 (OBUF(IBEGIN(IBND)),2,ICNSTX)
        CALL STOR16 (OBUF(IBEGIN(IBND)),3,IHDCNT)
C
C...  SET POINTER TO NEW BUFFER
        NEXTO(IBND) = NCHUNK + 3
C
C...  RETURN FROM INLINE SUBROUTINE
        GO TO (810,830),IRTN
  900   CONTINUE
C
C...  RETURN IF DONE
      GO TO (116,117,118,119),KRTN
      RETURN
      END
