      SUBROUTINE PAPER (XMINN,XMAXX,YMINN,YMAXX)
C
C     NAME:  PAPER
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     PAPER - CALLED TO SET THE DEFAULT PAPER BOUNDARIES
C
C     PAPER IS CALLED BY THE USER TO SPECIFY THE BOUNDARIES OF THE
C     PLOTTING AREA FOR THE CURRENT JOB.  THIS INSURES THAT ALL
C     SUBSEQUENT SUBROUTINE VPORT CALLS SPECIFY A VIEWPORT WITHIN
C     THE PLOTTING AREA.
C
C     THE PAPER CALL ARGUMENTS ARE USED TO SET THE DEFAULT VIEWPORT
C     AND WINDOW DIMENSIONS.  THE USER CAN ALSO CALL VPORT OR WINDOW
C     TO OVERRIDE THESE VALUES.
C
C     FOR ROTATED PLOTS, THERE CAN BE LARGE BLANK AREA PRECEEDING
C     THE PLOT OUTPUT.  THIS BECAUSE THE VIEWPORT IS ROTATED USING
C     THE MAXIMUM 'Y' PAPER DIMENSION TO ALLOW FOR MULTIPLE
C     VIEWPORTS.  THE LENGTH OF THE BLANK AREA CAN BE MINIMIZED
C     BY SPECIFYING A SMALLER MAXIMUM 'Y' PAPER BOUNDARY.
C
C
C     *NOTE:  PAPER MUST BE CALLED BEFORE SUBROUTINE PLOTS
C             IS CALLED AND CALLED ONLY ONCE PER JOB.
C
C
C     ENTRY:  CALL PAPER(XMINN,XMAXX,YMINN,YMAXX)
C
C            XMINN - MINIMUM X EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE POSITIVE).
C            XMAXX - MAXIMUM X EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE .GT. ZERO).
C            YMINN - MINIMUM Y EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE POSITIVE).
C            YMAXX - MAXIMUM Y EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE .GT. ZERO).
C
C     EXIT:  PXMIN,PXMAX,PYMIN,PYMAX IN DVCOM COMMON UPDATED,
C            VXMIN,VXMAX,VYMIN,VYMAX,WXMIN,WXMAX,WYMIN,WYMAX IN
C            PRMCOM COMMON UPDATED.
C
C     CALLS:  NONE
C
C     CALLED BY:  USER
C
C     COMMON USED:
C     /DVCOM/
C            I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C            I PXMAX   - PAPER MAXIMUM 'X' DIMENSION
C            I PXMIN   - PAPER MINIMUM 'X' DIMENSION
C            I PYMAX   - PAPER MAXIMUM 'Y' DIMENSION
C            I PYMIN   - PAPER MINIMUM 'Y' DIMENSION
C
C     /PRMCOM/
C            I IFONT   - DEFAULT FONT PATTERN NUMBER.
C            R VXMIN   - DEFAULT MINIMUM X VIEWPORT COORDINATE.
C            R VXMAX   - DEFAULT MAXIMUM X VIEWPORT COORDINATE.
C            R VYMIN   - DEFAULT MINIMUM Y VIEWPORT COORDINATE.
C            R VYMAX   - DEFAULT MAXIMUM Y VIEWPORT COORDINATE.
C            R WXMIN   - DEFAULT MINIMUM X WINDOW COORDINATE.
C            R WXMAX   - DEFAULT MAXIMUM X WINDOW COORDINATE.
C            R WYMIN   - DEFAULT MINIMUM Y WINDOW COORDINATE.
C            R WYMAX   - DEFAULT MAXIMUM Y WINDOW COORDINATE.
C
C      LOCAL:  NONE
C
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /PRMCOM/ - DEFAULT PLOTTING PARAMETERS
C
      INTEGER PENTBL,BMODEL,BBYTES,CMODEL,CBYTES
      LOGICAL VSTRP
      COMMON /PRMCOM/
     *    IBYTES,      IDISK,       IFFAP,       LASTFF,
     *    IJPEN,       INHNCE,      INITFF,      INVERS,
     *    IRDT,        ISPACE,      ISPEED,      ISFLAG,
     *    IUSER,       JBYTES(75),  KREP,        IFONT,
     *    MIRROR,      MODEL,       MODL(75),    MXPEN,
     *    NCOPY,       NMODL,       PENTBL(64,2), RDEN,
     *    RDENS(75),   SCALE,       UNITS,       XFACT,
     *    YFACT,       XSTART,      YSTART,
     *    VXMIN,       VXMAX,       VYMIN,       VYMAX,
     *    WXMIN,       WXMAX,       WYMIN,       WYMAX,
     *    BMODEL,      BDEN,        BBYTES,
     *    CMODEL,      CDEN,        CBYTES,
     *    IDEFLG(256), IUCLR,       MODE1,       IPRISM(61),
     *    MUXOUT,      PMSIZE,      MAXPEN,      KTWO,
     *         LTNFLG,      LTNCLR,      MTAPE,       VSTRP,
     *         JSORT,       JCPCMD,      JCUT,        KDISK
C
C
C...  CHECK IF PLOTS ALREADY CALLED
      IF (IOPEN .NE. 0)  RETURN
C
C...  SET COMMON VARIABLES
      PXMIN = XMINN
      PXMAX = XMAXX
      PYMIN = YMINN
      PYMAX = YMAXX
C
C...  SET VIEWPORT/WINDOW DIMENSIONS IF NECESSARY
      VXMIN = PXMIN
      VXMAX = PXMAX
      VYMIN = PYMIN
      VYMAX = PYMAX
      WXMIN = PXMIN
      WXMAX = PXMAX
      WYMIN = PYMIN
      WYMAX = PYMAX
      RETURN
C
      END
