      SUBROUTINE PLOTS (IBUF,NLOC,LDEV)
C
C     NAME:  PLOTS
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY:
C     REV. B  2/16/83      PLOT ROTATION NOT WORKING IF CHANGE
C                          CALLED, REMOVE ALL CODE REFERENCING
C                          THE VARIABLE 'IROT', NOT USED FOR
C                          IVS/UVS CODE.
C             2/27/84      VARIABLE XLEN CALCULATED INCORRECTLY
C                          WHEN UNITS IS NOT 1.0 INCHES, CAUSES
C                          32 BIT PRECISION TO BE SET.
C
C             5/30/84      32-BIT FLAG NOT BEING SET FOR WIDE
C                          ROTATED PLOTS.
C
C     REV C   2/21/85      CODE TO ALLOW STRIPPING OF PLOTS WIDER
C                          THAN THE PLOTTER HAS BEEN ADDED.
C                          THE NUMBER OF NIBS PER SCAN (YNIPS) IS
C                          DECREASED BY 8 IF THE OUTPUT IS GOING
C                          TO A REP.  THE PAGE SIZE TIMES THE
C                          NUMBER OF STRIPS IS NOW USED TO SET
C                          PRECISION AND NIBSX.
C
C                          THE NUMBER OF PATTERNS AVAILABLE AND
C                          THE ALLOWABLE PEN WIDTHS ARE MODIFIED
C                          DEPENDING ON WHETHER THE OUTPUT IS GOING
C                          TO A REP OR A PRISM.
C     PLOTS - INITIALIZE THE VERSAPLOT PLOTTING SYSTEM
C
C     PLOTS INITIALIZES THE PLOTTING SOFTWARE BY SETTING DEFAULT
C     VALUES FOR THE PLOTTER MODEL IN USE AND OPENING THE REQUIRED
C     FILES.
C
C     ENTRY: CALL PLOTS (IBUF,NLOC,LDEV)
C
C            IBUF - PEN PLOTTER ARGUMENT, NOT USED FOR VERSAPLOT
C            NLOC - PEN PLOTTER ARGUMENT, NOT USED FOR VERSAPLOT
C            LDEV - PEN PLOTTER ARGUMENT, NOT USED FOR VERSAPLOT
C
C     EXIT:  THE VERSAPLOT DATA FILE IS OPEN
C
C
C     CALLS:  VPINIT,ROPEN,VPORT,WINDOW,AUTHOR,OCHUNK,SETFNT,
C            DEFPAT,RWAIT,RWRIT
C            IRAM,ATAN,CHANGE(OPTIONAL)
C
C     CALLED BY:  PLOT,USERS PROGRAM FOR INITIALIZATION
C
C     COMMON USED:
C     /DVCOM/
C            I ICXPTS  - MAXIMUM NUMBER OF POLYGON ELEMENTS ALLOWED
C            I IEOJ    - END-OF-JOB IPEN CODE
C            I IEOP()  - END-OF-PLOT IPEN CODE
C            I IHBUF() - VERSATEC DATA STANDARD HEADER WORDS
C            I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C            L IPDEF() - .TRUE. IF PEN HAS BEEN DEFINED
C            I ISORT   - PHASE II SORT FLAG SET BY SUBROUTINE PLOT
C                        = 0 - NO PARTITIONING REQUIRED
C                        = 1 - REP PARTITIONING REQUIRED
C                        = 2 - RPM PARTITIONING REQUIRED
C                        = 3 - REP AND RPM PARTITIONING REQUIRED
C            I JPEN    - THE CURRENT PEN NUMBER
C            I KPAT    - NUMBER OF CURRENTLY ACTIVE TONE PATTERN
C            I MSB     - WORD TO SET HIGH ORDER BIT DETERMINED BY
C                        PRECISION (16/32) SELECTED.
C            I MSKALL  - WORD MASK USED IN IRAM CALL TO 'AND' BITS
C            I NIBSX   - NUMBER OF SCAN LINES IN THE PLOTTING AREA
C            I PXMAX   - PAPER MAXIMUM 'X' DIMENSION
C            I PXMIN   - PAPER MINIMUM 'X' DIMENSION
C            I PYMAX   - PAPER MAXIMUM 'Y' DIMENSION
C            I PYMIN   - PAPER MINIMUM 'Y' DIMENSION
C            I RADN    - DEGREES TO RADIAN ANGLE CONVERSION FACTOR
C            L ROT90   - IF ROT90 = .TRUE. THEN ROTATE THE PLOT
C                        COUNTERCLOCKWISE 90 DEGREES
C            R XDEN    - NUMBER OF NIBS PER VIEWPORT UNIT IN THE X
C                        DIRECTION
C            I XNIPS   - NUMBER OF NIBS PER PAGE IN THE X-DIRECTION
C            R YDEN    - THE NUMBER OF NIBS PER VIEWPORT UNIT IN
C                        THE Y DIRECTION.
C            I YNIPS   - NIBS PER SCAN
C
C     /PRMCOM/
C            I IBYTES  - DEFAULT PLOTTER BYTES/SCAN (8-BIT BYTES).
C            I IDISK   - CONTROLLER WITH DISK FLAG.
C                       = 0 - NO DISK [DEFAULT]
C                       = 1 - DISK INSTALLED IN REP CONTROLLER
C                       = 2 - DISK INSTALLED IN RPM CONTROLLER
C                       = 3 - DISK INSTALLED IN BOTH REP AND
C                             RPM CONTROLLER
C            I IFONT   - DEFAULT FONT PATTERN NUMBER.
C            I IJPEN   - DEFAULT CURRENT PEN NUMBER.
C            I INITFF  - INITIAL FORM FEED FLAG.
C                       = 0 - NO INITIAL FORM FEED [DEFAULT]
C                       # 0 - OUTPUT INITIAL FORM FEED
C            I ISFLAG  - PLOTTER SPEED CHANGE FLAG.
C                       = 0 - NO SPEED CONTROL OUTPUT [DEFAULT]
C                       # 0 - OUTPUT SPEED CONTROL COMMAND
C            I ISPEED  - PLOTTER OUTPUT SPEED. NOT SUPPORTED ON
C                       ALL PLOTTERS.
C                       = -1 - FULL SPEED [DEFAULT]
C                       =  0 - .125 IPS
C                       =  1 - .250 IPS
C                       =  2 - .500 IPS
C                       =  3 - .750 IPS
C                       =  4 - 1.00 IPS
C            I IUSER   - RESERVED.
C            I KDISK   - RPM DISK USE FLAG
C                       = 0 - OVERFLOW ELEMENTS TO DISK IF
C                            MEMORY CAPACITY EXCEEDED
C                       = 1 - RASTER TO DISK ONLY IF MEMORY EXCEEDED
C                       = 2 - RASTER TO DISK
C            I KREP    - TARGET OUTPUT CONTROLLER
C                       = 0 - UNKNOWN
C                        = 1 - REP CONTROLLER
C                        = 4 - RPM CONTROLLER
C            I MODEL   - DEFAULT PLOTTER MODEL.
C            I MXPEN   - MAXIMUM PEN NUMBER TO BE ACTIVATED BY USER
C            I NCOPY   - PLOT COPY COUNT.
C            R RDEN    - DEFAULT PLOTTER NIBS/INCH VALUE.
C            R SCALE   - DEFAULT DRAWING SCALE FACTOR.
C            R UNITS   - DEFAULT UNITS MEASURE EXPRESSED
C                       IN UNITS/INCH.
C            R XFACT   - DEFAULT X SCALING FACTOR.
C            R YFACT   - DEFAULT Y SCALING FACTOR.
C            R XSTART  - DEFAULT STARTING X COORDINATE.
C            R YSTART  - DEFAULT STARTING Y COORDINATE.
C            L VSTRP   - .TRUE. IFF Y-STRIPPING ENABLED
C     /VRFCOM/
C            R DRWELM  - ELEMENT COUNT FOR A DRAW COMMAND
C            R DRWMAX  - BYTE COUNT FOR A DRAW COMMAND WITH A PEN
C                       OF WIDTH GREATER THAN 1
C            R DRWMIN  - BYTE COUNT FOR A DRAW COMMAND WITH A PEN
C                       OF WIDTH AT MOST 1
C            I IBXMAX  - MAXIMUM X VALUE (USED FOR BANDING)
C            I IREC()  - CURRENT RECORD POINTER
C            I NREC    - NEXT RECORD POINTER
C            I IHDCNT  - VDS HEADER RECORD BYTE COUNT
C            I ICNSTX  - WORD CONTAINING 'CAN-STX' HEADER
C            I IBEGIN()- THE INDEX POINTER INTO THE OBUF ARRAY
C                        OF THE START OF THE CURRENT VRF OUTPUT
C                        BUFFER
C            I ICOMD() - INTEGER ARRAY TO HOLD 16/32 BIT VRF
C                        COMMANDS, INITIALIZED IN PLOTS
C            I NBYTS   - NUMBER OF BYTES IN A 'OBUF' WORD
C            I NEXTO() - CURRENT OUTPUT POINTER FOR THE VRF
C                        OUTPUT BUFFER
C            I OBUF()  - ARRAY FOR VRF OUTPUT BUFFERS (LREC*5)
C            I PRECIS  - COORDINATE PRECISION FOR THE VRF
C                        OUTPUT FILE (16 OR 32-BIT PRECISION)
C     /IOCOM/
C            I LUNIT   - LOGICAL UNIT NUMBER OF LISTING DEVICE
C            I LREC    - LENGTH OF DATA FILE RECORD IN WORDS
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C       /CLRCOM/
C               I ICLRDF()- ARRAY CONTAINING COLOR DEFINITIONS
C            I ITNCLR  - CURRENT TONE COLOR INDEX
C            I ITNFLG  - USE PEN OR TONE COLOR FOR AREAS
C            I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C            I IVCFLG  - FLAG TO INDICATE COLOR MODE SET
C            I NCPASS  - NUMBER OF COLOR PASSES
C     /KLCOM/
C            L KFLAG   - FLAG INDICATING REP OUTPUT AND .GT. 13.65'
C                        PLOTTING REQUIRED.
C            I KSIZE   - VARIABLE DEFINING 13.65' IN SCANS, USED TO
C                        DETERMINE IF ELEMENT CROSSES A 13.65' PAGE
C                        BOUNDARY.
C
C     LOCAL:
C            I DOTS     - DOTS PER INCH.
C            I FNIBS    - NIBS PER SCAN.
C            I I        - TEMPORARY VARIABLE.
C            I IA       - LOOP COUNTER.
C            I IERR     - TONING SEQUENCE ERROR FLAG.
C            I MBIT     - WORD WITH 32ND (MOST SIGNIFICANT) BIT SET.
C            I MBIT16   - WORD WITH 16TH BIT SET.
C            R PLIMX    - MAXIMUM X PLOTTING COORDINATE FOR
C                        PRECISION SELECTED.
C            R PLIMY    - MAXIMUM Y PLOTTING COORDINATE FOR
C                        PRECISION SELECTED.
C
C
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /PRMCOM/ - DEFAULT PLOTTING PARAMETERS
C
      INTEGER PENTBL,BMODEL,BBYTES,CMODEL,CBYTES
      LOGICAL VSTRP
      COMMON /PRMCOM/
     *    IBYTES,      IDISK,       IFFAP,       LASTFF,
     *    IJPEN,       INHNCE,      INITFF,      INVERS,
     *    IRDT,        ISPACE,      ISPEED,      ISFLAG,
     *    IUSER,       JBYTES(75),  KREP,        IFONT,
     *    MIRROR,      MODEL,       MODL(75),    MXPEN,
     *    NCOPY,       NMODL,       PENTBL(64,2), RDEN,
     *    RDENS(75),   SCALE,       UNITS,       XFACT,
     *    YFACT,       XSTART,      YSTART,
     *    VXMIN,       VXMAX,       VYMIN,       VYMAX,
     *    WXMIN,       WXMAX,       WYMIN,       WYMAX,
     *    BMODEL,      BDEN,        BBYTES,
     *    CMODEL,      CDEN,        CBYTES,
     *    IDEFLG(256), IUCLR,       MODE1,       IPRISM(61),
     *    MUXOUT,      PMSIZE,      MAXPEN,      KTWO,
     *         LTNFLG,      LTNCLR,      MTAPE,       VSTRP,
     *         JSORT,       JCPCMD,      JCUT,        KDISK
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /IOCOM/ - INPUT/OUTPUT VARIABLES
C
      COMMON /IOCOM/
     *    IUNIT, LUNIT, LREC, IOTYPE
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
C...  COMMON /CLRCOM/ - COLOR VARIABLES
C
      INTEGER PCOLOR, CURPEN
      LOGICAL PENCHG
      COMMON /CLRCOM/
     *    ICLMAX,  ITNCLR,  ITNFLG,  IVCFLG,  NCPASS,  PENCHG,
     *         CURPEN(4), ICLRDF(4,512), IDASRT(4), ITNSEQ(4),
     *         PCOLOR(64)
C
C...  COMMON /KLCOM/ - X STRIPPING VARIABLES
C
      LOGICAL KFLAG
      COMMON /KLCOM/ KFLAG, KSIZE
C
C-W   *****  SYSTEM DEPENDENT VARIABLE  *****
C
C...  SET 32ND BIT, MOST SIGNIFICANT BIT (UPPER LEFT BIT) MASK
      DATA MBIT/-2147483648/
C
C...  SET 16TH BIT, THE MOST SIGNIFICANT BIT FOR A 16 BIT NUMBER
      DATA MBIT16/32768/
C-W   ***************************************
C
C
C
C
C
C...  IF FIRST TIME THROUGH, INITIALIZE SOFTWARE FOR THE PLOTTER
C...  MODEL IN USE, OTHERWISE RETURN.
      IF(IOPEN .EQ. -1) RETURN
C
C...  CHECK IF PREVIOUS PLOT NEEDS TO BE OUTPUT
      IF(IOPEN .NE. -2) GO TO 10
C-C
C...    ACTIVATE THE FOLLOWING LINE OF CODE TO SUPPORT VRF OUTPUT
C       CALL VRFPLT
C-C
 10   CONTINUE
C
C
C
C...  SET FIRST CALL FLAG FOR PLOTS
      IOPEN = -1
C
C     **********************************************************
C...  *  FIRST CALL, INITIALIZE PLOTTING VARIABLES FOR PLOTTER
C     *  MODEL AND OPEN THE OUTPUT FILE
C     **********************************************************
C
C...  INITIALIZE RADN
      RADN = ATAN(1.0) * 4.0/180.
C
C...  CALCULATE XDEN/YDEN IN TERMS OF NIBS/INCH OVER UNITS OF MEASURE.
      DOTS = (RDEN * SCALE) / UNITS
      YDEN = DOTS * YFACT
      XDEN = DOTS * XFACT
C
C...  SET NIB/SCAN COUNT
      FNIBS = FLOAT (IBYTES * 8) - 1.0
C
C...  SET PAPER COORDINATES TO PLOTTER DIMENSIONS, IF NECESSARY
      IF (PXMAX .EQ. -99999.0) PXMAX = FNIBS/XDEN
      IF (PYMAX .EQ. -99999.0) PYMAX = FNIBS/YDEN
C
C...  SET VIEWPORT COORDINATES, IF NECESSARY
      IF (VXMIN .EQ. -99999.0) VXMIN = PXMIN
      IF (VYMIN .EQ. -99999.0) VYMIN = PYMIN
      IF (VXMAX .EQ. -99999.0) VXMAX = PXMAX
      IF (VYMAX .EQ. -99999.0) VYMAX = PYMAX
C
C...  SET THE CLIPPING WINDOW, IF NECESSARY
      IF (WXMIN .EQ. -99999.0) WXMIN = PXMIN
      IF (WYMIN .EQ. -99999.0) WYMIN = PYMIN
      IF (WXMAX .EQ. -99999.0) WXMAX = PXMAX
      IF (WYMAX .EQ. -99999.0) WYMAX = PYMAX
C
C
C-C*****
C...  ALLOW USER TO MODIFY PLOT OPTIONS AT RUN-TIME
      IF (IBUF .NE. 0)  CALL CHANGE
C-C
C...  SET COMMON VARIABLES
C
C...  CHECK VALUE OF KREP AND SET KTWO IF NECESSARY
      KTWO = 0
      IF (KREP .NE. 0) GO TO 90
        KREP = 1
        KTWO = 1
   90 CONTINUE
C
C...  DETERMINE BYTES PER DRAW FOR THIN LINES
C     AND WIDE LINES ASSUMING 16 BIT PRECISION
      DRWMIN = 8.0
      DRWMAX = 12.0
      IF (IPRISM(11) .EQ. 1) DRWMAX = 14.0
C
C...  SET HIGH ORDER BIT SET WORD FOR 16 BIT PRECISION
      MSB = MBIT16
C
C...  INITIALIZE NIBS PER SCAN
      YNIPS = IBYTES * 8
      IF (KREP .EQ. 1) YNIPS = YNIPS - 8
C
C...  INITIALIZE NUMBER OF SCAN LINES IN THE PLOTTING WINDOW
      XNIPS = PXMAX * XDEN + 1.5
      IF (ROT90) XNIPS = PYMAX * YDEN + 1.5
C
C...  DETERMINE NUMBER OF STRIPS
      ITEMP = PYMAX * YDEN
      IF (ROT90) ITEMP = PXMAX * XDEN
      NSTRIP = ITEMP / YNIPS + 1
      IF (.NOT. VSTRP) NSTRIP = 1
C
C...  SET PRECISION
      TEMP = 32767.0
      IF (KREP .EQ. 1) TEMP = 32759.0
      XLEN = TEMP/XDEN
      YLEN = TEMP/YDEN
      IF ((.NOT. ROT90) .AND. (PXMAX*NSTRIP .GT. XLEN))  PRECIS = 32
      IF ((ROT90) .AND. (PYMAX*NSTRIP .GT. YLEN))  PRECIS = 32
C
C...  SET X STRIPPING FLAG IF REQUIRED
      KFLAG = .FALSE.
      IF (PRECIS .EQ. 32)  KFLAG = .TRUE.
C
C...  INITIALIZE HEADER BYTE COUNT
      IHDCNT = (LREC-1) * NBYTS - 4
C
C...  CHECK FOR 32 BIT PRECISION
      IF (PRECIS .EQ. 16)  GO TO 99
C
C...  SET HIGH ORDER BIT SET WORD FOR 32 BIT PRECISION
      MSB = MBIT
C
C...  SET UP BYTES PER DRAW FOR THIN LINES
      DRWMIN = 12.0
C
C...  SET MAXIMUM NUMBER OF POLYGON ELEMENTS ALLOWED
      ICXPTS = 63
C
C...  INITIALIZE 32 BIT PRECISION COMMANDS
      ICOMD(1) = ICOMD(1) + 1
      ICOMD(2) = ICOMD(2) + 2
C
C...  INITIALIZE INIT-VRF,BEGIN-BAND COMMANDS
      IHBUF(1) = IHBUF(1) + 256
      IHBUF(2) = IHBUF(2) + 1
   99 CONTINUE
C
C     ***********************
C...  * SET PLOTTING LIMITS *
C     ***********************
C
C
C
C...  SET MAXIMUM PLOTTING COORDINATES FOR SPECIFIED PRECISION
      PLIMY = 16375.0
      PLIMX = 32759.0
C
C...  CHECK IF PLOTTER WIDER THAN 16383 NIBS
      IF (IBYTES .LT. 2048)  GO TO 100
C
C...  SET LIMITS FOR PLOTTERS WIDER THAN 16375 NIBS
        PLIMY = 32759.0
C
C...  SET ELEMENT COUNT FOR DRAW COMMAND
        DRWELM = 2.0
  100 CONTINUE
C
C...  SET LIMITS IF GOING TO A PRISM
      IF (KREP .NE. 4) GO TO 101
        PLIMY = 32767.0
        PLIMX = 32767.0
  101 CONTINUE
      IF (PRECIS .EQ. 16) GO TO 105
      PLIMX = 2147483647.0
      PLIMY = 2147483647.0
  105 IF (.NOT.ROT90) GO TO 110
      TEMP = PLIMY
      PLIMY = PLIMX
      PLIMX = TEMP
  110 PLIMX = PLIMX/XDEN
      PLIMY = PLIMY/YDEN
C
C...  CHECK FOR LEGAL PAPER COORDINATES
      IF ((PXMAX .LE. PXMIN) .OR. (PYMAX .LE. PYMIN)) GO TO 120
      IF ((PXMIN .LT. 0.0) .OR. (PYMIN .LT. 0.0)) GO TO 120
      IF ((PXMAX .LE. 0.0) .OR. (PYMAX .LE. 0.0)) GO TO 120
C
C...  CHECK PAPER COORDINATES AGAINST MAXIMUM PLOTTING COORDINATES
      IF (VSTRP) GO TO 115
      IF ((PXMAX .GT. PLIMX) .OR. (PYMAX .GT. PLIMY)) GO TO 120
C
C...  CHECK VIEWPORT COORDINATES
  115 IF ((VXMIN.LT.PXMIN) .OR. (VXMIN.GT.PXMAX)) GO TO 150
      IF ((VYMIN.LT.PYMIN) .OR. (VYMIN.GT.PYMAX)) GO TO 150
      IF ((VXMAX.LT.PXMIN) .OR. (VXMAX.GT.PXMAX)) GO TO 150
      IF ((VYMAX.LT.PYMIN) .OR. (VYMAX.GT.PYMAX)) GO TO 150
      IF ((VXMIN.EQ.VXMAX) .OR. (VYMIN.EQ.VYMAX)) GO TO 150
      GO TO 160
C
C-E
  120 INTARG(1) = PRECIS
      CALL MSGLG1 (64)
C
      RELARG(1) = PXMIN
      RELARG(2) = PXMAX
      RELARG(3) = PYMIN
      RELARG(4) = PYMAX
      CALL MSGLG1 (65)
      STOP
C
  150 RELARG(1) = VXMIN
      RELARG(2) = VXMAX
      RELARG(3) = VYMIN
      RELARG(4) = VYMAX
      CALL MSGLG1 (66)
C
      RELARG(1) = PXMIN
      RELARG(2) = PXMAX
      RELARG(3) = PYMIN
      RELARG(4) = PYMAX
      CALL MSGLG1 (65)
      STOP
C-E
C
C...  CHECK WINDOW COORDINATES
  160 IF ((WXMAX .GT. WXMIN) .AND. (WYMAX .GT. WYMIN)) GO TO 170
C
C-E
      RELARG(1) = WXMIN
      RELARG(2) = WXMAX
      RELARG(3) = WYMIN
      RELARG(4) = WYMAX
      CALL MSGLG1 (68)
      STOP
C-E
C
C...  SWAP XDEN AND YDEN IF ROTATED PLOT
  170 IF (.NOT. ROT90) GO TO 175
      TEMP = XDEN
      XDEN = YDEN
      YDEN = TEMP
C
  175 TEMP = PXMAX
      IF (ROT90) TEMP = PYMAX
C
C
C...  NIBSX IS THE NUMBER OF SCAN LINES IN THE PLOTTING WINDOW
      NIBSX = TEMP * NSTRIP * XDEN + 0.5
C
C...  SET NIBSX FOR PLOTS GREATER THAN 13.65' IN LENGTH
C     (CODE DEEMED NOT NECESSARY)
C     IF (KFLAG)  NIBSX = 32760
C
C...  SET PEN/PATTERN LIMITS IF REP
      IF (KREP .NE. 1) GO TO 180
        MAXPAT = 63
        MAXPEN  = 14
  180 CONTINUE
C
C...  CHECK IF MULTIPLE CONTROLLER CONFIGURATION
      IF (KTWO .NE. 0)  KREP = 1
C-E
C...  CHECK IF RPM CONTROLLER AND MEMORY SIZE SPECIFIED
      IF (KREP .EQ. 1 .AND. KTWO .EQ. 0)  GO TO 200
        IF (PMSIZE .GT. 0.0)  GO TO 200
          CALL MSGLG1 (127)
          STOP
C-E
  200 CONTINUE
C
C...  OPEN OUTPUT FILE
      CALL ROPEN (1)
C
C...  INITIALIZE REC# 1,2 AND OUTPUT TO FILE
      OBUF(1) = 0
      CALL RWRIT (OBUF(1),1)
      CALL RWAIT
      CALL RWRIT (OBUF(1),2)
      NHEAD = 2
      NREC = 3
C
C...  CALL VPINIT TO INITIALIZE THE BUFFER PTRS, INITIALIZATION
C...  HEADERS AND DEFAULT PLOTTING PARAMETERS.
      CALL VPINIT
C
      RETURN
      END
