/*    RIOPKG - DISK I/O PACKAGE FOR VERSAPLOT                */
/*                                                           */
/*    NAME: RIOPKG - DISK I/O ROUTINES                       */
/*                                                           */
/*   LANGUAGE:  C                                            */
/*                                                           */
/*   OPERATING SYSTEM:  SUN UNIX                             */
/*                                                           */
/*   ORDER NUMBER:  ????-??                                  */
/*                                                           */
/*   PART NUMBER:  000-??????  APRIL 1986                    */
/*                                                           */
/*   PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0          */
/*                                                           */
/*   Produced by Lattice Logic Ltd, Edinburgh, April 1986    */
/*                                                           */
/*    SUBROUTINES TO PERFORM DISK I/O OPERATIONS             */
/*                                                           */
/*    THE ROUTINES (ROPEN, RREAD, RWRIT, RWAIT, RCLOS) ARE   */
/*    USED TO CREATE AND MANIPULATE THE INTERMEDIATE FILE.   */
/*                                                           */
/*    ROPEN(IARG) - OPEN VERSAPLOT DATA FILE                 */
/*        IARG = 1 - OPEN A NEW FILE                         */
/*        IARG = 2 - OPEN AN EXISTING FILE                   */
/*                                                           */
/*    RWAIT - WAIT FOR I/0 COMPLETION                        */
/*                                                           */
/*    RWRIT (BUFFER,IREC) - WRITE A RECORD                   */
/*        BUFFER - ADDRESS OF BUFFER TO WRITE FROM           */
/*        IREC   - DISK RECORD NUMBER                        */
/*                                                           */
/*    RREAD (BUFFER,IREC) - READ A RECORD                    */
/*        BUFFER - ADDRESS OF BUFFER TO READ INTO            */
/*        IREC   - DISK RECORD NUMBER                        */
/*                                                           */
/*    RCLOS - CLOSE VERSAPLOT DATA FILE.                     */
/*                                                           */
/*************************************************************/
#include <stdio.h>
#include <sys/file.h>
extern char *getenv();
extern int lunit;
static int munit;
int lrec = 128;
/*************************************************************/
ropen_ (ifunc)
   int * ifunc;
{
   /* ROPEN - OPEN VERSAPLOT VRF FILE */
   char *FileName;

   FileName = getenv ("RANDOM");
   if (FileName == NULL) FileName = "RANDOM.RAN";

   if (*ifunc == 1) {
      munit = open (FileName, O_CREAT+O_RDWR, 0200+0400);
   } else {
      munit = open (FileName, O_RDWR, 0200+0400);
   }
   if (munit < 0) {
      perror ("VERSAPLOT ROPEN fails");
      exit (-1);
   }
}
/*************************************************************/
rwait_ ()
{
   /* RWAIT - WAIT FOR I/O COMPLETION. */
}
/*************************************************************/
rwrit_ (ibuf,irec)
   int *irec;
   char *ibuf;
{
   register int length, pos, size;
   size = lrec*4;
   length = size;
   pos = (*irec-1) * size;
   lseek (munit, pos, 0);
   write (munit, ibuf, size);
   if (length != size) {
      perror ("VERSAPLOT RWRIT fails");
      exit (-1);
   }
}
/*************************************************************/
rread_ (ibuf, irec)
   int *irec;
   char *ibuf;
{
   register int length, pos, size;
   size = lrec * 4;
   pos = (*irec-1) * size;
   length = lseek (munit, pos, 0);
   length = read (munit, ibuf, size);
   if (length != size) {
      perror ("VERSAPLOT RREAD fails");
      exit (-1);
   }
}
/*************************************************************/
rclos_ ()
{
   /* RCLOS - CLOSE THE VERSAPLOT VRF FILE. */
   close (munit);
}
