      SUBROUTINE SETFRE (JREC)
C
C
C     NAME:  SETFRE
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY
C     REV. C        8/30/85  VARIABLES VSTACK AND MAXVS USED
C                           TO KEEP TRACK OF HOW LARGE AN
C                           UNLIMITED STACK WOULD GET.  THIS
C                           IS USED IN DETERMINING THE
C                           OPTIMUM STACK SIZE.
C                           UNUSED RECORDS THAT ARE LOST ARE
C                           COUNTED - NO MESSAGE IS OUTPUT.
C     SETFRE - PUT RECORD INTO AVAILABLE POOL
C
C     SUBROUTINE SETFRE PUT A DISK RECORD INDEX ONTO THE STACK
C     OF AVAILABLE DISK RECORDS.
C
C
C     ENTRY:  CALL SETFRE (JREC)
C
C                   JREC - INDEX OF THE DISK RECORD
C
C     EXIT:  "JREC" HAS BEEN PUSHED ONTO THE FREE-RECORD STACK
C
C     CALLS:  NONE
C
C     CALLED BY:  ICHUNK
C
C     COMMON USED:
C     /STKCOM/
C            I NLOSTA  - NUMBER OF RECORDS LOST THAT WOULD NOT
C                       HAVE BEEN REUSED
C            I STACK   - ARRAY USED AS A STACK
C            I STKMAX  - MAXIMUM SIZE OF THE STACK
C            I STKPTR  - STACK POINTER
C            I VSTACK  - VIRTUAL STACK SIZE IF WE WERE USING
C                       AN UNLIMITED STACK
C            I MAXVS   - MAX. SIZE OF VSTACK
C
C     LOCAL VARIABLES USED:  NONE
C
C
C...  COMMON /STKCOM/ - DISK RECORD ALLOCATION STACK VARIABLES
C
      INTEGER NEXTFR,STKPTR,STKMAX,STACK
      INTEGER VSTACK,MAXVS,VSUSED,NLOSTA,NLOSTB
C
      COMMON /STKCOM/
     *    NEXTFR,STKPTR,STKMAX,VSTACK,MAXVS,VSUSED,
     *    NLOSTA,NLOSTB,STACK(1000)
C
C
C
C...  UPDATE VIRTUAL STACK POINTERS
      VSTACK = VSTACK + 1
      IF (VSTACK .GT. MAXVS) MAXVS = VSTACK
C
C...  CHECK FOR STACK FULL
      IF (STKPTR.EQ.STKMAX) GO TO 100
      STKPTR = STKPTR + 1
      STACK(STKPTR) = JREC
      RETURN
C
C...  UNUSED RECORD LOST
  100 NLOSTA = NLOSTA + 1
      RETURN
      END
