      SUBROUTINE VPOPT ( ICODE, IARG, RARG, IER )
C
C     NAME:  VPOPT
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C
C     REVISION HISTORY:
C     REV. B  5/29/84      ALLOW FONT PATTERN NUMBER 0.
C             9/28/84      ALLOW RETURNING OF VARIABLES
C                          AFTER PLOTS CALL.
C     REV. C  1/10/85      ADD OPTIONS 23-42
C
C     VPOPT - CALLED TO CHANGE DEFAULT PLOTTING PARAMETERS.
C
C     SUBROUTINE VPOPT MAY BE CALLED BY THE USER TO CHANGE
C     A SET OF PLOT PROCESSING VARIABLES WHICH PROVIDE
C     ADDITIONAL INFORMATION AND CONTROL TO THE GRAPHIC
C     SUBROUTINES.  THESE GLOBAL PLOTTING VARIABLES ARE
C     ASSIGNED DEFAULT VALUES AT INSTALLATION TIME.  VPOPT
C     ALLOWS THE OVERRIDING OF THESE VARIABLES AT RUN-TIME.
C     NOT ALL VARIABLES ARE SUPPORTED BY ALL SYSTEMS.  REFER
C     TO THE VERSAPLOT RANDOM OPERATING MANUAL FOR ADDITIONAL
C     INFORMATION ABOUT SYSTEM/INSTALLATION DEPENDENT PROCESSING
C     PARAMETERS.
C
C     DEFAULT VALUES ARE SHOWN IN BRACKETS [VALUE].  THE VALUES
C     SHOWN ARE THE VALUES AS THE VERSAPLOT RANDOM PACKAGE IS
C     DISTRIBUTED, AND MAY BE CHANGED AT INSTALLATION TIME.
C
C     VPOPT MUST BE CALLED BEFORE SUBROUTINE PLOTS IS CALLED OR
C     THE CALL IS IGNORED.
C
C     ENTRY:  CALL VPOPT ( ICODE, IARG, RARG ,IER )
C
C            ICODE   - OP-CODE FOR ARGUMENTS BEING PASSED.
C                 >0 = INTEGER VALUE INDICATING THE OPCODE FOR THE
C                      ARGUMENTS BEING PASSED.
C                  0 = ILLEGAL VALUE, CALL IGNORED.
C                 <0 = RETURN CURRENT VALUE OF THE OP-CODE VARIABLES
C
C            IARG()  = INTEGER ARRAY USED TO PASS INTEGER ARGUMENTS
C
C            RARG()  = REAL ARRAY USED TO PASS REAL ARGUMENTS
C
C            IER     - RETURN CODE
C                  0 = NO ERROR
C                 -1 = ERROR, PLOTS ALREADY CALLED
C                 -2 = ILLEGAL ARGUMENT(S)
C                 -3 = OPTION NOT SUPPORTED
C            .......................................................
C                 1  - CHANGE DEFAULT PLOTTER MODEL.  THE DEFAULT
C                     PAPER, VIEWPORT, AND WINDOW DIMENSIONS WILL
C                     BE UPDATED TO REFLECT THE NEW MODEL.  NOTE:
C                     A 400 DOT/INCH PLOTTER WILL RESET LINE EN-
C                     HANCE TO ZERO, THUS IGNORING ANY PREVIOUS
C                     VALUE SET BY THE USER.
C            IARG(1) = VERSATEC PLOTTER MODEL IN USE.  FOR SPECIAL
C                      CONFIGURATIONS OR FOR MODELS NOT SUPPORTED,
C                      SET TO 9999 AND SPECIFY THE NIBS AND BYTES
C                      (RARG(1),IARG(2)) PARAMETERS. [80]
C            RARG(1) = NIBS PER INCH.
C                      ASSUMED TO BE THE SAME IN X AND Y DIRECTION.
C                      NIBS <0 IS ILLEGAL. [200.0]
C            IARG(2) = NUMBER OF 8 BIT BYTES PER SCAN LINE. [264]
C            .......................................................
C                 2  - CHANGE DEFAULT PAPER DIMENSIONS.  DEFAULT
C                      VALUES WILL RESULT IN A PLOTTING AREA WITH
C                      MAXIMUM X AND Y DIMENSIONS EQUAL TO THE
C                      PLOTTER WIDTH.  THE VIEWPORT AND WINDOW
C                     DIMENSIONS WILL BE UPDATED TO THE SAME
C                     VALUES AS THE PAPER VALUES.
C            RARG(1) = MINIMUM X DIMENSION EXPRESSED IN TERMS OF THE
C                      DEFINED 'UNITS' OF MEASURE(MUST BE POSITIVE).
C            RARG(2) = MAXIMUM X DIMENSION EXPRESSED IN TERMS OF THE
C                      DEFINED 'UNITS' OF MEASURE(MUST BE .GT. 0.0).
C            RARG(3) = MINIMUM Y DIMENSION EXPRESSED IN TERMS OF THE
C                      DEFINED 'UNITS' OF MEASURE(MUST BE POSITIVE).
C            RARG(4) = MAXIMUM Y DIMENSION EXPRESSED IN TERMS OF THE
C                      DEFINED 'UNITS' OF MEASURE(MUST BE .GT. 0.0).
C            .......................................................
C                 3  - CHANGE DEFAULT CLIPPING WINDOW DIMENSIONS.
C                      THE DEFAULT VALUES WILL RESULT IN A CLIPPING
C                      WINDOW WITH SAME VALUES AS THE PAPER VALUES.
C
C                     NOTE:  WINDOW DIMENSIONS WILL BE UPDATED
C                            TO THE PAPER VALUES IF THE PAPER
C                            DIMENSIONS ARE CHANGED.
C            RARG(1) = MINIMUM X VALUE [DEFAULT = 0.0]
C            RARG(2) = MAXIMUM X VALUE [DEFAULT = PLOTTER WIDTH]
C            RARG(3) = MINIMUM Y VALUE [DEFAULT = 0.0]
C            RARG(4) = MAXIMUM Y VALUE [DEFAULT = PLOTTER WIDTH]
C            .......................................................
C                 4  - CHANGE DEFAULT VIEWPORT AREA.  THE DEFAULT
C                      VALUES WILL RESULT IN A VIEWPORT WITH THE
C                      SAME VALUES AS THE PAPER VALUES.
C
C                     NOTE:  VIEWPORT DIMENSIONS WILL BE UPDATED
C                            TO THE PAPER VALUES IF THE PAPER
C                            DIMENSIONS ARE CHANGED.
C            RARG(1) = MINIMUM X DIMENSION [DEFAULT = 0.0]
C            RARG(2) = MAXIMUM X DIMENSION [DEFAULT = PLOTTER WIDTH]
C            RARG(3) = MINIMUM Y DIMENSION [DEFAULT = 0.0]
C            RARG(4) = MAXIMUM Y DIMENSION [DEFAULT = PLOTTER WIDTH]
C            .......................................................
C                 5  - ENABLE PLOT ROTATION
C            IARG(1) = 0  = DO NOT ROTATE PLOT [DEFAULT]
C                    = -1 = ROTATE PLOT
C            .......................................................
C                 6  - DRAWING SCALE FACTOR
C            RARG(1) = NEW DRAWING FACTOR [1.0]
C            .......................................................
C                 7  - VRF COORDINATE PRECISION
C            IARG(1) = 16 = OUTPUT 15-BIT PRECISION COORDINATES
C                      32 = OUTPUT 31-BIT PRECISION COORDINATES
C                           [DEFAULT = 16]
C            .......................................................
C                 8  - BASIC PLOTTING UNITS OF MEASURE
C            RARG(1) = 1.000 INCHES [DEFAULT]
C                    = .0833 FEET
C                    = .0278 YARDS
C                    = 1000.0 MILLS
C                    = 25.40 MILLIMETERS
C                    = 2.540 CENTIMETERS
C                    = .0254 METERS
C            .......................................................
C                *9  - DEFAULT FONT TO BE USED
C            IARG(1) = FONT NUMBER [0]
C            .......................................................
C                10  - DEFAULT STARTING X AND Y PLOT POSITION
C            RARG(1) = XSTART [0.0]
C            RARG(2) = YSTART [0.0]
C            .......................................................
C                11  - DEFAULT X/Y SCALING FACTORS
C            RARG(1) = XFACT [1.0]
C            RARG(2) = YFACT [1.0]
C            .......................................................
C                12  - END-OF-PLOT CODES
C            IARG(1) = IEOP(1) [+999]
C            IARG(2) = IEOP(2) [-999]
C            IARG(3) = IEOP(3) [+23]
C            IARG(4) = IEOP(4) [-23]
C            IARG(5) = IEOJ [+999]
C            .......................................................
C                13  - PLOT COPY COUNT
C            IARG(1) = NCOPY [DEFAULT=1]
C            .......................................................
C               *14  - PLOT HEADER FLAG
C                     NOT SUPPORTED
C            .......................................................
C               *15  - SPECIFY OUTPUT CONTROLLER
C            IARG(1) = 0  = UNKNOWN
C                     1  = REP [DEFAULT]
C                     4  = RPM CONTROLLER
C            .......................................................
C                16  - INITIAL FORM FEED FLAG
C            IARG(1) = 0  = NO INITIAL FORM FEED [DEFAULT]
C                   = -1 = OUTPUT INITIAL FORM FEED
C            .......................................................
C               *17  - DISK/NO DISK FLAG
C            IARG(1) = 0  = NO DISK IN CONTROLLER [DEFAULT]
C                      1  = REP WITH A DISK
C                      2  = RPM WITH A DISK
C                      3  = REP AND RPM BOTH WITH DISKS
C            .......................................................
C               *18  - SELECT MAXIMUM PLOTTER OUTPUT SPEED
C            IARG(1) = -1 = FULL SPEED [DEFAULT]
C                       0 = .125 IPS
C                       1 = .250 IPS
C                       2 = .500 IPS
C                       3 = .750 IPS
C                       4 = 1.00 IPS
C            .......................................................
C                19  - SELECT INITIAL PEN NUMBER
C            IARG(1) = PEN NUMBER (0-7) [DEFAULT=1]
C            .......................................................
C                20  - SELECT LOGICAL LISTING UNIT
C            IARG(1) = LISTING UNIT NUMBER
C            .......................................................
C               *21  - SET AUTHOR ANNOTATION
C            IARG(1) = NUMBER OF CHARACTERS IN THE TEXT STRING. MUST
C                      EVEN WITH A MAXIMUM OF 60 CHARACTERS.
C            IARG(2) = TEXT STRING TO BE PASSED.
C            .......................................................
C               *22  - CHANGE DEFAULT VRF FILE PATHNAME
C                     NOT SUPPORTED
C            .......................................................
C                23 - SET FORM FEED OR SPACE AFTER EACH COPY OF
C                     A PLOT.  THIS FLAG IS USED FOR MULTIPLE
C                     COPIES OF A PLOT.
C            IARG(1)       >=  0  = SPACE BETWEEN COPIES (IN UNITS)
C                   =  -1  = FORM FEED AFTER EACH COPY
C                           [DEFAULT=2]
C            .......................................................
C                24  - SET FORM FEED OR SPACE AFTER EACH PLOT.
C                     THIS FLAG IS USED AFTER A SINGLE-COPY PLOT
C                     OR AFTER THE LAST COPY OF A MULTI-COPY PLOT.
C            IARG(1)       >=  0 = SPACE AFTER EACH PLOT (IN UNITS)
C                   =  -1 = FORM FEED AFTER EACH PLOT
C                          [DEFAULT = 0]
C                     NOTE: FOR COLOR PLOTS, THIS FLAG IS IGNORED
C                          AND A FORM FEED IS ALWAYS OUTPUT.
C            .......................................................
C               *25  - SET NSCAN FOR PLOT
C                     NOT SUPPORTED
C            .......................................................
C               *26  - SET LINE ENHANCE
C            IARG(1) = 0  = NO LINE ENHANCE [DEFAULT]
C                   = -1 = LINE ENHANCE
C            .......................................................
C               *27  - SET INVERSE IMAGE PLOTTING
C            IARG(1) = 0  = NO INVERSE IMAGE PLOTTING [DEFAULT]
C                   = -1 = INVERSE IMAGE PLOTTING
C            .......................................................
C               *28 - SET MIRROR IMAGE PLOTTING
C            IARG(1) = 0  = NO MIRROR IMAGE PLOTTING [DEFAULT]
C                   = -1 = MIRROR IMAGE PLOTTING
C            .......................................................
C               *29 - SET RASTER DATA TRANSLATE
C            IARG(1) = 0  = NO RASTER DATA TRANSLATE [DEFAULT]
C                   = -1 = RASTER DATA TRANSLATE
C            .......................................................
C                30 - SET LAST FORM FEED
C            IARG(1) = 0  = NO FORM FEED AFTER THE LAST PLOT
C                   = -1 = FORM FEED AFTER THE LAST PLOT [DEFAULT]
C                     NOTE: FOR A COLOR PLOT, THE DEFAULT IS 0.
C            .......................................................
C               *31 - OUTPUT MODE
C                     NOT SUPPORTED
C            .......................................................
C               *32 - PLOTTER DEVICE NUMBER
C            IARG(1) = 0  = NO OUTPUT MULTIPLEXER (MODEL 511A)
C                   = 1  = OUTPUT TO PORT #1
C                   = 2  = OUTPUT TO PORT #2
C                   = 3  = OUTPUT TO PORTS #1 AND #2
C            .......................................................
C               *33 - ENABLE AUTOMATIC STRIPPING OF PLOTS
C                     THAT ARE WIDER THAN THE PLOTTER
C            IARG(1) = 0  = NO AUTOMATIC STRIPPING [DEFAULT]
C                   = -1 = AUTOMATIC STRIPPING OF WIDE PLOTS
C            .......................................................
C               *34  - RPM SERIES CONTROLLER MEMORY SIZE
C            RARG(1) = MEMORY SIZE IN BYTES
C            .......................................................
C               *35 - INVOKE VRF OUTPUT FLAG
C            IARG(1) = 0  = DO NOT INVOKE VRF OUTPUT [DEFAULT]
C                   = 1  = AUTOMATICALLY INVOKE THE OUTPUT
C                          ROUTINES AT THE END OF JOB
C                   = 2  = AUTOMATICALLY INVOKE THE OUTPUT
C                           ROUTINES AT THE END OF EACH PLOT
C            .......................................................
C               *36  - MAG TAPE OUTPUT FLAG
C            IARG(1) = 0  = NO MAG TAPE OUTPUT [DEFAULT]
C                   = 1  = OUTPUT TO MAG TAPE FOR USE WITH A 430
C                   = 2  = OUTPUT TO MAG TAPE FOR USE WITH
C                          A REP OR RPM
C            .......................................................
C               *37  - PARTITION FLAG
C            IARG(1) = 0  = NEVER PARTITION
C                   = 1  = ALWAYS PARTITION
C                   = 2  = PARTITION IF NECESSARY [DEFAULT]
C            .......................................................
C               *38  - COPY COMMAND FLAG
C            IARG(1) = 0  = DO NOT USE COPY COMMAND [DEFAULT]
C                   = 1  = USE COPY COMMAND WHEN POSSIBLE
C                   NOTE: WHEN THE COPY COMMAND IS NOT USED,
C                         THE HOST SOFTWARE GENERATES THE COPIES.
C            .......................................................
C               *39  - BYTES/RASTER BUFFER
C                     NOT SUPPORTED
C            .......................................................
C               *40  - PAPER CUT FLAG
C            IARG(1) = -1 = CUT IMMEDIATE
C                   = 0  = NO PAPER CUT COMMAND
C                   = 1  = SET PAGE MODE
C            .......................................................
C               *41  - RPM DISK USE FLAG
C            IARG(1) = 0 = OVERFLOW ELEMENTS TO DISK IF
C                         MEMORY CAPACITY EXCEEDED [DEFAULT]
C                   = 1 = RASTER TO DISK ONLY IF MEMORY EXCEEDED
C                   = 2 = RASTER TO DISK
C            .......................................................
C               *42  - MODIFY THE RPM CONTROL ARRAY
C            IARG(1) = CONTROL ARRAY ENTRY TO BE MODIFIED
C                   =  1 = RESERVED
C                   =  2 = SYSTEM OPERATION MODE
C                   =  3 = PLOTTER ERROR ACTION
C                   =  4 = VRF DATA ERROR ACTION
C                   =  5 = RESERVED
C                   =  6 = PLOT AUTHOR TEXT
C                   =  7 = PLOT VRF DATA STATISTICS
C                   =  8 = RESERVED
C                   =  9 = DISK CONTROL
C                   = 10 = BITSLICE PARSER CONTROL
C                   = 11 = PLOTTER OFFLINE/ERROR RETRY PERIOD
C                   = 12-55 = RESERVED
C            IARG(2) = NEW VALUE
C
C                   NOTE:  THE DEFAULT VALUES FOR ALL ENTRIES IS
C                          (-1).  THIS INSTRUCTS THE RPM CONTROLLER
C                          TO USE THE INSTALLATION DEFAULTS.
C
C                          VALUES SENT FROM THE HOST OVERRIDE THE
C                          INSTALLATION DEFAULTS FOR THE CURRENT
C                          PLOT ONLY.
C
C                          SEE THE RPM OPERATING MANUAL FOR ADD-
C                          ITIONAL INFORMATION ON SETTING THE
C                          CONTROL ARRAY VALUES.
C
C            .......................................................
C
C            *******************************************************
C            *                                                     *
C            *  THE FOLLOWING OPTIONS ARE APPLICABLE ONLY WITH     *
C            *  VERSAPLOT COLOR RANDOM SOFTWARE PACKAGE.           *
C            *                                                     *
C            *******************************************************
C            .......................................................
C              *101  - INITIALIZE FOR COLOR PLOTTING.  THE DEFAULT
C                     PAPER, VIEWPORT, AND WINDOW DIMENSIONS WILL
C                     BE UPDATED TO REFLECT THE COLOR PLOTTER.
C            IARG(1) = NUMBER OF COLOR PASSES
C                 <0 = BLACK/WHITE PLOTTING ONLY [DEFAULT]
C                  0 = DEFAULT COLOR TONING SEQUENCE OF BLACK, CYAN,
C                      MAGENTA AND YELLOW, 4 PASSES.
C                1-4 = NUMBER OF TONING PASSES
C            IARG(2) THRU IARG(5) = TONER NUMBER:
C                      BLACK   = 1
C                      CYAN    = 2
C                      MAGENTA = 3
C                      YELLOW  = 4
C            .......................................................
C              *102  - SELECT PEN OR TONE COLOR FOR POLYGON TONING
C            IARG(1) = 0  = USE PEN COLOR [DEFAULT]
C                    = -1 = USE TONE COLOR
C            IARG(2) = TONE COLOR NUMBER (1-512) [DEFAULT=1]
C            .......................................................
C              *103  - SELECT COLOR/WIDTH FOR A PEN
C            IARG(1) = PEN NUMBER (0-MXPEN) (BY DEFAULT, MXPEN = 7)
C            IARG(2) = PEN COLOR (1-8)
C            IARG(3) = PEN WIDTH (0-MAXPEN)
C                            (MAXPEN = 31 IF AN RPM,
C                              = 14 IF A REP)
C            .......................................................
C
C            *NOTE:  NOT ALL VERSATEC CONTROLLERS, PLOTTERS,
C                   AND RANDOM SOFTWARE PACKAGES SUPPORT THESE
C                   FEATURES.  SEE THE VERSAPLOT RANDOM OPERATING
C                   MANUAL APPLICABLE FOR YOUR OPERATING SYSTEM
C                   AND CONFIGURATION FOR DETAILS  ON THE SUPPORT
C                   LEVEL OF THESE FEATURES.
C
C
C     EXIT:  COMMON VARIABLES IN PRMCOM/DVCOM/VRFCOM/IOCOM/CLRCOM
C            COMMON ARE UPDATED.
C
C     CALLS:  NONE
C
C     CALLED BY:  USER
C
C     COMMON USED:
C
C     /PRMCOM/
C            I BMODEL  - DEFAULT BLACK AND WHITE PLOTTER MODEL.
C            I BDEN    - DEFAULT BLACK AND WHITE PLOTTER NIBS/INCH.
C            I BBYTES  - DEFAULT BLACK AND WHITE PLOTTER BYTES/SCAN.
C            I CMODEL  - DEFAULT COLOR PLOTTER MODEL.
C            I CDEN    - DEFAULT COLOR PLOTTER NIBS/INCH.
C            I CBYTES  - DEFAULT COLOR PLOTTER BYTES/SCAN.
C            I IBYTES  - DEFAULT PLOTTER BYTES/SCAN (8-BIT BYTES).
C            I IDISK   - CONTROLLER WITH DISK FLAG.
C                       = 0 - NO DISK [DEFAULT]
C                       = 1 - DISK INSTALLED IN REP CONTROLLER
C                       = 2 - DISK INSTALLED IN RPM CONTROLLER
C                       = 3 - DISK INSTALLED IN BOTH REP AND
C                             RPM CONTROLLER
C            I IFONT   - DEFAULT FONT PATTERN NUMBER.
C            I IJPEN   - DEFAULT CURRENT PEN NUMBER.
C            I INITFF  - INITIAL FORM FEED FLAG.
C                       = 0 - NO INITIAL FORM FEED [DEFAULT]
C                       # 0 - OUTPUT INITIAL FORM FEED
C            I ISFLAG  - PLOTTER SPEED CHANGE FLAG.
C                       = 0 - NO SPEED CONTROL OUTPUT [DEFAULT]
C                       # 0 - OUTPUT SPEED CONTROL COMMAND
C            I ISPEED  - PLOTTER OUTPUT SPEED. NOT SUPPORTED ON
C                       ALL PLOTTERS.
C                       = -1 - FULL SPEED [DEFAULT]
C                       =  0 - .125 IPS
C                       =  1 - .250 IPS
C                       =  2 - .500 IPS
C                       =  3 - .750 IPS
C                       =  4 - 1.00 IPS
C            I IUSER   - RESERVED.
C            I JBYTES()- ARRAY OF ALL POSSIBLE BYTES/SCAN FOR
C                       CURRENTLY SUPPORTED PLOTTER MODELS.
C            I JCPCMD  - COPY COMMAND FLAG
C                       = 0 - DON'T USE COPY COMMAND
C                       = 1 - USE COPY COMMAND WHEN POSSIBLE
C            I JCUT    - PAPER CUT FLAG
C                       = -1 - CUT IMMEDIATE
C                       = 0  - NO PAPER CUT COMMAND
C                       = 1  - SET PAGE MODE
C            I JSORT   - PARTITION FLAG
C                       = 0 - NEVER PARTITION
C                       = 1 - ALWAYS PARTITION
C                       = 2 - PARTITION ONLY WHEN NECESSARY
C            I KDISK   - RPM DISK USE FLAG
C                       = 0 - OVERFLOW ELEMENTS TO DISK IF
C                            MEMORY CAPACITY EXCEEDED
C                       = 1 - RASTER TO DISK ONLY IF MEMORY EXCEEDED
C                       = 2 - RASTER TO DISK
C            I KREP    - TARGET OUTPUT CONTROLLER
C                       = 0 - UNKNOWN
C                        = 1 - REP CONTROLLER
C                        = 4 - RPM CONTROLLER
C            I MODE1   - INVOKE VRF OUTPUT FLAG
C                       = 0 - DO NOT INVOKE VRF OUTPUT
C                       = 1 - INVOKE VRF OUTPUT AT END-OF-JOB
C                       = 2 - INVOKE VRF OUTPUT AT END-OF-PLOT
C            I MODEL   - DEFAULT PLOTTER MODEL.
C            I MODL()  - ARRAY OF VERSATEC PLOTTER MODELS.
C            I MTAPE   - MAG TAPE OUTPUT FLAG
C                       = 0 - OUTPUT TO A CONTROLLER
C                       = 1 - OUTPUT TO A 430 MAG TAPE
C                       = 2 - OUTPUT TO A REP OR RPM
C            I MXPEN   - MAXIMUM PEN NUMBER TO BE ACTIVATED BY USER
C            I NCOPY   - PLOT COPY COUNT.
C            I NMODL   - NUMBER OF PLOTTER MODELS IN MODL().
C            I PENTBL()- ARRAY WITH COLOR AND WIDTH OF EACH PEN
C            R PMSIZE  - RPM CONTROLLER MEMORY SIZE IN MEGABYTES
C            R RDEN    - DEFAULT PLOTTER NIBS/INCH VALUE.
C            R SCALE   - DEFAULT DRAWING SCALE FACTOR.
C            R UNITS   - DEFAULT UNITS MEASURE EXPRESSED
C                       IN UNITS/INCH.
C            R XFACT   - DEFAULT X SCALING FACTOR.
C            R YFACT   - DEFAULT Y SCALING FACTOR.
C            R XSTART  - DEFAULT STARTING X COORDINATE.
C            R YSTART  - DEFAULT STARTING Y COORDINATE.
C            L VSTRP   - .TRUE. IFF Y-STRIPPING ENABLED
C            R VXMIN   - DEFAULT MINIMUM X VIEWPORT COORDINATE.
C            R VXMAX   - DEFAULT MAXIMUM X VIEWPORT COORDINATE.
C            R VYMIN   - DEFAULT MINIMUM Y VIEWPORT COORDINATE.
C            R VYMAX   - DEFAULT MAXIMUM Y VIEWPORT COORDINATE.
C            R WXMIN   - DEFAULT MINIMUM X WINDOW COORDINATE.
C            R WXMAX   - DEFAULT MAXIMUM X WINDOW COORDINATE.
C            R WYMIN   - DEFAULT MINIMUM Y WINDOW COORDINATE.
C            R WYMAX   - DEFAULT MAXIMUM Y WINDOW COORDINATE.
C     /DVCOM/
C            I IAUTXT()- ARRAY TO HOLD AUTHOR TEXT STRING
C            I IEOJ    - END-OF-JOB IPEN CODE
C            I IEOP()  - END-OF-PLOT IPEN CODE
C            I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C            I PXMAX   - PAPER MAXIMUM 'X' DIMENSION
C            I PXMIN   - PAPER MINIMUM 'X' DIMENSION
C            I PYMAX   - PAPER MAXIMUM 'Y' DIMENSION
C            I PYMIN   - PAPER MINIMUM 'Y' DIMENSION
C            L ROT90   - IF ROT90 = .TRUE. THEN ROTATE THE PLOT
C                        COUNTERCLOCKWISE 90 DEGREES
C     /VRFCOM/
C            I PRECIS  - COORDINATE PRECISION FOR THE VRF
C                        OUTPUT FILE (16 OR 32-BIT PRECISION)
C       /CLRCOM/
C            I ICLMAX  - NUMBER OF TONE COLORS DEFINED
C            I ITNCLR  - CURRENT TONE COLOR INDEX
C            I ITNFLG  - USE PEN OR TONE COLOR FOR AREAS
C            I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C            I IVCFLG  - FLAG TO INDICATE COLOR MODE SET
C            I NCPASS  - NUMBER OF COLOR PASSES
C     /IOCOM/
C            I LUNIT   - LOGICAL UNIT NUMBER OF LISTING DEVICE
C
C     LOCAL:
C
C            I IBMAX   - NUMBER OF NON-COLOR OPTIONS SUPPORTED
C            I ICMAX   - NUMBER OF COLOR OPTIONS SUPPORTED
C            I ICPEN   - INDEX FOR CURRENT PEN
C            I JCODE   - ABSOLUTE VALUE OF ICODE
C            L KCODE   - FLAG TO INDICATE IF RETURNING VALUES
C
C
C
C
C...  COMMON /CLRCOM/ - COLOR VARIABLES
C
      INTEGER PCOLOR, CURPEN
      LOGICAL PENCHG
      COMMON /CLRCOM/
     *    ICLMAX,  ITNCLR,  ITNFLG,  IVCFLG,  NCPASS,  PENCHG,
     *         CURPEN(4), ICLRDF(4,512), IDASRT(4), ITNSEQ(4),
     *         PCOLOR(64)
C
      LOGICAL ROT90,PMOVE,IPDEF,DASHPN,XMAJOR,VSFLAG
      INTEGER PWIDTH,XNIPS,YNIPS,PENPAT,VSMAX,PFONT
C...  COMMON /DVCOM/  PHASE I COMMON VARIABLES
C
      COMMON /DVCOM/
     *         ANC,    DASHPN, FACT,   HTC,    ICUT,   ICWTV,  ICXPTS,
     *         IEOJ,   ILWM,   ILWP,   IOPEN,  ISORT,  ITFLAG, IX1,
     *         IX2,    IY1,    IY2,    JFONT,  JPEN,   KPAT,   KWIDTH,
     *         LASTX,  LASTY,  MAXPAT, MSB,    MSKALL, NCH,    NCLIP,
     *         NIBSX,  NLPAT,  NPLOT,  PFONT,  PMOVE,  PXMIN,  PXMAX,
     *         PYMIN,  PYMAX,  RADN,   ROT90,  SXC,    SYC,    TSINA,
     *         TCOSA,  XDEN,   XFAC,   XNIPS,  XOFF,   YDEN,   YFAC,
     *         YOFF,   YNIPS,  VSFLAG, VSMAX,  XMAJOR,
     *         IPAT(16,256), IEOP(4),  IHBUF(2), IPDEF(64),
     *         NPAT(255),    PENPAT(4,64), PWIDTH(64),
     *         RORG(2), VCP(2), VP(4), WIN(4), WTV(4), WX(4),  WY(4),
     *         IAUTXT(15)
C
C
C
C...  COMMON /VRFCOM/ - VRF COMMON VARIABLES
C
      INTEGER PRECIS
      INTEGER OBUF
      COMMON /VRFCOM/
     *    DRWELM,    DRWMAX,    DRWMIN,    DRWKNT,    ICOPY,
     *         ICNSTX,    IBXMAX,    IHDCNT,    MIN,
     *         NBYTS,     NCHUNK,    NHEAD,     NREC,      PRECIS,
     *         RMXELM,    VRFMAX,
     *         BYTKNT(4), IBEGIN(4), ICOMD(2),  IOCODE(2), IREC(4),
     *         MAX(4),    NEXTO(4),  OBJKNT(4), VRFKNT(4), OBUF(640)
C
C...  COMMON /PRMCOM/ - DEFAULT PLOTTING PARAMETERS
C
      INTEGER PENTBL,BMODEL,BBYTES,CMODEL,CBYTES
      LOGICAL VSTRP
      COMMON /PRMCOM/
     *    IBYTES,      IDISK,       IFFAP,       LASTFF,
     *    IJPEN,       INHNCE,      INITFF,      INVERS,
     *    IRDT,        ISPACE,      ISPEED,      ISFLAG,
     *    IUSER,       JBYTES(75),  KREP,        IFONT,
     *    MIRROR,      MODEL,       MODL(75),    MXPEN,
     *    NCOPY,       NMODL,       PENTBL(64,2), RDEN,
     *    RDENS(75),   SCALE,       UNITS,       XFACT,
     *    YFACT,       XSTART,      YSTART,
     *    VXMIN,       VXMAX,       VYMIN,       VYMAX,
     *    WXMIN,       WXMAX,       WYMIN,       WYMAX,
     *    BMODEL,      BDEN,        BBYTES,
     *    CMODEL,      CDEN,        CBYTES,
     *    IDEFLG(256), IUCLR,       MODE1,       IPRISM(61),
     *    MUXOUT,      PMSIZE,      MAXPEN,      KTWO,
     *         LTNFLG,      LTNCLR,      MTAPE,       VSTRP,
     *         JSORT,       JCPCMD,      JCUT,        KDISK
C
C...  COMMON /IOCOM/ - INPUT/OUTPUT VARIABLES
C
      COMMON /IOCOM/
     *    IUNIT, LUNIT, LREC, IOTYPE
C
      LOGICAL KCODE
      DIMENSION IARG(1), RARG(1)
      DATA IBMAX/42/
      DATA ICMAX/3/
C
C
C
C...  CHECK IF RETURN VALUES CALL
      IF (ICODE .LT. 0)  GO TO 10
C
C...  CHECK IF PLOTS CALLED
      IF (IOPEN .NE. 0)  GO TO 90001
C
C...  INITIALIZE RETURN CODE
   10 IER = 0
C
C...  CHECK IF LEGAL RANGE FOR OPTIONS
      JCODE = IABS(ICODE)
C
C...  CHECK IF CALL TO RETURN VALUES
      KCODE = .FALSE.
      IF (ICODE .LT. 0)  KCODE = .TRUE.
C
C...  CHECK OPTION RANGE
      IF (JCODE .GT. 100)  GO TO 10000
      IF (JCODE .GT. IBMAX)  GO TO 90003
C
C...  PROCESS CALL
      GO TO (100,200,300,400,500,600,700,800,900,1000,
     *              1100,1200,1300,1400,1500,1600,1700,1800,
     *              1900,2000,2100,2200,2300,2400,90003,2600,2700,
     *              2800,2900,3000,90003,3200,3300,3400,3500,
     *              3600,3700,3800,90003,4000,4100,4200 ), JCODE
C
C***  PLOTTER MODEL   ***
  100 IF (KCODE)  GO TO 140
      IF (IARG(1) .NE. 9999)  GO TO 160
      IF (RARG(1) .LE. 0. .OR. IARG(2) .LE. 0)  GO TO 90002
      RDEN = RARG(1)
      IF (RDEN .EQ. 400.0) INHNCE = 0
      IBYTES = IARG(2)
      GO TO 175
C
C...  RETURN VALUES
  140 IARG(1) = MODEL
      RARG(1) = RDEN
      IARG(2) = IBYTES
      GO TO 99999
C
C...  CHECK FOR VALID MODEL
  160 DO 165 IA = 1,NMODL
        IT = IA
        IF (MODL(IA) .EQ. IARG(1))  GO TO 170
  165 CONTINUE
      GO TO 90002
C
C...  VALID MODEL FOUND, UPDATE IDENS/IBYTES
  170 RDEN = RDENS(IT)
      IF (RDEN .EQ. 400.0) INHNCE = 0
      IBYTES = JBYTES(IT)
  175 MODEL = IARG(1)
C
C...  UPDATE PAPER/VIEWPORT/WINDOW FOR NEW MODEL
  180 DOTS = (RDEN * SCALE) / UNITS
      XDEN = DOTS * XFACT
      YDEN = DOTS * YFACT
      FNIBS = FLOAT(IBYTES*8) - 1.0
      PXMIN = 0.0
      PYMIN = 0.0
      PXMAX = FNIBS/XDEN
      PYMAX = FNIBS/YDEN
      GO TO 205
C
C***  PAPER DIMENSIONS   ***
  200 IF (KCODE)  GO TO 240
      PXMIN = RARG(1)
      PXMAX = RARG(2)
      PYMIN = RARG(3)
      PYMAX = RARG(4)
C
C...  UPDATE VIEWPORT/WINDOW DIMENSIONS
  205 VXMIN = PXMIN
      VXMAX = PXMAX
      VYMIN = PYMIN
      VYMAX = PYMAX
      WXMIN = PXMIN
      WXMAX = PXMAX
      WYMIN = PYMIN
      WYMAX = PYMAX
      GO TO 99999
C
C...  RETURN VALUES
  240 RARG(1) = PXMIN
      RARG(2) = PXMAX
      RARG(3) = PYMIN
      RARG(4) = PYMAX
      GO TO 99999
C
C***  CLIPPING WINDOW DIMENSIONS   ***
  300 IF (KCODE)  GO TO 340
      WXMIN = RARG(1)
      WXMAX = RARG(2)
      WYMIN = RARG(3)
      WYMAX = RARG(4)
      GO TO 99999
C
C...  RETURN VALUES
  340 RARG(1) = WXMIN
      RARG(2) = WXMAX
      RARG(3) = WYMIN
      RARG(4) = WYMAX
      GO TO 99999
C
C***  VPORT DIMENSIONS   ***
  400 IF (KCODE)  GO TO 440
      IF (RARG(1) .LT. 0.0 .OR. RARG(2) .LT. 0.0)  GO TO 90002
      IF (RARG(3) .LT. 0.0 .OR. RARG(4) .LT. 0.0)  GO TO 90002
      VXMIN = RARG(1)
      VXMAX = RARG(2)
      VYMIN = RARG(3)
      VYMAX = RARG(4)
      GO TO 99999
C
C...  RETURN VALUES
  440 RARG(1) = VXMIN
      RARG(2) = VXMAX
      RARG(3) = VYMIN
      RARG(4) = VYMAX
      GO TO 99999
C
C***  PLOT ROTATION   ***
  500 IF (KCODE)  GO TO 540
      ROT90 = .FALSE.
      IF (IARG(1) .NE. 0)  ROT90 = .TRUE.
      GO TO 99999
C
C...  RETURN VALUE
  540 IARG(1) = 0
      IF (ROT90) IARG(1) = -1
      GO TO 99999
C
C***  SCALE FACTOR   ***
  600 IF (KCODE)  GO TO 640
      IF (RARG(1) .LE. 0.0)  GO TO 90002
      SCALE = RARG(1)
C
C...  UPDATE PAPER/VIEWPORT/WINDOW
      GO TO 180
C
C...  RETURN VALUE
  640 RARG(1) = SCALE
      GO TO 99999
C
C***  VRF PRECISION   ***
  700 IF (KCODE)  GO TO 740
      IF (IARG(1) .NE. 16 .AND. IARG(1) .NE. 32)  GO TO 90002
      PRECIS = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
  740 IARG(1) = PRECIS
      GO TO 99999
C
C***  PLOTTING UNITS   ***
  800 IF (KCODE)  GO TO 840
      IF (RARG(1) .LE. 0.0)  GO TO 90002
      UNITS = RARG(1)
C
C...  UPDATE PAPER/VIEWPORT/WINDOW
      GO TO 180
C
C...  RETURN VALUE
  840 RARG(1) = UNITS
      GO TO 99999
C
C***  FONT NUMBER   ***
  900 IF (KCODE)  GO TO 940
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 19)  GO TO 90002
      IFONT = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
  940 IARG(1) = IFONT
      GO TO 99999
C
C***  INITIAL X/Y VALUE   ***
 1000 IF (KCODE)  GO TO 1040
      XSTART = RARG(1)
      YSTART = RARG(2)
      GO TO 99999
C
C...  RETURN VALUE
 1040 RARG(1) = XSTART
      RARG(2) = YSTART
      GO TO 99999
C
C***  X/Y SCALING FACTORS   ***
 1100 IF (KCODE)  GO TO 1140
      IF (RARG(1) .LE. 0.0 .OR. RARG(2) .LE. 0.0)  GO TO 90002
      XFACT = RARG(1)
      YFACT = RARG(2)
      GO TO 99999
C
C...  RETURN VALUES
 1140 RARG(1) = XFACT
      RARG(2) = YFACT
      GO TO 99999
C
C***  END OF PLOT CODES   ***
 1200 IF (KCODE)  GO TO 1240
      IEOP(1) = IARG(1)
      IEOP(2) = IARG(2)
      IEOP(3) = IARG(3)
      IEOP(4) = IARG(4)
      IEOJ = IARG(5)
      GO TO 99999
C
C...  RETURN VALUES
 1240 IARG(1) = IEOP(1)
      IARG(2) = IEOP(2)
      IARG(3) = IEOP(3)
      IARG(4) = IEOP(4)
      IARG(5) = IEOJ
      GO TO 99999
C
C***  PLOT COPY COUNT   ***
 1300 IF (KCODE)  GO TO 1340
      IF (IARG(1) .LE. 0)  GO TO 90002
      NCOPY = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 1340 IARG(1) = NCOPY
      GO TO 99999
C
C***  PLOT HEADER FLAG   ***
C     NOT SUPPORTED
 1400 GO TO 90003
C
C
C***  OUTPUT CONTROLLER   ***
 1500 IF (KCODE)  GO TO 1540
      IF (IARG(1) .NE. 0 .AND. IARG(1) .NE. 1
     *           .AND. IARG(1) .NE. 4)  GO TO 90002
      KREP = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 1540 IARG(1) = KREP
      GO TO 99999
C
C***  INITIAL FORM-FEED FLAG   ***
 1600 IF (KCODE)  GO TO 1640
      INITFF = 0
      IF (IARG(1) .NE. 0) INITFF = -1
      GO TO 99999
C
C...  RETURN VALUE
 1640 IARG(1) = INITFF
      GO TO 99999
C
C***  CONTROLLER WITH DISK FLAG   ***
 1700 IF (KCODE)  GO TO 1740
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 3)  GO TO 90002
      IDISK = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 1740 IARG(1) = IDISK
      GO TO 99999
C
C***  PLOTTER OUTPUT SPEED   ***
 1800 IF (KCODE)  GO TO 1840
      IF (IARG(1) .LT. -1 .OR. IARG(1) .GT. 4) GO TO 90002
      ISPEED = IARG(1)
C
C...  SET FLAG TO HAVE SPEED CONTROL COMMAND SENT OUT
      ISFLAG = -1
      GO TO 99999
C
C...  RETURN VALUE
 1840 IARG(1) = ISPEED
      GO TO 99999

C
C***  SELECT DEFAULT PEN   ***
 1900 IF (KCODE)  GO TO 1940
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. MXPEN)  GO TO 90002
      IJPEN = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 1940 IARG(1) = IJPEN
      GO TO 99999
C
C***  SELECT LOGICAL LISTING UNIT   ***
 2000 IF (KCODE)  GO TO 2040
      IF (IARG(1) .LT. 0)  GO TO 90002
      LUNIT = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 2040 IARG(1) = LUNIT
      GO TO 99999
C
C***  AUTHOR CALL   ***
 2100 IF (KCODE)  GO TO 2140
C
C...  GET CHARACTER COUNT
      IF (IARG(1) .LE. 0)  GO TO 90002
      CALL AUTHOR ( IARG(2), IARG(1) )
      GO TO 99999
C
C...  RETURN VALUE
 2140 IARG(1) = NCH
      KNT = (NCH+3)/4
      J = 2
      DO 2150 IA = 1,KNT
        IARG(J) = IAUTXT(IA)
        J = J + 1
 2150 CONTINUE
      GO TO 99999
C
C***  CHANGE VRF FILE PATHNAME
C
C...  NOT SUPPORTED
 2200 GO TO 90003
C
C***  FORM FEED OR SPACE AFTER EACH COPY    ***
 2300 IF (KCODE)  GO TO 2340
      IF (IARG(1) .LT. -1)  GO TO 90002
      ISPACE = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 2340 IARG(1) = ISPACE
      GO TO 99999
C
C***  FORM FEED OR SPACE AFTER EACH PLOT    ***
 2400 IF (KCODE)  GO TO 2440
      IF (IARG(1) .LT. -1)  GO TO 90002
      IFFAP = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 2440 IARG(1) = IFFAP
      GO TO 99999
C
C***  NSCAN FOR PLOT    ***
C
C 2500       NOT SUPPORTED
C
C
C***  LINE ENHANCE      ***
 2600 IF (KCODE)  GO TO 2640
      INHNCE = 0
      IF (IARG(1) .NE. 0) INHNCE = -1
      IF (RDEN .NE. 400.0 .OR. INHNCE .EQ. 0) GO TO 99999
      INHNCE = 0
      GO TO 90002
C
C...  RETURN VALUE
 2640 IARG(1) = INHNCE
      GO TO 99999
C
C***  INVERSE IMAGE     ***
 2700 IF (KCODE)  GO TO 2740
      INVERS = 0
      IF (IARG(1) .NE. 0) INVERS = -1
      GO TO 99999
C
C...  RETURN VALUE
 2740 IARG(1) = INVERS
      GO TO 99999
C
C***  MIRROR IMAGE      ***
 2800 IF (KCODE)  GO TO 2840
      MIRROR = 0
      IF (IARG(1) .NE. 0) MIRROR = -1
      GO TO 99999
C
C...  RETURN VALUE
 2840 IARG(1) = MIRROR
      GO TO 99999
C
C***  RASTER DATA TRANS ***
 2900 IF (KCODE)  GO TO 2940
      IRDT = 0
      IF (IARG(1) .NE. 0) IRDT = -1
      GO TO 99999
C
C...  RETURN VALUE
 2940 IARG(1) = IRDT
      GO TO 99999
C
C***  LAST FORM FEED    ***
 3000 IF (KCODE)  GO TO 3040
      LASTFF = 0
      IF (IARG(1) .NE. 0) LASTFF = -1
      GO TO 99999
C
C...  RETURN VALUE
 3040 IARG(1) = LASTFF
      GO TO 99999
C
C***  OUTPUT MODE       ***
C
C 3100       NOT SUPPORTED
C
C
C***  PLOTTER DEVICE NUMBER  ***
 3200 IF (KCODE)  GO TO 3240
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 3)  GO TO 90002
      MUXOUT = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 3240 IARG(1) = MUXOUT
      GO TO 99999
C
C***  WIDE PLOT STRIPPING FLAG   ***
 3300 IF (KCODE)  GO TO 3340
      VSTRP = .FALSE.
      IF (IARG(1) .NE. 0) VSTRP = .TRUE.
      GO TO 99999
C
C...  RETURN VALUE
 3340 IARG(1) = 0
      IF (VSTRP) IARG(1) = -1
      GO TO 99999
C
C***  RPM MEMORY SIZE ***
 3400 IF (KCODE)  GO TO 3440
      IF (RARG(1) .LE. 0.0)  GO TO 90002
      PMSIZE = RARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 3440 RARG(1) = PMSIZE
      GO TO 99999
C
C***  INVOKE VRF OUTPUT FLAG ***
 3500 IF (KCODE)  GO TO 3540
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 2)  GO TO 90002
      MODE1 = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 3540 IARG(1) = MODE1
      GO TO 99999
C
C***  MAG TAPE OUTPUT FLAG  ***
 3600 IF (KCODE)  GO TO 3640
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 2)  GO TO 90002
      MTAPE = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 3640 IARG(1) = MTAPE
      GO TO 99999
C
C***  PARTITION FLAG  ***
 3700 IF (KCODE)  GO TO 3740
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 2)  GO TO 90002
      JSORT = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 3740 IARG(1) = JSORT
      GO TO 99999
C
C***  COPY COMMAND FLAG  ***
 3800 IF (KCODE)  GO TO 3840
      IF (IARG(1) .NE. 0 .AND. IARG(1) .NE. 1)  GO TO 90002
      JCPCMD = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 3840 IARG(1) = JCPCMD
      GO TO 99999
C
C***  BYTES/RASTER BUFFER   ***
C
C 3900       NOT SUPPORTED
C
C
C***  PAPER CUT FLAG  ***
 4000 IF (KCODE)  GO TO 4040
      IF (IARG(1) .LT. -1 .OR. IARG(1) .GT. 1)  GO TO 90002
      JCUT = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 4040 IARG(1) = JCUT
      GO TO 99999
C
C***  RPM DISK USE FLAG ***
 4100 IF (KCODE)  GO TO 4140
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. 2)  GO TO 90002
      KDISK = IARG(1)
      GO TO 99999
C
C...  RETURN VALUE
 4140 IARG(1) = KDISK
      GO TO 99999
C
C***  MODIFY RPM CONTROL ARRAY  ***
C
C...  CHECK FOR VALID INDEX RANGE
 4200 IF (IARG(1) .LT. 1 .OR. IARG(1) .GT. (IPRISM(1)-5))  GO TO 90002
      IF (KCODE)  GO TO 4240
C
C...  UPDATE CONTROL ARRAY
      IPRISM(IARG(1)+6) = IARG(2)
      GO TO 99999
C
C...  RETURN VALUE
 4240 IARG(2) = IPRISM(IARG(1)+6)
      GO TO 99999
C
C
C************************************************
C     PROCESS COLOR OPTIONS              *
C************************************************
C
C...  CHECK IF COLOR RANDOM SUPPORTED
10000 JCODE = JCODE - 100
      IF (JCODE .GT. ICMAX)  GO TO 90003
C
C...  PROCESS OPTION
      GO TO (10100,10200,10300) ,JCODE
C
C***  INITIALIZE FOR COLOR PLOTTING   ***
10100 IF (KCODE)  GO TO 10140
C
C...  INITIALIZE ALL TONER FLAGS
      DO 10101 IA = 1,4
        ITNSEQ(IA) = 0
10101 CONTINUE
C
C...  PROCESS CALL
      IF ( IARG(1) ) 10110, 10120, 10130
C
C...  SET FOR BLACK/WHITE PLOTTING
10110 NCPASS = 1
      ITNSEQ(1) = 1
      MODEL = BMODEL
      RDEN = BDEN
      IBYTES = BBYTES
      IVCFLG = 0
      INITFF = -1
      LASTFF = -1
      GO TO 180
C
C...  SET FOR DEFAULT 4 PASS COLOR
10120 NCPASS = 4
      DO 10121 IA = 1,NCPASS
        ITNSEQ(IA) = IA
10121 CONTINUE
      GO TO 10134
C
C...  SET FOR USER SPECIFIED TONING SEQUENCE
10130 IF ( IARG(1) .GT. 4)  GO TO 90002
      NCPASS = IARG(1)
C
C...  ZERO OUT TONING SEQUENCE FIRST
      DO 10131 IA = 1,4
        ITNSEQ(IA) = 0
10131 CONTINUE
      DO 10132 IA = 1,NCPASS
        ITNSEQ(IA) = IARG(IA+1)
10132 CONTINUE
C
C...  INITIALIZE FOR COLOR PLOTTER
10134 MODEL = CMODEL
      RDEN = CDEN
      IBYTES = CBYTES
      IVCFLG = -1
      INITFF = 0
      LASTFF = 0
C
C...  UPDATE PAPER/VIEWPORT/WINDOW FOR COLOR MODEL
      GO TO 180
C
C...  RETURN VALUES
10140 IARG(1) = NCPASS
      DO 10141 IA = 1,NCPASS
        IARG(IA+1) = ITNSEQ(IA)
10141 CONTINUE
      GO TO 99999
C
C***  SELECT TONE COLOR   ***
10200 IF (KCODE)  GO TO 10240
C
C...  CHECK THAT COLOR MODE IS SET
      IF (IARG(1) .NE. 0 .AND. IVCFLG .EQ. 0) GO TO 90002
      LTNFLG = 0
      IF (IARG(1) .NE. 0) LTNFLG = -1
      IF (LTNFLG .EQ. 0) GO TO 99999
C
C...  CHECK COLOR NUMBER RANGE FOR TONE COLOR
      IF (IARG(2) .LT. 1 .OR. IARG(2) .GT. ICLMAX)  GO TO 90002
      LTNCLR = IARG(2)
      GO TO 99999
C
C...  RETURN VALUES
10240 IARG(1) = LTNFLG
      IARG(2) = LTNCLR
      GO TO 99999
C
C***  SELECT PEN COLOR/WIDTH   ***
10300 ICPEN = IARG(1) + 1
      IF (KCODE)  GO TO 10340
C
C...  CHECK IF VALID PEN RANGE
      IF (IARG(1) .LT. 0 .OR. IARG(1) .GT. MXPEN)  GO TO 90002
C
C...  CHECK IF VALID PEN COLOR NUMBERS/WIDTHS
      IF (IARG(2) .LT. 1 .OR. IARG(2) .GT. 8)  GO TO 90002
      ITMP = MAXPEN
      IF (KREP .EQ. 1) ITMP = 14
      IF (IARG(3) .LT. 0 .OR. IARG(3) .GT. ITMP)  GO TO 90002
      PENTBL(ICPEN,1) = IARG(2)
      PENTBL(ICPEN,2) = IARG(3)
      GO TO 99999
C
C...  RETURN VALUES
10340 IARG(2) = PENTBL(ICPEN,1)
      IARG(3) = PENTBL(ICPEN,2)
      GO TO 99999
C
C-E
C...  RETURN ERROR CODE
C
C...  ERROR, CALLED AFTER PLOTS CALLED
90001 IER = -1
      GO TO 99999
C
C...  ILLEGAL ARGUMENTS
90002 IER = -2
      GO TO 99999
C
C...  OPTION NOT SUPPORTED
90003   IER = -3
C-E
C
99999 RETURN
C
      END
