      SUBROUTINE WBCHNK (IB,IDATA,NWRDS,IFLAG)
C
C     NAME:  WBCHNK
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C     REVISION HISTORY:
C     WBCHNK - WRITE A WORD TO VRF FILE
C
C     SUBROUTINE WBCHNK OUTPUTS A 16 OR 32 BIT (DEPENDING ON THE
C     PRECISION AND IFLAG) WORD TO BAND "IB" OF THE VRF DATA FILE.
C
C
C     ENTRY:  CALL WBCHNK (IB,IDATA,NWRDS,IFLAG)
C
C                   IB    - OUTPUT BAND
C                   IDATA - ARRAY OF WORDS TO BE OUTPUT
C                       NWRDS - NUMBER OF WORDS IN IDATA
C                   IFLAG - FLAG INDICATING 16 OR 32 BITS OUTPUT
C                           FOR 32-BIT PRECISION
C
C     EXIT:  "IDATA" OUTPUT TO THE VRF FILE
C
C     CALLS:  IRAM,GETFRE,RWAIT,RWRIT
C
C     CALLED BY:  BAND
C
C     COMMON USED:
C     /BSORT/
C            I BEGIN   - ARRAY OF POINTERS TO BEGINNING OF
C                        EACH BAND OUTPUT BUFFER
C            I BYTCNT  - COUNT OF DATA IN RECORD FOR VRF HEADER
C            I CANSTX  - VRF HEADER
C            I FREMAX  - INDEX OF END OF FREE BUFFER
C            I FRENXT  - INDEX OF BEGINNING OF FREE BUFFER
C            I MSKALL  - MASK WITH ALL BITS TURNED ON
C            I MAX     - ARRAY OF POINTERS TO END OF EACH
C                        OUTPUT BUFFER
C            I NEXTO   - ARRAY OF POINTERS TO CURRENT OUTPUT
C                        LOCATION WITHIN EACH BUFFER
C            I NXDREC  - ARRAY OF DISK RECORD INDICES WHERE EACH
C                        BAND OUTPUT BUFFER SHOULD BE WRITTEN.
C                        MAINTAINED FOR CHAINING PURPOSES.
C            I IVBUF   - ARRAY USED FOR SORT AND OUTPUT BUFFERS.
C            I PRECIS  - VRF PRECISION (16 OR 32-BIT)
C
C     LOCAL VARIABLES USED:
C
C            I  ITEMP  - TEMPORARY USED TO HOLD DATA WORD
C            I  IRTN   - FLAG INDICATING PROGRAM LOCATION
C                        REQUIRING OUTPUT OF DATA RECORD
C            I  JREC   - INDEX OF NEXT RECORD TO OUTPUT
C             I  NWRDS  - NUMBER OF WORDS TO OUTPUT
C
C
C...  COMMON /IOCOM/ - INPUT/OUTPUT VARIABLES
C
      COMMON /IOCOM/
     *    IUNIT, LUNIT, LREC, IOTYPE
C
C...  COMMON /BSORT/ -  BANDING VARIABLES
C
      INTEGER NEXTI,PRECIS,CANSTX,BYTCNT,FREMAX,FRENXT
      INTEGER BEGIN,NEXTO,MAX,NXDREC,MAXI,NCHUNK,MSKALL
      INTEGER IBUF,IVBUF
      LOGICAL EOF
C
      COMMON /BSORT/
     *    NEXTI, PRECIS, EOF, CANSTX, BYTCNT,
     *    MAXI,  NCHUNK, FREMAX, FRENXT, IWRD, NBYTS, KPTR,
     *    ISIZE, MSKALL, BEGIN(74), NEXTO(74), MAX(74),
     *    NXDREC(74), IST2, IBUF(128), IVBUF(9600)
C
C
C
C
C
      DIMENSION IDATA(1)
C
C
      IPREC = 0
      INEXT = NEXTO(IB)
      IBEGIN = BEGIN(IB)
C
C...  CHECK IF OUTPUT TWO CHUNKS
      IF ((IFLAG.EQ.0) .OR. (PRECIS.EQ.16)) IPREC = 1
C
      DO 10 I = 1,NWRDS
         ITEMP = IDATA(I)
         IF (IPREC .EQ. 1) GO TO 115
         IRTN = 1
C
C...  CHECK FOR BUFFER FULL
         IF (INEXT.GT.MAX(IB)) GO TO 1000
C
C
C...  OUTPUT UPPER 16 BITS
  100    CALL STOR16 (IVBUF(IBEGIN),INEXT-1,IRAM(ITEMP,16,MSKALL))
         INEXT = INEXT + 1
C
  115    IRTN = 2
C...  CHECK FOR BUFFER FULL
         IF (INEXT.GT.MAX(IB)) GO TO 1000
C
C...  OUTPUT LOWER 16 BITS TO BUFFER
  120    CALL STOR16 (IVBUF(IBEGIN),INEXT-1,ITEMP)
         INEXT = INEXT + 1
         GO TO 10
C
C
C...  OUTPUT THE FULL BUFFER
C     FIRST GET THE INDEX OF NEXT DATA RECORD
 1000    CALL GETFRE (JREC)
         IVBUF(IBEGIN) = JREC
C
C...  OUTPUT THE RECORD AND SWAP BUFFER POINTERS
         CALL RWAIT
         CALL RWRIT (IVBUF(IBEGIN),NXDREC(IB))
         IBEGIN = FRENXT
         FRENXT = BEGIN(IB)
         BEGIN(IB) = IBEGIN
         NXDREC(IB) = JREC
         INEXT = NCHUNK + 3
C
C...  INSERT VDS HEADER
         CALL STOR16 (IVBUF(IBEGIN),2,CANSTX)
         CALL STOR16 (IVBUF(IBEGIN),3,BYTCNT)
C
         GO TO (100,120),IRTN
  10  CONTINUE
        NEXTO(IB) = INEXT
      RETURN
      END
