      SUBROUTINE XTEXT(XZ,YZ,HGT,ITEXT,ANGLE,NZ)
C
C     NAME: XTEXT
C
C    LANGUAGE:  FORTRAN
C
C    OPERATING SYSTEM:  UNIVERSAL
C
C    ORDER NUMBER:  5428-SE
C
C    PART NUMBER:  000-026366  NOVEMBER 1985
C
C    PRODUCT:  UNIVERSAL VERSAPLOT COLOR RANDOM 2.0
C
C    VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C    A XEROX COMPANY
C
C    Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C    "NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C    INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C    LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C    PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C    REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C    THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C    VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C    AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C    THE COPYRIGHT ACT OF 1976."
C
C
C     XTEXT - COMPUTES VECTOR REPRESENTATION OF CHARACTER SET
C
C     SUBROUTINE XTEXT CONFORMS TO CONVENTIONAL PEN PLOTTER DESCRIP-
C     TIONS AND MAY BE USED TO PLOT ALPHANUMERIC ANNOTATIONS AT
C     VARIOUS AND SIZES.  SPECIAL CHARACTERS NOT INCLUDED IN THE
C     STANDARD CHARACTER SET OF THE COMPUTER MAY ALSO BE PRODUCED.
C
C     ENTRY:  CALL XTEXT(X,Y,HGT,ITEXT,ANGLE,NC)
C
C            X,Y - THE STARTING COORDINATE FOR THE LOWER LEFT-HAND
C                  CORNER OF THE FIRST CHARACTER TO BE PRODUCED.
C            HGT - IS THE CHARACTER HEIGHT SPECIFICATION (IN INCHES).
C            ITEXT - IS THE ALPHANUMERIC TEXT TO BE GENERATED.
C                   +NC - ITEXT CONTAINS THE ALPHANUMERIC TEXT STRING
C                         TO BE PLOTTED IN COMPUTER DEPENDENT INTER-
C                         NAL FORMAT(ASCII, EBCDIC, DISPLAY CODE AND
C                         SO FORTH).  THE CHARACTERS MUST BE CONTIG-
C                         UOUS IN ITEXT AND LEFT JUSTIFIED.
C                   NC=0 - ITEXT CONTAINS A SINGLE, RIGHT JUSTIFIED
C                         ALPHANUMERIC CHARACTER TO BE PLOTTED.
C                   -NC - ITEXT DEFINES THE INTEGER SYMBOL NUMBER TO
C                         BE PLOTTED.  IF ITEXT IS ONE OF THE SPECIAL
C                         CENTERED SYMBOLS (0-13) IT IS PLOTTED WITH
C                         THE X,Y REFERENCE POINT AS THE GEOMETRIC
C                         CENTER OF THE SYMBOL.
C                         ITEXT MAY BE AN ARRAY.
C            ANGLE - THE ANGLE, IN DEGREES THAT THE TEXT IS ROTATED
C                   ABOUT THE REFERENCE POINT BEFORE IT IS PLOTTED,
C                   MEASURED COUNTERCLOCKWISE FROM THE HORIZONTAL
C                   (0.0 IS HORIZONTAL, 90.0 IS VERTICAL).
C            NC    - THE NUMBER OF CHARACTERS TO BE PLOTTED
C                   FROM THE TEXT STRING ITEXT.
C
C                NC>0   ALPHA TEXT, NUMBER OF CHARACTER TO BE PLOTTED.
C                NC=0   INDICATES THAT ITEXT CONTAINS A SINGLE,
C                      RIGHT-JUSTIFIED CHARACTER TO BE PLOTTED.
C                NC=-1  SPECIFIES THAT THE 'PEN' IS TO BE UP DURING
C                      INITIAL MOVE FROM THE PRESENT PEN POSITION
C                      TO (X,Y).
C                NC<-1  SPECIFIES THAT THE 'PEN' IS TO BE DOWN
C                      DURING THE INITIAL MOVE FROM THE PRESENT
C                      POSITION TO (X,Y).
C
C          IF X OR Y =999.0; THEN SYMBOL WILL USE THE PREVIOUS VALUE(S)
C          OF X AND/OR Y
C
C     EXIT: RETURN
C
C     CALLS: AND, PLOT, COS, SIN, IRAM, MOD, AMOD
C
C     CALLED BY: SYMBOL
C
C     COMMON USED:
C
C     /MSGCOM/
C            I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C            R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C     LOCAL:
C           R   A      - USED IN ANGLE ROUND-OFF
C           RA  ACOS    - ARRAY OF COSINE VALUES FOR SPECIFIC ANGLES
C           R   ANCC    - COSINE OF ANGLE
C           R   ANCS    - SIN OF ANGLE
C           R   ANG     - ANGLE MODULO 360
C           RA  ASIN    - ARRAY OF SIN VALUES FOR SPECIFIC ANGLES
C           R   DIV     - USED TO COMPUTE SCALING FACTOR
C           R   EPSIL   - CONSTANT USED TO DETERMINE WHETHER OR NOT TO
C                       COMPUTE SIN AND COS OF ANGLE
C           R   FACC    - WORKING COPY OF FCT
C           R   FCT     - COMPUTED SCALING FACTOR RELATED TO CHARACTER
C                       HEIGHT
C           I   I       - USED IN ANGLE ROUND-OFF
C           I   IFUNCT  - USED FOR COMPUTED GO-TO WHEN ENTERING SPECIAL
C                       FUNCTION PROCESSING SECTION
C           I   INDEX   - BYTE INDEX TO NODE ARRAY
C           I   IRETURN - COMPUTED GO-TO RETURN OF INLINE SUBROUTINE
C           I   IS      - ARITHMETIC GO-TO'S DEPENDENT ON STATE
C                       IN SPECIAL FUNCTION PROCESSING
C           I   ISTAT   - STATE VARIABLE USED IN ENTERING AND EXITING
C                       SPECIAL FUNCTION MODES
C           I   K       - INDEX TO ITEXT
C           I   KBIT    - NUMBER OF BITS PER CHARACTER
C           I   KDEX    - INDEX TO KHAR ARRAY
C           IA  KHAR    - ARRAY USED TO INDEX NODE ARRAY FOR GIVEN
C                       CHARACTER.  CONTAINS ADDRESS AND LENGTH OF
C                       NODE ENTRY
C           I   KVAL   - SET TO WORD OF KHAR ARRAY FOR CHARACTER BEING
C                      PROCESSED
C           I   L      - LOOP CONTROL IN INLINE SUBROUTINE
C             I   MONE   - MASK WITH ALL BITS ON
C           I   MSKBIT - MASK USED TO AND ALL BITS OF A CHARACTER
C           I   MSK4   - MASK TO 'AND' WITH RIGHT 4 BITS USED TO GET
C                      X AND Y VALUE OF NODE
C           I   MSK5   - MASK TO 'AND' WITH RIGHT 5 BITS USED TO GET
C                      NODE COUNT
C           I   MSK8   - WORD MASK TO 'AND' WITH RIGHT 8 BITS
C           I   MSK11  - WORD MASK TO 'AND' WITH RIGHT 11 BITS; USED TO
C                      GET INDEX TO NODE
C           I   NB     - FOR LOOP CONTROL, NUMBER OF CHARACTERS PER
C                      COMPUTER WORD
C             I   NBITS  - NUMBER OF BITS IN A COMPUTER WORD
C           I   NBT    - SHIFT COUNT FOR IRAM TO GET NEXT NODE FOR NODE
C                      ARRAY
C           I   NBYTES - NUMBER OF BYTES IN COMPUTER WORD
C           I   NC     - NUMBER OF CHARACTERS TO BE PLOTTED,
C                      COMPUTATIONAL COPY OF NZ
C           I   NCC    - INDIVIDUAL CHARACTER VALUE MASKED FROM ITEXT
C           I   NCHAR  - NUMBER OF CHARACTERS PER COMPUTER WORD
C           I   NCHRS  - LENGTH OF CHARACTER SET DEFINED BY KHAR/NODE
C           I   NDKNT  - NUMBER OF NODES USED TO DEFINE A PARTICULAR
C                      CHARACTER
C                      ARRAY
C           IA  NODE   - ARRAY DEFINING SET OF NODES FOR EACH CHARACTER
C           I   NODES  - INDIVIDUAL NODE BEING ACTED ON
C           I   NODEX  - X COMPONENT OF A NODE
C           I   NODEY  - Y COMPONENT OF A NODE
C           I   NWD    - WORD INDEX OF NODE ARRAY
C           R   RADCO  - DEGREE TO RADIAN CONVERSION FACTOR
C           R   THETA  - ANGLE USED IN PREVIOUS CALL
C           R   W      - TEMPORARY USED TO CALCULATE NEW VALUES FOR YA
C                      ARRAY IN INLINE SUBROUTINE
C           R   X      - COMPUTATIONAL COPY OF XZ
C           RA  XA     - ARRAY OF OFFSET VALUES USED TO CALCULATE X
C                      VALUE FOR CALL TO PLOT
C           R   XC     - HOLDING VARIABLE FOR X VALUE
C           R   XI     - INCREMENTAL VALUE USED IN INLINE SUBROUTINE
C           R   XT     - X VALUE USED IN CALL TO PLOT
C           R   Y      - COMPUTATION COPY OF YZ
C           RA  YA     - ARRAY OF OFFSET VALUES USED TO CALCULATE Y
C                      VALUE FOR CALL TO PLOT
C           R   YC     - HOLDING VARIABLE FOR Y VALUE
C           R   YI     - INCREMENTAL VALUE USED IN INLINE SUBROUTINE
C           R   YT     - Y VALUE USED IN CALL TO PLOT
C           R   Z      - TEMPORARY USED TO CALCULATE NEW VALES FOR XA
C                      ARRAY IN INLINE SUBROUTINE
C
C        ASSUMPTIONS: COMPUTER WORD BIT SIZE DIVIDES EVENLY BY 8.
C                   'ITEXT' CONTAINS 'ASCII' INTERNAL CODES ONE PER
C                   'KBIT' BYTE AND 'NCHAR' PER COMPUTER WORD. 'KHAR'
C                   AND 'NODE' ARRAY VALUES ARE PRODUCED BY 'TABLE'
C                   PROGRAM. THE VALUE OF 'NBYTES' MUST BE
C                   EQUAL TO THE VALUE OF 'NBYTE' IN PROGRAM TABLE.
C
C        DEPENDENCY: VALUES OF 'KHAR' AND 'NODE' ARRAY ARE SET
C
C                   FOR 32 BIT/WORD COMPUTERS. THE VALUES OF 'KBIT'
C                   ,'MSKBIT','NCHAR','NCHRS', AND
C                   'NBYTES' ARE ALL COMPUTER DEPENDENT.
C
C        NOTE:       'DATA' STATEMENTS FOR 'KHAR' AND 'NODE' ARRAY ARE
C                   NOT 'ANSI' STANDARD FORTRAN .
C
C
C
C...  COMMON /MSGCOM/ - MESSAGE OUTPUT VARIABLES
C
      COMMON /MSGCOM/ INTARG(8), RELARG(12)
C
C
      DIMENSION XA(14),YA(14),KHAR(128),NODE(223)
      DIMENSION ASIN(5),ACOS(5)
      DIMENSION ITEXT(1)
C
      DIMENSION KHARA(40),KHARB(40),KHARC(48)
      DIMENSION NODEA(40),NODEB(40),NODEC(40)
      DIMENSION NODED(40),NODEE(40),NODEF(23)
      EQUIVALENCE (KHAR(1),KHARA(1)),(KHAR(41),KHARB(1))
      EQUIVALENCE (KHAR(81),KHARC(1))
      EQUIVALENCE (NODE(1),NODEA(1)),(NODE(41),NODEB(1))
      EQUIVALENCE (NODE(81),NODEC(1)),(NODE(121),NODED(1))
      EQUIVALENCE (NODE(161),NODEE(1)),(NODE(201),NODEF(1))
C
      DATA  RADCO/0.01745329/,FACC/0.0/,THETA/0.0/
      DATA  ANCC/1.0/,ANCS/0.0/,XC/0.0/,YC/0.0/,XT/0.0/
      DATA YT/0.0/
      DATA XA(1)/0./,XA(2)/0./,XA(3)/0./,XA(4)/0./,XA(5)/0./,XA(6)/0./,
     1XA(7)/0./,XA(8)/0./,XA(9)/0./,XA(10)/0./,XA(11)/0./,XA(12)/0./,
     2XA(13)/0./,XA(14)/0./
      DATA YA(1)/0./,YA(2)/0./,YA(3)/0./,YA(4)/0./,YA(5)/0./,YA(6)/0./,
     1YA(7)/0./,YA(8)/0./,YA(9)/0./,YA(10)/0./,YA(11)/0./,YA(12)/0./,
     2YA(13)/0./,YA(14)/0./
C
C-W   ***** SYSTEM DEPENDENT VARIABLES *****
      DATA NBYTES/4/,NCHAR/4/,NBITS/32/,MONE/-1/
      DATA KBIT/8/,MSKBIT/255/,NCHRS/128/
C-W   *****
C
      DATA  MSK4/15/,MSK5/31/,MSK8/255/,MSK11/2047/,EPSIL/0.0000277/
      DATA ASIN(1)/0./,ASIN(2)/1./,ASIN(3)/0./,ASIN(4)/-1./,ASIN(5)/0./
      DATA ACOS(1)/1./,ACOS(2)/0./,ACOS(3)/-1./,ACOS(4)/0./,ACOS(5)/1./
C
      DATA KHARA/        7,         267,         645,         839,
     1                  1095,        1350,        1574,        1797,
     2                  1994,        2343,        2609,        3182,
     3                  3653,        3843,        3977,        4289,
     4                  4353,        4416,        4450,        4551,
     5                  4804,        4960,        4999,        5255,
     6                  5505,        5568,        5601,        5671,
     7                  5925,        6114,        6213,        6412,
     8                  6816,        6854,        7080,        7370,
     9                  7725,        8173,        8617,        8931/
      DATA KHARB/     9059,        9187,        9322,        9668,
     1                  9829,       10017,       10084,       10241,
     2                 10312,       10597,       10792,       11084,
     3                 11491,       11625,       11946,       12292,
     4                 12463,       12970,       13322,       13675,
     5                 14050,       14148,       14306,       14413,
     6                 14863,       15369,       15691,       16071,
     7                 16326,       16551,       16806,       17036,
     8                 17447,       17703,       17957,       18151,
     9                 18402,       18500,       18659,       18795/
      DATA KHARC/    19174,       19403,       19785,       20108,
     1                 20516,       20677,       20866,       20964,
     2                 21124,       21285,       21478,       21699,
     3                 21825,       21891,       22018,       22113,
     4                 22184,       22472,       22760,       23047,
     5                 23307,       23691,       24073,       24384,
     6                 24424,       24710,       24941,       25387,
     7                 25760,       25792,       25824,       25856,
     8                 25892,       26061,       26501,       26693,
     9                 26883,       27011,       27139,       27265,
     A                 27335,       27588,       27744,       27776,
     1                 27812,       27972,       28132,       28292/
      DATA NODEA/572785664,  1078207522,   572789763,    17838145,
     1            1127490594,   572784961,   606216770,  -266067728,
     2              35791428,  -268156688,     2236964,    35668516,
     3             572661796,    37889058,   570442756,  1075978820,
     4              71565376,     2289682,   841106672,    69398560,
     5             572671216,   858865904,     1118980,  -267308560,
     6             322118178,  1123034144,  -268295612,  -268156688,
     7               2236996,    71303202,   572792866,   572784961,
     8             619709216,  1124278850,   572846371,  1197680487,
     9            -261806608,   593700197,  1448371697,   844623910/
      DATA NODEB/1727013731,  593752132,  1223698022,   293728538,
     1           -1978523343,  1112103530,  2032424037,  1716987686,
     2            1113986085,   894657396,   337982803,  1668608118,
     3            1700083495,   384846148,  -265141422,   844581209,
     4            1475360553,   959915108,  1414747990,  1713780279,
     5             858010451,  1684362806,   658004071,  -263634376,
     6             673790264,  -261545232,  1399022162,  1398945592,
     7            1230513444,   860054615,  1230591810,   859326786,
     8            1398294821,  1710236519,  -265853968,  1128743751,
     9            -265984702,  1398031427,  1394959683,  1146377027/
      DATA NODEC/577333337,   958931762,  1382246456,  1229123634,
     1            1378297913,  1500014371,   576858169,  1500014422,
     2             911631715,  1379017554,  1495557156,   590500451,
     3            1700144681,  1768446265,   673395282,  1667585574,
     4            1114138921,   676751208,  1496918055,   911631715,
     5            1379017509,   908276306,  1667782969,   673592677,
     6            1129534532,  1139820118,  1464288834,  1398031427,
     7            1408255574,  1464288872,   644096867,  -265918940,
     8            1713910339,  1379070020,  1180067688,  1496918055,
     9            1716995894,   893670501,  1733834791,   607343460/
      DATA NODED/572876272,   623393113,  1751278437,  1445353063,
     1            1750673698,  1382246489,   958931762,  1382246489,
     2             690115171,  1751722278,  1458578978,  1651058982,
     3            1458578978,  1734891833,   673395282,  1667625045,
     4            1965173232,   644280425,  1647465200,  1112141881,
     5            1495540530,  1382246697,   586163561,  -263757271,
     6             576856617,  1181311593,  1646862898,  1382246489,
     7             958931762,  -262707166,   693725287,  1445357657,
     8             958931762,  1382246640,  1147281961,  1500014422,
     9             653280866,  1750677800,   657872485,  1666331171/
      DATA NODEE/606693872,  1229072675,   844260201,   692218153,
     1             575038057,   694349858,  1765951017,  -261536215,
     2            1763861232,   911626802,   962144610,   844257593,
     3             591880981,  1965043777,  1146439241,   975855696,
     4            1094989126,  1230662178,   926171987,  1684497523,
     5             859303975,  1743804243,  1112076343,   639906643,
     6            1684428599,   925246515,  1399088727,   938481013,
     7             641086531,  1414948592,  1112076583,   607339591,
     8            1146315879,   674710883,  -266189465,  1464219431,
     9             370484276,  1162233172,  1683507255,  1180067172/
      DATA NODEF/1396913205, 1190261233,  -244244154,   712655699,
     1            1413759984,   628486214,  1448560454,  1747346672,
     2            1663263523,  -266050008,   593708835,  1379023193,
     3             844257593,  1646864441,  1212346440,  1499996980,
     4            1112107505,  -249220042,   627385191,  -265854142,
     5            1395868233,  1112094808,  1224736768/
C
C-D   DEBUG MESSAGE
C     RELARG(1)=XZ
C     RELARG(2)=YZ
C     RELARG(3)=HGT
C     INTARG(1)=ITEXT(1)
C     RELARG(4)=ANGLE
C     INTARG(2)=NZ
C     CALL MSGLG1(110)
C-D
C
      Y = YZ
      X = XZ
      NC = NZ
C
      NB = 0
      IC = 3
      DIV = 7.0
C
C...  CHECK FOR DRAW TO INITIAL POSITION
      IF (NC.LT.-1) IC = 2
C
C...  INPUT INTEGER/SYMBOL RIGHT JUSTIFIED.
  110 NVD = ITEXT(1)
C
C...  CHARACTER TEXT OUTPUT
C
      ISTAT = 1
      FCT = HGT/DIV
C
C...  NEW ANGLE IN THIS 'SYMBOL' CALL?
      IF (ANGLE.EQ.THETA) GO TO 140
C
C...  CALCULATE A NEW THETA
      FACC = FCT
      THETA = ANGLE
      ANG = AMOD(ANGLE,360.0)
      IF (ANG.LT.0) ANG = 360.0 + ANG
      I = (ANG + EPSIL)/90.0
      A = I*90.0
      IF (ABS(ANG-A).GT.EPSIL) GO TO 132
      ANCS = ASIN(I+1)
      ANCC = ACOS(I+1)
      GO TO 145
  132 ANCC = THETA*RADCO
      ANCS = SIN(ANCC)
      ANCC = COS(ANCC)
      GO TO 145
C
C...  IS CALCULATION OF NEW OFFSETS UNNECCESSARY?
  140 IF (FCT.EQ.FACC) GO TO 150
      FACC = FCT
C...  CALCULATE OFFSETS FOR NEW 'FACC' AND/OR 'ANGLE'.
C...  CALCULATE OFFSETS (INLINE SUBROUTINE)
C
C
C...  INLINE SUBROUTINE TO BUILD UP XA AND YA ARRAYS WHICH ARE USED AS
C     OFFSET VALUES IN COMPUTING THE ACTUAL VECTOR COORDINATES.  EACH
C     CHARACTER IS DEFINED IN TERMS OF A 14 X 14 GRID, AND A SERIES
C     OF VECTOR MOVES WITHIN THIS IMAGINARY GRID WILL GENERATE THE
C     CHARACTER.  EACH END-POINT OF THE GRID VECTOR IS CALLED A NODE.
C
C     THE SIZE AND POSITION OF THE GRID WITH RESPECT TO THE STARTING
C     COORDINATES FOR THE SYMBOL, IS A FUNCTION OF THE HEIGHT
C     AND ANGLE.  BY USING THE SINE AND COSINE VALUES OF THE ANGLE, THE
C     IMAGINARY GRID IS ROTATED AROUND THE STARTING COORDINATES.  BY
C     USING THE HEIGHT REQUESTED, THE GRID IS EXPANDED OR CONTRACTED.
C     THE DISPLACEMENT OF EACH GRID POINT FROM THE STARTING COORDINATE
C     IS CONTAINED IN THE ARRAYS XA AND YA.  BY INDEXING THESE ARRAYS
C     THROUGH THE X AND Y VALUES OF THE NODE, THE ACTUAL STARTING AND
C     ENDING COORDINATES OF EACH VECTOR CAN BE PROPERLY COMPUTED FOR
C     ANY ANGLE AND HEIGHT.
  145 Z = FACC*ANCC
      W = FACC*ANCS
      XI = Z
      YI = W
      DO 149 L=2,14
      XA(L) = Z
      YA(L) = W
      Z = Z+XI
  149 W = W+YI
C
C
  150 X = X-XA(3)+YA(3)
      XC = X
      Y = Y-XA(3)-YA(3)
      YC = Y
      K = 0
      NCC = NVD
C
C...  SINGLE RIGHT JUSTIFIED SYMBOL(CENTERED) OR SYMBOL/INTEGER?
      IF (NC.LE.0) GO TO 205
C
C...  ANY CHARACTERS REMAINING IN PRESENT CHARACTER TEXT WORD (NVD)?
C
C             NO, NO,YES
  180 IF (NB) 190,190,200
C
C...   EXTRACT NEXT WORD OF CHARACTER TEXT FROM ITEXT ARRAY.
  190 K = K + 1
      NVD = ITEXT(K)
C...  SET NUMBER OF (KBIT) CHARACTERS CONTAINED IN (NVD).
      NB = NCHAR
C
C
C...  POSITION NEXT CHARACTER CODE (LOW ORDER) TO BE USED AS KHAR INDEX
  200 NVD = IRAM(NVD,-KBIT,MONE)
  201 NB = NB - 1
      NCC = AND(NVD,MSKBIT)
C
C...  EXTRACT NODE COUNT (5 BITS) AND INDEX (11 BITS) INTO NODE ARRAY.
  205 KDEX = MOD(NCC,NCHRS) + 1
      KVAL = KHAR(KDEX)
      NDKNT = AND(KVAL,MSK5)
      INDEX = IRAM(KVAL,5,MSK11)
C
C...  COMPUTE WORD INDEX INTO NODE ARRAY FOR FIRST NODE.
      NWD = INDEX/NBYTES + 1
C
C..   COMPUTE BYTE INDEX(NBT= SHIFT COUNT)INTO NODE WORD FOR NODE START
      NBT = -8*MOD(INDEX,NBYTES) - 8
  210 IF(NBT+NBITS) 220,230,230
  220 NWD = NWD + 1
      NBT = -8
C
C...  EXTRACT THE NEXT NODE.
  230 NODES = IRAM(NODE(NWD),NBT,MSK8)
      NBT = NBT - 8
      NODEY = AND(NODES,MSK4)
      NODEX = IRAM(NODES,4,MSK4)
C
C...  CHECK FOR SPECIAL CONTROL FUNCTIONS. (NODEX = 15)
      IF (NODEX - 15) 240,270,270
C
C...  PROCESS MOVE TO NODE
  240 NODEX = NODEX + 1
      NODEY = NODEY + 1
      YT = Y + YA(NODEX) + XA(NODEY)
      XT = X + XA(NODEX) - YA(NODEY)
C
C
      CALL PLOT(XT,YT,IC)
      IC = 2
      X = XC
      Y = YC
C
C...  DECREMENT AND TEST NODE COUNT
  245 NDKNT = NDKNT - 1
C
C...  ANY NODES YET TO BE PROCESSED?
C
C                NO,YES,YES
      IF (NDKNT) 250,210,210
  250 X = X + XA(8)
      Y = Y + YA(8)
C
C...  DECREMENT AND TEST SYMBOL COUNT.
  260 XC = X
      YC = Y
      IC = 3
      NC = NC - 1
C
C...  ANY SYMBOLS YET TO BE PLOTTED?
C
C             NO, NO,YES
      IF (NC) 900,900,180
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C...  DECODE SPECIAL FUNCTION (Y-OFFSET)
  270 IF (NODEY .EQ. 1) GO TO 260
C
C...  BLANK CHARACTER.
  300 IC = 3
      GO TO 245
C
  900 IF (ITEXT(1).LE.13) RETURN
      X = X + XA(3) - YA(3)
      Y = Y + XA(3) + YA(3)
      CALL PLOT (X,Y,+3)
      RETURN
      END
