	SUBROUTINE CLIP(VECT,ISTAT)
C
C	NAME: CLIP
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	CLIP - CLIP VECTOR TO SPECIFIED WINDOW
C
C	CLIP IS PASSED A VECTOR AND RETURNS THE CLIPPED VECTOR AND
C	THE STATUS OF THE VECTOR IN RELATION TO THE CLIPPING WINDOW.
C
C	THE CLIPPING ALGORITHM USED IS DESCRIBED IN DETAIL IN
C	SECTION 5-1 OF "PRINCIPLES OF INTERACTIVE COMPUTER GRAPHICS",
C	2ND EDITION,NEWMAN AND SPROULL,MCGRAW HILL,1979.
C
C	ENTRY: CALL CLIP(VECT,ISTAT)
C
C		VECT()  - A REAL ARRAY OF VECTOR COORDINATES:
C		VECT(1) - X1
C		VECT(2) - Y1
C		VECT(3) - X2
C		VECT(4) - Y2
C		ISTAT  - CLIPPING STATUS RETURN
C
C	EXIT:
C		ISTAT CONTAINS THE CLIPPING STATUS OF THE VECTOR.
C		IF ISTAT .EQ. 4 THEN
C			VECT WAS COMPLETELY OUTSIDE THE CLIPPING LIMITS
C			VECT REMAINS UNCHANGED
C		ELSE IF ISTAT .EQ. 0 THEN
C			VECT WAS COMPLETELY INSIDE THE CLIPPING LIMITS
C			VECT REMAINS UNCHANGED
C		ELSE IF ISTAT .EQ. 1 THEN
C			X1,Y1 LAY OUTSIDE THE CLIPPING LIMITS
C			VECT CONTAINS THE CLIPPED VECTOR
C		ELSE IF ISTAT .EQ. 2 THEN
C			X2,Y2 LAY OUTSIDE THE CLIPPING LIMITS
C			VECT CONTAINS THE CLIPPED VECTOR
C		ELSE IF ISTAT .EQ. 3 THEN
C			BOTH ENDPOINTS LAY OUTSIDE THE CLIPPING LIMITS
C			VECT CONTAINS THE CLIPPED VECTOR
C
C	CALLS: OCODE,IAND,IOR
C
C	  CALLED BY: PLOT
C
C	COMMON USED:
C	/DVCOM/
C		R WIN()   - THE CURRENT VIEW WINDOW IN COMPUTATIONAL
C		            COORDINATES
C	/VRFCOM/
C		I IOCODE()- THE OUTCODES FOR THE STARTING AND
C		            ENDING POINTS OF A VECTOR
C
C	LOCAL:
C		I IC - OUT CODE OF THE VECTOR ENDPOINT BEING PROCESSED
C		R X  - X INTERSECTION OF THE VECTOR WITH WINDOW EDGE
C		R X1 - X ORDINATE OF THE FIRST VECTOR ENDPOINT
C		R X2 - X ORDINATE OF THE SECOND VECTOR ENDPOINT
C		R Y  - Y INTERSECTION OF THE VECTOR WITH WINDOW EDGE
C		R Y1 - Y ORDINATE OF THE FIRST VECTOR ENDPOINT
C		R Y2 - Y ORDINATE OF THE SECOND VECTOR ENDPOINT
C
C
C
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'VRFCOM.CMN'
C
C
	DIMENSION VECT(1)
C
C
C...	STORE WORKING VECTOR
	X1 = VECT(1)
	Y1 = VECT(2)
	X2 = VECT(3)
	Y2 = VECT(4)
C
	ISTAT = 0
C
C...	REPEAT UNTIL WORKING VECTOR IS COMPLETELY INSIDE WINDOW
C	AN OUT CODE OF 0 MEANS THAT A POINT IS INSIDE THE CLIPPING
C	WINDOW WHEN BOTH ENDPOINTS OF A VECTOR LIE INSIDE THE WINDOW,
C	THE ENTIRE VECTOR LIES INSIDE THE WINDOW.
  100	IF (IOCODE(1).EQ.0 .AND. IOCODE(2).EQ.0) GO TO 990
C
C...	   IS WORKING VECTOR COMPLETELY OUTSIDE WINDOW?
	   IF (IAND(IOCODE(1),IOCODE(2)) .EQ. 0) GO TO 110
C
C...	      YES. SET STATUS AND RETURN
C	      IF THE VECTOR IS COMPLETELY OUTSIDE THE WINDOW, INDICATE
C	      THIS BY SETTING THE STATUS FLAG.  THE VECTOR RETURNED
C	      IS THE VECTOR PASSED.
	      ISTAT = 4
	      GO TO 999
C
C...	   SET UP TO CLIP THE 1ST VECTOR ENDPOINT
  110	IC = IOCODE(1)
C
C...	   IF THE 1ST ENDPOINT LIES INSIDE THE CLIPPING WINDOW, CLIP THE
C...	   2ND ENDPOINT
	   IF (IC .EQ. 0) IC = IOCODE(2)
C
C
C...	   FIND INTERSECTION WITH CLIPPING EDGE
C	   THE INTERSECTION EQUATIONS ARE DERIVED FROM THE TWO POINT
C	   EQUATION FOR A LINE:
C	      Y-Y1 = (X-X1) * (Y2-Y1)/(X2-X1)
C
	   IF (IAND(IC,1) .EQ.0) GO TO 120
C
C...	      VECTOR CROSSES LEFT WINDOW EDGE. CLIP
C	      THE Y INTERSECTION EQUATION BELOW IS DERIVED BY SOLVING
C	      THE TWO POINT EQUATION FOR A LINE FOR X=WIN(XMIN).
	      Y = Y1 + (WIN(1)-X1)*(Y2-Y1)/(X2-X1)
	      X = WIN(1)
	      GO TO 200
C
  120	IF (IAND(IC,2) .EQ.0) GO TO 130
C
C...	      VECTOR CROSSES RIGHT WINDOW EDGE. CLIP
C	      THE Y INTERSECTION EQUATION BELOW IS DERIVED BY SOLVING
C	      THE TWO POINT EQUATION FOR A LINE FOR X=WIN(XMAX)
	      Y = Y1 + (WIN(3)-X1)*(Y2-Y1)/(X2-X1)
	      X = WIN(3)
	      GO TO 200
C
  130	IF (IAND(IC,4) .EQ.0) GO TO 140
C
C...	      VECTOR CROSSES BOTTOM WINDOW EDGE. CLIP
C	      THE X INTERSECTION EQUATION BELOW IS DERIVED BY SOLVING
C	      THE TWO POINT EQUATION FOR A LINE FOR Y=WIN(YMIN)
	      X = X1 + (WIN(2)-Y1)*(X2-X1)/(Y2-Y1)
	      Y = WIN(2)
	      GO TO 200
C
  140	IF (IAND(IC,8) .NE.0) GO TO 145
C-E
C...	      THIS ERROR SHOULD NEVER HAPPEN IN NORMAL OPERATION.
C	      INVALID OUT CODE WAS PASSED.
	   CALL MSGLG1(6)
	   STOP
C-E
C
C...	      VECTOR CROSSES TOP WINDOW EDGE. CLIP
C	      THE X INTERSECTION EQUATION BELOW IS DERIVED BY SOLVING
C	      THE TWO POINT EQUATION FOR A LINE FOR Y=WIN(YMAX)
  145	X = X1 + (WIN(4)-Y1)*(X2-X1)/(Y2-Y1)
	      Y = WIN(4)
C
C
C...	   DETERMINE WHICH ENDPOINT WAS CLIPPED
C	   THE OUT CODE OF THE CURRENT POINT IS COMPARED WITH THE OUT
C	   CODE FOR THE FIRST ENDPOINT TO DETERMINE WHICH ENDPOINT HAS
C	   BEEN CLIPPED.  IF THE TWO CODES ARE EQUAL THE 1ST ENDPOINT
C	   WAS CLIPPED.  IF THEY AREN'T EQUAL, THEN THE 1ST ENDPOINT IS
C	   INSIDE THE CLIPPING WINDOW AND IOCODE(1)=0.  IN THIS CASE
C	THE 2ND END- POINT MUST HAVE BEEN CLIPPED.
  200	IF (IC .NE. IOCODE(1)) GO TO 210
C
C...	      X1,Y1 WAS CLIPPED
	      X1 = X
	      Y1 = Y
C
C...	      COMPUTE OUT CODE FOR CLIPPED ENDPOINT AND INDICATE THAT
C	      THE 1ST ENDPOINT HAS BEEN CLIPPED IN THE STATUS RETURN
	      CALL OCODE(X1,Y1,IOCODE(1))
	      ISTAT = IOR(ISTAT,1)
C
C...	CONTINUE REPEAT LOOP
	GO TO 100
C
C...	      X2,Y2 WAS CLIPPED
  210	X2 = X
	      Y2 = Y
C
C...	      COMPUTE OUT CODE FOR CLIPPED ENDPOINT AND INDICATE THAT
C	      THE 2ND ENDPOINT HAS BEEN CLIPPED IN THE STATUS RETURN
	      CALL OCODE(X2,Y2,IOCODE(2))
	      ISTAT = IOR(ISTAT,2)
C
C...	CONTINUE REPEAT LOOP
	GO TO 100
C
C
C...	RETURN THE CLIPPED VECTOR
  990	VECT(1) = X1
	VECT(2) = Y1
	VECT(3) = X2
	VECT(4) = Y2
C
  999	RETURN
	END
