	SUBROUTINE CWTV
C
C	NAME: CWTV
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	CWTV - CALCULATE WINDOW TRANSFORMATION VARIABLES
C
C	CWTV IS CALLED BY VPORT, WINDOW, AND FACTOR TO RECALCULATE THE
C	WINDOW TRANFORMATION WHENEVER THE WINDOW OR VIEWPORT IS CHANGED.
C	CWTV ALSO UPDATES COMMON VARIABLES XDOTS AND YDOTS.
C
C
C	THE WINDOW TO VIEWPORT TRANSFORMATION USED IS DESCRIBED IN
C	SECTION 5-6 OF "PRINCIPALS OF INTERACTIVE COMPUTER GRAPHICS",
C	MCGRAW HILL, 1979, BY NEWMAN AND SPROULL.
C
C	GIVEN A VIRTUAL PLOTTING WINDOW DESCRIBED BY WXMIN,WYMIN,WXMAX,
C	WYMAX, AND A VIEWPORT DESCRIBED BY VXMIN,VYMIN,VXMAX,VYMAX,
C	WHICH SPECIFIES IN DEVICE COORDINATES THE AREA ON THE PLOTTER
C	TO WHICH THE WINDOW WILL BE MAPPED, POINT (X,Y) IN THE WINDOW
C	COORDINATE SYSTEM MAPS TO POINT (IX',IY') IN THE DEVICE
C	COORDINATE SYSTEM ACCORDING TO THE FOLLOWING EQUATION:
C
C	  IX'=((VXMAX-VXMIN)/(WXMAX-WXMIN)*(X-WXMIN)+VXMIN)*XDEN + 0.5
C	  IY'=((VYMAX-VYMIN)/(WYMAX-WYMIN)*(Y-WYMIN)+VYMIN)*YDEN + 0.5
C
C	  THESE EQUATIONS CAN BE SIMPLIFIED TO THE FORM:
C
C	    IX' = A*X + B
C	    IY' = C*Y + D
C
C	  THE VARIABLES A,B,C,D CORRESPOND TO WTV(1),WTV(2),WTV(3),
C	  WTV(4) AND ARE USED IN SUBROUTINES PLOT AND TONE.
C
C	ENTRY:  CALL CWTV
C
C	EXIT:  COMMON VARIABLES WTV(),XDOTS, AND YDOTS HAVE
C	       BEEN RECALCULATED
C
C	CALLS: NONE
C
C	CALLED BY: VPORT,WINDOW
C
C	COMMON USED:
C	/DVCOM/
C		I ANC     - HOLD PREVIOUS SYMBOL CALL ANGLE VALUE
C		I HTC     - HOLD PREVIOUS SYMBOL CALL HEIGHT VALUE
C		I ICWTV   - SUBROUTINE CWTV FIRST CALL FLAG
C		R WTV()   - WINDOW TRANSFORMATION VARIABLES. USED TO
C		            TRANSFORM COORDINATES FROM THE VIEW WINDOW
C		            SYSTEM TO THE  VIEWPORT SYSTEM
C		R XDEN    - NUMBER OF NIBS PER VIEWPORT UNIT IN THE X
C		            DIRECTION
C		R YDEN    - THE NUMBER OF NIBS PER VIEWPORT UNIT IN
C		            THE Y DIRECTION.
C
C	LOCAL:  NONE
C
C
C
	INCLUDE 'DVCOM.CMN'
C
C
C...	RETURN ON FIRST CALL TO AVOID A DIVIDE BY 0.
	IF (ICWTV .NE. 0) GO TO 10
	   ICWTV = -1
	   GO TO 999
C
C...	COMPUTE WINDOW TRANSFORMATION VARIABLES
   10	WTV(1)=XDEN*((VP(3)-VP(1))/(WIN(3)-WIN(1)))
	WTV(2)=XDEN*VP(1) - WTV(1)*WIN(1) + .5
	WTV(3)=YDEN*((VP(4)-VP(2))/(WIN(4)-WIN(2)))
	WTV(4)=YDEN*VP(2) - WTV(3)*WIN(2) + .5
C
C...	RESET PREVIOUS ANGLE/HEIGHT
	ANC = 0.0
	HTC = 0.0
C
C
  999	RETURN
	END
