	SUBROUTINE DEFPEN (IPEN,JWIDTH,NBON1,NBOFF1,NBON2,NBOFF2)
C
C	NAME:  DEFPEN
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY
C		REV. C
C		2/21/85		PEN DEFINITIONS ARE NO LONGER OUTPUT
C				TO THE VRF FILE.  INSTEAD, WE SAVE
C				THE PEN PATTERN DEFINITION AND (LET
C				SUBROUTINE PLOT) STROKE	OUT EACH DASH.
C				INSTEAD OF OUTPUTTING THE WIDTH AS PART
C				OF A PEN DEFINITION, WE OUTPUT A SET-PEN
C				COMMAND THAT CORRESPONDS TO THE WIDTH
C				OF THE PEN.
C
C
C	DEFPEN - DEFINE A PEN
C
C	SUBROUTINE DEFPEN IS USED TO DEFINE THE ATTRIBUTES OF PENS
C	0-7.  THE CALL ALLOWS THE USER TO SPECIFY THE LINE
C	THICKNESS (IN NIBS) AND THE DASH PATTERN DEFINED AS THE NUMBER
C	OF NIBS ON, OFF, ON, AND OFF FOR A PARTICULAR PEN.
C
C	CALL SUBROUTINE NEWPEN TO SELECT THE DEFINED PEN.
C
C	ENTRY:  CALL DEFPEN(IPEN,JWIDTH,NBON1,NBOFF1,NBON2,NBOFF2)
C
C		IPEN	- PEN NUMBER BEING DEFINED
C			<= 0 = PEN #0
C			>= 7 = PEN #7
C		JWIDTH	- PEN WIDTH IN NIBS
C			0 <= JWIDTH <= MAXPEN
C		NBON1	- DASH PATTERN, NUMBER OF NIBS ON
C		NBOFF1	- DASH PATTERN, NUMBER OF NIBS OFF
C		NBON2	- DASH PATTERN, NUMBER OF NIBS ON
C		NBOFF2	- DASH PATTERN, NUMBER OF NIBS OFF
C
C	NOTES:
C		PENS MAY ONLY BE DEFINED ONCE.  CALL IS IGNORED IF
C		PEN IS ALREADY DEFINED.
C
C		IF PEN "IPEN" IS USED WITHOUT BEING DEFINED, WHERE
C		0 <= "IPEN" <= 7, A SOLID LINE "IPEN" NIBS
C		THICK WILL BE DRAWN.  PEN NUMBERS GREATER THAN 7
C		WILL BE IGNORED AND SET TO 7, PENS LESS THAN ZERO
C		WILL BE IGNORED AND SET TO ZERO.
C
C		PEN WIDTHS FROM 0 TO MAXPEN NIBS WIDE ARE ALLOWED.
C		'JWIDTH' LESS THAN ZERO WILL BE SET TO ZERO, 'JWIDTH'
C		GREATER THAN MAXPEN WILL BE SET TO MAXPEN.
C
C		IF 'NBON1,NBOFF1,NBON2,NBOFF2' ARE ALL ZERO, THE LINE IS
C		SOLID.  OTHERWISE THE DASH PATTERN IS DEFINED AS THE
C		NUMBER OF NIBS ON, OFF, ON, AND OFF.
C
C		AN END-OF-PLOT CALL (-999,+-23) WILL RESET ALL PEN
C		ATTRIBUTES FOR ALL PENS (0-7).
C
C	EXIT:  RETURN
C
C	CALLS:  MSGLG1,OCHUNK
C
C	CALLED BY:  USER
C
C	COMMON USED:
C	/DVCOM/
C		L DASHPN  - .TRUE. IFF THE CURRENT PEN IS DEFINED AS
C		            AN ON-OFF-ON-OFF PATTERN
C		I ILWP    - (LINE WIDTH - 1)/2
C		I ILWM    - LINE WIDTH/2
C		L IPDEF() - .TRUE. IF PEN HAS BEEN DEFINED
C		I JPEN    - THE CURRENT PEN NUMBER
C		I KWIDTH  - WIDTH OF CURRENT PEN
C		I PENPAT()- ARRAY TO STORE PEN DEFINITIONS
C		I PWIDTH()- ARRAY WITH WIDTH OF EACH PEN
C
C	/PRMCOM/
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C		I MAXPEN  - MAXIMUM ALLOWABLE PEN WIDTH
C		I MXPEN   - MAXIMUM PEN NUMBER TO BE ACTIVATED BY USER
C	/VRFCOM/
C		R DRWKNT  - BYTE COUNT FOR A DRAW COMMAND
C		R DRWMAX  - BYTE COUNT FOR A DRAW COMMAND WITH A PEN
C			    OF WIDTH GREATER THAN 1
C		R DRWMIN  - BYTE COUNT FOR A DRAW COMMAND WITH A PEN
C			    OF WIDTH AT MOST 1
C		I PRECIS  - COORDINATE PRECISION FOR THE VRF
C		            OUTPUT FILE (16 OR 32-BIT PRECISION)
C
C	/MSGCOM/
C		I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C       /CLRCOM/
C		I CURPEN()- ARRAY CONTAINING CURRENT PEN NUMBER
C		            FOR EACH TONER
C		I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C		I NCPASS  - NUMBER OF COLOR PASSES
C
C	LOCAL VARIABLES:
C		ICMD    - SET-PEN COMMAND WORD
C		IIPEN   - PEN NUMBER BEING DEFINED
C		IIPEN1  - IIPEN + 1
C		IWIDTH  - THE NEW PEN WIDTH
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
	INCLUDE 'VRFCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
	INCLUDE 'CLRCOM.CMN'
C
C
C...	SET-PEN COMMAND WORD (X'8301')
	DATA ICMD/33537/
C
C-D  DEBUG MESSAGE
C	INTARG(1)=IPEN
C	INTARG(2)=JWIDTH
C	INTARG(3)=NBON1
C	INTARG(4)=NBOFF1
C	INTARG(5)=NBON2
C	INTARG(6)=NBOFF2
C	CALL MSGLG1(21)
C-D
C
C
C
	IIPEN = IPEN
C
C...	CHECK FOR ILLEGAL DASH PATTERN ARGUMENTS
	IF (NBON1 .LT. 0)  GO TO 900
	IF (NBON2 .LT. 0)  GO TO 900
	IF (NBOFF1 .LT. 0)  GO TO 900
	IF (NBOFF2 .LT. 0)  GO TO 900
C
C...	CHECK FOR VALID PEN NUMBERS
	IF (IIPEN .LT. 0)  IIPEN = 0
	IF (IIPEN .GT. MXPEN)  IIPEN = MXPEN
C
C...	INITIALIZE IIPEN1 FOR INDEXING INTO ARRAYS
	IIPEN1 = IIPEN + 1
C
C...	CHECK FOR VALID PEN WIDTHS
	IWIDTH = JWIDTH
	IF (IWIDTH .LT. 0)  IWIDTH = 0
	IF (IWIDTH .GT. MAXPEN)  IWIDTH = MAXPEN
C
C...	CHECK IF PEN ALREADY DEFINED
	IF (.NOT. IPDEF(IIPEN1))  GO TO 10
C
C...	  PEN ALREADY DEFINED IGNORE CALL
	  INTARG(1)=IIPEN
	  CALL MSGLG1(22)
	  RETURN
C
C...	CHECK IF THE PEN BEING DEFINED IS THE CURRENT PEN
C	AND IF THE NEW WIDTH IS DIFFERENT FROM THE OLD WIDTH
   10	IF (IIPEN .NE. JPEN) GO TO 20
C
C...	    THIS DEFPEN CALL IS REDEFINING THE CURRENT PEN
	    IF ((NBOFF1+NBOFF2) .NE. 0) DASHPN = .TRUE.
C
C...	    CHECK IF THE NEW WIDTH IS DIFFERENT FROM THE OLD WIDTH
	    IF (IWIDTH .EQ. KWIDTH) GO TO 20
C
C...	    THIS DEFPEN CALL IS REDEFINING THE WIDTH OF THE CURRENT PEN
C	    WE MUST OUTPUT THE NEW WIDTH TO THE CONTROLLER
	    CALL OCHUNK(ICMD,0)
	    CALL OCHUNK(IWIDTH,0)
C
C...	    SAVE CURRENT PEN WIDTH FOR THE ACTIVE TONERS
	    DO 15 I=1,NCPASS
		IF (ITNSEQ(I) .LT. 0) CURPEN(-ITNSEQ(I)) = IWIDTH
   15	    CONTINUE
C
C...	    SET WIDTH VARIABLES
	    KWIDTH = IWIDTH
	    ILWP = (KWIDTH-1)/2
	    ILWM = KWIDTH/2
C
C...	    SET UP BYTES-PER-DRAW
	    DRWKNT = DRWMIN
	    IF (KWIDTH .EQ. 0) DRWKNT = 0.0
	    IF (KWIDTH .GT. 1) DRWKNT = DRWMAX
C
C...	SAVE PEN DEFINITION
   20	IPDEF(IIPEN1) = .TRUE.
	PWIDTH(IIPEN1) = IWIDTH
	PENPAT(1,IIPEN1) = NBON1
	PENPAT(2,IIPEN1) = NBOFF1
	PENPAT(3,IIPEN1) = NBON2
	PENPAT(4,IIPEN1) = NBOFF2
C
	RETURN
C
C
C...	OUTPUT ILLEGAL PATTERN MESSAGE AND RETURN
  900	INTARG(1)=IPEN
	INTARG(2)=JWIDTH
	INTARG(3)=NBON1
	INTARG(4)=NBOFF1
	INTARG(5)=NBON2
	INTARG(6)=NBOFF2
	CALL MSGLG1(21)
	CALL MSGLG1(24)
	RETURN
	END
