	SUBROUTINE ELLIPS(XC,YC,ANGLE,MAJOR,MINOR)
C
C	NAME:  ELLIPS
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	ELLIPS DRAWS AN ELLIPSE GIVEN THE CENTER POINT OF THE ELLIPSE,
C	THE ANGLE BETWEEN THE X-AXIS AND THE MAJOR AXIS, AND THE LENGTH
C	OF THE SEMI-MAJOR AND SEMI-MINOR AXIS
C
C	ENTRY: CALL ELLIPS(XC,YC,ANGLE,MAJOR,MINOR)
C
C		     ALL ARGUMENTS ARE REAL
C		     XC,YC     - COORDINATES OF ELLIPSE CENTER
C		     ANGLE     - ANGLE OF ELLIPSE IN DEGREES (TILT)
C		     MAJOR     - LENGTH ALONG SEMI-MAJOR AXIS
C		     MINOR     - LENGTH ALONG SEMI-MINOR AXIS
C
C	EXIT:  RETURNS WITH CURRENT POSITION AT CENTER OF ELLIPSE
C
C	CALLS:
C	     COS, SIN, AMAX1, PLOT
C
C	CALLED BY:  USER
C
C
C	COMMON USED:
C	/DVCOM/
C		I RADN    - DEGREES TO RADIAN ANGLE CONVERSION FACTOR
C
C	/MSGCOM/
C		R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C	LOCAL VARIABLES USED:
C
C	     C1     - COSINE OF THE INCLINATION ANGLE
C	     C2     - COSINE OF THE INCREMENT ANGLE
C	     NPTS   - INTEGER EQUIVALENT TO POINTS
C	     C3     - COSINE ACCUMULATOR
C	     POINTS - NUMBER OF POINTS ON ELLIPSE
C	     RINCL  - INCLINATION ANGLE, IN RADIANS
C	     RINCR  - INCREMENT FOR EACH POINT, IN RADIANS
C	     S1     - SINE OF THE INCLINATION ANGLE
C	     S2     - SINE OF THE INCREMENT ANGLE
C	     S3     - SINE ACCUMULATOR
C	     T1     - DOUBLE ANGLE FOR COSINE
C	     X,Y    - POINT ALONG EDGE OF ELLIPSE
C	     X1,Y1  - INCREMENTS IN X AND Y
C	     XC,YC  - COORDINATES OF ELIPSE CENTER
C
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C	CHANGE POINTS TO CHANGE THE NUMBER OF POINTS USED TO DRAW
C	THE ELLIPSE.
C
	REAL MAJOR,MINOR
C
C-D  DEBUG MESSAGE
C	 RELARG(1)=XC
C	 RELARG(2)=YC
C	 RELARG(3)=ANGLE
C	 RELARG(4)=MAJOR
C	 RELARG(5)=MINOR
C	 CALL MSGLG1(25)
C-D
C
C
C
C
C  IF THE LENGTH OF THE MAJOR OR MINOR AXIS OF THE ELLIPSE
C  IS SET TO ZERO, THEN RETURN TO THE CALLING ROUTINE.
C
	IF( MAJOR .LE. 0.0  .OR.  MINOR .LE. 0.0 )  GOTO 9999
C
C  SET THE NUMBER OF POINTS ON THE ELLIPSE TO BE CALCULATED.
C
	POINTS = 120.0
C
C  IF THE LENGTH OF THE MAJOR AXIS IS LESS THAN 30 NIBS
C  IN LENGTH, THEN SET THE NUMBER OF POINTS PER ELLIPSE
C  TO THE NUMBER OF NIBS IN THE LENGTH OF THE MAJOR AXIS.
C
C  IF THE NUMBER OF POINTS IS ZERO, SET NPTS TO 1 SO
C  THAT A DOT WILL BE PLOTTED FOR THE ELLIPSE.
C
	 IF( MAJOR .LE. 30.0/XDEN )
     *  POINTS = AMAX1( ( MAJOR * XDEN + 0.5 ), 2.0 )
C
C  INTEGERIZE THE NUMBER OF POINTS.
C
	NPTS = INT( POINTS )
C
C  CALCULATE THE INCREMENT ANGLE, IN RADIANS.
C
	RINCR = RADN * 360.0 / ( POINTS - 1 )
C
C  CONVERT THE INCLINATION ANGLE TO RADIANS.
C
	RINCL = ANGLE * RADN
C
C  CALCULATE THE COSINE AND SINE OF THE INCLINATION ANGLE.
C
	C1 = COS( RINCL )
	S1 = SIN( RINCL )
C
C  CALCULATE THE COSINE AND SINE OF THE INCREMENT ANGLE.
C
	C2 = COS( RINCR )
	S2 = SIN( RINCR )
C
C  INITIALIZE THE ACCUMULATION VARIABLES.
C
	C3 = 1.0
	S3 = 0.0
C
C  CALCULATE AND MOVE TO FIRST POSITION ON ELLIPSE.
C
	X = XC + ( MAJOR * C3 * C1 ) - ( MINOR * S3 * S1 )
	Y = YC + ( MAJOR * C3 * S1 ) + ( MINOR * S3 * C1 )
	CALL PLOT ( X, Y, 3 )
C
C  CALCULATE AND DRAW TO EACH POSITION ON ELLIPSE.
C
	DO 100 IA=1,NPTS,1
C
C	  CALCULATE INCREMENTS IN X AND Y.
C
	  X1 = MAJOR * C3
	  Y1 = MINOR * S3
C
C	  CALCULATE NEW X AND Y.
C
	  X = XC + ( X1 * C1 ) - ( Y1 * S1 )
	  Y = YC + ( X1 * S1 ) + ( Y1 * C1 )
C
C	  CALCULATE NEW ANGLE FORMULAS.
C
	  T1 = ( C3 * C2 ) - ( S3 * S2 )
	  S3 = ( S3 * C2 ) + ( C3 * S2 )
	  C3 = T1
C
C	  DRAW TO NEW POINT ON ELLIPSE.
C
	  CALL PLOT ( X, Y, 2 )
  100	CONTINUE
C
C  MOVE BACK TO CENTER
C
	CALL PLOT ( XC, YC, 3 )
C
 9999	CONTINUE
	RETURN
	END
