	SUBROUTINE GETFRE (IREC)
C
C	NAME:  GETFRE
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY
C	REV. C		8/30/85		VARIABLES VSTACK, MAXVS, AND
C					VSUSED ARE USED TO DETERMINE AN
C					OPTIMUM STACK SIZE.
C					LOST RECORDS THAT COULD HAVE
C					BEEN USED ARE COUNTED.
C	GETFRE - GET A FREE DISK RECORD
C
C	SUBROUTINE GETFRE IS USED BY THE BAND ROUTINE TO
C	HANDLE ALLOCATION OF DISK RECORDS FOR THE SORTED
C	OUTPUT DATA.
C
C	GETFRE AND SETFRE MAINTAIN A STACK OF FREE DISK-RECORD
C	NUMBERS FOR ALLOCATION PURPOSES. IF THE STACK IS EMPTY,
C	GETFRE EXTENDS THE SIZE OF THE FILE.
C
C	ENTRY:  CALL GETFRE (IREC)
C
C	EXIT:  IREC = INDEX OF A FREE DISK RECORD
C
C	CALLS:  NONE
C
C	CALLED BY: WCHUNK,BAND
C
C	COMMON USED:
C	/STKCOM/
C		I NEXTFR  - INDEX TO DISK RECORD IF FILE MUST BE
C			    EXTENDED
C		I NLOSTA  - NUMBER OF RECORDS LOST THAT WOULD NOT
C			    HAVE BEEN REUSED
C		I NLOSTB  - NUMBER OF RECORDS LOST THAT WOULD HAVE
C			    BEEN REUSED
C		I STKPTR  - STACK POINTER
C		I VSTACK  - VIRTUAL STACK SIZE IF WE WERE USING
C			    AN UNLIMITED STACK
C		I MAXVS   - MAX. SIZE OF VSTACK
C		I VSUSED  - MAX. NUMBER OF STACK ENTRIES THAT WOULD
C			    HAVE BEEN USED ASSUMING AN UNLIMITED STACK
C
C	LOCAL:
C		NONE
C
C
	INCLUDE 'STACK.CMN'
C
C
C
C...	UPDATE VIRTUAL STACK
	IF (VSTACK .GT. 0) VSTACK = VSTACK - 1
	IF ((MAXVS - VSTACK) .GT. VSUSED) VSUSED = MAXVS - VSTACK
C
C...	CHECK FOR STACK EMPTY
	IF (STKPTR.EQ.0) GO TO 100
	IREC = STACK(STKPTR)
	STKPTR = STKPTR - 1
	RETURN
C
C...	STACK EMPTY,MUST EXTEND THE FILE
  100	IREC = NEXTFR
	NEXTFR = NEXTFR + 1
C
C...	CHECK IF A LOST RECORD COULD HAVE BEEN USED
	IF (NLOSTA .EQ. 0)  GO TO 200
	  NLOSTB = NLOSTB + 1
	  NLOSTA = NLOSTA - 1
C
  200	RETURN
	END
