	SUBROUTINE MSGLG1 ( MSGNO )
C
C	NAME: MSGLG1
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C
C	RIVISION HISTORY
C		REV. C	 8/22/85		ADDED MESSAGE NO. 18
C
C	MSGLG1 - FORMAT AND WRITE MESSAGES FOR PHASE I
C
C	SUBROUTINE MSGLG1 IS CALLED TO WRITE OUT THE ERROR, DEBUG AND
C	INFORMATIVE MESSAGES FOR PHASE I. THE WRITE ARGUMENTS ARE PASSED
C	TO MSGLG1 THROUGH COMMON ARRAYS, INTARG AND RELARG.
C
C	ENTRY:  CALL MSGLG1(MSGNO)
C
C	       MSGNO - THE MESSAGE NUMBER TO WRITE
C
C	EXIT:  RETURN
C
C	CALLS:  NONE
C
C	CALLED BY:  AUTHOR,AXIS,CARC,CIRCLE,CLIP,CONVEX,CURVE,CUT,
C		    DASHLN,DEFCLR,DEFPAT,DEFPEN,ELLIPS,FACTOR,GRID,LINE,
C		    NEWPEN,NUMBER,OFFSET,PENCLR,PLOT,PLOTS,SCALE,SETPAT,
C		    SYMBOL,TONCLR,TONE,TONFLG,VPORT,WHERE,WINDOW,XTEXT
C
C	COMMON USED:
C	/IOCOM/
C		I LUNIT   - LOGICAL UNIT NUMBER OF LISTING DEVICE
C
C	/MSGCOM/
C		I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C		R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C	LOCAL VARIABLES:
C
C	  I    I - WORKING VARIABLE FOR INDEXING IN WRITE STATEMENTS
C
C
C
C
	INCLUDE 'IOCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C
C	  FORMAT STATEMENTS
C
 100	FORMAT (4X,'MSGLG1 - ILLEGAL MESSAGE NUMBER',/)
C
 101	FORMAT (4X,'AUTHOR - ILLEGAL CHARACTER COUNT, NC=',I6)
C
 102	FORMAT(4X,'AXIS   - (',2(F8.2,2X),I10,2X,I6,2X,4(F8.2,2X),')',/)
C
 103	FORMAT (4X,'CARC   - (',5(F10.2),')',/)
C
 104	FORMAT (4X,'CIRCLE - (',3F10.2,I6,')',/)
C
 105	FORMAT (4X,'CIRCLE - UNPLOTTABLE CIRCLE, X,Y=',2F10.2,/)
C
 106	FORMAT (4X,'CLIP   - INTERNAL ERROR',/)
C
 107	FORMAT (4X,'CONVEX - (',2F10.2,I6,')',/)
C
 108	FORMAT (4X,'CONVEX - ',
     &       'ILLEGAL NUMBER OF X,Y ELEMENTS = ',I8,/)
C
 109	FORMAT (4X,'CURVE  - (',2(F8.2,2X),I6,2X,F8.2,')',/)
C
 110	FORMAT (4X,'DASHLN - (',2F10.2,I6,2F10.2,')',/)
C
 111	FORMAT (4X,'DASHLN - ',
     &       'ILLEGAL NPTS/ONLTH/OFFLTH VALUES:','(',I6,2(F10.2),')',/)
C
 112	FORMAT(4X,'DEFCLR - COLOR MODE HAS NOT BEEN SET, CALL IGNORED.')
C
 113	FORMAT (4X,'DEFCLR - INVALID COLOR NUMBER, CALL IGNORED.')
C
 114	FORMAT (4X,'DEFCLR - INVALID PATTERN NUMBER IN NPWRD, ',
     &       'CALL IGNORED')
C
 115	FORMAT (4X,'DEFPAT - (',3I6,')',/)
C
 116	FORMAT (4X,'DEFPAT - ILLEGAL PATTERN INDEX = ',I6,/)
C
 117	FORMAT (4X,'DEFPAT - FILL PATTERN ',I3,2X,'ALREADY DEFINED,'
     &       ,' CALL IGNORED'/)
C
 118	FORMAT (4X,'DEFPAT - ILLEGAL NUMBER OF ELEMENTS = ',I6,/)
C
 119	FORMAT (4X,'PLOTS  - ILLEGAL SPEED VALUE = ',I6,/)
C
 120	FORMAT (4X,'DEFPAT - ELEMENT COUNT TRUNCATED TO 16',/)
C
 121	FORMAT (4X,'DEFPEN - (',6I6,')',/)
C
 122	FORMAT (4X,'DEFPEN - PEN ALREADY DEFINED, CALL IGNORED, IPEN =',
     &       I2,/)
C
 123	FORMAT (1X,'(IFFAP)  FF/SPACE AFTER PLOTS  =',I7,
     &	     2X,'(LASTFF) LAST FORM FEED        =',I7,/,
     &	     1X,'(INVVRF) INVOKE VRF OUTPUT     =',I7,
     &	     2X,'(IVSTRP) STRIP WIDE PLOTS      =',I7)
C
 124	FORMAT (4X,'DEFPEN - ILLEGAL DASH PATTERN, CALL IGNORED'/)
C
 125	FORMAT (4X,'ELLIPS - (',5(F10.2),')',/)
C
 126	FORMAT (4X,'FACTOR - (',F10.2,')')
C
 127	FORMAT (4X,'GRID   - (',2(F8.2,2X),I6,2X,F8.2,2X,I6,2X,
     &       F8.2,2X,I10,')',/)
C
 128	FORMAT (1X,'(NSCAN)  NOT SUPPORTED          ',7X,
     &	     2X,'(INHNCE) LINE ENHANCE          =',I7,/,
     &	     1X,'(INVERS) INVERSE IMAGE         =',I7,
     &	     2X,'(MIRROR) MIRROR IMAGE          =',I7,/,
     &	     1X,'(IRDT)   RASTER DATA TRANSLATE =',I7,
     &	     2X,'(MODE)   NOT SUPPORTED          ',7X,/,
     &	     1X,'(MUXOUT) PLOTTER DEVICE #      =',I7,
     &	     2X,'(PMSIZE) RPM MEMORY SIZE (MB)  =',F7.2)
C
 129	FORMAT (4X,'LINE   - (',2(F8.2,2X),4(I6,2X),')',/)
C
 130	FORMAT (4X,'NEWPEN - (',I6,')',/)
C
 131	FORMAT (4X,'NUMBER - (',5(F8.2,2X),I6,')',/)
C
 132	FORMAT (4X,'OFFSET - (',4(F8.2,2X),')',/)
C
 133	FORMAT (4X,'PENCLR - COLOR MODE NOT SET, CALL IGNORED')
C
 134	FORMAT (4X,'PENCLR - ILLEGAL ARGUMENTS, CALL IGNORED',/
     &       13X,'ICPEN/NUMCLR =',I6,I6)
C
 135	FORMAT (/4X,'PLOT   - CALL PLOT (',F8.2, ',' ,F8.2, ',' ,I5,')')
C
 136	FORMAT (4X,'PLOT   - UNDEFINED PEN = ',I5,'  CALL IGNORED',/)
C
 137	FORMAT (4X,'PLOT   - UNPLOTTABLE VECTOR: (',F8.2, ',' ,F8.2,
     &       ')  TO  (',F8.2, ',' ,F8.2,')',/,5X,'WINDOW:',4F7.2,3X,
     &       'ORIGIN:',2F7.2,/)
C
 138	FORMAT (4X,'PLOT   - VECTOR: (',F8.2, ',' ,F8.2,')  TO  (',F8.2,
     &       ',' ,F8.2,')',/,5X,'CLIPPED TO WINDOW:',4F7.2,3X,
     &       'ORIGIN:',2F7.2,/)
C
 139	FORMAT (4X,'PLOT   - PLOTTABLE VECTOR: (',F8.2, ',' ,F8.2,
     &       ') TO (',F8.2, ',' ,F8.2,')',/,5X,'WINDOW:',4F7.2,3X,
     &       'ORIGIN:',2F7.2,/)
C
 140	FORMAT (4X,'PLOT   - REORIGIN - NEW ORIGIN:',2F7.2,/,7X,
     &       'WINDOW:',4F7.2,/)
C
 141	FORMAT (4X,'PLOTS  - LINE ENHANCE WITH 400.0 RESOLUTION - ',
     &       F8.2,/)
C
 142	FORMAT (//4X,'PLOT   - PLOT ',I3,' SUMMARY:',/8X,
     &       'NUMBER OF CLIPPED/UNPLOTTABLE OBJECTS - ',I10/)
C
 143	FORMAT (4X,'PLOTS  - INVALID PLOTTER DEVICE NUMBER - ',I6,/)
C
 144	FORMAT (4X,'PLOTS  - INVALID RPM SERIES MEMORY SIZE - ',
     &	     F7.2,' MBYTES',/)
C
 145	FORMAT (4X,'PLOTS  - INVALID SPACE BETWEEN COPIES OF PLOTS - ',
     &       I6,/)
C
 146	FORMAT (4X,'PLOTS  - INVALID SPACE BETWEEN PLOTS - ',I6,/)
C
 147	FORMAT (1X,'PLOTS  - INVALID NCPASS VALUE - ',I6,/)
C
 148	FORMAT (1X,'PLOTS  - INVALID ITNSEQ ',I2,' VALUE - ',I6,/)
C
 149	FORMAT (1X,'PLOTS  - INVALID KREP VALUE - ',I6,/)
C
 150	FORMAT (1X,'PLOTS  - INVALID ITNCLR VALUE - ',I6,/)
C
 151	FORMAT (1X,'PLOTS  - INVALID IJPEN VALUE - ',I6,/)
C
 152	FORMAT (1X,'PLOTS  - INVALID IDISK VALUE - ',I6,/)
C
 153	FORMAT (1X,'PLOTS  - INVALID JCLR ',I2,' VALUE - ',I2,/)
C
 154	FORMAT (1X,'PLOTS  - INVALID JWTH ',I2,' VALUE - ',I2,/)
C
 155	FORMAT (1X,'PLOTS  - INVALID ICLOSE VALUE - ',I6,/)
C
 156	FORMAT (1X,'PLOTS  - INVALID PLOTTER MODEL - ',I6,/)
C
 157	FORMAT (4X,'PLOTS  - NEGATIVE PLOT SCALE, SCALE = ',F8.2,/)
C
 158	FORMAT (1X,'PLOTS  - INVALID IFONT VALUE - ',I6,/)
C
 159	FORMAT (1X,'PLOTS  - INVALID UNITS VALUE - ',F9.4,/)
C
 160	FORMAT (1X,'PLOTS  - INVALID XFACT OR YFACT VALUE ',2(F9.4),/)
C
 161	FORMAT (1X,'PLOTS  - INVALID RDEN OR IBYTES VALUE ',F6.2,I6,/)
C
 162	FORMAT (1X,'PLOTS  - INVALID NCOPY VALUE - ',I6,/)
C
 163	FORMAT (1X,'PLOTS  - INVALID IPRECS VALUE - ',I6,/)
C
 164	FORMAT (4X,'PLOTS  - ILLEGAL PAPER SPECIFICATION FOR ',I2,
     &       ' BIT PRECISION VRF')
C
 165	FORMAT (12X,'PXMIN= ',F10.2,5X,'PXMAX= ',F10.2,/12X,'PYMIN= ',
     &       F10.2,5X,'PYMAX= ',F10.2)
C
 166	FORMAT (4X,'PLOTS  - ILLEGAL VIEWPORT SPECIFICATION',/12X,
     &       'VXMIN= ',F10.2,5X,'VXMAX= ',F10.2,/12X,'VYMIN= ',
     &       F10.2,5X,'VYMAX= ',F10.2)
C
 167	FORMAT (1X,'(MTAPE)  MAG TAPE OUTPUT       =',I7,
     &	     2X,'(JSORT)  PARTITION FLAG        =',I7,/,
     &	     1X,'(JCPCMD) COPY COMMAND FLAG     =',I7,
     &	     2X,'(IBRAS)  NOT SUPPORTED          '/,
     &	     1X,'(JCUT)   PAPER CUT FLAG        =',I7,
     &	     2X,'(KDISK)  RPM DISK USE FLAG     =',I7)
C
 168	FORMAT (4X,'PLOTS  - ILLEGAL WINDOW SPECIFICATION',/12X,
     &       'WXMIN= ',F10.2,5X,'WXMAX= ',F10.2,/12X,'WYMIN= ',
     &       F10.2,5X,'WYMAX= ',F10.2)
C
 169	FORMAT (19X,'VERSAPLOT COLOR RANDOM 2.0 REV C',//,
     &	     17X,'PLOTS  - PLOT OPTIONS IN EFFECT -',//,
     &	     1X,'(NCOPY)  NUMBER OF COPIES      =',I7,
     &	     2X,'(LUNIT)  LISTING UNIT NUMBER   =',I7,/,
     &	     1X,'(IPRECS) COORDINATE PRECISION  =',I7,
     &	     2X,'(IFONT)  FONT PATTERN NUMBER   =',I7,/,
     &	     1X,'(INITFF) INITIAL FORM-FEED     =',I7,
     &	     2X,'(IUSER)  PLOT DATE/TIME STAMP  =',I7,/,
     &	     1X,'(IEND1)  END-OF-PLOT CODE 1    =',I7,
     &	     2X,'(IEND2)  END-OF-PLOT CODE 2    =',I7)
C
 170	FORMAT (
     &	     1X,'(IEND3)  END-OF-PLOT CODE 3    =',I7,
     &	     2X,'(IEND4)  END-OF-PLOT CODE 4    =',I7,/,
     &	     1X,'(ICLOSE) END-OF-JOB CODE       =',I7,
     &	     2X,'(UNITS)  UNITS PER INCH        =',F7.2,/,
     &	     1X,'(IROT)   PLOT ROTATION         =',I7,
     &	     2X,'(SCALE)  DRAWING SCALE FACTOR  =',F7.2,/,
     &	     1X,'(XFACT)  X SCALING FACTOR      =',F7.2,
     &	     2X,'(YFACT)  Y SCALING FACTOR      =',F7.2,/,
     &	     1X,'(XSTART) STARTING X COORD.     =',F7.2,
     &	     2X,'(YSTART) STARTING Y COORD.     =',F7.2,/,
     &	     1X,'(IJPEN)  CURRENT PEN           =',I7,
     &	     2X,'(ISPACE) FF/SPACE AFTER COPIES =',I7)
C
 171	FORMAT (//,19X,'CURRENT PEN DEFINITIONS'/)
C
 172	FORMAT (1X,'(JWTH(',I2,')) PEN ',I2,' WIDTH        =',I7,
     &	     2X,'(JWTH(',I2,')) PEN ',I2,' WIDTH        =',I7)
C
 173	FORMAT (1X,'(JWTH(',I2,')) PEN ',I2,' WIDTH        =',I7)
C
 174	FORMAT (//,19X,'PLOTTER/CONTROLLER OPTIONS',//,
     &	     1X,'(MODEL)  PLOTTER MODEL         =',I7,/,
     &	     1X,'(RDEN)   NIBS PER INCH         =',F7.2,
     &	     2X,'(IBYTES) BYTES PER SCAN        =',I7,/,
     &	     1X,'(ISFLAG) OUTPUT SPEED CONTROL  =',I7,
     &	     2X,'(ISPEED) SPEED CONTROL VALUE   =',I7,/,
     &	     1X,'(KREP)   OUTPUT CONTROLLER     =',I7,
     &	     2X,'(IDISK)  CONTROLLER WITH DISK  =',I7)
C
 175	FORMAT (//,19X,'VIEWING OPTIONS',//,
     &	     1X,'(PXMIN)  MIN. PAPER X DIM.     =',F7.2,
     &	     2X,'(PYMIN)  MIN. PAPER Y DIM.     =',F7.2,/,
     &	     1X,'(PXMAX)  MAX. PAPER X DIM.     =',F7.2,
     &	     2X,'(PYMAX)  MAX. PAPER Y DIM.     =',F7.2,/,
     &	     1X,'(VXMIN)  MIN. VIEWPORT X DIM.  =',F7.2,
     &	     2X,'(VYMIN)  MIN. VIEWPORT Y DIM.  =',F7.2,/,
     &	     1X,'(VXMAX)  MAX. VIEWPORT X DIM.  =',F7.2,
     &	     2X,'(VYMAX)  MAX. VIEWPORT Y DIM.  =',F7.2,/,
     &	     1X,'(WXMIN)  MIN. WINDOW X DIM.    =',F7.2,
     &	     2X,'(WYMIN)  MIN. WINDOW Y DIM.    =',F7.2,/,
     &	     1X,'(WXMAX)  MAX. WINDOW X DIM.    =',F7.2,
     &	     2X,'(WYMAX)  MAX. WINDOW Y DIM.    =',F7.2)
C
 176	FORMAT (//,19X,'COLOR OPTIONS',//,
     &	     1X,'(IVCFLG) COLOR/BLACK PLOTTING  =',I7,
     &	     2X,'(ITNFLG) HATCH/TONE  FLAG      =',I7,/,
     &	     1X,'(ITNCLR) CURRENT TONE COLOR    =',I7,
     &	     2X,'(NCPASS) NUMBER OF TONE PASSES =',I7)
C
 177	FORMAT (1X,'(ITSEQ1) PASS 1 (',2A4,')     =',I7)
C
 178	FORMAT (1X,'(ITSEQ1) PASS 1 (',2A4,')     =',I7,
     &	     2X,'(ITSEQ2) PASS 2 (',2A4,')     =',I7)
C
 179	FORMAT (4X,'PLOTS - INVALID MAG TAPE OUTPUT ',I6,/)
C
 180	FORMAT (1X,'(ITSEQ3) PASS 3 (',2A4,')     =',I7)
C
 181	FORMAT (4X,'PLOTS - INVALID PARTITION FLAG ',I6,/)
C
 182	FORMAT (1X,'(ITSEQ3) PASS 3 (',2A4,')     =',I7,
     &	     2X,'(ITSEQ4) PASS 4 (',2A4,')     =',I7)
C
 183	FORMAT (1X,'(JCLR(',I2,')) PEN ',I2,' COLOR        =',I7,
     &	     2X,'(JWTH(',I2,')) PEN ',I2,' WIDTH        =',I7)
C
 184	FORMAT (//)
C
 185	FORMAT (4X,'SCALE  - (',F8.2,F8.2,I9,I9,')')
C
 186	FORMAT (4X,'SETPAT - PATTERN NOT DEFINED OR OUT OF RANGE',4X,I3,
     &       /)
C
 187	FORMAT (4X,'SYMBOL - (',3F10.2,I6,F10.2,I6,')',/)
C
 188	FORMAT (4X,'SYMBOL - UNPLOTTABLE TEXT,  X,Y=',2F10.2,/)
C
 189	FORMAT(4X,'TONCLR - COLOR MODE HAS NOT BEEN SET. CALL IGNORED.')
C
 190	FORMAT (4X,'TONCLR - INVALID TONE COLOR NUMBER. CALL IGNORED.')
C
 191	FORMAT (4X,'TONE   - (',2(F8.2,2X),I6,2X,I6,')'/)
C
 192	FORMAT (4X,'TONE   - PATTERN COUNT EXCEEDED LIMIT OF ',I6)
C
 193	FORMAT (4X,'TONE   - MAXIMUM NUMBER OF TONE PATTERNS EXCEEDED',
     &       ' - CALL IGNORED',/)
C
 194	FORMAT (4X,'TONE   - FILL PATTERN NOT SET, CALL IGNORED',/)
C
 195	FORMAT (4X,'TONE   -  I=',I4,'    X(I),Y(I) =',2F8.3)
C
 196	FORMAT (4X,'TONE   -  NET=',I4,', XXMAX,XMIN=',2F8.3,2X,
     &       ' YGNF=',F8.3,/)
C
 197	FORMAT (4X,'TONE   - ARRAY OVERFLOW',/)
C
 198	FORMAT (4X,'TONE   -  INTERSECT - N=',I4,'  YL(N),YR(N),SLOPE=',
     &       3F8.3,/)
C
 199	FORMAT (4X,'TONE   - I =',2I4,',  XLF,YL(I),YL(J)=',3F8.3,/,
     &       4X,'XRI,YR(I),YR(J)=',3F8.3,',  Y1,Y2=',2F8.3)
C
 200	FORMAT (4X,'TONE   -  SUBSECTION AT XRI =',F8.3)
C
 201	FORMAT (4X,'TONE   - ILLEGAL PARAMETER VALUE',/)
C
 202	FORMAT(4X,'TONFLG - COLOR MODE HAS NOT BEEN SET. CALL IGNORED.')
C
 203	FORMAT (4X,'VPORT  - (',4(1X,F8.2),')')
C
 204	FORMAT (13X,'VPORT  - PLOTS MUST BE CALLED BEFORE VPORT, '
     &       ,'CALL IGNORED',/)
C
 205	FORMAT (4X,'VPORT  - VIEWPORT SPECIFICATION EXCEEDS MAXIMUM '
     &       ,'PLOTTING BOUNDS FOR THIS PLOT',/8X,'PAPER DIMENSIONS=('
     &       ,4(1X,F8.2, ','), ')',/)
C
 206	FORMAT (4X,'WHERE  - (',3(2X,F8.2),')',/)
C
 207	FORMAT (4X,'WINDOW - (',4(F8.2,2X),')')
C
 208	FORMAT (13X,'WINDOW - PLOTS MUST BE CALLED BEFORE WINDOW, '
     &       ,'CALL IGNORED',/)
C
 209	FORMAT (4X,'WINDOW - ILLEGAL ARGUMENTS, CALL IGNORED',/)
C
 210	FORMAT (4X,'XTEXT  - (',3F10.2,I6,F10.2,I6,')',/)
C
 211    FORMAT (4X,'GRID - NO PATTERNS AVAILABLE FOR GENERATING ',
     &             'THE GRID'/)
C
 212	FORMAT (8X,'NUMBER OF VECTORS     ',F10.0)
C
 213	FORMAT (8X,'NUMBER OF POLYGONS    ',F10.0)
C
 214	FORMAT (8X,'NUMBER OF CIRCLES     ',F10.0)
C
 215	FORMAT (8X,'NUMBER OF CHARACTERS  ',F10.0)
C
 216	FORMAT (/8X,'TONERS USED:',15X,'BYTES',12X,'ELEMENTS')
C
 217	FORMAT (12X,'BLACK',13X,F10.0,10X,F10.0)
C
 218	FORMAT (12X,'CYAN',14X,F10.0,10X,F10.0)
C
 219	FORMAT (12X,'MAGENTA',11X,F10.0,10X,F10.0)
C
 220	FORMAT (12X,'YELLOW',12X,F10.0,10X,F10.0)
C
 221	FORMAT (4X,'OUTVEC - VECTOR: (',I6,',',I6,
     &		') TO (',I6,',',I6,')')
C
 222	FORMAT (4X,'CIRCLE - FILL PATTERN NOT SET, CIRCLE NOT',
     &		' FILLED',/)
C
 223	FORMAT (4X,'CONVEX - FILL PATTERN NOT SET, ',
     &		'POLYGON NOT FILLED',/)
C
 224	FORMAT (4X,'RECT   - FILL PATTERN NOT SET, RECTANGLE NOT',
     &		' FILLED',/)
C
 225	FORMAT (4X,'DEFCLR - COLOR PREVIOUSLY DEFINED, CALL IGNORED.')
C
 226	FORMAT (4X,'PLOT - SPACE PLUS PLOT TOO LARGE FOR 16 BIT',
     &          ' PRECISION, TRUNCATED TO 32759 SCANS')
C
 227	FORMAT (4X,'PLOTS - RPM MEMORY SIZE NOT SPECIFIED')
C
 228	FORMAT (4X,'PLOTS - INVALID COPY COMMAND FLAG ',I6,/)
C
 229	FORMAT (4X,'CUT - INVALID PAPER CUT VALUE. CALL IGNORED.')
C
 230	FORMAT (4X,'PLOTS - INVALID PAPER CUT VALUE = ',I6,/)
C
 231	FORMAT (4X,'SYMBOL - CHARACTER HEIGHT TOO LARGE,',
     &		' CALL IGNORED.')
C
 232	FORMAT (4X,'SYMBOL - UNABLE TO DRAW TEXT WITH DASHED PEN,',
     &		' SOLID PEN USED.')
C
 233	FORMAT (4X,'SYMBOL - TEXT CROSSES STRIPPING',
     &		' BOUNDARY AND CANNOT BE STROKED OUT.')
C
 234	FORMAT (//,4X,'PLOTS - VRF OUTPUT WAS INVOKED',/)
C
 235	FORMAT (4X,'PLOTS - INVALID FLAG FOR INVOKING VRF OUTPUT',
     &	     ' FROM PHASE 1 = ',I6,/)
C
 236	FORMAT (4X,'PLOTS - NEGATIVE PAPER SIZE IN X AND/OR Y ',
     &		'DIRECTIONS = ',2F8.2,/)
C
 237	FORMAT (4X,'CONVEX - POLYGON IS NOT CONVEX, CALL ',
     &		'IGNORED, ',/,'             X(1),Y(1),NPT =',2F10.2,
     &		I4,/)
C
 238	FORMAT (4X,'FACTOR - RATIO MUST BE GREATER THAN ZERO', /,
     &		4X,'         CALL IGNORED, FACTR = ', F8.3, / )
C
 239	FORMAT (4X,'PLOTS - INVALID RPM DISK USE FLAG - ',I6,/)
C
 240	FORMAT (//,3X,'NEW VALUES FOR RPM CONTROL ARRAY',//)
C
 241	FORMAT (7X,'IPRISM(',I2,') = ',I7)
C
 242	FORMAT (4X,'SETFNT - ILLEGAL FONT FOR STRIPPED PLOT, ',
     &		'FONT 0 USED.')
C
C
	IF (MSGNO .GT. 142 .OR. MSGNO .LE. 0) GO TO 9000
C
	GO TO ( 1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,
     & 1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,
     & 1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,
     & 1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,
     & 1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,
     & 1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,
     & 1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,
     & 1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,
     & 1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,
     & 1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,
     & 1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,
     & 1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142), MSGNO
C
C
C	  WRITE STATEMENTS
C
C
C   MSGNO=1  AUTHOR  NON-FATAL ERROR - BAD CHARACTER COUNT
C   VARIABLE NC IS OUTPUT BY AUTHOR
C
C
 1001	WRITE (LUNIT,101) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=2  AXIS  DEBUG MESSAGE - PRINT START COORDINATES, AXIS LABEL,
C			   NUMBER OF LABEL CHARACTERS, AXIS LENGTH, AXIS
C			   ANGLE, 1ST AXIS ANNOTATION INTERVAL, AND
C			   THE NUMBER OF DATA UNITS PER AXIS UNIT
C   VARIABLES X, Y, LABEL,NCHAR,AXLEN,ANGLE,FVAL AND DV ARE
C   OUTPUT BY AXIS
C
C
 1002	WRITE (LUNIT,102) RELARG(1),RELARG(2),INTARG(1),INTARG(2),
     &                    (RELARG(I), I=3,6)
	GO TO 5000
C
C
C   MSGNO=3  CARC  DEBUG MESSAGE - PRINT COORDINATES OF CENTER OF ARC,
C			   RADIUS, ANGLE DEGREES OF START AND END POINTS
C   VARIABLES XC, YC, RADIUS, START AND END ARE OUTPUT BY CARC
C
C
 1003	WRITE (LUNIT,103) (RELARG(I), I=1,5)
	GO TO 5000
C
C
C   MSGNO=4  CIRCLE  DEBUG MESSAGE - PRINT COORDINATES OF CIRCLE CENTER,
C			     RADIUS, AND PEN NUMBER FOR CIRCLE WIDTH
C   VARIABLES XC, YC, RADIUS AND IWIDTH ARE OUTPUT BY CIRCLE
C
C
 1004	WRITE (LUNIT,104) (RELARG(I), I=1,3), INTARG(1)
	GO TO 5000
C
C
C   MSGNO=5  CIRCLE  NON-FATAL ERROR - UNPLOTTABLE CIRCLE
C   VARIABLES XC AND YC ARE OUTPUT BY CIRCLE
C
C
 1005	WRITE (LUNIT,105) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=6  CLIP  FATAL ERROR - INTERNAL ERROR
C
C
 1006	WRITE (LUNIT,106)
	GO TO 5000
C
C
C   MSGNO=7  CONVEX  DEBUG MESSAGE - PRINT FIRST X AND Y COORDINATES AND
C			     THE NUMBER OF ELEMENTS DEFINING THE POLYGON
C   VARIABLES X(1), Y(1) AND NPT ARE OUTPUT BY CONVEX
C
C
 1007	WRITE (LUNIT,107) RELARG(1),RELARG(2),INTARG(1)
	GO TO 5000
C
C
C   MSGNO=8  CONVEX  NON-FATAL ERROR - ILLEGAL NUMBER OF ELEMENTS
C   VARIABLE NP1 IS OUTPUT BY CONVEX
C
C
 1008	WRITE (LUNIT,108) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=9  CURVE  DEBUG MESSAGE - PRINT 1ST COORDINATE PTS. FOR CURVE,
C			    NUMBER OF COORDINATE POINTS AND THE SEGMENT
C			    LTH FOR INCREMENTAL APPROXIMATION OF CURVE
C   VARIABLES X(1), Y(1), NE AND DELTA ARE OUTPUT BY CURVE
C
C
 1009	WRITE (LUNIT,109) RELARG(1),RELARG(2),INTARG(1),RELARG(3)
	GO TO 5000
C
C
C   MSGNO=10  DASHLN  DEBUG MESSAGE - PRINT FIRST ABSCISSA AND ORDINATE
C			     VALUES, NUMBER OF THESE VALUES, LENGTH OF
C			     'ON' SEGMENT AND LENGTH OF 'OFF' SEGMENT
C   VARIABLES X(1), Y(1), NPTS, ONLTH AND OFFLTH ARE OUTPUT BY DASHLN
C
C
 1010	WRITE (LUNIT,110) RELARG(1),RELARG(2),INTARG(1),
     &                    RELARG(3),RELARG(4)
	GO TO 5000
C
C
C   MSGNO=11  DASHLN  NON-FATAL ERROR - ILLEGAL VALUES
C   VARIABLES NPTS, ONLTH AND OFFLTH ARE OUTPUT BY DASHLN
C
C
 1011	WRITE (LUNIT,111) INTARG(1),RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=12  DEFCLR  NON-FATAL ERROR - COLOR MODE HAS NOT BEEN SET
C
C
 1012	WRITE (LUNIT,112)
	GO TO 5000
C
C
C   MSGNO=13  DEFCLR  NON-FATAL ERROR - INVALID COLOR NUMBER
C
C
 1013	WRITE (LUNIT,113)
	GO TO 5000
C
C
C   MSGNO=14  DEFCLR  NON-FATAL ERROR - INVALID PATTERN WORD COUNT
C
C
 1014	WRITE (LUNIT,114)
	GO TO 5000
C
C
C   MSGNO=15  DEFPAT  DEBUG MESSAGE - PRINT FILL PATTERN INDEX, FILL
C			      PATTERN ARRAY AND NUMBER IN ARRAY
C   VARIABLES IP, JPAT(1) AND NTP ARE OUTPUT BY DEFPAT
C
C
 1015	WRITE (LUNIT,115) (INTARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=16  DEFPAT  NON-FATAL ERROR - ILLEGAL PATTERN INDEX
C   VARIABLE IP IS OUTPUT BY DEFPAT
C
C
 1016	WRITE (LUNIT,116) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=17  DEFPAT  NON-FATAL ERROR - FILL PATTERN ALREADY DEFINED
C   VARIABLE IP IS OUTPUT BY DEFPAT
C
C
 1017	WRITE (LUNIT,117) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=18  DEFPAT  NON-FATAL ERROR - ILLEGAL NUMBER OF ELEMENTS
C   VARIABLE NTP IS OUTPUT BY DEFPAT
C
C
 1018	WRITE (LUNIT,118) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=19  PLOTS  NON-FATAL ERROR - ILLEGAL SPEED VALUE
C   VARIABLE ISPEED IS OUTPUT BY PLOTS
C
C
 1019	WRITE (LUNIT,119) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=20  DEFPAT  NON-FATAL ERROR - TRUNCATE ELEMENT COUNT TO 16
C
C
 1020	WRITE (LUNIT,120)
	GO TO 5000
C
C
C   MSGNO=21  DEFPEN  DEBUG MESSAGE - PRINT PEN NUMBER, WIDTH AND
C			      DASH PATTERN - NIBS ON, OFF, ON, OFF
C   VARIABLES IPEN, JWIDTH, NBON1, NBOFF1, NBON2 AND NBOFF2 ARE
C   OUTPUT BY DEFPEN
C
C
 1021	WRITE (LUNIT,121) (INTARG(I), I=1,6)
	GO TO 5000
C
C
C   MSGNO=22  DEFPEN  NON-FATAL ERROR - PEN ALREADY DEFINED
C   VARIABLE IPEN IS OUTPUT BY DEFPEN
C
C
 1022	WRITE (LUNIT,122) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=23  PLOTS INFORMATIVE MESSAGE - PLOT OPTIONS
C   VARIABLES IFFAP, LASTFF, MODE1 AND IVSTRP ARE OUTPUT BY PLOTS
C
C
 1023	WRITE (LUNIT,123) (INTARG(I),I=1,4)
	GO TO 5000
C
C
C   MSGNO=24  DEFPEN  NON-FATAL ERROR - ILLEGAL DASH PATTERN
C
C
 1024	WRITE (LUNIT,124)
	GO TO 5000
C
C
C   MSGNO=25  ELLIPS  DEBUG MESSAGE - PRINT COORDINATES OF ELLIPSE
C			      CENTER, ANGLE OF ELLIPSE AND LENGTH OF
C			      SEMI-MAJOR AND SEMI-MINOR AXIS
C   VARIABLES XC, YC, ANGLE, MAJOR AND MINOR ARE OUTPUT BY ELLIPS
C
C
 1025	WRITE (LUNIT,125) (RELARG(I), I=1,5)
	GO TO 5000
C
C
C   MSGNO=26  FACTOR  DEBUG MESSAGE - PRINT RATIO OF DESIRED TO 'NORMAL'
C   VARIABLE FACTR IS OUTPUT BY FACTOR
C
C
 1026	WRITE (LUNIT,126) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=27  GRID  DEBUG MESSAGE - PRINT THE START COORDINATE OF THE
C			    GRID, INTERVALS IN X AND Y DIRECTION, DISTANCE
C			    BETWEEN VERTICAL AND HORIZONTAL LINES,
C			    AND THE LINE MASK BIT PATTERN
C   VARIABLES X, Y, NX, XD, NY, YD AND LMASK ARE OUTPUT BY GRID
C
C
 1027	WRITE (LUNIT,127) RELARG(1),RELARG(2),INTARG(1),RELARG(3),
     &                    INTARG(2),RELARG(4),INTARG(3)
	GO TO 5000
C
C
C   MSGNO=28  PLOTS INFORMATIVE MESSAGE - PLOTTER/CONTROLLER OPTIONS
C   VARIABLES INHNCE, INVERS, MIRROR, IRDT, MUXOUT AND PMSIZE ARE
C   OUTPUT BY PLOTS
C
C
 1028	WRITE (LUNIT,128) (INTARG(I),I=1,5),RELARG(1)
	GO TO 5000
C
C
C   MSGNO=29  LINE  DEBUG MESSAGE - PRINT ARRAY OF ABSCISSA AND ARRAY
C			    OF ORDINATE VALUES, NUMBER IN ARRAYS,
C			    INCREMENT FOR DTA VALUES, LINE TYPE/SYMBOL
C			    AND THE SYMBOL NUMBER
C   VARIABLES XARRAY, YARRAY, NPTS, INC, LINTYP AND INTEQ ARE
C   OUTPUT BY LINE
C
C
 1029	WRITE (LUNIT,129) RELARG(1),RELARG(2), (INTARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=30  NEWPEN  DEBUG MESSAGE - PRINT SELECTED PEN NUMBER
C   VARIABLE NPEN IS OUTPUT BY NEWPEN
C
C
 1030	WRITE (LUNIT,130) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=31  NUMBER  DEBUG MESSAGE - PRINT START COORDINATES OF
C			      CHARACTER, CHARACTER HEIGHT, NUMBER TO PLOT,
C			      ANGLE FOR PLOT AND NUMBER AND TYPE OF DIGITS
C   VARIABLES X, Y, HEIGHT, FPN, ANGLE AND NDIG ARE OUTPUT BY NUMBER
C
C
 1031	WRITE (LUNIT,131) (RELARG(I), I=1,5), INTARG(1)
	GO TO 5000
C
C
C   MSGNO=32  OFFSET  DEBUG MESSAGE - PRINT X AND Y OFFSETS AND X AND Y
C			      SCALING FACTORS
C   VARIABLES XOF, XFA, YOF AND YFA ARE OUTPUT BY OFFSET
C
C
 1032	WRITE (LUNIT,132) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=33  PENCLR  NON-FATAL ERROR - COLOR MODE NOT SET
C
C
 1033	WRITE (LUNIT,133)
	GO TO 5000
C
C
C   MSGNO=34  PENCLR  NON-FATAL ERROR - ILLEGAL ARGUMENTS
C   VARIABLES ICPEN AND NUMCLR ARE OUTPUT BY PENCLR
C
C
 1034	WRITE (LUNIT,134) INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=35  PLOT  DEBUG MESSAGE - PRINT X AND Y COORDINATES AND PEN
C			    PLOTTER ARGUMENT
C   VARIABLES XX, YY AND IPEN ARE OUTPUT BY PLOT
C
C
 1035	WRITE (LUNIT,135) RELARG(1),RELARG(2),INTARG(1)
	GO TO 5000
C
C
C   MSGNO=36  PLOT  NON-FATAL ERROR - UNDEFINED CALL MESSAGE
C   VARIABLE IPEN IS OUTPUT BY PLOT
C
C
 1036	WRITE (LUNIT,136) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=37  PLOT  DEBUG MESSAGE - UNPLOTTABLE VECTOR
C   VARIABLES VEC(1)-VEC(4), WIN(1)-WIN(4) AND RORG ARE OUTPUT BY PLOT
C
C
 1037	WRITE (LUNIT,137) (RELARG(I), I=1,10)
	GO TO 5000
C
C
C   MSGNO=38  PLOT  DEBUG MESSAGE - CLIPPED VECTOR
C   VARIABLES VEC(1)-VEC(4), WIN(1)-WIN(4) AND RORG ARE OUTPUT BY PLOT
C
C
 1038	WRITE (LUNIT,138) (RELARG(I), I=1,10)
	GO TO 5000
C
C
C   MSGNO=39  PLOT  DEBUG MESSAGE - PLOTTABLE VECTOR
C   VARIABLES VEC(1)-VEC(4), WIN(1)-WIN(4) AND RORG ARE OUTPUT BY PLOT
C
C
 1039	WRITE (LUNIT,139) (RELARG(I), I=1,10)
	GO TO 5000
C
C
C   MSGNO=40  PLOT  DEBUG MESSAGE - RE-ORIGIN
C   VARIABLES RORG AND WIN(1)-WIN(4) ARE OUTPUT BY PLOT
C
C
 1040	WRITE (LUNIT,140) (RELARG(I), I=1,6)
	GO TO 5000
C
C
C   MSGNO=41  PLOTS FATAL ERROR - LINE ENHANCE WAS REQUESTED WITH
C   400.0 RESOLUTION
C   VARIABLE RDENS IS OUTPUT BY PLOTS
C
C
 1041	WRITE (LUNIT,141) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=42  PLOT  INFORMATIVE MESSAGE - PLOT SUMMARY
C   VARIABLES NPLOT AND NCLIP ARE OUTPUT BY PLOT
C
C
 1042	WRITE (LUNIT,142) (INTARG(I), I=1,2)
	GO TO 5000
C
C
C   MSGNO=43  PLOTS FATAL ERROR - INVALID PLOTTER DEVICE NUMBER
C   VARIABLE MUXOUT IS OUTPUT BY PLOTS
C
C
 1043	WRITE (LUNIT,143) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=44  PLOTS FATAL ERROR - INVALID RPM SERIES CONTROLLER MEMORY
C   SIZE. VARIABLE PMSIZE IS OUTPUT BY PLOTS
C
C
 1044	WRITE (LUNIT,144) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=45  PLOTS FATAL ERROR - INVALID SPACE BETWEEN COPIES OF PLOTS
C   VARIABLE ISPACE IS OUTPUT BY PLOTS
C
C
 1045	WRITE (LUNIT,145) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=46  PLOTS FATAL ERROR - INVALID SPACE BETWEEN PLOTS.
C   VARIABLE IFFAP IS OUTPUT BY PLOTS
C
C
 1046	WRITE (LUNIT,146) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=47  PLOTS  FATAL ERROR - INVALID NCPASS VALUE
C   VARIABLE NCPASS IS OUTPUT BY PLOTS
C
C
 1047	WRITE (LUNIT,147) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=48  PLOTS  FATAL ERROR - INVALID ITNSEQ VALUE
C   VARIABLES IBND AND ITNSEQ(IBND) ARE OUTPUT BY PLOTS
C
C
 1048	WRITE (LUNIT,148) INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=49  PLOTS  FATAL ERROR - INVALID KREP VALUE
C   VARIABLE KREP IS OUTPUT BY PLOTS
C
C
 1049	WRITE (LUNIT,149) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=50  PLOTS  FATAL ERROR - INVALID ITNCLR VALUE
C   VARIABLE ITNCLR IS OUTPUT BY PLOTS
C
C
 1050	WRITE (LUNIT,150) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=51  PLOTS  FATAL ERROR - INVALID IJPEN VALUE
C   VARIABLE IJPEN IS OUTPUT BY PLOTS
C
C
 1051	WRITE (LUNIT,151) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=52  PLOTS  FATAL ERROR - INVALID IDISK VALUE
C   VARIABLE IDISK IS OUTPUT BY PLOTS
C
C
 1052	WRITE (LUNIT,152) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=53  PLOTS  FATAL ERROR - INVALID PCLR VALUE
C   VARIABLES I AND PENTBL(IIT,1) ARE OUTPUT BY PLOTS
C
C
 1053	WRITE (LUNIT,153) INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=54  PLOTS  FATAL ERROR - INVALID PWTH VALUE
C   VARIABLES I AND PENTBL(IIT,2) ARE OUTPUT BY PLOTS
C
C
 1054	WRITE (LUNIT,154) INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=55  PLOTS  FATAL ERROR - INVALID ICLOSE VALUE
C   VARIABLE IEOJ IS OUTPUT BY PLOTS
C
C
 1055	WRITE (LUNIT,155) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=56  PLOTS  FATAL ERROR - INVALID PLOTTER MODEL
C   VARIABLE MODEL IS OUTPUT BY PLOTS
C
C
 1056	WRITE (LUNIT,156) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=57  PLOTS  FATAL ERROR - NEGATIVE PLOT SCALE
C   VARIABLE SCALE IS OUTPUT BY PLOTS
C
C
 1057	WRITE (LUNIT,157) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=58  PLOTS  FATAL ERROR - INVALID IFONT VALUE
C   VARIABLE IFONT IS OUTPUT BY PLOTS
C
C
 1058	WRITE (LUNIT,158) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=59  PLOTS  FATAL ERROR - INVALID UNITS VALUE
C   VARIABLE UNITS IS OUTPUT BY PLOTS
C
C
 1059	WRITE (LUNIT,159) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=60  PLOTS  FATAL ERROR - INVALID XFACT OR YFACT VALUE
C   VARIABLES XFACT AND YFACT ARE OUTPUT BY PLOTS
C
C
 1060	WRITE (LUNIT,160) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=61  PLOTS  FATAL ERROR - INVALID RDEN OR IBYTES VALUE
C   VARIABLES RDEN AND IBYTES ARE OUTPUT BY PLOTS
C
C
 1061	WRITE (LUNIT,161) RELARG(1),INTARG(1)
	GO TO 5000
C
C
C   MSGNO=62  PLOTS  FATAL ERROR - INVALID NCOPY VALUE
C   VARIABLE NCOPY IS OUTPUT BY PLOTS
C
C
 1062	WRITE (LUNIT,162) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=63  PLOTS  FATAL ERROR - INVALID IPRECS VALUE
C   VARIABLE PRECIS IS OUTPUT BY PLOTS
C
C
 1063	WRITE (LUNIT,163) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=64  PLOTS  FATAL ERROR - ILLEGAL PAPER SPECIFICATION
C   VARIABLE PRECIS IS OUTPUT BY PLOTS
C
C
 1064	WRITE (LUNIT,164) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=65  PLOTS  FATAL ERROR - VALUES FOR ILLEGAL PAPER
C   VARIABLES PXMIN, PXMAX, PYMIN AND PYMAX ARE OUTPUT BY PLOTS
C
C
 1065	WRITE (LUNIT,165) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=66  PLOTS  FATAL ERROR - ILLEGAL VIEWPORT SPECIFICATION
C   VARIABLES VXMIN, VXMAX, VYMIN AND VYMAX ARE OUTPUT BY PLOTS
C
C
 1066	WRITE (LUNIT,166) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=67  PLOTS INFORMATIVE MESSAGE - PLOTTER/CONTROLLER OPTIONS
C   VARIABLES MTAPE, JSORT, JCPCMD, JCUT AND KDISK ARE OUTPUT BY PLOTS
C
C
 1067	WRITE (LUNIT,167) (INTARG(I),I=1,5)
	GO TO 5000
C
C
C   MSGNO=68  PLOTS  FATAL ERROR - ILLEGAL WINDOW SPECIFICATION
C   VARIABLES WXMIN, WXMAX, WYMIN AND WYMAX ARE OUTPUT BY PLOTS
C
C
 1068	WRITE (LUNIT,168) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=69  PLOTS  INFORMATIVE MESSAGE - PLOT OPTIONS IN EFFECT
C   VARIABLES NCOPY, LUNIT, PRECIS, IFONT, INITFF, IUSER, IEOP(1)
C   AND IEOP(2) ARE OUTPUT BY PLOTS
C
C
 1069	WRITE (LUNIT,169) (INTARG(I), I=1,8)
	GO TO 5000
C
C
C   MSGNO=70  PLOTS  INFORMATIVE MESSAGE - PLOT OPTIONS IN EFFECT
C   VARIABLES IEOP(3), IEOP(4), IEOJ, UNITS, IROT, SCALE, XFACT, YFACT,
C   XSTART, YSTART, IJPEN AND ISPACE ARE OUTPUT BY PLOTS
C
C
 1070	WRITE (LUNIT,170) (INTARG(I), I=1,3),RELARG(1),INTARG(4),
     &                    (RELARG(I), I=2,6),INTARG(5),INTARG(6)
	GO TO 5000
C
C
C   MSGNO=71  PLOTS  INFORMATIVE MESSAGE - CURRENT PEN DEFINITIONS
C
C
 1071	WRITE (LUNIT,171)
	GO TO 5000
C
C
C   MSGNO=72  PLOTS  INFORMATIVE MESSAGE - CURRENT PEN DEFINITIONS
C   VARIABLES II, II, PENTBL(I,2), I, I AND PENTBL(I+1,2) ARE
C   OUTPUT BY PLOTS
C
C
 1072	WRITE (LUNIT,172) (INTARG(I), I=1,6)
	GO TO 5000
C
C
C   MSGNO=73  PLOTS  INFORMATIVE MESSAGE - CURRENT PEN DEFINITIONS
C   VARIABLES MXPEN, MXPEN AND PENTBL(MXPEN+1,2) ARE OUTPUT BY PLOTS
C
C
 1073	WRITE (LUNIT,173) (INTARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=74  PLOTS  INFORMATIVE MESSAGE - PLOTTER OPTIONS
C   VARIABLES MODEL, RDEN, IBYTES, ISFLAG, ISPEED, KREP AND IDISK
C   ARE OUTPUT BY PLOTS
C
C
 1074	WRITE (LUNIT,174) INTARG(1),RELARG(1),(INTARG(I), I=2,6)
	GO TO 5000
C
C
C   MSGNO=75  PLOTS  INFORMATIVE MESSAGE - VIEWING OPTIONS
C   VARIABLES PXMIN, PYMIN, PXMAX, PYMAX, VXMIN, VYMIN, VXMAX, VYMAX,
C   WXMIN, WYMIN, WXMAX AND WYMAX ARE OUTPUT BY PLOTS
C
C
 1075	WRITE (LUNIT,175) (RELARG(I), I=1,12)
	GO TO 5000
C
C
C   MSGNO=76  PLOTS  INFORMATIVE MESSAGE - COLOR OPTIONS
C   VARIABLES IVCFLG, ITNFLG, ITNCLR AND NCPASS ARE OUTPUT BY PLOTS
C
C
 1076	WRITE (LUNIT,176) (INTARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=77  PLOTS  INFORMATIVE MESSAGE - TONE PASS 1
C   VARIABLES ICLRDA(ITS,1), ICLRDA(ITS,2) AND ITS ARE OUTPUT BY PLOTS
C
C
 1077	WRITE (LUNIT,177) (INTARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=78  PLOTS  INFORMATIVE MESSAGE - TONE PASS 1 AND 2
C   VARIABLES ICLRDA(ITS,1), ICLRDA(ITS,2), ITS, ICLRDA(ITT,1),
C   ICLRDA(ITT,2) AND ITT ARE OUTPUT BY PLOTS
C
C
 1078	WRITE (LUNIT,178) (INTARG(I), I=1,6)
	GO TO 5000
C
C
C   MSGNO=79  PLOTS FATAL ERROR - INVALID MAG TAPE OUTPUT
C   VARIABLE MTAPE IS OUTPUT BY PLOTS
C
C
 1079	WRITE (LUNIT,179) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=80  PLOTS  INFORMATIVE MESSAGE - TONE PASS 3
C   VARIABLES ICLRDA(ITU,1), ICLRDA(ITU,2) AND ITU ARE OUTPUT BY PLOTS
C
C
 1080	WRITE (LUNIT,180) (INTARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=81  PLOTS - INVALID PARTITION FLAG
C   VARIABLE JSORT IS OUTPUT BY PLOTS
C
C
 1081	WRITE (LUNIT,181) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=82  PLOTS  INFORMATIVE MESSAGE - TONE PASS 3 AND 4
C   VARIABLES ICLRDA(ITU,1), ICLRDA(ITU,2), ITU, ICLRDA(ITV,1),
C   ICLRDA(ITV,2) AND ITV ARE OUTPUT BY PLOTS
C
C
 1082	WRITE (LUNIT,182) (INTARG(I), I=1,6)
	GO TO 5000
C
C
C   MSGNO=83  PLOTS  INFORMATIVE MESSAGE - PEN DEFINITIONS
C   VARIABLES II, II, PENTBL(I,1), II, II AND PENTBL(I,2) ARE
C   OUTPUT BY PLOTS
C
C
 1083	WRITE (LUNIT,183) (INTARG(I), I=1,6)
	GO TO 5000
C
C
C   MSGNO=84  PLOTS  INFORMATIVE MESSAGE - '//' TWO CARRIAGE RETURNS
C
C
 1084	WRITE (LUNIT,184)
	GO TO 5000
C
C
C   MSGNO=85  SCALE  DEBUG MESSAGE - PRINT ARRAY OF UNSCALED DTA POINTS,
C			     AXIS LTH TO SCALE DATA, NUMBER TO SCALE AND
C			     THE INCREMENT
C   VARIABLES ARRAY, AXLEN, NPTS AND INC ARE OUTPUT BY SCALE
C
C
 1085	WRITE (LUNIT,185) RELARG(1),RELARG(2),INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=86  SETPAT  NON-FATAL ERROR - PATTERN OUT OF RANGE
C				  OR NOT DEFINED
C   VARIABLE INTARG IS OUTPUT BY SETPAT
C
C
 1086	WRITE (LUNIT,186) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=87  SYMBOL  DEBUG MESSAGE - PRINT START COORDINATES, HEIGHT
C			      SPEC, ALPHANUMERIC TEXT, ANGLE DEGREES
C			      FOR TEXT AND NUMBER OF CHARACTERS
C   VARIABLES XZ, YZ, HGT, ITEXT(1), ANGLE AND NC ARE OUTPUT BY SYMBOL
C
C
 1087	WRITE (LUNIT,187) (RELARG(I), I=1,3), INTARG(1),RELARG(4),
     &                    INTARG(2)
	GO TO 5000
C
C
C   MSGNO=88  SYMBOL  NON-FATAL ERROR - TEXT IS OUTSIDE PLOTTING WINDOW
C   VARIABLES XZ AND YZ ARE OUTPUT BY SYMBOL
C
C
 1088	WRITE (LUNIT,188) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=89  TONCLR  NON-FATAL ERROR - COLOR MODE HAS NOT BEEN SET
C
C
 1089	WRITE (LUNIT,189)
	GO TO 5000
C
C
C   MSGNO=90  TONCLR  NON-FATAL ERROR - INVALID TONE COLOR NUMBER
C
C
 1090	WRITE (LUNIT,190)
	GO TO 5000
C
C
C   MSGNO=91  TONE  DEBUG MESSAGE - PRINT COORDINATE ARRAYS DEFINING
C			    POLYGON, NUMBER OF X,Y COORDINATES AND THE
C			    NUMBER OF AREAS
C   VARIABLES X, Y, NE AND NA ARE OUTPUT BY TONE
C
C
 1091	WRITE (LUNIT,191) RELARG(1),RELARG(2),INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=92  TONE  NON-FATAL ERROR - PATTERN COUNT EXCEEDED LIMIT
C   VARIABLE NTP IS OUTPUT BY TONE
C
C
 1092	WRITE (LUNIT,192) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=93  TONE  NON-FATAL ERROR - MAXIMUM TONE PATTERNS EXCEEDED
C
C
 1093	WRITE (LUNIT,193)
	GO TO 5000
C
C
C   MSGNO=94  TONE  NON-FATAL ERROR - TONE PATTERN NOT DEFINED
C
C
 1094	WRITE (LUNIT,194)
	GO TO 5000
C
C
C   MSGNO=95  TONE  DEBUG MESSAGE - PRINT ARRAY INDEX AND POLYGON
C			    X-Y ARRAY COORDINATES
C   VARIABLES I, X(I) AND Y(I) ARE OUTPUT BY TONE
C
C
 1095	WRITE (LUNIT,195) INTARG(1),RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=96  TONE  DEBUG MESSAGE - PRINT NUMBER OF ELEMENTS IN X AND Y,
C			    MAX X IN X ARRAY, LEFT X LIMIT OF AN AREA
C			    AND DISTANCE OF 1/2 SCAN LINE
C   VARIABLES NET, XXMAX, XLF AND YGNF ARE OUTPUT BY TONE
C
C
 1096	WRITE (LUNIT,196) INTARG(1), (RELARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=97  TONE  NON-FATAL ERROR - ARRAY OVERFLOW
C
C
 1097	WRITE (LUNIT,197)
	GO TO 5000
C
C
C   MSGNO=98  TONE  DEBUG MESSAGE - PRINT NUMBER OF POLYGON EDGES
C			    CROSSING CURRENT AREA, INTERSECTIONS BETWEEN
C			    EDGES AND XLF AND XRI AND SLOPE OF EDGE
C   VARIABLES N, YL(N), YR(N) AND SLOPE ARE OUTPUT BY TONE
C
C
 1098	WRITE (LUNIT,198) INTARG(1), (RELARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=99  TONE  DEBUG MESSAGE - PRINT NUMBER OF POLYGON EDGES
C			    CROSSING CURRENT AREA, LEFT AND RIGHT X
C			    LIMIT OF AN AREA AND INTERSECTIONS BETWEEN
C			    EDGES AND XLF AND XRI AND SLOPE OF EDGE
C   VARIABLES II, N, XLF, YL(II), YL(N), XRI, YR(II), YR(N), YY1 AND
C   YY2 ARE OUTPUT BY TONE
C
C
 1099	WRITE (LUNIT,199) INTARG(1),INTARG(2), (RELARG(I), I=1,8)
	GO TO 5000
C
C
C   MSGNO=100  TONE  DEBUG MESSAGE - PRINT RIGHT X LIMIT OF AREA SECTION
C   VARIABLE XRI IS OUTPUT BY TONE
C
C
 1100	WRITE (LUNIT,200) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=101  TONE  NON-FATAL ERROR - ILLEGAL CALLING PARAMETER
C
C
 1101	WRITE (LUNIT,201)
	GO TO 5000
C
C
C   MSGNO=102  TONFLG  NON-FATAL ERROR - COLOR MODE HAS NOT BEEN SET
C
C
 1102	WRITE (LUNIT,202)
	GO TO 5000
C
C
C   MSGNO=103  VPORT  DEBUG MESSAGE - X-Y MIN AND MAX VIEWPORT EDGES
C   VARIABLES VXMIN, VXMAX, VYMIN AND VYMAX ARE OUTPUT BY VPORT
C
C
 1103	WRITE (LUNIT,203) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=104  VPORT  NON-FATAL ERROR - CALL PLOTS BEFORE VPORT
C
C
 1104	WRITE (LUNIT,204)
	GO TO 5000
C
C
C   MSGNO=105  VPORT  NON-FATAL ERROR - VIEWPORT SPEC EXCEEDS PLOT BOUND
C   VARIABLES PXMIN, PXMAX, PYMIN AND PYMAX ARE OUTPUT BY VPORT
C
C
 1105	WRITE (LUNIT,205) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=106  WHERE  DEBUG MESSAGE - PRINT X AND Y COORDINATES OF THE
C			      'PEN' POSITION AND DRAWING FACTOR
C   VARIABLES XNOW, YNOW AND DFACT ARE OUTPUT BY WHERE
C
C
 1106	WRITE (LUNIT,206) (RELARG(I), I=1,3)
	GO TO 5000
C
C
C   MSGNO=107  WINDOW  DEBUG MESSAGE - PRINT X AND Y, MINIMUM AND
C			       MAXIMUM CLIPPING EDGES
C   VARIABLES WMINX, WMAXX, WMINY AND WMAXY ARE OUTPUT BY WINDOW
C
C
 1107	WRITE (LUNIT,207) (RELARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=108  WINDOW  NON-FATAL ERROR - CALL PLOTS BEFORE WINDOW
C
C
 1108	WRITE (LUNIT,208)
	GO TO 5000
C
C
C   MSGNO=109  WINDOW  NON-FATAL ERROR - ILLEGAL ARGUMENTS
C
C
 1109	WRITE (LUNIT,209)
	GO TO 5000
C
C
C   MSGNO=110  XTEXT  DEBUG MESSAGE - PRINT START COORDINATES, HEIGHT
C			      SPEC, ALPHANUMERIC TEXT, ANGLE DEGREES
C			      FOR TEXT AND NUMBER OF CHARACTERS
C   VARIABLES XZ, YZ, HGT, ITEXT(1), ANGLE AND NC ARE OUTPUT BY XTEXT
C
C
 1110	WRITE (LUNIT,210) (RELARG(I), I=1,3),INTARG(1),RELARG(4),
     &                    INTARG(2)
	GO TO 5000
C
C
C   MSGNO=111  GRID   ERROR MESSAGE - NOT ENOUGH PATTERNS AVAILABLE TO
C                     PRODUCE THE GRID PATTERN.
C
C
 1111	WRITE (LUNIT,211)
	GO TO 5000
C
C
C   MSGNO=112  PLOT   INFORMATIVE MESSAGE - TOTAL VECTORS OUTPUT
C
C
 1112	WRITE (LUNIT,212) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=113  PLOT   INFORMATIVE MESSAGE - TOTAL POLYGONS OUTPUT
C
C
 1113	WRITE (LUNIT,213) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=114  PLOT   INFORMATIVE MESSAGE - TOTAL CIRCLES OUTPUT
C
C
 1114	WRITE (LUNIT,214) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=115  PLOT   INFORMATIVE MESSAGE - TOTAL CHARACTERS OUTPUT
C
C
 1115	WRITE (LUNIT,215) RELARG(1)
	GO TO 5000
C
C
C   MSGNO=116  PLOT   INFORMATIVE MESSAGE - TONERS USED, BYTE COUNT,
C					    AND ELEMENT COUNT
C
C
 1116	WRITE (LUNIT,216)
	GO TO 5000
C
C
C   MSGNO=117  PLOT   INFORMATIVE MESSAGE - BLACK TONER USED, BYTE
C					    COUNT, AND ELEMENT COUNT
C
C
 1117	WRITE (LUNIT,217) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=118  PLOT   INFORMATIVE MESSAGE - CYAN TONER USED, BYTE
C					    COUNT, AND ELEMENT COUNT
C
C
 1118	WRITE (LUNIT,218) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=119  PLOT   INFORMATIVE MESSAGE - MAGENTA TONER USED, BYTE
C					    COUNT, AND ELEMENT COUNT
C
C
 1119	WRITE (LUNIT,219) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=120  PLOT   INFORMATIVE MESSAGE - YELLOW TONER USED, BYTE
C					    COUNT, AND ELEMENT COUNT
C
C
 1120	WRITE (LUNIT,220) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=121  OUTVEC  DEBUG MESSAGE - PRINT THE CURRENT VECTOR
C
C
 1121	WRITE (LUNIT,221) (INTARG(I), I=1,4)
	GO TO 5000
C
C
C   MSGNO=122  CIRCLE  NON-FATAL ERROR - FILL PATTERN NOT DEFINED
C
C
 1122	WRITE (LUNIT,222)
	GO TO 5000
C
C
C   MSGNO=123  CONVEX  NON-FATAL ERROR - FILL PATTERN NOT DEFINED
C
C
 1123	WRITE (LUNIT,223)
	GO TO 5000
C
C
C   MSGNO=124  RECT  NON-FATAL ERROR - FILL PATTERN NOT DEFINED
C
C
 1124	WRITE (LUNIT,224)
	GO TO 5000
C
C
C   MSGNO=125  DEFCLR  NON-FATAL ERROR - COLOR PREVIOUSLY DEFINED
C
C
 1125	WRITE (LUNIT,225)
	GO TO 5000
C
C
C   MSGNO=126  PLOT  NON-FATAL ERROR - SPACE PLUS PLOT TOO LARGE FOR
C              16 BIT PRECISION, TRUNCATED TO 32759 SCANS
C
C
 1126	WRITE (LUNIT,226)
	GO TO 5000
C
C
C   MSGNO=127  PLOTS  FATAL ERROR - RPM MEMORY SIZE NOT SPECIFIED
C
C
 1127	WRITE (LUNIT,227)
	GO TO 5000
C
C
C   MSGNO=128 PLOTS  FATAL ERROR - INVALID COPY COMMAND FLAG
C   VARIABLE JCPCMD IS OUTPUT BY PLOTS
C
 1128	WRITE (LUNIT,228) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=129 CUT  NON-FATAL ERROR - INVALID VALUE FOR PAPER CUT FLAG
C
 1129	WRITE (LUNIT,229)
	GO TO 5000
C
C
C   MSGNO=130 PLOTS  NON-FATAL ERROR - INVALID VALUE FOR PAPER CUT FLAG
C   VARIABLE JCUT IS OUTPUT BY PLOTS
C
 1130	WRITE (LUNIT,230) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=131 SYMBOL  NON-FATAL ERROR - TEXT STRING TOO LARGE
C   (AND CANNOT BE STROKED OUT BECAUSE IT IS THE WRONG FONT)
C
 1131	WRITE (LUNIT,231)
	GO TO 5000
C
C
C   MSGNO=132 SYMBOL  WARNING - TEXT STRING CANNOT BE DRAWN
C   WITH A DASHED PEN (BECAUSE IT IS THE WRONG FONT)
C
 1132	WRITE (LUNIT,232)
	GO TO 5000
C
C
C   MSGNO=133 SYMBOL  NON-FATAL ERROR - TEXT STRING CROSSES STRIPPING
C   BOUNDARY AND CANNOT BE STROKED OUT (BECAUSE IT IS THE WRONG FONT)
C
 1133	WRITE (LUNIT,233)
	GO TO 5000
C
C
C   MSGNO=134 PLOTS   INFORMATIVE MESSAGE - VRF OUTPUT WAS INVOKED
C   FROM PHASE I
C
C
 1134	WRITE (LUNIT,234)
	GO TO 5000
C
C
C   MSGNO=135 PLOTS   NON-FATAL ERROR - INVALID FLAG FOR INVOKING VRF
C   OUTPUT FROM PHASE I
C   VARIABLE MODE1 IS OUTPUT BY PLOTS
C
C
 1135	WRITE (LUNIT,235) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=136 PLOTS   NON-FATAL ERROR - NEGATIVE PAPER SIZE IN X
C   AND/OR Y DIRECTIONS
C   VARIABLES PXMIN AND PYMIN ARE OUTPUT BY PLOTS
C
C
 1136	WRITE (LUNIT,236) RELARG(1),RELARG(2)
	GO TO 5000
C
C
C   MSGNO=137 CONVEX   POLYGON IS NOT CONVEX, CALL IGNORED,
C   X(1),Y(1) = XXXXXX.XX,XXXXXX.XX., NPT = NNN
C
C
 1137	WRITE (LUNIT,237) RELARG(1),RELARG(2),INTARG(1)
	GO TO 5000
C
C
C   MSGNO=138 FACTOR   NON_FATAL ERROR - ILLEGAL PLOT RATIO.
C   VARIABLE FACTR IS OUTPUT BY FACTOR
C
C
 1138	WRITE (LUNIT,238) RELARG( 1 )
	GO TO 5000
C
C
C   MSGNO=139 PLOTS   NON-FATAL ERROR - ILLEGAL RPM DISK USE FLAG
C   VARIABLE KDISK IS OUTPUT BY PLOTS
C
C
 1139	WRITE (LUNIT,239) INTARG (1)
	GO TO 5000
C
C
C   MSGNO=140 PLOTS   INFORMATIVE MESSAGE - NEW VALUES FOR RPM CONTROL
C   ARRAY - TITLE
C
C
 1140	WRITE (LUNIT,240)
	GO TO 5000
C
C
C   MSGNO=141 PLOTS   INFORMATIVE MESSAGE - NEW VALUE FOR RPM CONTROL	
C   ARRAY
C   VARIABLE IPRISM(I) IS OUTPUT BY PLOTS
C
C
 1141	WRITE (LUNIT,241) INTARG (1), INTARG (2)
	GO TO 5000
C
C
C   MSGNO=142 SETFNT  ERROR MESSAGE - USER TRIED TO SET AN ILLEGAL FONT
C   FOR A STRIPPED PLOT.  ONLY FONT 0 MAY BE USED.
C
C
 1142	WRITE (LUNIT,242)
	GO TO 5000
C
C
C   MSGLG1  NON-FATAL ERROR - ILLEGAL MESSAGE NUMBER
C
C
 9000	WRITE (LUNIT,100)
C
C   RETURN
C
 5000	RETURN
	END
