	SUBROUTINE MSGLG2 ( MSGNO )
C
C	NAME: MSGLG2
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	MSGLG2 - FORMAT AND WRITE MESSAGES FOR PHASE II
C
C	SUBROUTINE MSGLG2 IS CALLED TO WRITE OUT THE ERROR, DEBUG AND
C	INFORMATIVE MESSAGES FOR PHASE II. THE WRITE ARGUMENTS ARE PASSED
C	TO MSGLG2 THROUGH COMMON ARRAY INTARG.
C
C	ENTRY:  CALL MSGLG2(MSGNO)
C
C	       MSGNO - THE MESSAGE NUMBER TO WRITE
C
C	EXIT:  RETURN
C
C	CALLS:  NONE
C
C	CALLED BY:  BAND,ICHUNK,RANDOM,SETFRE
C
C	COMMON USED:
C	/IOCOM/
C		I LUNIT   - LOGICAL UNIT NUMBER OF LISTING DEVICE
C
C	/MSGCOM/
C		I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C
C	LOCAL VARIABLES:
C
C	  I    I - WORKING VARIABLE USED FOR INDEXING IN WRITE STATEMENTS
C
C
C
C
	INCLUDE 'IOCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C
C	  FORMAT STATEMENTS
C
 100	FORMAT (4X,'MSGLG2 - ILLEGAL MESSAGE NUMBER',/)
C
 101	FORMAT (4X,'VRFPLT   - INVALID VRF FILE, NOT TERMINATED ',
     &     'PROPERLY IN USER PROGRAM',/)
C
 102	FORMAT (4X,'PARTITIONING STARTED')
C
 103	FORMAT (4X,'BAND   - INSUFFICIENT SPACE ALLOCATED FOR SORT ',
     &     'BUFFERS',/)
C
 104	FORMAT (4X,'BAND   - INVALID VDS FILE, MISSING BLOCK HEADERS',/)
C
 105	FORMAT (4X,'BAND   - INSUFFICIENT SPACE ALLOCATED FOR EXTENDED',
     &     ' PARTITIONING',/,13X,I3,' BUFFERS REQUIRED',/)
C
 106	FORMAT (4X,'BAND   - INVALID VRF COMMAND ENCOUNTERED= ',I4,/)
C
 107	FORMAT (4X,'BAND   - SORTED TO PARTITION SIZE OF 1.',/4X,
     &     'NUMBER OF ELEMENTS STILL GREATER THAN MAXIMUM.',/)
C
 108	FORMAT (4X,'VRFPLT - PLOT #',I3,' COMPLETED')
C
 109	FORMAT (4X,'PARTITIONING COMPLETE',/)
C
 110	FORMAT (1X,'CURRENT RECORD NUMBER= ',I12)
C
 111	FORMAT (4X,'ICHUNK - ERROR IN VRF DATA',/,'     RECORD NUMBER= ',
     &     I6,/,'     DATA CHUNK= ',I6,/)
C
 112	FORMAT (4X,'VRFPLT - INVALID VERSION OF VRF FILE',/)
C
 113	FORMAT (4X,'VRFPLT - OUTPUT STARTED')
C
 114	FORMAT (4X,'BAND - ',I10,' REUSABLE RECORDS LOST.',/4X,
     &		'STACK SIZE = ',I10,'  OPTIMUM STACK SIZE = ',I10,/)
C
 115	FORMAT (4X,'VRFPLT - COLOR PLOT TOO LONG FOR PLOTTER')
C
 116	FORMAT (4X,'BAND - RPM MEMORY SIZE TOO SMALL, UNABLE TO ',
     &	  'PARTITION')
C
 117	FORMAT (4X,'VRFPLT - PLOT TOO LONG, COPY COUNT DECREMENTED',
     &	  ' TO: ',I4)
C
 118    FORMAT (4X,'BAND - NUMBER OF BUFFERS NEEDED',I5,' NUMBER OF',
     &    ' BUFFERS AVAILABLE ',I5)
C
	IF (MSGNO .GT. 18 .OR. MSGNO .LE. 0) GO TO 4999
C
	GO TO (1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,
     & 1012,1013,1014,1015,1016,1017,1018 ), MSGNO
C
C
C	  WRITE STATEMENTS
C
C
C   MSGNO=1  VRFPLT  FATAL ERROR - INVALID VRF FILE
C
C
 1001	WRITE (LUNIT,101)
	GO TO 5000
C
C
C   MSGNO=2  BAND  INFORMATIVE MESSAGE - BANDING STARTED
C
C
 1002	WRITE (LUNIT,102)
	GO TO 5000
C
C
C   MSGNO=3  BAND  FATAL ERROR - INSUFFICIENT SPACE FOR SORT BUFFERS
C
C
 1003	WRITE (LUNIT,103)
	GO TO 5000
C
C
C   MSGNO=4  BAND  FATAL ERROR - INVALID VDS FILE
C
C
 1004	WRITE (LUNIT,104)
	GO TO 5000
C
C
C   MSGNO=5  BAND  FATAL ERROR - INSUFFICIENT SPACE FOR EXTENDED BANDING
C   VARIABLE NBUFR IS OUTPUT BY BAND
C
C
 1005	WRITE (LUNIT,105) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=6  BAND  FATAL ERROR - INVALID VRF COMMAND
C   VARIABLE ICOM IS OUTPUT BY BAND
C
C
 1006	WRITE (LUNIT,106) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=7  BAND  FATAL ERROR - NUMBER OF ELEMENTS GREATER THAN MAXIMUM
C
C
 1007	WRITE (LUNIT,107)
	GO TO 5000
C
C
C   MSGNO=8  VRFPLT  INFORMATIVE MESSAGE - PLOT #NNN COMPLETED
C
C
 1008	WRITE (LUNIT,108) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=9  BAND  INFORMATIVE MESSAGE - BANDING COMPLETE
C
C
 1009	WRITE (LUNIT,109)
	GO TO 5000
C
C
C   MSGNO=10  ICHUNK  INFORMATIVE MESSAGE - CURRENT RECORD NUMBER
C   VARIABLE JREC IS OUTPUT BY ICHUNK
C
C
 1010	WRITE (LUNIT,110) INTARG(1)
	GO TO 5000
C
C
C   MSGNO=11  ICHUNK  FATAL ERROR - ERROR IN VRF DATA
C   VARIABLES JREC AND ITEMP ARE OUTPUT BY ICHUNK
C
C
 1011	WRITE (LUNIT,111) INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGNO=12  VRFPLT FATAL ERROR - INVALID VRF FILE
C
C
 1012	WRITE (LUNIT,112)
	GO TO 5000
C
C
C   MSGNO=13  VRFPLT  INFORMATIVE MESSAGE - OUTPUT STARTED
C
C
 1013	WRITE (LUNIT,113)
	GO TO 5000
C
C
C   MSGNO=14  BAND  NON-FATAL ERROR - STACK OVERFLOW, REUSABLE RECORDS
C		    LOST.  NUMBER OF RECORDS, STACK SIZE, AND OPTIMUM
C		    STACK SIZE ARE OUTPUT.
C
C
 1014	WRITE (LUNIT,114) INTARG(1),INTARG(2),INTARG(3)
	GO TO 5000
C
C
C   MSGNO=15  VRFPLT FATAL ERROR - COLOR PLOT TOO LONG FOR PLOTTER
C
C
 1015	WRITE (LUNIT,115)
	GO TO 5000
C
C
C   MSGNO=16  BAND  FATAL ERROR - MEMORY SIZE TOO SMALL, UNABLE TO
C                                 PARTITION ANY PLOT
C
C
 1016	WRITE (LUNIT,116)
	GO TO 5000
C
C
C   MSGNO=17  VRFPLT INFORMATIVE - PLOT TOO LONG, COPY COUNT TRUNCATED
C	                           TO: NNN
C
C
 1017	WRITE (LUNIT,117) INTARG(1)
	GO TO 5000
C
C
C    MSGNO=18 BAND INFORMATIVE - NUMBER OF BUFFERS NEEDED AND NUMBER OF
C                                BUFFERS AVAILABLE
C
C
 1018   WRITE (LUNIT,118) INTARG(1),INTARG(2)
	GO TO 5000
C
C
C   MSGLG2  NON-FATAL ERROR - ILLEGAL MESSAGE NUMBER
C
C
 4999	WRITE (LUNIT,100)
C
C   RETURN
C
 5000	RETURN
	END
