	SUBROUTINE NEWPEN(NPEN)
C
C	NAME: NEWPEN
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY:
C	REV. B	  5/ 7/84	FIX PROBLEM WITH UPDATING
C				ACTIVE COLORS TO NEW PEN WIDTH.
C
C		 6/11/84	OUTPUT NEWPEN COMMAND IF SAME
C				PEN WIDTH AND COLOR BUT
C				DIFFERENT PATTERN.
C		 6/18/84	OUTPUT NEWPEN COMMAND ONLY FOR ACTIVE
C				TONERS.
C
C	REV C
C		 2/21/85	NEWPEN NOW OUTPUTS SET-PEN COMMANDS
C				THAT CORRESPOND TO THE WIDTH OF THE
C				PEN, NOT THE PEN NUMBER.
C
C				CURPEN NOW USED TO HOLD THE WIDTH OF THE
C				CURRENT PEN FOR EACH TONER.
C
C				NEW VARIABLES ILWP, ILWM, DRWKNT, AND
C				DASHPN ARE NOW INITIALIZED.
C
C				JPEN IS ALWAYS SET TO NPEN IF NPEN IS
C				NOT EQUAL TO JPEN, EVEN IF THE
C				DEFINITIONS OF PEN NPEN AND PEN JPEN
C				ARE THE SAME.  (PREVIOUSLY THIS WASN'T
C				DONE, WHICH MEANT THAT IF THE USER THEN
C				CHANGED THE COLOR OR DEFINITION OF PEN
C				NPEN, HIS PLOT DIDN'T REFLECT THAT
C				CHANGE.)
C
C	NEWPEN - SELECT A PEN
C
C	SUBROUTINE NEWPEN IS USED TO SELECT A PEN.  LINES FROM NOW UNTIL
C	THE NEXT NEWPEN CALL WILL BE DRAWN WITH THE ATTRIBUTES OF THE
C	SELECTED PEN.  IF PEN 'NPEN' IS SELECTED WITHOUT BEING DEFINED
C	(SEE SUBROUTINE DEFPEN), WHERE 0<= 'NPEN' <=7, A SOLID LINE
C	'NPEN' NIBS THICK WILL BE DRAWN.
C
C	FOR COLOR RANDOM, SUBROUTINE NEWPEN WILL CHECK TO SEE IF THE
C	'NEW' PEN NEEDS TO BE DEFINED.  IF THE PEN WIDTH WAS MODIFIED
C	AT RUN TIME AND IS NOT THE SAME AS THE PEN NUMBER, AND IF
C	THE 'NEW' PEN HAS NOT BEEN PREVIOUSLY DEFINED A CALL TO
C	SUBROUTINE DEFPEN WILL BE MADE TO DEFINE THE 'NEW' PEN AS
C	A SOLID PEN (NO DASH PATTERN) WITH THE NEW WIDTH.
C
C	ENTRY: CALL NEWPEN(NPEN)
C
C		NPEN - SELECTED PEN# (0-7)
C		     <= 0 = PEN# 0
C		     <= 7 = PEN# 7
C
C		NOTE:  VERSAPLOT RANDOM ALLOWS THE USER TO DEFINE
C		       PENS 0-7, SEE SUBROUTINE DEFPEN.
C	EXIT: RETURN
C
C	CALLS: OCHUNK
C
C	CALLED BY: USER
C
C	COMMON USED:
C	/DVCOM/
C		L DASHPN  - .TRUE. IFF THE CURRENT PEN IS DEFINED AS
C		            AN ON-OFF-ON-OFF PATTERN
C		I ILWP    - (LINE WIDTH - 1)/2
C		I ILWM    - LINE WIDTH/2
C		L IPDEF() - .TRUE. IF PEN HAS BEEN DEFINED
C		I JPEN    - THE CURRENT PEN NUMBER
C		I KWIDTH  - WIDTH OF CURRENT PEN
C		I PENPAT()- ARRAY TO STORE PEN DEFINITIONS
C		L PMOVE   - STATUS OF LAST PLOT CALL (.TRUE.=MOVE)
C		I PWIDTH()- ARRAY WITH WIDTH OF EACH PEN
C
C	/PRMCOM/
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C		I MXPEN   - MAXIMUM PEN NUMBER TO BE ACTIVATED BY USER
C       /CLRCOM/
C		I CURPEN()- ARRAY CONTAINING CURRENT PEN NUMBER
C		            FOR EACH TONER
C               I ICLRDF()- ARRAY CONTAINING COLOR DEFINITIONS
C		I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C		I IVCFLG  - FLAG TO INDICATE COLOR MODE SET
C		I NCPASS  - NUMBER OF COLOR PASSES
C		I PCOLOR()- ARRAY WITH COLOR OF EACH PEN
C		L PENCHG  - FLAG TO INDICATE PEN COLOR CHANGED
C	/VRFCOM/
C		R DRWKNT  - BYTE COUNT FOR A DRAW COMMAND
C		R DRWMAX  - BYTE COUNT FOR A DRAW COMMAND WITH A PEN
C			    OF WIDTH GREATER THAN 1
C		R DRWMIN  - BYTE COUNT FOR A DRAW COMMAND WITH A PEN
C			    OF WIDTH AT MOST 1
C		I PRECIS  - COORDINATE PRECISION FOR THE VRF
C		            OUTPUT FILE (16 OR 32-BIT PRECISION)
C
C	/MSGCOM/
C		I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C
C	 LOCAL VARIABLES:
C		ICMD   - VDS SET-PEN COMMAND WORD
C		JPEN1  - JPEN + 1
C		NEWPN  - THE NEW PEN NUMBER
C		NEWPN1 - NEWPN + 1
C		PCLR   - NEW PEN COLOR
C		PWDTH  - NEW PEN WIDTH
C		NTNSEQ - THE NEW TONING SEQUENCE
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
	INCLUDE 'CLRCOM.CMN'
C
C
	INCLUDE 'VRFCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
	DIMENSION NTNSEQ(4)
	INTEGER PCLR,PWDTH
C
C...	SET-PEN COMMAND WORD (X'8301')
	DATA ICMD/33537/
C
C-D   DEBUG MESSAGE
C	 INTARG(1)=NPEN
C	 CALL MSGLG1(30)
C-D
C
C
C...	CHECK FOR ILLEGAL PEN
	NEWPN = NPEN
	IF (NEWPN .LT. 0)  NEWPN = 0
	IF (NEWPN .GT. MXPEN)  NEWPN = MXPEN
C
C...	CHECK IF SAME PEN
	IF (NEWPN .EQ. JPEN) RETURN
C
C...	INITIALIZE NEWPN1 AND JPEN1 FOR INDEXING INTO ARRAYS
	NEWPN1 = NEWPN + 1
	JPEN1  = JPEN + 1
C
C...	INITIALIZE NEW PEN WIDTH
	PWDTH = PWIDTH(NEWPN1)
C
C...	CHECK IF PEN COLOR CHANGED
	IF (IVCFLG .EQ. 0) GO TO 100
	IF (PCOLOR(NEWPN1) .EQ. PCOLOR(JPEN1)) GO TO 100
C
C...	  ** DIFFERENT PEN COLOR **
C
	    PENCHG = .TRUE.
	    PMOVE  = .TRUE.
C
C...	    UPDATE ITNSEQ FOR NEW COLOR
	    PCLR = PCOLOR(NEWPN1)
	    DO 50 I = 1,NCPASS
C
C...		SET UP NEW TONING SEQUENCE - STORE IT IN NTNSEQ
		ITNSEQ(I) = IABS(ITNSEQ(I))
		NTNSEQ(I) = ITNSEQ(I)
		IF (ICLRDF(NTNSEQ(I),PCLR) .EQ. 0)
     *		    NTNSEQ(I) = -NTNSEQ(I)
C
C...		TURN ON TONER IF PEN WIDTH IS CHANGED FOR THIS TONER
		IF (NTNSEQ(I) .LT. 0 .AND.
     *		    CURPEN(ITNSEQ(I)).NE.PWDTH) ITNSEQ(I)=-ITNSEQ(I)
C
   50	    CONTINUE
C
C...	    OUTPUT NEW PEN WIDTH FOR THOSE
C	    TONERS WHERE THE WIDTH CHANGED
	    CALL OCHUNK(ICMD,0)
	    CALL OCHUNK(PWDTH,0)
C
C...	    SET ITNSEQ TO THE TONING SEQUENCE FOR THE NEW PEN
	    DO 75 I = 1,NCPASS
		ITNSEQ(I) = NTNSEQ(I)
   75	    CONTINUE
C
	    GO TO 200
C
C...	  ** SAME PEN COLOR **
C
C...	    CHECK IF PEN WIDTH CHANGED
  100	    IF (PWIDTH(JPEN1) .EQ. PWDTH) GO TO 300
C
C...	    OUTPUT APPROPRIATE PEN TO THE CONTROLLER
	    CALL OCHUNK(ICMD,0)
	    CALL OCHUNK(PWDTH,0)
C
C...	UPDATE CURRENT PEN FOR ACTIVE TONERS
  200	DO 250 I = 1,NCPASS
	    IF (ITNSEQ(I) .LT. 0) CURPEN(-ITNSEQ(I)) = PWDTH
  250	CONTINUE
C
C...	UPDATE PEN WIDTH VARIABLES
	KWIDTH = PWDTH
	ILWP = (KWIDTH-1)/2
	ILWM = KWIDTH/2
C
C...	SET UP BYTES-PER-DRAW
	DRWKNT = DRWMIN
	IF (KWIDTH .EQ. 0) DRWKNT = 0.0
	IF (KWIDTH .GT. 1) DRWKNT = DRWMAX
C
C...	SET NEW CURRENT PEN
  300	JPEN = NEWPN
	DASHPN = .FALSE.
	IF (IPDEF(NEWPN1) .AND.
     *	  (PENPAT(2,NEWPN1)+PENPAT(4,NEWPN1)).NE.0) DASHPN=.TRUE.
C
	RETURN
C
	END
