	SUBROUTINE NUMBER(X,Y,HEIGHT,FPN,ANGLE,NDIG)
C
C	NAME: NUMBER
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C
C	NUMBER - PLOT NUMERIC VALUE
C
C	SUBROUTINE NUMBER CONVERTS A FLOATING POINT NUMBER INTO
C	INDIVIDUAL DIGITS AND PLOTS A SPECIFIED NUMBER OF THEM AS AN
C	ANNOTATION STRING ON THE PLOT.  THE SYMBOL ROUTINE IS CALLED
C	INITIALLY TO ACTUALLY PLOT THE DIGITS.
C
C	WHEN INTEGRATING NUMBER, THE DATA STATEMENT FOR IZERO SHOULD BE
C	SET TO THE INTERNAL REPRESENTATION FOR THE DIGIT ZERO (0) IN
C	YOUR COMPUTER.  THE VALUE 48 HAPPENS TO BE THE DIGIT ZERO VALUE
C	FOR AN ASCII ZERO ON THE PDP11.
C
C	ENTRY: CALL NUMBER(X,Y,HEIGHT,FPN,ANGLE,NDIG)
C
C		 (X,Y)  - IS THE STARTING COORDINATE DEFINING THE LOWER
C			  LEFT-HAND CORNER OF THE FIRST CHARACTER TO BE
C			  PRODUCED. FOR X AND/OR Y EQUAL TO 999.0
C			  SEE SUBROUTINE SYMBOL FOR DESCRIPTION.
C		 HEIGHT - CHARACTER HEIGHT(REAL)
C		 FPN    - NUMBER TO BE CONVERTED TO DIGITS
C			  AND PLOTTED(REAL)
C		 ANGLE  - ANGLE AT WHICH NUMERIC STRING IS TO BE PLOTTED
C			  IN DEGREES MEASURED FROM THE X-AXIS(REAL)
C		 NDIG   - SPECIFICATION OF THE NUMBER OF DIGITS AND
C			  THE TYPE OF NUMERIC STRING TO BE PLOTTED
C			  (INTEGER)
C		     >0 - NUMBER OF DIGITS TO THE RIGHT OF THE DECIMAL
C			  POINT TO BE PLOTTED (LAST DIGIT IS ROUNDED)
C		     =0 - ROUNDED INTEGER PORTION OF FPN IS PLOTTED
C			  WITH A DECIMAL POINT
C		    =-1 - ROUNDED INTEGER PORTION OF FPN IS PLOTTED
C			  WITHOUT THE DECIMAL POINT
C		    <-1 - ROUNDED INTEGER PORTION OF FPN IS PLOTTED
C			  AFTER HAVING THE LEAST SIGNIFICANT DIGITS
C			  TRUNCATED (ABS(NDEC)-1 DIGITS ARE TRUNCATED)
C
C	EXIT: RETURN
C
C	CALLS: SYMBOL
C
C	CALLED BY: USER
C
C	COMMON USED:
C
C	/MSGCOM/
C		I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C		R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C	LOCAL:
C	       I  IDIG  - THE CURRENT DIGIT IN PROCESS
C	       I  IPOINT- INTEGER VALUE OF DECIMAL POINT CHARACTER
C	       I  MINUS - INTEGER VALUE OF MINUS SIGN
C	       I  IZERO - THE INTEGER VALUE OF THE CHARACTER 'ZERO'
C	       I  ITEXT - ARRAY USED TO PASS NUMBERS TO SYMBOL
C	       I  ND    - DIGIT COUNT TEMPORARY
C	       I  NL    - WORKING COUNT OF NUMBER OF DIGITS TO THE LEFT
C			  OF THE DECIMAL POINT
C	       R  T1    - TEMPORARY FOR WORKING FLOATING POINT ARGUMENT
C	       R  T2    - TEMPORARY FOR DIGIT EXTRACTION
C	       R  XZ    - WORKING X COORDINATE
C	       R  YZ    - WORKING Y COORDINATE
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C
	LOGICAL*1 ITEXT,MINUS,IPOINT,IZERO
C
C...	LOCAL ARRAY TO STORE NUMBERS FOR SYMBOL CALL
	DIMENSION ITEXT(20)
	DATA NWRDS/20/
C
C-D    DEBUG MESSAGE
C	RELARG(1)=X
C	RELARG(2)=Y
C	RELARG(3)=HEIGHT
C	RELARG(4)=FPN
C	RELARG(5)=ANGLE
C	INTARG(1)=NDIG
C	CALL MSGLG1(31)
C-D
C
C
C...	NOTE...
C		THE FOLLOWING LINE OF CODE IS DEPENDENT ON THE CHARACTER
C		SET AND SHOULD BE CHANGED TO EQUAL THE DECIMAL INTEGER
C		VALUE FOR THE CHARACTERS:  0(ZERO), .(DECIMAL POINT),
C		AND -(MINUS SIGN).
C
	DATA IZERO/48/,IPOINT/46/,MINUS/45/
C
C
C...	INITIALIZE
	INDX = 1
	DO 8 I = 1,NWRDS
	ITEXT(I) = 0
    8	CONTINUE
C
C...	WORKING COPIES MADE OF THE NUMBER TO BE CONVERTED AND
C	THE COORDINATES.
	T1 = FPN
	XZ = X
	YZ = Y
C
C...	TEST THE NUMBER IF IT IS NON-NEGATIVE, NO MINUS SIGN SHOULD
C	BE PLOTTED.
C
C...	NUMBER NEGATIVE?        Y, N, N
	IF (T1)                10,20,20
C
C...	STORE MINUS SIGN IN BUFFER
   10	ITEXT(INDX) = MINUS
	INDX = INDX + 1
C
C...	MAKE WORKING NUMBER POSITIVE.
	T1 = -T1
C
C...	SET WORKING DIGIT COUNT
   20	ND = -NDIG
C
C...	TYPE OF CONVERSION CHECKED.
C
C...	INTEGER ONLY TO BE PLOTTED? Y, Y, N
	IF (NDIG)                  30,25,40
C
C...	ROUND AND TRUNCATE FOR FRACTION.
C	INTEGER WITH DECIMAL POINT TO BE PLOTTED.  WORKING DIGIT
C	COUNT SET TO 1 SO STATEMENT 30 WILL CONVERT IT TO A ZERO.
   25	ND = 1
C
C...	NO FRACTIONAL PART TO BE PLOTTED.  WORKING DIGIT COUNT ADJUSTED
C	TO ABS(NDEC)-1, THE NUMBER OF DIGITS TO BE TRUNCATED.
   30	ND = ND - 1
C
C...	THE NUMBER IS ADJUSTED SO THAT THE INTEGER PORTION IS JUST
C	WHAT IS TO BE PLOTTED.
	T2 = FLOAT (IFIX  ((T1 + 0.5)/(10.**ND))) + 0.5
C
C...	THE WORKING DIGIT COUNT IS SET FOR THE PLOTTABLE DIGIT COUNT
C	COMPUTATION AT 70.
	ND = 0
	IF (NDIG.EQ.0) ND = -1
	GO TO 50
C
C
C...	FRACTIONAL PART TO BE PLOTTED.
C	THE NUMBER IS ROUNDED AT THE APPROPIATE PLACE FOR THE NUMBER OF
C	FRACTION DIGITS REQUESTED.
   40	T2 = T1 + 0.5/(10.**NDIG)
C
C...	A WORKING COUNTER OF THE NUMBER OF DIGITS TO THE LEFT
C	OF THE DECIMAL POINT IS INITIALIZED.
   50	NL = 1
C
C...	IF THE NUMBER IS LESS THAN 10., THERE IS ONLY 1 DIGIT
C	REMAINING TO THE LEFT OF THE DECIMAL POINT.
   60	IF (T2.LT.10.) GO TO 70
C
C...	THE NUMBER IS GREATER THAN OR EQUAL TO 10. AND THUS HAS AT
C	LEAST TWO DIGITS REMAINING TO THE LEFT OF THE DECIMAL POINT.
C	IT IS DIVIDED BY 10. AND THE COUNT OF DIGITS TO THE LEFT OF
C	THE DECIMAL POINT IS INCREMENTED.
	T2 = T2/10.
	NL = NL + 1
	GO TO 60
C
C...	THE NUMBER OF DIGITS TO BE PLOTTED IS COMPUTED.
   70	INP = NL - ND
C
C...	THE NON-POSITIVE DIGIT COUNT IS FORCED TO 1.
	IF (INP.LE.0) INP = 1
C
C...	DO NOT PRINT MINUS SIGN IF NOT NEEDED BECAUSE
C	NEGATIVE NUMBER IS SO SMALL IN MAGNITUDE THAT
C	ALL DIGITS TO BE PRINTED ARE ZERO.
	NN = ND
	IF (NDIG .EQ. 0) NN = 0
	IF (T2 .LT. (10.0 ** NN)) INDX = 1
C
C...	THIS IS THE START OF THE DIGIT EXTRACTION AND PLOTTING
C	LOOP.  IF ALL DIGITS TO THE LEFT OF THE DECIMAL POINT
C	HAVE BEEN PLOTTED,  IT IS TIME TO PLOT THE DECIMAL POINT.
C
C...	TIME TO PLOT DECIMAL POINT? N, Y,  N
   80	IF (NL)                   100,90,100
C
C...	IF THERE IS TO BE NO DECIMAL POINT, ITS PLOTTING IS
C	BYPASSED.
   90	IF (NDIG.LT.0) GO TO 120
C
C...	STORE DECIMAL POINT IN BUFFER
	ITEXT(INDX) = IPOINT
	INDX = INDX + 1
C
C...	IF THERE ARE DIGITS TO BE PLOTTED TO THE RIGHT OF THE
C	DECIMAL POINT, INCREASE THE DIGIT COUNT TO MAKE UP FOR
C	THE DICIMAL POINT WHICH WILL BE COUNTED AT THE END OF THE
C	LOOP.
	IF (NDIG.NE.0) INP = INP + 1
	GO TO 110
C
C...	EXTRACT THE NEXT DIGIT TO BE PLOTTED.
C	SINCE THE INTEGER PORTION OF T2 IS ALWAYS LESS THAN 10., A
C	SINGLE DIGIT ONLY IS EXTRACTED.
  100	IDIG = T2
C
C...	SUBTRACT THE DIGIT JUST EXTRACTED (LEAVING A NUMBER LESS THAN
C	1.) AND SHIFT THE NEXT DIGIT INTO THE INTEGER PORTION OF T2.
	T2 = (T2 - FLOAT (IDIG))*10.
C
C...	CONVERT THE EXTRACTED DIGIT (IN BINARY) TO A RIGHT ADJUSTED
C	CHARACTER AND STORE IN BUFFER.
	ITEXT(INDX) = IDIG + IZERO
	INDX = INDX + 1
C
C...	COUNT THE PLOTTED DIGIT(OR DECIMAL POINT)
  110	INP = INP - 1
C
C...	COUNT A DIGIT PLOTTED TO THE LEFT OF THE DECIMAL POINT.
C	IF THE DECIMAL POINT HAS BEEN PLOTTED, THE COUNT IS
C	CONTINUED ANYWAY.  IT IS ONLY WHEN NL=0 THAT ITS ACTUAL
C	VALUE IS RELEVANT
  120	NL = NL - 1
C
C...	MORE DIGITS TO PLOT?
	IF (INP.GT.0) GO TO 80
C
C...	NO, CALL SYMBOL AND RETURN
	NC = INDX - 1
  140	CALL SYMBOL(X,Y,HEIGHT,ITEXT,ANGLE,NC)
C
	RETURN
C
	END
