	SUBROUTINE PAPER (XMINN,XMAXX,YMINN,YMAXX)
C
C	NAME:  PAPER
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	PAPER - CALLED TO SET THE DEFAULT PAPER BOUNDARIES
C
C	PAPER IS CALLED BY THE USER TO SPECIFY THE BOUNDARIES OF THE
C	PLOTTING AREA FOR THE CURRENT JOB.  THIS INSURES THAT ALL
C	SUBSEQUENT SUBROUTINE VPORT CALLS SPECIFY A VIEWPORT WITHIN
C	THE PLOTTING AREA.
C
C	THE PAPER CALL ARGUMENTS ARE USED TO SET THE DEFAULT VIEWPORT
C	AND WINDOW DIMENSIONS.  THE USER CAN ALSO CALL VPORT OR WINDOW
C	TO OVERRIDE THESE VALUES.
C
C	FOR ROTATED PLOTS, THERE CAN BE LARGE BLANK AREA PRECEEDING
C	THE PLOT OUTPUT.  THIS BECAUSE THE VIEWPORT IS ROTATED USING
C	THE MAXIMUM 'Y' PAPER DIMENSION TO ALLOW FOR MULTIPLE
C	VIEWPORTS.  THE LENGTH OF THE BLANK AREA CAN BE MINIMIZED
C	BY SPECIFYING A SMALLER MAXIMUM 'Y' PAPER BOUNDARY.
C
C
C	*NOTE:  PAPER MUST BE CALLED BEFORE SUBROUTINE PLOTS
C	        IS CALLED AND CALLED ONLY ONCE PER JOB.
C
C
C	ENTRY:  CALL PAPER(XMINN,XMAXX,YMINN,YMAXX)
C
C		XMINN - MINIMUM X EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE POSITIVE).
C		XMAXX - MAXIMUM X EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE .GT. ZERO).
C		YMINN - MINIMUM Y EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE POSITIVE).
C		YMAXX - MAXIMUM Y EXPRESSED IN TERMS OF THE DEFINED
C                       'UNITS' OF MEASURE (MUST BE .GT. ZERO).
C
C	EXIT:  PXMIN,PXMAX,PYMIN,PYMAX IN DVCOM COMMON UPDATED,
C	       VXMIN,VXMAX,VYMIN,VYMAX,WXMIN,WXMAX,WYMIN,WYMAX IN
C	       PRMCOM COMMON UPDATED.
C
C	CALLS:  NONE
C
C	CALLED BY:  USER
C
C	COMMON USED:
C	/DVCOM/
C		I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C		I PXMAX   - PAPER MAXIMUM 'X' DIMENSION
C		I PXMIN   - PAPER MINIMUM 'X' DIMENSION
C		I PYMAX   - PAPER MAXIMUM 'Y' DIMENSION
C		I PYMIN   - PAPER MINIMUM 'Y' DIMENSION
C
C	/PRMCOM/
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C		R VXMIN   - DEFAULT MINIMUM X VIEWPORT COORDINATE.
C		R VXMAX   - DEFAULT MAXIMUM X VIEWPORT COORDINATE.
C		R VYMIN   - DEFAULT MINIMUM Y VIEWPORT COORDINATE.
C		R VYMAX   - DEFAULT MAXIMUM Y VIEWPORT COORDINATE.
C		R WXMIN   - DEFAULT MINIMUM X WINDOW COORDINATE.
C		R WXMAX   - DEFAULT MAXIMUM X WINDOW COORDINATE.
C		R WYMIN   - DEFAULT MINIMUM Y WINDOW COORDINATE.
C		R WYMAX   - DEFAULT MAXIMUM Y WINDOW COORDINATE.
C
C	 LOCAL:  NONE
C
C
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
C
C...	CHECK IF PLOTS ALREADY CALLED
	IF (IOPEN .NE. 0)  RETURN
C
C...	SET COMMON VARIABLES
	PXMIN = XMINN
	PXMAX = XMAXX
	PYMIN = YMINN
	PYMAX = YMAXX
C
C...	SET VIEWPORT/WINDOW DIMENSIONS IF NECESSARY
	VXMIN = PXMIN
	VXMAX = PXMAX
	VYMIN = PYMIN
	VYMAX = PYMAX
	WXMIN = PXMIN
	WXMAX = PXMAX
	WYMIN = PYMIN
	WYMAX = PYMAX
	RETURN
C
	END
