	PROGRAM RDUMP
C	NAME:  RDUMP
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY:
C	REV. B	 7/15/84	VARIABLE TSTFBL MISSPELLED AS TSTFGL
C				IN TWO PLACES.
C
C		 9/28/84	SUPPORT DATA STANDARDS COPY COUNT.
C
C	RDUMP - DUMP THE VRF DATA FILE
C
C	RDUMP OUTPUTS A FORMATTED DUMP OF THE VRF DATA FILE
C	GENERATED BY VERSAPLOT-RANDOM. RDUMP LISTS ALL COMMANDS
C	GENERATED WITH PARAMETERS.
C
C
C	CALLS: IAND,IRAM,ICHUNK,RIOPKG
C
C	COMMON USED:
C	/IOCOM/
C		I LUNIT   - LOGICAL UNIT NUMBER OF LISTING DEVICE
C		I IUNIT   - LOGICAL UNIT NUMBER OF VERSAPLOT DATA FILE
C		I LREC    - LENGTH OF DATA FILE RECORD IN WORDS
C	/RDPCOM/
C		L EOF     - FLAG INDICATING END-OF-DATA IN BAND
C		            HAS BEEN REACHED
C		I IBUF    - VRF INPUT BUFFER
C		I MAXI    - POINTER TO END OF INPUT BUFFER
C		I NCHUNK  - NUMBER OF 16-BIT CHUNKS PER OUTPUT WORD
C		I NEXTI   - POINTER TO INPUT BUFFER
C		I PRECIS  - VRF PRECISION (16 OR 32-BIT)
C
C
C	LOCAL VARIABLES USED:
C
C
C
	INCLUDE 'IOCOM.CMN'
C
C
	INCLUDE 'RDPCOM.CMN'
C
C
C
C
C
	DIMENSION IAULFT(30),IAURGT(30),IPCA(4)
	DIMENSION ICAENT(60)
	INTEGER ISIZE,HREC,BNDFLG,XMIN,IDATA,ICOM,MSK8,IBIT8,MSK7
	INTEGER IC0,NSKIP,IC2,IC506,I83,MSBIT,NMSBIT,IDENS,ISCAN
	INTEGER MBIT16,NMBT16,I84,MBIT32,NMBT32,NPARAM,ITONE
	INTEGER I,J,NH,PI,S1,S2,S3,S4,W,IX,IY,N,CPX,CPY,TX,TY
	INTEGER ICRCLE,IMVDRW,IPOLYG,ITXT
	INTEGER R,H,NWORD,FP,NPTS,NC,ISPACE,XB,YB,PFONT
	INTEGER CANSTX,CANSOH,BYTKNT
	LOGICAL PDUMP
	INTEGER ITEXT(508),IPAT(16)
C
	INTEGER CHARY,CHARN,YN
C
	REAL PART,MOVE,DRAW,TEXT,POLY,SETFBL,CIRCLE,SETFOT,DEFPEN
	REAL DEFFIL,SETPEN,COUNT,DRWMAX,DRWMIN,DRWKNT
	DIMENSION CHRKNT(128,6)
	DIMENSION CH1KNT(128),CH2KNT(128),CH3KNT(128)
	DIMENSION CH4KNT(128),CH5KNT(128),CH6KNT(128)
	EQUIVALENCE (CHRKNT(1,1),CH1KNT(1))
	EQUIVALENCE (CHRKNT(1,2),CH2KNT(1))
	EQUIVALENCE (CHRKNT(1,3),CH3KNT(1))
	EQUIVALENCE (CHRKNT(1,4),CH4KNT(1))
	EQUIVALENCE (CHRKNT(1,5),CH5KNT(1))
	EQUIVALENCE (CHRKNT(1,6),CH6KNT(1))
	INTEGER VRFKNT,DRWELM
C
	INTEGER*4 ITEMPL
	INTEGER*2 ITEMPW(2)
	EQUIVALENCE (ITEMPL,ITEMPW(1))
	DATA IESCR/39767/,IC506/50438/
	DATA IESCK/39755/
	DATA ICC/204/
	DATA MSK8/255/,IBIT8/128/,IC0/192/,MSK7/127/
	DATA IC2/194/,I83/131/,I84/132/
	DATA ISPACE/32/
	DATA CANSOH/6145/
	DATA CHARY/1HY/,CHARN/1HN/
	DATA MBIT16/32768/,NMBT16/32767/
	DATA MBIT32/-2147483648/,NMBT32/2147483647/
	DATA MSKLO/65535/,MSKUP/-65536/,MSKHI/-16777216/
C
C    TABLE OF THE NUMBER OF STROKES IT TAKES TO DRAW
C    EACH CHARACTER IN THE CHARACTER TABLE.
C
C    THIS TABLE IS FOR THE DEFAULT FONT.
C
	DATA  CH1KNT /7.,11., 5., 3., 3., 6., 6., 5., 8., 3.,
     +                9., 6., 5., 3., 7., 1., 1., 0., 2., 3.,
     +                4., 0., 3., 3., 1., 0., 1., 7., 5., 2.,
     +                5.,10., 0., 4., 6.,10.,11., 9., 9., 3.,
     +                3., 3., 4., 2., 5., 1., 4., 1., 8., 3.,
     +                8.,12., 3., 9.,10., 4.,15.,10., 8., 9.,
     +                2., 2., 2.,11.,15., 7.,11., 7., 6., 5.,
     +                4.,10., 3., 3., 5., 3., 2., 4., 3., 9.,
     +                6., 9., 7.,12., 2., 5., 2., 4., 2., 3.,
     +                4., 3., 1., 3., 2., 1., 8., 8., 8., 3.,
     +                9., 9., 7., 0., 8., 4.,13.,11., 0., 0.,
     +                0., 0., 4., 9., 3., 3., 3., 3., 3., 1.,
     +                5., 4., 0., 0., 4., 2., 4., 4./
C
C    2ND FONT - SIMPLEX
C
	DATA  CH2KNT /0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
     +                0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
     +                0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
     +                0., 0., 0., 5., 2., 4.,21.,26.,33., 1.,
     +                9., 9., 3., 2., 7., 1., 4., 1.,16., 3.,
     +               13.,14., 3.,16.,22., 2.,28.,22., 8.,11.,
     +                2., 2., 2.,17.,25., 3.,18.,17.,12., 4.,
     +                3.,19., 3., 1., 9., 3., 2., 4., 3.,20.,
     +               10.,21.,11.,19., 2., 9., 2., 4., 2., 3.,
     +                3., 4., 1., 4., 7., 1., 3.,14.,14.,13.,
     +               14.,16., 5.,19., 7., 5., 8., 3., 1.,13.,
     +                7.,16.,14.,14., 5.,16., 5., 7., 2., 4.,
     +                2., 6., 3.,34., 1.,34.,12., 0./
C
C    3RD FONT - FRENCH
C
	DATA  CH3KNT /0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
     +                0., 0., 0., 0., 0., 0.,16.,15.,15.,30.,
     +               18.,17.,17.,32.,18., 3.,17.,18.,32., 9.,
     +                8.,23., 0., 5., 2., 4.,21.,26.,33., 1.,
     +                9., 9., 3., 2., 7., 1., 4., 1.,16., 3.,
     +               13.,14., 3.,16.,22., 2.,28.,22., 8.,11.,
     +                2., 2., 2.,17.,25., 3.,18.,17.,12., 4.,
     +                3.,19., 3., 1., 9., 3., 2., 4., 3.,20.,
     +               10.,21.,11.,19., 2., 9., 2., 4., 2., 3.,
     +                3., 4., 1., 4., 7., 1., 3.,14.,14.,13.,
     +               14.,16., 5.,19., 7., 5., 8., 3., 1.,13.,
     +                7.,16.,14.,14., 5.,16., 5., 7., 2., 4.,
     +                2., 6., 3.,34., 1.,34.,12., 0./
C
C    4TH FONT - SWEDISH
C
	DATA  CH4KNT /7.,11., 5., 3., 3., 6., 6., 5., 8., 3.,
     +                9., 6., 5., 3., 7., 1., 1., 0., 2., 3.,
     +                4., 0., 3., 3., 1., 0., 1., 7., 5., 2.,
     +                5.,10., 0., 4., 6.,10.,11., 9., 9., 3.,
     +                3., 3., 4., 2., 5., 1., 4., 1., 8., 3.,
     +                8.,12., 3., 9.,10., 4.,15.,10., 8., 9.,
     +                2., 2., 2.,11.,15., 7.,11., 7., 6., 5.,
     +                4.,10., 3., 3., 5., 3., 2., 4., 3., 9.,
     +                6., 9., 7.,12., 2., 5., 2., 4., 2., 3.,
     +                4.,15.,16.,11.,13., 1., 8., 8., 8., 3.,
     +                9., 9., 7., 0., 8., 4.,13.,11., 0., 0.,
     +                0., 0., 4., 9., 3., 3., 3., 3., 3., 1.,
     +                5., 4., 0., 0., 4., 2., 4., 4./
C
C    5TH FONT - GERMAN
C
	DATA  CH5KNT /5., 9., 4., 2., 2., 5., 4., 3., 4., 3.,
     +                8., 4., 4., 1., 7., 1., 1., 0., 8., 3.,
     +               19., 0., 3., 3., 8., 0., 6., 3., 3., 1.,
     +               10., 6., 0., 5., 2., 4.,12.,17.,14., 1.,
     +                5., 5., 4., 2., 2., 1., 4., 1.,12., 2.,
     +                8.,13., 3., 9.,13., 3.,23.,13., 8., 6.,
     +                2., 2., 2.,11.,18., 3.,13., 7., 8., 4.,
     +                3., 9., 3., 1., 4., 3., 2., 4., 3.,12.,
     +                8.,13., 9.,13., 2., 7., 2., 4., 2., 3.,
     +                3.,11.,20.,15., 2., 1., 1., 9., 8., 7.,
     +                8.,11., 4.,11., 5., 5., 7., 3., 1., 6.,
     +                5.,12., 8., 8., 4.,11., 2., 5., 2., 4.,
     +                2., 3., 3.,17.,20.,13.,10., 7./
C
C    6TH FONT - NORWEGIAN
C
	DATA  CH6KNT /7.,11., 5., 3., 3., 6., 6., 5., 8., 3.,
     +                9., 6., 5., 3., 7., 1., 1., 0., 2., 3.,
     +                4., 0., 3., 3., 1., 0., 1., 7., 5., 2.,
     +                5.,10., 0., 4., 6.,10.,11., 9., 9., 3.,
     +                3., 3., 4., 2., 5., 1., 4., 1., 8., 3.,
     +                8.,12., 3., 9.,10., 4.,15.,10., 8., 9.,
     +                2., 2., 2.,11.,15., 7.,11., 7., 6., 5.,
     +                4.,10., 3., 3., 5., 3., 2., 4., 3., 9.,
     +                6., 9., 7.,12., 2., 5., 2., 4., 2., 3.,
     +                4., 6., 9.,11., 2., 1., 8., 8., 8., 3.,
     +                9., 9., 7., 0., 8., 4.,13.,11., 0., 0.,
     +                0., 0., 4., 9., 3., 3., 3., 3., 3., 1.,
     +                5., 4., 0., 0., 4., 2., 4., 4./
C
    1	FORMAT (19X,8HVRF DUMP//12X,23HFILE AFTER PARTITIONING/)
    2	FORMAT (19X,8HVRF DUMP//12X,24HFILE BEFORE PARTITIONING/)
    3	FORMAT (1X,14HWORD IN RECORD,/1X,14H 7 FILE SIZE: ,15X,I12,
     X		8H RECORDS)
    4	FORMAT (1X,
     X /47H **********************************************,
     X /28H * PARTITION HEADER NUMBER: ,11X,I6,2H *,
     X /17H * WORD IN RECORD,29X,1H*,
     X /25H *  1 FIRST DATA RECORD: ,14X,I6,2H *,
     X /32H *  3 PARTITION FLAG: (0=SORTED),11X,I2,2H *,
     X /36H *  5 NEXT PARTITION HEADER RECORD: ,3X,I6,2H *,
     X /37H *  7 STARTING X-VALUE OF PARTITION: ,I8,2H *,
     X /28H *  9 CONTROL ARRAY RECORD: ,7X,I10,2H *,
     X /19H * 11 PLOT NUMBER: ,22X,I4,2H *,
     X /24H * 12 NUMBER OF COPIES: ,18X,I3,2H *,
     X /26H * 13 NUMBER OF ELEMENTS: ,10X,I9,2H *,
     X /35H * 15 ENDING X-VALUE OF PARTITION: ,1X,I9,2H *,
     X /25H * 17 PARTITIONING FLAG: ,10X,I10,2H *,
     X /40H * 21 NUMBER OF AUTHOR TEXT CHARACTERS: ,I5,2H *,
     X /28H * 53 PARTITION BYTE COUNT: ,7X,I10,2H *,
     X /25H * 55 COPY COMMAND FLAG: ,10X,I10,2H *,
     X /22H * 56 PAPER CUT FLAG: ,13X,I10,2H *,
     X /19H * 57 PLOT LENGTH: ,16X,I10,2H *)
    5	FORMAT (1X,26HWORDS 22 - 51 AUTHOR TEXT:,/1X,60A1)
    6	FORMAT (1X,20H** ERROR IN VRF DATA/5X,
     X          15HRECORD NUMBER= ,I6/5X,
     X          7HINDEX= ,I6/5X,
     X          //,125(1X,8(Z4,1X),/),/)
    7	FORMAT (1X,17HFORM-FEED COMMAND)
    8	FORMAT (1X,10HBEGIN-VRF ,I2,15H-BIT PRECISION:,
     X          /5X,7HIDENS= ,I10,7X,8H ISCAN= ,I10)
    9	FORMAT (1X,15HEND-VRF COMMAND)
   10	FORMAT (1X,29HBEGIN-PARTITION: VRF HEIGHT= ,7X,I10)
   11	FORMAT (1X,18HDEFINE-PEN COMMAND/5X,5HPEN= ,I9,
     X          /5X,4HS1= ,I10/5X,4HS2= ,I10/5X,4HS3= ,I10,
     X          /5X,4HS4= ,I10/5X,3HW= ,I11)
   12	FORMAT (1X,14HSET PEN: PEN= ,I10)
   13	FORMAT (1X,14HBEGIN MACRO # ,I3)
   14	FORMAT (1X,9HEND MACRO)
   15	FORMAT (1X,12HCALL MACRO #,I3/5X,4HTX= ,I10,5H TY= ,I10)
   16	FORMAT (1X,19HDEFINE FILL-PATTERN/5X,15HPATTERN INDEX= ,I4,
     X          /5X,7HWIDTH= ,8X,I4/5X,8HHEIGHT= ,7X,I4/5X,
     X          13HFILL PATTERN:)
   17	FORMAT (5X,4HROW(,I2,3H): ,16(Z4,1X))
   18	FORMAT (1X,16HDRAW POLYGON OF ,I3,21H VERTICES USING FILL ,
     X          7HPATTERN,1X,I3/5X,21HFROM CURRENT POSITION)
   19	FORMAT (5X,8HMOVE TO ,I10,2H, ,I10)
   20	FORMAT (5X,8HDRAW TO ,I10,2H, ,I10)
   21	FORMAT (1X,15HTEXT STRING OF ,I3,11H CHARACTERS/5X,
     X          15HTEXT (DECIMAL):,27(/4X,19(I3,1X)))
   22	FORMAT (5X,13HTEXT (ASCII):,7(/5X,75A1))
   23	FORMAT (1X,13HSET FONT TO #,I2)
   24	FORMAT (1X,23HSET FONT BASELINE: XB= ,I10,5H YB= ,I10)
   25	FORMAT (1X,17HLEVEL II SKIP OF ,I3,7H CHUNKS)
   26	FORMAT (1X,27HDRAW CIRCLE WITH RADIUS OF ,I10/5X,
     X          20HFILL PATTERN INDEX= ,I3/5X,
     X          15HOUTLINE WIDTH= ,I2)
   27	FORMAT (1X,8HMOVE TO ,I10,2H, ,I10)
   28	FORMAT (1X,8HDRAW TO ,I10,2H, ,I10)
   29	FORMAT (1X,15HEND OF VRF FILE)
   30	FORMAT (1X,16HLEVEL I SKIP OF ,I3,6H BYTES)
C
   31	FORMAT (1X,25HFULL DUMP OUTPUT? (Y/N): )
   32	FORMAT(A1)
   33	FORMAT (1X,29HTOTAL NUMBER OF PARTITIONS = ,F10.0)
   34	FORMAT (1X,38HCURRENT PARTITION TOTAL VRF COMMANDS: )
   35	FORMAT (3X,15HMOVES =        ,F10.0)
   36	FORMAT (3X,15HDRAWS =        ,F10.0)
   37	FORMAT (3X,15HDEFPENS =      ,F10.0)
   38	FORMAT (3X,15HSETPENS =      ,F10.0)
   39	FORMAT (3X,15HPOLYGONS =     ,F10.0)
   40	FORMAT (3X,15HCIRCLES =      ,F10.0)
   41	FORMAT (3X,15HTEXT STRINGS = ,F10.0)
   42	FORMAT (3X,20HSET-FONT BASELINE = ,F5.0)
   43	FORMAT (3X,15HSET-FONT =     ,F10.0)
   44	FORMAT (3X,15HDEFPAT =       ,F10.0)
   45	FORMAT (1X,29H** PLOT TOTAL VRF COMMANDS **)
   46	FORMAT (1X,29H** MIN/MAX X,Y COORDINATES = ,4(I10))
   47	FORMAT (1X,25H** TOTAL ELEMENT COUNT = ,4X,F10.0)
   48	FORMAT (1X,47HENTER FIRST/LAST PARTITION TO DUMP (I.E. 1,99):)
   49	FORMAT (2I6)
   50	FORMAT(1X,31H 2 PARTITION FLAG (0=SORTED) = ,8X,I10,
     X /1X,41H 3 MAX. ELEMENT COUNT FOR PARTITIONING = ,F8.0)
   51	FORMAT (1X,23HCURRENT RECORD NUMBER= ,17X,I6)
   52	FORMAT (1X,22HCOLOR HEADER PREAMBLE:)
   53	FORMAT (3X,14HPLOT LENGTH = ,I6)
   54	FORMAT (3X,13HCOLOR = BLACK)
   55	FORMAT (3X,12HCOLOR = CYAN)
   56	FORMAT (3X,15HCOLOR = MAGENTA)
   57	FORMAT (3X,14HCOLOR = YELLOW)
   58	FORMAT (3X,11HSINGLE PASS)
   59	FORMAT (3X,10HFIRST PASS)
   60	FORMAT (3X,17HINTERMEDIATE PASS)
   61	FORMAT (1X,23HPLOTTER SPEED CONTROL= ,F5.3,4H IPS)
   62	FORMAT (1X,33HPLOTTER SPEED CONTROL= FULL SPEED)
   63	FORMAT (1X,22HPLOTTER REWIND COMMAND)
   64	FORMAT (1X,43HUNABLE TO PROCESS, INCORRECT VERSION NUMBER)
   65	FORMAT (41H- INPUT VARIABLES ARE INCORRECT TRY AGAIN)
   66	FORMAT (1X,35HDATA STANDARDS COPY COMMAND: COUNT=,I6,
     X             8H LENGTH=,I14)
   67	FORMAT (1X,20H 5 VERSION NUMBER = ,19X,I10,
     X /1X,35H 9 FIRST PARTITION HEADER RECORD = ,4X,I10,
     X /1X,23H13 OUTPUT CONTROLLER = ,16X,I10,
     X /1X,28H14 INITIAL FORM-FEED FLAG = ,11X,I10,
     X /1X,37H15 FORM-FEED/SPACE AFTER EACH PLOT = ,2X,I10,
     X /1X,37H16 FORM-FEED/SPACE AFTER EACH COPY = ,2X,I10,
     X /1X,25H17 LAST FORM-FEED FLAG = ,14X,I10,
     X /1X,19H18 NIBS PER INCH = ,20X,F10.0,
     X /1X,20H19 BYTES PER SCAN = ,19X,I10,
     X /1X,29H20 MULTIPLEXER PORT NUMBER = ,10X,I10)
   68	FORMAT (1X,23H21 LINE ENHANCE FLAG = ,16X,I10,
     X /1X,24H22 INVERSE IMAGE FLAG = ,15X,I10,
     X /1X,23H23 MIRROR IMAGE FLAG = ,16X,I10,
     X /1X,32H24 RASTER DATA TRANSLATE FLAG = ,7X,I10,
     X /1X,24H25 SPEED CONTROL FLAG = ,15X,I10,
     X /1X,15H26 DISK FLAG = ,24X,I10,
     X /1X,20H27 RDEN PER UNITS = ,19X,I10,
     X /1X,30H28 CONTROLLER CONFIGURATION = ,9X,I10,
     X /1X,21H29 RPM MEMORY SIZE = ,18X,I10,
     X /1X,19H31 VRF PRECISION = ,20X,I10,
     X /1X,22H32 TAPE OUTPUT FLAG = ,17X,I10)
   69	FORMAT (1H )
   70	FORMAT (1X,33HNUMBER OF CONTROL ARRAY ENTRIES: ,3X,I10,
     X		/1X,29HFIRST WORD IN CONTROL ARRAY: ,13X,4A1)
   71	FORMAT (1X,23HREST OF CONTROL ARRAY: ,
     X		/9(1X,6I10/),1X,6I10)
   72	FORMAT (35H * 18 PLOT LENGTH AND COLOR FLAG:  ,I10,2H *,
     X	/30H * 19 NUMBER OF COLOR PASSES: ,5X,I10,2H *,
     X	/20H * 20 TONER NUMBER: ,15X,I10,2H *)
   73	FORMAT (1X,22H** TOTAL BYTE COUNT = ,7X,F10.0)
   74	FORMAT (1X,23HOUTPUT CIRCLES? (Y/N): )
   75	FORMAT (1X,20HOUTPUT TEXT? (Y/N): )
   76	FORMAT (1X,26HOUTPUT MOVE/DRAWS? (Y/N): )
   77	FORMAT (1X,24HOUTPUT POLYGONS? (Y/N): )
   78	FORMAT (1X,30HCHANGE RDUMP 'WINDOW'? (Y/N): )
   79	FORMAT (1X,44HENTER MIN X, MAX X, MIN Y AND MAX Y VALUES: )
   80	FORMAT (47H **********************************************)
   81	FORMAT (1X,27HPAPER CUT IMMEDIATE COMMAND)
C
C
C
C...	INITIALIZE COMMON
C-W	*****  SYSTEM DEPENDENT VARIABLES  *****
C
C...	INITIALIZE DISK RECORD SIZE
	LREC = 2048
C
C...	INITIALIZE VERSAPLOT DATA FILE LOGICAL UNIT NUMBER
	IUNIT = 1
C
C...	INITIALIZE INPUT FILE
	KUNIT = 5
C
C...	INITIALIZE FULL DUMP OUTPUT FILE
	LUNIT = 6
C-W	****************************************
	CANSTX = 6146
	EOF = .FALSE.
	NCHUNK = 1
C
C...	INIT COMMON
	MINX = NMBT32
	MINY = NMBT32
	MAXX = 0
	MAXY = 0
C
	BNDKNT = 0.0
	BNDBYT = 0.0
	ICURB = 0
	ISTART = 0
	IBEND = 99999
	LSTPLT = 0
	STARTD = .TRUE.
C
C...	INIT PLOT TOTALS
	TOTKNT = 0.0
	TOTBYT = 0.0
	TMOVE = 0.0
	TDRAW = 0.0
	TTEXT = 0.0
	TPOLY = 0.0
	TSTFBL = 0.0
	TSTFOT = 0.0
	TSTPEN = 0.0
	TDFPEN = 0.0
	TDFFIL = 0.0
	TCIRCL = 0.0
	IPLOT = 0
C
C...	INITIALIZE INDEX FOR CHARACTER STROKE COUNT
	PFONT = 1
C
C...	INIT COUNTERS FOR CURRENT PARTITION
	PART = 0.0
	MOVE = 0.0
	DRAW = 0.0
	TEXT = 0.0
	POLY = 0.0
	SETFBL = 0.0
	SETFOT = 0.0
	SETPEN = 0.0
	DEFPEN = 0.0
	DEFFIL = 0.0
	CIRCLE = 0.0
C
C...	READ IN FILE HEADER RECORD
	CALL ROPEN(2)
	CALL RREAD (IBUF(1),1)
	CALL RWAIT
	PRECIS = IBUF(31)
C
C...	CHECK IF FULL DUMP OUTPUT
	SDUMP = .TRUE.
	FDUMP = .TRUE.
	PDUMP = .TRUE.
	ICRCLE = 1
	ITXT = 1
	IMVDRW = 1
	IPOLYG = 1
	IMINX = 0
	IMINY = 0
	IMAXX = NMBT16
	IMAXY = NMBT16
	IF (PRECIS .EQ. 16) GO TO 100
	IMAXX = NMBT32
	IMAXY = NMBT32
  100	TYPE 31
	READ (KUNIT,32) YN
	IF (YN .EQ. CHARY) GO TO 110
	IF (YN .NE. CHARN) GO TO 100
	SDUMP = .FALSE.
	FDUMP = .FALSE.
C
C...	CHECK IF SPECIFYING CIRCLES, TEXT, MOVES/DRAWS AND POLYGONS
  101	TYPE 74
	READ (KUNIT,32) YN
	IF (YN .EQ. CHARY) GO TO 102
	IF (YN .NE. CHARN) GO TO 101
	ICRCLE = 0
  102	TYPE 75
	READ (KUNIT,32) YN
	IF (YN .EQ. CHARY) GO TO 103
	IF (YN .NE. CHARN) GO TO 102
	ITXT = 0
  103	TYPE 76
	READ (KUNIT,32) YN
	IF (YN .EQ. CHARY) GO TO 104
	IF (YN .NE. CHARN) GO TO 103
	IMVDRW = 0
  104	TYPE 77
	READ (KUNIT,32) YN
	IF (YN .EQ. CHARY) GO TO 105
	IF (YN .NE. CHARN) GO TO 104
	IPOLYG = 0
C
C...	CHECK IF SPECIFYING 'WINDOW' TO RDUMP
  105	TYPE 78
	READ (KUNIT,32) YN
	IF (YN .EQ. CHARN) GO TO 110
	IF (YN .NE. CHARY) GO TO 105
  106	TYPE 79
	READ (KUNIT,*) IMINX,IMAXX,IMINY,IMAXY
	IF ((IMINX .LT. 0) .OR. (IMINX .GE. IMAXX)) GO TO 107
	IF ((IMINY .LT. 0) .OR. (IMINY .GE. IMAXY)) GO TO 107
	IF (PRECIS .EQ. 32) GO TO 108
	IF ((IMAXX .LE. NMBT16) .AND. (IMAXY .LE. NMBT16)) GO TO 110
  107	WRITE (LUNIT,65)
	GO TO 106
  108	IF ((IMAXX .GT. NMBT32) .OR. (IMAXY .GT. NMBT32)) GO TO 107
C
C
C...	GET FIRST/LAST PARTITION # TO DUMP
  110	TYPE 48
	READ (KUNIT,49) ISTART,IBEND
	IF (ISTART .GT. 0)  GO TO 112
	IF (ISTART .LE. IBEND)  GO TO 112
	WRITE(LUNIT,65)
	GO TO 110
C
C...	CHECK IF NOT STARTING AT PARTITION #1
  112	IF (ISTART .EQ. 1)  GO TO 115
C
C...	TURN OFF FULL DUMP FLAG UNTIL ISTART IS REACHED
	SDUMP = FDUMP
	FDUMP = .FALSE.
	PDUMP = .FALSE.
	STARTD = .FALSE.
  115	CONTINUE
C
C...	OPEN THE VRF FILE
C
C...	GET DATA FROM FILE HEADER RECORD
	ITEMPW(1) = IBUF(5)
	ITEMPW(2) = IBUF(6)
	IF (ITEMPL .EQ. 102) GO TO 195
	WRITE(LUNIT,64)
	STOP
  195   CONTINUE
C
C...	HAS VRF FILE BEEN PARTITIONED?
	IF (IBUF(2).NE.0) GO TO 200
	WRITE (LUNIT,1)
	GO TO 250
C
  200	WRITE (LUNIT,2)
C
C...	GET SIZE OF FILE
  250	ITEMPW(1) = IBUF(7)
	ITEMPW(2) = IBUF(8)
	ISIZE = ITEMPL
	WRITE (LUNIT,3) ISIZE
	HREC = 2
	LEVEL = 1
	ITEMPW(1) = IBUF(3)
	ITEMPW(2) = IBUF(4)
	MAXELM = ITEMPL
	ISORT = IBUF(2)
	WRITE (LUNIT,50) ISORT,MAXELM
C
C...	GET REST OF FILE HEADER BAND
	ITEMPW(1) = IBUF(5)
	ITEMPW(2) = IBUF(6)
	IVER   = ITEMPL
	ITEMPW(1) = IBUF(9)
	ITEMPW(2) = IBUF(10)
	IPHPTR = ITEMPL
	KREP   = IBUF(13)
	INITFF = IBUF(14)
	IFFAP  = IBUF(15)
	ISPCE  = IBUF(16)
	LASTFF = IBUF(17)
	RDEN   = IBUF(18)
	IBYTES = IBUF(19)
	MUXOUT = IBUF(20)
	INHNCE = IBUF(21)
	INVERS = IBUF(22)
	MIRROR = IBUF(23)
	IRDT   = IBUF(24)
	ISPEED = IBUF(25)
	IDISK  = IBUF(26)
	NDOTS  = IBUF(27)
	KTWO   = IBUF(28)
	ITEMPW(1) = IBUF(29)
	ITEMPW(2) = IBUF(30)
	IMSIZE = ITEMPL
	MTAPE  = IBUF(32)
	WRITE (LUNIT,67) IVER,IPHPTR,KREP,INITFF,IFFAP,
     X		ISPCE,LASTFF,RDEN,IBYTES,MUXOUT
	WRITE (LUNIT,68) INHNCE,INVERS,MIRROR,IRDT,ISPEED,
     X		IDISK,NDOTS,KTWO,IMSIZE,PRECIS,MTAPE
C
C...	SET UP ELEMENT COUNT FOR DRAW COMMAND
	DRWELM = 1
	IF (IBYTES .GE. 2048) DRWELM = 2
C
C	***********************
C	* PROCESS A PARTITION *
C	***********************
C...	READ PARTITION HEADER RECORD
  300	IF (HREC .EQ. 0) GO TO 90000
	CALL RREAD (IBUF(1),HREC)
	CALL RWAIT
C
C...	OUTPUT CURRENT RECORD NUMBER
	IF (STARTD .AND. FDUMP)  WRITE (LUNIT,51) HREC
	JREC = HREC
C
C...	SAVE POINTER TO NEXT PARTITION HEADER
	ITEMPW(1) = IBUF(5)
	ITEMPW(2) = IBUF(6)
	HREC = ITEMPL
C
C...	GET NEXT PLOT NUMBER
	ISVPLT = 0
	IF (HREC .EQ. 0) GO TO 310
	CALL RREAD (IBUF(1),HREC)
	CALL RWAIT
	ISVPLT = IBUF(11)
	CALL RREAD (IBUF(1),JREC)
	CALL RWAIT
C
C...	INCREMENT PARTITION COUNT
  310	ICURB = ICURB + 1
C
C...	RESET DUMP FLAG IF STARTING PARTITION REACHED
	IF (ICURB .LT. ISTART) GO TO 315
	FDUMP = SDUMP
	PDUMP = .TRUE.
	STARTD = .TRUE.
C
C...	EXIT IF LAST PARTITION PROCESSED
  315	IF (ICURB .GT. IBEND)  GO TO 90000
C
C...	CHECK IF FIRST PARTITION IN CURRENT PLOT
	IF (LEVEL .EQ. 1)  GO TO 320
C
C...	CHECK IF CURRENT PARTITION NEEDS TO BE DUMPED
	IF (.NOT. STARTD)  GO TO 320
C
C...	OUTPUT PREVIOUS PARTITION TOTALS
	WRITE (LUNIT,34)
	WRITE (LUNIT,35) MOVE
	WRITE (LUNIT,36) DRAW
	WRITE (LUNIT,37) DEFPEN
	WRITE (LUNIT,38) SETPEN
	WRITE (LUNIT,39) POLY
	WRITE (LUNIT,40) CIRCLE
	WRITE (LUNIT,41) TEXT
	WRITE (LUNIT,42) SETFBL
	WRITE (LUNIT,43) SETFOT
	WRITE (LUNIT,44) DEFFIL
C
C...	UPDATE PLOT TOTALS
	TOTKNT = TOTKNT + BNDKNT
	TOTBYT = TOTBYT + BNDBYT
	TMOVE = TMOVE + MOVE
	TDRAW = TDRAW + DRAW
	TDFPEN = TDFPEN + DEFPEN
	TSTPEN = TSTPEN + SETPEN
	TPOLY = TPOLY + POLY
	TCIRCL = TCIRCL + CIRCLE
	TTEXT = TTEXT + TEXT
	TSTFBL = TSTFBL + SETFBL
	TSTFOT = TSTFOT + SETFOT
	TDFFIL = TDFFIL + DEFFIL
C
C...	RESET PARTITION TOTALS
	BNDKNT = 0.0
	BNDBYT = 0.0
	MOVE = 0.0
	DRAW = 0.0
	DEFPEN = 0.0
	SETPEN = 0.0
	POLY = 0.0
	CIRCLE = 0.0
	TEXT = 0.0
	SETFBL = 0.0
	SETFOT = 0.0
	DEFFIL = 0.0
C
  320	CONTINUE
C
C...	UPDATE VARIABLES FROM PARTITION HEADER
	ITEMPW(1) = IBUF(1)
	ITEMPW(2) = IBUF(2)
	IFIRST = ITEMPL
	ITEMPW(1) = IBUF(3)
	ITEMPW(2) = IBUF(4)
	BNDFLG = ITEMPL
	ITEMPW(1) = IBUF(7)
	ITEMPW(2) = IBUF(8)
	XMIN = ITEMPL
	ITEMPW(1) = IBUF(9)
	ITEMPW(2) = IBUF(10)
	ICAREC = ITEMPL
C
C  GET THE PLOT NUMBER AND CHECK FOR A NULL PLOT. A NULL PLOT CAN ONLY
C  OCCUR AT THE END OF PLOT.
C
	IPLOT = IBUF(11)
	IF (IPLOT .EQ. 0) GO TO 300
C
C  GET THE NUMBER OF COPIES, ELEMENT COUNT, MAX X VALUE, PLOT LENGTH,
C  NUMBER OF PASSES AND TONER.
C
	NCOPY = IBUF(12)
	ITEMPW(1) = IBUF(13)
	ITEMPW(2) = IBUF(14)
	VRFKNT = ITEMPL
	ITEMPW(1) = IBUF(15)
	ITEMPW(2) = IBUF(16)
	IBXMAX = ITEMPL
	IB13 = IBUF(17)
	IPLEN = IBUF(18)
	NPASS = IBUF(19)
	ITONE = IBUF(20)
	NCH = IBUF(21)
	ITEMPW(1) = IBUF(53)
	ITEMPW(2) = IBUF(54)
	BYTKNT = ITEMPL
	ICPCMD = IBUF(55)
	ICUT = IBUF(56)
	ITEMPW(1) = IBUF(57)
	ITEMPW(2) = IBUF(58)
	JBXMAX = ITEMPL
C
C...	GET AUTHOR TEXT
	ITMP = NCH/2
	DO 340 I=1,ITMP
	  IAUTMP = IBUF(I+21)
	  IAULFT(I) = IRAM (IAUTMP,8,MSK8)
	  IAURGT(I) = IAND (IAUTMP,MSK8)
  340	CONTINUE
C
C...	CHECK IF CURRENT PARTITION NEEDS TO BE DUMPED
	IF (.NOT. STARTD)  GO TO 380
C
C...	OUTPUT PARTITION HEADER MESSAGE
	WRITE (LUNIT,4) ICURB,IFIRST,BNDFLG,HREC,XMIN,ICAREC,IPLOT,
     X	 NCOPY,VRFKNT,IBXMAX,IB13,NCH,BYTKNT,ICPCMD,ICUT,JBXMAX
	IF (IPLEN .NE. 0)  WRITE (LUNIT,72) IPLEN,NPASS,ITONE
	WRITE (LUNIT,80)
	ITMP = NCH/2
	IF (LSTPLT .NE. IPLOT .OR. LSTPLT .EQ. 0) WRITE (LUNIT,5)
     X		(IAULFT(I),IAURGT(I),I=1,ITMP)
	WRITE (LUNIT,69)
	LSTPLT = IPLOT
C
C...	READ CONTROL ARRAY
	IF (ICAREC .EQ. 0) GO TO 380
	CALL RREAD (IBUF(1),ICAREC)
	CALL RWAIT
	ITEMPW(1) = IBUF(1)
	ITEMPW(2) = IBUF(2)
	ICACNT = ITEMPL
	ITEMPL = IBUF(3)
	IPCA(4) = IAND(ITEMPL,MSK8)
	IPCA(3) = IRAM (ITEMPL,8,MSK8)
	ITEMPL = IBUF(4)
	IPCA(2) = IAND(ITEMPL,MSK8)
	IPCA(1) = IRAM (ITEMPL,8,MSK8)
	ITEMPW(1) = IBUF(5)
	ITEMPW(2) = IBUF(6)
	ICAENT(2) = ITEMPL
	ITEMPW(1) = IBUF(7)
	ITEMPW(2) = IBUF(8)
	ICAENT(3) = ITEMPL
	ITEMPW(1) = IBUF(9)
	ITEMPW(2) = IBUF(10)
	ICAENT(4) = ITEMPL
	DO 360 I=5,ICACNT
	  ICAENT(I) = IBUF(6+I)
  360	CONTINUE
C
C...	DETERMINE WHETHER THICK LINES ARE
C	TURNED INTO RECTANGLES
	DRWMAX = 12.0
	IF (ICAENT(10) .EQ. 1) DRWMAX = 14.0
C
C...	OUTPUT CONTROL ARRAY
	WRITE (LUNIT,70) ICACNT, (IPCA(I),I=1,4)
	WRITE (LUNIT,71) (ICAENT(I),I=2,ICACNT)
C
C...	READ FIRST DATA RECORD
  380	CALL RREAD (IBUF(1),IFIRST)
C
C...	OUTPUT CURRENT RECORD NUMBER
	IF (STARTD .AND. FDUMP)  WRITE (LUNIT,51) IFIRST
	MAXI = LREC
	NEXTI = 3
	EOF = .FALSE.
C...	SAVE CURRENT RECORD NUMBER IN BYTCNT
	BYTCNT = IFIRST
C
	CALL RWAIT
C
C...	READ PAST SYNC HEADER
  400	CALL ICHUNK (IDATA,0)
C
C...	CHECK IF VALID HEADERS
	IF (IDATA .NE. CANSOH .AND. IDATA .NE. CANSTX) GO TO 2080
C
C...	READ BYTE COUNT
  500	CALL ICHUNK (IDATA,0)
	IF (IDATA.EQ.0) GO TO 400
C
C...	IS DATA LEVEL II
	IF (LEVEL.EQ.2) GO TO 2000
C
C...	PROCESS LEVEL I COMMANDS UNTIL BEGIN-VRF COMMAND
C
 1000	CALL ICHUNK (IDATA,0)
	IF (EOF) GO TO 300
	ICOM = IRAM (IDATA,8,MSK8)
C
C...	CHECK FOR VALID COMMAND
	IF (IAND(ICOM,IBIT8).EQ.0) GO TO 2080
C
C	***********************
C...	*** LEVEL I COMMAND ***
C	***********************
C...	IS IT A SKIP COMMAND?
 1200	IF (ICOM.NE.IC0) GO TO 1300
	NSKIP = IAND (IDATA,MSK8)
	IF (NSKIP.NE.0) GO TO 1203
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,30) NSKIP
	GO TO 1000
C
C	********************
C...	*** SKIP COMMAND ***
C	********************
 1203	CALL ICHUNK (IDATA,0)
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,30) NSKIP
	GO TO 1207
 1205	CALL ICHUNK (IDATA,0)
 1207	NSKIP = NSKIP -2
	IF (NSKIP.GT.0) GO TO 1205
	GO TO 1000
C
C
C...	IS IT A FORM FEED COMMAND?
 1300	IF (ICOM.NE.IC2) GO TO 1400
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,7)
	GO TO 1000
C
C...	IS IT A BEGIN-VRF (16-BIT) COMMAND?
 1400	IF (ICOM.NE.I83) GO TO 1500
	DRWMIN = 8.0
	MSBIT = MBIT16
	NMSBIT = NMBT16
	MINX = NMBT16
	MINY = NMBT16
C
C	*************************
C...	*** BEGIN-VRF COMMAND ***
C	*************************
 1450	CALL ICHUNK (IDENS,-1)
	CALL ICHUNK (ISCAN,-1)
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,8) PRECIS,IDENS,ISCAN
	LEVEL = 2
	DRWKNT = DRWMIN
	GO TO 2000
C
C...	IS IT A BEGIN-VRF (32-BIT) COMMAND?
 1500	IF (ICOM.NE.I84) GO TO 1600
	DRWMIN = 12.0
	MSBIT = MBIT32
	NMSBIT = NMBT32
	MINX = NMBT32
	GO TO 1450
C
C...	IS IT A PLOTTER CONTROL COMMAND?
 1600	IF (ICOM .NE. ICC)  GO TO 1700
C
C...	GET NUMBER OF PARAMETER CHUNKS
	NPARAM = IAND(IDATA,MSK8)
C
C...	CHECK IF ANY PARAMETERS
	IF (NPARAM .EQ. 0)  GO TO 1000
C
C...	PROCESS PLOTTER CONTROL COMMANDS
C...	GET A CHUNK
 	CALL ICHUNK (IDATA,0)
C
C...	CHECK IF REWIND COMMAND
	IF (IDATA .NE. IESCR)  GO TO 1610
	CALL ICHUNK (IDATA,0)
	IF (IDATA .NE. 0)  GO TO 2080
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,63)
	GO TO 1000
C
C...	CHECK IF PAPER CUT COMMAND
 1610	IF (IDATA .NE. IESCK)  GO TO 2080
	CALL ICHUNK (IDATA,0)
	IF (IDATA .NE. 0)  GO TO 2080
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,81)
	GO TO 1000
C
C...	CHECK IF DATA STANDARDS COPY COUNT COMMAND
1700	IF (IDATA .NE. IC506) GOTO 2080
C
C...	GET COPY COUNT AND PLOT LENGTH
	CALL ICHUNK(ICOPY,0)
	CALL ICHUNK(LENGUP,0)
	CALL ICHUNK(LENGLO,0)
	LENGTH = IRAM(LENGUP,-16,MSKUP) + IAND(LENGLO,MSKLO)
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,66) ICOPY,LENGTH
	GOTO 1000
C
C
C	*****************************
C	* PROCESS LEVEL II COMMANDS *
C	*****************************
C
C...	GET COMMAND CHUNK
 2000	CALL ICHUNK (IDATA,0)
	IF (EOF) GO TO 300
C
C...	IS IT A POSITIONING COMMAND?
	IF (IAND(IDATA,MBIT16).EQ.0) GO TO 2200
C
C...	SEPARATE COMMAND INTO INDEX AND NUMBER OF DATA CHUNKS
	ICOM = IRAM (IDATA,8,127)
	NPARAM = IAND (IDATA,MSK8)
C
C...	IS IT A VALID COMMAND?
	IF (ICOM.LE.13) GO TO 2100
C
C...	ERROR IN DATA
 2080	ICUR = NEXTI - 1
	WRITE (LUNIT,6) BYTCNT,ICUR,(IBUF(I),I=1,LREC)
	GO TO 99999
C
C...	GO TO APPROPRIATE COMMAND PROCESSING ROUTINE
 2100	I = ICOM + 1
	GO TO (3000,4000,5000,6000,7000,8000,9000,10000,11000,
     X         12000,13000,14000,15000,16000),I
C
C...	POSITIONING COMMAND
 2200	IX = IDATA
	IF (PRECIS.EQ.16) GO TO 2300
	CALL ICHUNK (IDATA,0)
	IX = IDATA + IRAM(IX,-16,MSKUP)
 2300	CALL ICHUNK (IY,-1)
C
C...	IS IT A MOVE OR A DRAW?
	IF (IAND(IY,MSBIT).NE.0) GO TO 2400
C
C	********************
C...	*** MOVE COMMAND ***
C	********************
	IF ((IX .LT. IMINX) .OR. (IX .GT. IMAXX)) GO TO 2000
	IF ((IY .LT. IMINY) .OR. (IY .GT. IMAXY)) GO TO 2000
	MOVE = MOVE + 1.0
	CALL CHKXY (IX,IY)
	IF ((IMVDRW .NE. 0) .AND. (PDUMP)) WRITE (LUNIT,27) IX,IY
	ISAVIX = IX
	ISAVIY = IY
	GO TO 2000
C
C	********************
C...	*** DRAW COMMAND ***
C	********************
 2400	IY = IAND (IY,NMSBIT)
	IF ((IX .LT. IMINX) .OR. (IX .GT. IMAXX)) GO TO 2000
	IF ((IY .LT. IMINY) .OR. (IY .GT. IMAXY)) GO TO 2000
	DRAW = DRAW + 1.0
	BNDKNT = BNDKNT + DRWELM
	BNDBYT = BNDBYT + DRWKNT
	CALL CHKXY(IX,IY)
	IF ((IMVDRW .NE. 0) .AND. (PDUMP)) WRITE (LUNIT,28) IX,IY
	GO TO 2000
C
C	***********************
C...	*** END VRF COMMAND ***
C	***********************
 3000	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,9)
C
C...	OUTPUT RECORD NUMBER
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,51) BYTCNT
	LEVEL = 1
	EOF = .FALSE.
C
C...	CHECK IF START DUMP FLAG ON
	IF (.NOT. STARTD)  GO TO 3010
C
C...	OUTPUT PARTITION TOTALS
	WRITE (LUNIT,34)
	WRITE (LUNIT,35) MOVE
	WRITE (LUNIT,36) DRAW
	WRITE (LUNIT,37) DEFPEN
	WRITE (LUNIT,38) SETPEN
	WRITE (LUNIT,39) POLY
	WRITE (LUNIT,40) CIRCLE
	WRITE (LUNIT,41) TEXT
	WRITE (LUNIT,42) SETFBL
	WRITE (LUNIT,43) SETFOT
	WRITE (LUNIT,44) DEFFIL
C
C...	UPDATE PLOT TOTALS
 3010	TOTKNT = TOTKNT + BNDKNT
	TOTBYT = TOTBYT + BNDBYT
	TMOVE = TMOVE + MOVE
	TDRAW = TDRAW + DRAW
	TDFPEN = TDFPEN + DEFPEN
	TSTPEN = TSTPEN + SETPEN
	TPOLY = TPOLY + POLY
	TCIRCL = TCIRCL + CIRCLE
	TTEXT = TTEXT + TEXT
	TSTFBL = TSTFBL + SETFBL
	TSTFOT = TSTFOT + SETFOT
	TDFFIL = TDFFIL + DEFFIL
C
C...	SEE IF NEED TO OUTPUT PLOT TOTALS
	IF (ISVPLT .EQ. IPLOT) GO TO 3200
C
C...	CHECK IF STARTING DUMP PARTITION REACHED
	IF (.NOT. STARTD)  GO TO 3040
C
C...	OUTPUT PLOT TOTALS
	WRITE (LUNIT,45)
	WRITE (LUNIT,35) TMOVE
	WRITE (LUNIT,36) TDRAW
	WRITE (LUNIT,37) TDFPEN
	WRITE (LUNIT,38) TSTPEN
	WRITE (LUNIT,39) TPOLY
	WRITE (LUNIT,40) TCIRCL
	WRITE (LUNIT,41) TTEXT
	WRITE (LUNIT,42) TSTFBL
	WRITE (LUNIT,43) TSTFOT
	WRITE (LUNIT,44) TDFFIL
	WRITE (LUNIT,47) TOTKNT
	WRITE (LUNIT,73) TOTBYT
	IF (BNDKNT .NE. 0.0)  WRITE (LUNIT,46) MINX,MAXX,MINY,MAXY
C
C...	INIT PLOT TOTALS
 3040	TOTKNT = 0.0
	TOTBYT = 0.0
	TMOVE = 0.0
	TDRAW = 0.0
	TTEXT = 0.0
	TPOLY = 0.0
	TSTFBL = 0.0
	TSTFOT = 0.0
	TSTPEN = 0.0
	TDFPEN = 0.0
	TDFFIL = 0.0
	TCIRCL = 0.0
 3200	MINX = NMBT32
	MINY = NMBT32
	MAXX = 0
	MAXY = 0
C
C...	INITIALIZE INDEX FOR CHARACTER STROKE COUNT
	PFONT = 1
C
C...	RESET PARTITION TOTALS
	BNDKNT = 0.0
	BNDBYT = 0.0
	MOVE = 0.0
	DRAW = 0.0
	DEFPEN = 0.0
	SETPEN = 0.0
	POLY = 0.0
	CIRCLE = 0.0
	TEXT = 0.0
	SETFBL = 0.0
	SETFOT = 0.0
	DEFFIL = 0.0
	GO TO 1000
C
C	*******************************
C...	*** BEGIN PARTITION COMMAND ***
C	*******************************
 4000	CALL ICHUNK (NH,-1)
	PART = PART + 1.0
	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,10) NH
	GO TO 2000
C
C	**************************
C...	*** DEFINE PEN COMMAND ***
C	**************************
 5000	CALL ICHUNK (PI,0)
	CALL ICHUNK (S1,-1)
	CALL ICHUNK (S2,-1)
	CALL ICHUNK (S3,-1)
	CALL ICHUNK (S4,-1)
	CALL ICHUNK (W,0)
	DEFPEN = DEFPEN + 1.0
	IF (FDUMP) WRITE (LUNIT,11) PI,S1,S2,S3,S4,W
	GO TO 2000
C
C	***********************
C...	*** SET PEN COMMAND ***
C	***********************
 6000	CALL ICHUNK (PI,0)
	SETPEN = SETPEN + 1.0
	IF (FDUMP) WRITE (LUNIT,12) PI
	DRWKNT = DRWMIN
	IF (PI .EQ. 0) DRWKNT = 0.0
	IF (PI .GT. 1) DRWKNT = DRWMAX
	GO TO 2000
C
C	***************************
C...	*** BEGIN MACRO COMMAND ***
C	***************************
 7000	CALL ICHUNK (N,0)
	CALL ICHUNK (CPX,-1)
	CALL ICHUNK (CPY,-1)
	IF (FDUMP) WRITE (LUNIT,13) N,CPX,CPY
	GO TO 2000
C
C	*************************
C...	*** END MACRO COMMAND ***
C	*************************
 8000	IF (FDUMP) WRITE (LUNIT,14)
	GO TO 2000
C
C	**************************
C...	*** CALL MACRO COMMAND ***
C	**************************
 9000	CALL ICHUNK (N,0)
	CALL ICHUNK (TX,-1)
	CALL ICHUNK (TY,-1)
	IF (FDUMP) WRITE (LUNIT,15) N,TX,TY
	GO TO 2000
C
C	***********************************
C...	*** DEFINE FILL-PATTERN COMMAND ***
C	***********************************
10000	CALL ICHUNK (PI,0)
	CALL ICHUNK (R,0)
	CALL ICHUNK (W,0)
	CALL ICHUNK (H,0)
	BNDBYT = BNDBYT + 2.0 * H
	NWORD = (W-1)/16 + 1
	DEFFIL = DEFFIL + 1.0
	IF (FDUMP) WRITE (LUNIT,16) PI,W,H
	DO 10200 I=1,H
	  DO 10100 J=1,NWORD
	    CALL ICHUNK (IPAT(J),0)
10100	  CONTINUE
	IF (FDUMP) WRITE (LUNIT,17) I,(IPAT(J),J=1,NWORD)
10200	CONTINUE
	GO TO 2000
C
C	****************************
C...	*** DRAW POLYGON COMMAND ***
C	****************************
11000	CALL ICHUNK (FP,0)
	IF ((IX .LT. IMINX) .OR. (IX .GT. IMAXX)) GO TO 11200
	IF ((IY .LT. IMINY) .OR. (IY .GT. IMAXY)) GO TO 11200
	POLY = POLY + 1.0
C
C...	COMPUTE NUMBER OF POINTS IN POLYGON
	NPTS = (NPARAM-1)/2
	IF (PRECIS.EQ.32) NPTS = NPTS/2
C
C...	GET FIRST POINT
	  CALL ICHUNK (IX,-1)
	  CALL ICHUNK (IY,-1)
C
C...	SET MOVE/DRAW FLAG
	  K = -1
	  IF (IAND(IY,MSBIT).NE.0) K = 0
	  IY = IAND (IY,NMSBIT)
C
C...	OUTPUT THE POLYGON MESSAGE
	IF ((IMVDRW .EQ. 0) .AND. (IPOLYG .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,27) ISAVIX,ISAVIY
	  NPTSP1 = NPTS
	  IF (K .EQ. -1) NPTSP1 = NPTSP1 + 1.0
	  IF ((IPOLYG .NE. 0) .AND. (PDUMP)) WRITE(LUNIT,18) NPTSP1,FP
C
C...	OUTPUT THE FIRST POINT
	  CALL CHKXY (IX,IY)
	  IF ((K .EQ. -1) .AND. (IPOLYG .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,19) IX,IY
	  IF ((K .EQ.  0) .AND. (IPOLYG .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,20) IX,IY
C
C...	OUTPUT THE REST OF THE POINTS
	DO 11100 I=2,NPTS
	  CALL ICHUNK (IX,-1)
	  CALL ICHUNK (IY,-1)
	  IF (IAND(IY,MSBIT).NE.0) GO TO 11050
	  CALL CHKXY (IX,IY)
	  IF ((IPOLYG .NE. 0) .AND. (PDUMP))
     *	  WRITE (LUNIT,19) IX,IY
	  GO TO 11100
11050	  IY = IAND (IY,NMSBIT)
	  CALL CHKXY (IX,IY)
	  IF ((IPOLYG .NE. 0) .AND. (PDUMP))
     *	  WRITE (LUNIT,20) IX,IY
11100	CONTINUE
	T = FLOAT(NPTSP1) + 1.0
	BNDKNT = BNDKNT + T
	BNDBYT = BNDBYT + 4.0 * NPTSP1 + 8.0
	IF (K .EQ. 0) BNDBYT = BNDBYT + NPTSP1 * DRWKNT
	GO TO 2000
C
C...	GET BUT DO NOT INCLUDE POLYGONS OUTSIDE THE RDUMP 'WINDOW'
C
C...	COMPUTE NUMBER OF POINTS IN POLYGON
11200	NPTS = (NPARAM-1)/2
	IF (PRECIS .EQ. 32) NPTS = NPTS/2
C
C...	GET FIRST POINT
	  CALL ICHUNK (IX,-1)
	  CALL ICHUNK (IY,-1)
	  IY = IAND (IY,NMSBIT)
C
C...	GET THE REST OF THE POINTS
	DO 11300 I=2,NPTS
	  CALL ICHUNK (IX,-1)
	  CALL ICHUNK (IY,-1)
	  IF (IAND (IY,MSBIT) .EQ. 0) GO TO 11300
	  IY = IAND (IY,NMSBIT)
11300	CONTINUE
	GO TO 2000
C
C	********************
C...	*** TEXT COMMAND ***
C	********************
12000	CALL ICHUNK (NC,0)
	IF ((IX .LT. IMINX) .OR. (IX .GT. IMAXX)) GO TO 12300
	IF ((IY .LT. IMINY) .OR. (IY .GT. IMAXY)) GO TO 12300
	TEXT = TEXT + 1.0
	J = 1
	NPARAM = NPARAM - 1
	DO 12100 I=1,NPARAM
	  CALL ICHUNK (IDATA,0)
	  ITEXT(J) = IRAM (IDATA,8,MSK8)
	  ITEXT(J+1) = IAND(IDATA,MSK8)
	  J = J + 2
12100	CONTINUE
	IF ((IMVDRW .EQ. 0) .AND. (ITXT .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,27) ISAVIX,ISAVIY
	IF ((ITXT .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,21) NC,(ITEXT(I),I=1,NC)
	COUNT = 0.0
	DO 12200 I=1,NC
	  ITEMPL = ITEXT(I)
	  COUNT = COUNT + CHRKNT(1+IAND(ITEMPL,MSK7),PFONT)
	  IF (ITEXT(I).LT.ISPACE) ITEXT(I) = ISPACE
12200	CONTINUE
	IF ((ITXT .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,22) (ITEXT(I),I=1,NC)
	BNDKNT = BNDKNT + FLOAT((NC-1)/4+4)
	BNDBYT = BNDBYT + COUNT * DRWKNT
	GO TO 2000
C
C...	GET BUT DO NOT INCLUDE TEXT OUTSIDE THE RDUMP 'WINDOW'
12300	NPARAM = NPARAM - 1
	DO 12400 I=1,NPARAM
	  CALL ICHUNK (IDATA,0)
12400	CONTINUE
	GO TO 2000
C
C	************************
C...	*** SET FONT COMMAND ***
C	************************
13000	CALL ICHUNK (FP,0)
	SETFOT = SETFOT + 1.0
	IF (FDUMP) WRITE (LUNIT,23) FP
	PFONT = 1
	IF (FP .GE. 15 .AND. FP .LE. 19) PFONT = FP - 13
	GO TO 2000
C
C	*********************************
C...	*** SET FONT BASELINE COMMAND ***
C	*********************************
14000	CALL ICHUNK (XB,-1)
	CALL ICHUNK (YB,-1)
C
C...	CHECK FOR 16-BIT NEGATIVE NUMBERS
	IF (PRECIS .EQ. 32) GO TO 14010
	IF (XB .LE. 32767) GO TO 14005
	  XB = IOR(XB,MSKUP)
14005	IF (YB .LE. 32767) GO TO 14010
	  YB = IOR(YB,MSKUP)
14010	CONTINUE
	SETFBL = SETFBL + 1.0
	IF (FDUMP) WRITE (LUNIT,24) XB,YB
	GO TO 2000
C
C	*****************************
C...	*** LEVEL II SKIP COMMAND ***
C	*****************************
15000	IF (FDUMP .AND. STARTD)  WRITE (LUNIT,25) NPARAM
15100	IF (NPARAM.EQ.0) GO TO 2000
	CALL ICHUNK (IDATA,0)
	NPARAM = NPARAM - 1
	GO TO 15100
C
C	***************************
C...	*** DRAW CIRCLE COMMAND ***
C	***************************
16000	CALL ICHUNK (FP,0)
	CALL ICHUNK (W,0)
	CALL ICHUNK (R,-1)
	IF ((IX .LT. IMINX) .OR. (IX .GT. IMAXX)) GO TO 2000
	IF ((IY .LT. IMINY) .OR. (IY .GT. IMAXY)) GO TO 2000
	CIRCLE = CIRCLE + 1.0
	IF ((IMVDRW .EQ. 0) .AND. (ICRCLE .NE. 0) .AND. (PDUMP))
     *			WRITE (LUNIT,27) ISAVIX,ISAVIY
	IF ((ICRCLE .NE. 0) .AND. (PDUMP)) WRITE (LUNIT,26) R,FP,W
	BNDKNT = BNDKNT + 2.0
	BNDBYT = BNDBYT + 12.0
	IF (W .NE. 0) BNDBYT = BNDBYT + 12.0
	GO TO 2000
C
90000	WRITE (LUNIT,29)
	WRITE (LUNIT,33) PART
C
C...	OUTPUT VRF SUMMARY
99999	CALL RCLOS
	STOP
	END
	SUBROUTINE CHKXY (IXX,IYY)
C
	INCLUDE 'RDPCOM.CMN'
C
C
C...	UPDATE MIN/MAX VALUES
	IF (IXX .LT. MINX)  MINX = IXX
	IF (IXX .GT. MAXX)  MAXX = IXX
	IF (IYY .LT. MINY)  MINY = IYY
	IF (IYY .GT. MAXY)  MAXY = IYY
  	RETURN
	END
