	FUNCTION RPMCAP ( IBYTES, MAXXR, IPART, PMSIZE )
C
C	NAME:  RPMCAP
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C
C	RPMCAP - CALCULATE THE RPM MEMORY CAPACITY
C
C	FUNCTION RPMCAP CALCULATES THE RPM MEMORY CAPACITY IN BYTES
C	BASED ON THE PLOTTER WIDTH, THE PLOT LENGTH, WHETHER THE PLOT
C	IS PARTITIONED, AND THE SIZE OF THE RPM MEMORY.
C
C	USE:  VALUE = RPMCAP (IBYTES,MAXXR,IPART,PMSIZE)
C
C			IBYTES - BYTES/SCAN OF THE TARGET PLOTTER
C			MAXXR  - MAX_X_RANGE OF ANY PARTITION
C			IPART  - PARTITION FLAG
C				   = 0 - UNPARTITIONED PLOT
C				   # 0 - PARTITIONED PLOT
C			PMSIZE - PRISM MEMORY SIZE IN BYTES
C
C	CALLED BY: PLOT, BAND
C
C	CALLS:  NONE
C
C	COMMON USED: NONE
C
C	LOCAL VARIABLES:
C		I IBAND  - NUMBER OF SCAN LINES IN A RASTER BAND
C		I IBSIZE - RASTER BUFFER SIZE OF PRISM IN 16-BIT WORDS
C		I ITANKS - NUMBER OF RPM INTERNAL ELEMENT TANKS
C		I JTANKS - NUMBER OF INTERNAL ELEMENT TANKS NEEDED FOR
C			   OVERHEAD
C		I NBINS  - NUMBER OF SORT BINS REQUIRED
C		I NPASS  - INDICATES WHETHER A MULTI-PASS SORT WILL
C			   BE REQUIRED - 0=SINGLE PASS, 1=MULTI-PASS
C		R TSIZE  - SIZE OF RPM INTERNAL ELEMENT TANKS
C
C
C...	PRISM RASTER BUFFER SIZE - 256K 16-BIT WORDS
C	(NOTE: THIS VALUE IS ALSO IN A DATA STATEMENT IN BAND)
	DATA IBSIZE/262144/
C
C...	SIZE OF RPM INTERNAL ELEMENT TANKS
	DATA TSIZE/2036./
C
C***********************************************************************
C
C   CALCULATE BAND SIZE
C
C   BASICALLY, THE BAND SIZE IS THE PRISM BUFFER SIZE DIVIDED BY
C   THE SIZE OF A SCAN LINE.  HOWEVER, WE HAVE TO RAISE THE
C   WORDS PER SCAN LINE TO A MULTIPLE OF 16, AND WE HAVE TO LOWER
C   THE BAND SIZE SO THAT IT IS A POWER OF 2.  THERE IS A LIMIT
C   ON THE BAND SIZE OF 2048.
C
C   NUMBER OF 16-BIT WORDS PER SCAN LINE
	ITEMP = (IBYTES+1)/2
C
C   RAISE TO A MULTIPLE OF 16
	ITEMP = 16 * ((ITEMP+15)/16)
C
C   CALCULATE INITIAL VALUE FOR BAND SIZE
	IBAND = IBSIZE / ITEMP
C
C   LOWER TO A POWER OF 2
	IBAND = IBAND / 2
	N = 1
 10	IF (N .GT. IBAND) GO TO 20
	  N = N + N
	  GO TO 10
 20	IBAND = N
	IF (IBAND .GT. 2048) IBAND = 2048
C
C***********************************************************************
C
C   CALCULATE THE NUMBER OF SORT BINS REQUIRED
C
C   BASICALLY, THE NUMBER OF BINS REQUIRED IS THE MAX_X_RANGE DIVIDED
C   BY THE BAND SIZE.  HOWEVER, IF THE PLOT IS PARTITIONED, WE DOUBLE
C   THE MAX_X_RANGE BECAUSE THE VRF PARTITIONS MAY NOT START ON PRISM
C   BAND BOUNDARIES.  ALSO, WE MUST RAISE THE NUMBER OF SORT BINS TO
C   A POWER OF 2.
C
	MAXX = MAXXR
	IF (IPART .NE. 0) MAXX = MAXX + MAXX
C
	NBINS = (MAXX + IBAND - 1) / IBAND
C
C   RAISE TO A POWER OF 2
	N = 1
 30	IF (N .GE. NBINS) GO TO 40
	  N = N + N
	  GO TO 30
 40	NBINS = N
C
C   A MINIMUM OF 4 SORT BINS WILL BE USED.  IF MORE THAN 256 SORT BINS
C   ARE REQUIRED, THEN ONLY 256 WILL BE USED AND THE SORT WILL BE DONE
C   AS A MULTI-PASS SORT.  VARIABLE NPASS INDICATES WHETHER A
C   MULTI-PASS SORT WILL BE USED.
C
	NPASS = 1
	IF (NBINS .LT. 4) NBINS = 4
	IF (NBINS .LE. 256) GO TO 50
	  NBINS = 256
	  NPASS = 2
 50	CONTINUE
C
C***********************************************************************
C
C   CALCULATE TOTAL NUMBER OF TANKS
C
C   THE NUMBER OF TANKS IS 0 FOR THE FIRST MEGABYTE AND
C   502.75 FOR EACH MEGABYTE THEREAFTER.  ALTHOUGH THERE ARE
C   NO RPMS WITH PARTIAL MEGABYTES OF MEMORY, WE DO THE
C   CALCULATION AS THOUGH THERE WERE SO THAT THE USER CAN
C   VARY HIS PARTITION SIZE BY VARYING HIS MEMORY SIZE.
C
C   TOTAL NUMBER OF TANKS
	ITANKS = 502.75 * (PMSIZE/1048576. - 1.0)
C
C***********************************************************************
C
C   CALCULATE THE NUMBER OF TANKS NEEDED FOR OVERHEAD
C
C   THIS VALUE INCLUDES TANKS NEEDED FOR SORT BINS
C
C   OVHD_COUNT = (1/2 + NPASS) * NBINS + 3
C
	JTANKS = NPASS * NBINS + NBINS / 2 + 3
C
C***********************************************************************
C
C   CAPACITY = TANK SIZE * (TOTAL # OF TANKS - OVERHEAD TANKS)
C
	RPMCAP = TSIZE * (ITANKS - JTANKS)
C
C***********************************************************************
C
	RETURN
	END
