C	NAME:  SCN35K
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C
C	THIS TEST PROGRAM IS USED TO TEST
C	PLOTTING GREATER THAN 32767 SCANS
C
	INTEGER ZPAT
	DIMENSION XC(3),YC(3),XT(4),YT(4)
	DIMENSION IPAT(16),ZPAT(1)
	DIMENSION NE(1)
	DIMENSION IDUM(2)
	DATA NE(1)/4/
	DATA IPAT/7168,8704,16640,16640,16640,8704,7168,0,
     1	            65,34,20,8,20,34,65,0/
	DATA ZPAT/0/
	DATA RADIUS/.5/,X1/162.295/,X2/163.795/
	DATA XC/162.795,162.795,161.795/
	DATA YC/2.,3.,2.5/
	DATA XT/162.795,162.295,161.795,162.295/
	DATA YT/3.75,3.25,3.75,4.25/
C
C... SET SCALE AND PAPER SIZE
	CALL VPOPT (-1,IDUM,RDEN,IER)
	CALL VPOPT (6,IDUM,(200.0 / RDEN),IER)
	CALL PAPER (0.,177.,0.,10.5)
	CALL PLOTS(0,0,0)
C
C...	DRAW 5000 SCAN MARKERS DOWN THE PAPER
	CALL TICK (177.)
	CALL DEFPAT (1,IPAT,16)
	I2 = 2
	I4 = 4
C
C...	DRAW BOX 175.0 LONG, 10.5 WIDE
	CALL PLOT(0.,0.,3)
	CALL PLOT(0.,10.5,2)
	CALL PLOT(175.,10.5,2)
	CALL PLOT(175.,0.,2)
	CALL PLOT(0.,0.,2)
C
C...	OUTPUT ELEMENTS TWICE
	DO 1000 ILOOP = 1,2
	CALL SETPAT (1)
	CALL NEWPEN(1)
C
C...	DRAW CIRCLE WITH FILL AND OUTLINE
	CALL CIRCLE (X1,1.25,RADIUS,1)
C
C...	DRAW A POLYGON WITH FILL AND OUTLINE
	CALL CONVEX (XC,YC,-3)
C
C...	DRAW USING TONE
	CALL TONE (XT,YT,NE(1),1)
C
C...	OUTPUT TEXT
	CALL SYMBOL (X1+.10,4.5,.2,3HABC,90.0,3)
C
C...	OUTPUT COMBINATIONS OF LINES W/WO PENS DEFINED
C...	ONE NIB WIDE DOWN
	CALL PLOT (X1-.5,5.5,3)
	CALL PLOT (X1+.5,5.5,2)
C
C...	ONE NIB WIDE UP
	CALL PLOT (X1+.5,5.75,3)
	CALL PLOT (X1-.5,5.75,2)
C
C...	DASHED PEN UP/DOWN PAPER
	CALL DEFPEN(I2,1,50,25,50,25)
	CALL NEWPEN(I2)
	CALL PLOT (X1-.5,6.0,3)
	CALL PLOT (X1+.5,6.0,2)
	CALL PLOT (X1+.5,6.25,3)
	CALL PLOT (X1-.5,6.25,2)
C
C...	4 NIB WIDE PEN UP/DOWN
	CALL DEFPEN (I4,4,0,0,0,0)
	CALL NEWPEN (I4)
	CALL PLOT (X1-.5,6.5,3)
	CALL PLOT (X1+.5,6.5,2)
	CALL PLOT (X1+.5,6.75,3)
	CALL PLOT (X1-.5,6.75,2)
C
C...	Y-ONLY VECTOR
	CALL PLOT (X1,7.0,3)
	CALL PLOT (X1,8.0,2)
C
C...	NOW USE A DASHED PEN
	CALL DEFPEN (I4+1,4,50,50,50,50)
	CALL NEWPEN(I4+1)
	CALL PLOT (X1,8.25,3)
	CALL PLOT (X1,10.25,2)
C...	SET X TO 32767 SCAN BOUNDARY
	X1 = X2
C
C...	ADJUST FOR SECOND PASS
	I2 = I2 + 1
	I4 = I4 + 2
	DO 100 II = 1,3
	XC(II) = XC(II) + 1.5
  100	CONTINUE
	DO 200 II = 1,4
	XT(II) = XT(II) + 1.5
  200	CONTINUE
 1000	CONTINUE
	CALL PLOT (0.,0.,999)
	STOP
	END
	SUBROUTINE TICK(XMAX)
	DATA XINC/163.84/
	Y1 = 0.0
	Y2 = .250
	X = 0.0
C
C
C...	DRAW TICKS AT 5000 SCAN INTERVALS
  100	CALL PLOT (X,Y1,3)
	CALL PLOT (X,Y2,2)
	XN = X + .188
	YN = Y2 + .125
	TIC = (X * 200.0) + 0.05
	CALL NUMBER (XN,YN,.125,TIC,90.0,-1)
	X = X + 25.0
	IF (X .LT. XMAX)  GO TO 100
C...	DRAW MARKERS AT 32767 SCAN PAGE BOUNDARYS
	CALL NEWPEN (1)
C...	CALCULATE NUMBER OF PAGES TO MARK
	ILOOP = XMAX/XINC
	IF (ILOOP .EQ. 0)  RETURN
C...	DRAW MARKERS
	X1 = 163.795
	DO 200 I = 1,ILOOP
	CALL PLOT (X1,0.,3)
	CALL PLOT (X1,.5,2)
	X2 = X1 + .005
	CALL PLOT (X2,0.,3)
	CALL PLOT (X2,.5,2)
	X1 = X1 + XINC
  200	CONTINUE
	RETURN
	END
