	SUBROUTINE SETFNT(IFPAT)
C
C	NAME:  SETFNT
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C
C	SETFNT - SELECTS FONT PATTERN
C
C	SUBROUTINE SETFNT OUTPUTS THE SET-FONT COMMAND WITH THE DESIRED
C	FONT PATTERN NUMBER.
C
C	NOTE:	NOT ALL VRF PROCESSORS SUPPORT MULTIPLE FONTS.
C		SEE THE OPERATING MANUAL FOR THE VRF OUTPUT PROCESSOR
C		FOR DETAILS ON THE TYPE AND NUMBER OF FONTS SUPPORTED.
C
C		AN END-OF-PLOT CALL WILL RESET THE DEFAULT FONT PATTERN
C		TO THE VALUE INITIALIZED IN SUBROUTINE PLOTS.
C
C	ENTRY:  CALL SETFNT(IFPAT)
C
C			IFPAT - FONT PATTERN NUMBER
C			 <0   - IFPAT = 0
C			 >19  - IFPAT = 19
C
C	EXIT:  RETURN
C
C	CALLS:  OCHUNK
C
C	COMMON USED:
C	/DVCOM/
C		I JFONT   - CURRENT FONT INDEX
C		I PFONT   - INDEX FOR RPM STROKE COUNT FOR CURRENT FONT
C
C	/PRMCOM/
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C		I KREP    - TARGET OUTPUT CONTROLLER
C			    = 0 - UNKNOWN
C		            = 1 - REP CONTROLLER
C		            = 4 - RPM CONTROLLER
C		L VSTRP   - .TRUE. IFF Y-STRIPPING ENABLED
C	/KLCOM/
C		L KFLAG   - FLAG INDICATING REP OUTPUT AND .GT. 13.65'
C		            PLOTTING REQUIRED.
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
	INCLUDE 'KLCOM.CMN'
C
C
C...	SET-FONT COMMAND (X'8A01')
	DATA ICMD/35329/
C
C
C
C
C
C...	CHECK FOR ILLEGAL FONT NUMBER
	JFONT = IFPAT
	IF (JFONT .LT. 0)  JFONT = 0
	IF (JFONT .GT. 19)  JFONT = 19
	IF (JFONT .EQ. 0 .OR. ((.NOT. VSTRP) .AND.
     *	    (KREP .EQ. 4 .OR. (.NOT. KFLAG))))  GO TO 100
C
C...	  STRIPPING MAY BE NECESSARY - ONLY FONT 0 MAY BE USED
	  CALL MSGLG1(142)
	  JFONT = 0
C
C...	OUTPUT SET-FONT COMMAND
  100	CALL OCHUNK (ICMD,0)
C
C...	OUTPUT FONT NUMBER
	CALL OCHUNK (JFONT,0)
C
C...	INITIALIZE THE FONT THE PRISM WILL USE (AND ADD 1)
	PFONT = 1
	IF (JFONT .GE. 15 .AND. JFONT .LE. 19)  PFONT = JFONT - 13
C
	RETURN
C
	END
