	SUBROUTINE SETPAT (IARG)
C
C	NAME: SETPAT
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY
C		REV. C
C		2/21/85		THE CODE THAT CHANGED ITNCLR (THE
C				CURRENT COLOR) HAS BEEN REMOVED.
C
C	SETPAT - SET FILL PATTERN INDEX
C
C	SUBROUTINE SETPAT ALLOWS THE USER TO SET A FILL PATTERN INDEX.
C	ALL SUBSEQUENT CALLS TO SUBROUTINES CONVEX, TONE, AND CIRCLE,
C	WILL NOW REFERENCE THIS INDEX.
C
C	ENTRY:  CALL SETPAT (IARG)
C
C		IARG - FILL PATTERN INDEX
C		0 <= IARG <=255 - ALLOWABLE RANGE
C
C		NOTE:  IF THE PATTERN IS UNDEFINED (DEFPAT NOT CALLED),
C		       OR AN OUT OF RANGE VALUE, AN ERROR MESSAGE IS
C		       OUTPUT AND THE CALL IS IGNORED.
C
C	EXIT:  RETURN
C
C	CALLS:  NONE
C
C	CALLED BY:  USER
C
C	COMMON USED:
C	/DVCOM/
C		I KPAT    - NUMBER OF CURRENTLY ACTIVE TONE PATTERN
C		I MAXPAT  - MAXIMUM NUMBER OF FILL PATTERNS DEFINABLE
C		I NPAT()  - NPAT(I) IS THE NUMBER OF WORDS IN TONE
C		            PATTERN #I
C
C	/MSGCOM/
C		I INTARG()- ARRAY FOR PASSING INTEGER OUTPUT ARGUMENTS
C
C
C	LOCAL VARIABLES:   NONE
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C...	CHECK FOR VALID RANGE
	IF (IARG .LT. 0  .OR. IARG .GT. MAXPAT)  GO TO 10
C
C...	CHECK IF PATTERN #0 SPECIFIED
	IF (IARG .EQ. 0)  GO TO 20
C
C...	CHECK IF PATTERN PREVIOUSLY DEFINED
	IF (NPAT(IARG) .NE. 0)  GO TO 20
C-E
C
C...	PATTERN NOT DEFINED, INFORM USER, RETURN
   10	INTARG(1)=IARG
	CALL MSGLG1(86)
	RETURN
C-E
C
C...	PATTERN PREVIOUSLY DEFINED, SET CURRENT
   20	KPAT = IARG
C
	RETURN
C
	END
