      SUBROUTINE TONCLR ( NCOLOR )
C
C     NAME:  TONCLR
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY
C		REV. C
C		2/21/85		IF COLOR NCOLOR HAS NOT BEEN DEFINED,
C				ITNCLR IS SET TO 1.  (PREVIOUSLY,
C				UNDEFINED COLORS WERE INITIALIZED TO
C				BLACK, SO THIS CHANGE GIVES THE USER
C				THE SAME RESULT.  BECAUSE WE DON'T
C				ALLOW THE USER TO REDEFINE COLORS IN
C				THIS REVISION, WE EITHER HAD TO SET
C				ITNCLR TO 1 OR TURN ON THE DEFINED-
C				COLOR FLAG.)
C
C     THIS ROUTINE CAN BE USED TO SELECT THE COLOR FOR
C     POLYGON AND CIRCLE TONING.
C
C     ENTRY:  CALL TONCLR ( NCOLOR )
C
C               NCOLOR - NUMBER OF TONE COLOR FOR POLYGON TONING.
C
C                        1-256 = PREDEFINED COLORS.
C                      257-512 = USER DEFINED COLORS.
C
C     EXIT:  RETURN.
C
C     CALLS:  NONE.
C
C     CALLED BY:  USER
C
C     COMMON USED:
C       /CLRCOM/
C		I ICLMAX  - NUMBER OF TONE COLORS DEFINED
C		I ITNCLR  - CURRENT TONE COLOR INDEX
C		I IVCFLG  - FLAG TO INDICATE COLOR MODE SET
C
C	/PRMCOM/
C		I IDEFLG  - USER DEFINED COLOR FLAG.
C			    =  0 - UNDEFINED
C			    = -1 - DEFINED DURING INSTALLATION
C			    =  1 - DEFINED WITH DEFCLR CALL
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C
C
	INCLUDE 'CLRCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
C
C...  REPORT AN ERROR IF COLOR MODE NOT SET
      IF ( IVCFLG .NE. 0 )  GOTO 0100
        CALL MSGLG1(89)
        GOTO 9999
C
C...  REPORT AN ERROR IF COLOR NUMBER OUT OF RANGE.
 0100 CONTINUE
      IF ( NCOLOR .GE. 1  .AND.  NCOLOR .LE. ICLMAX )  GOTO 0110
        CALL MSGLG1(90)
        GOTO 9999
C
C...  SET THE CURRENT TONE COLOR.
 0110 CONTINUE
      ITNCLR = NCOLOR
C
C...  IF COLOR NOT DEFINED, USE COLOR 1
      IF (ITNCLR .LE. 256) GO TO 9999
      IF (IDEFLG(ITNCLR-256) .EQ. 0) ITNCLR = 1
C
C...  ALL DONE, EXIT.
 9999 CONTINUE
      RETURN
      END
