	SUBROUTINE TRAP(T)
C
C	NAME: TRAP
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY
C		REV. C
C		2/20/85		THIS SUBROUTINE WAS WRITTEN FOR THIS
C				REVISION.  IT INCLUDES CODE TO STRIP
C				TRAPEZOIDS IN THE Y-DIRECTION, TO
C				UPDATE IBXMAX FOR EACH TRAPEZOID
C				AND TO COUNT BYTES FOR THE PRISM.
C
C	TRAP - STRIP TRAPEZOIDS
C
C	TRAP IS CALLED BY TONE ONCE FOR EACH TRAPEZOID THAT IT
C	GENERATES.  TRAP WILL STRIP THE TRAPEZOID IF NECESSARY IN BOTH
C	THE X AND Y DIRECTIONS.
C
C	IF THE TRAPEZOID EXTENDS BEYOND THE STRIP WIDTH TRAP BREAKS
C	IT INTO SUB-TRAPEZOIDS, EACH OF WHICH IS COMPLETELY CONTAINED
C	IN ONE STRIP.  THE STRIPPING PROCESS GENERATES FROM TWO TO FOUR
C	SUB-TRAPEZOIDS FOR EACH STRIP BOUNDARY CROSSED, DEPENDING ON
C	THE GEOMETRIC RELATION OF THE ORIGINAL TRAPEZOID TO THE
C	STRIPPING BOUNDARY.
C
C	IF THE DELTA X VALUE OF THE TRAPEZOID IS GREATER THAN 13.65', OR
C	IF THE OUTPUT IS GOING TO A REP AND IT CROSSES THE 13.65' MARK,
C	THE TRAPEZOID IS SPLIT AT THE 13.65' MARKS.
C
C	STRIPPING IS A PLOTTING FEATURE THAT IS ONLY RARELY USED.  FOR
C	THIS REASON THIS STRIPPING ALGORITHM WAS CHOSEN SO THAT IT
C	WOULD CAUSE A MINIMUM OF OVERHEAD FOR THE MAJORITY OF
C	PLOTS THAT MAKE NO USE OF THIS FEATURE.
C
C	ENTRY:	CALL TRAP(T)
C
C	       THE TRAPEZOID IS DEFINED BY THE FOUR EDGES -
C		 LOWER SCANLINE - <T(1),T(3)> - <T(1),T(4)>
C		 UPPER SCANLINE - <T(2),T(5)> - <T(2),T(6)>
C		 EDGE 1         - <T(1),T(3)> - <T(2),T(5)>
C		 EDGE 2         - <T(1),T(4)> - <T(2),T(6)>
C
C	       T(1) - X ORDINATE OF LOWER SCANLINE
C	       T(2) - X ORDINATE OF UPPER SCANLINE
C	       T(3),T(4) - Y ORDINATES OF LOWER SCANLINE
C	       T(5),T(6) - Y ORDINATES OF UPPER SCANLINE
C
C	EXIT: THE VALUES IN T ARE UNCHANGED
C
C	CALLS: OCHUNK
C
C	CALLED BY: TONE,RECT
C
C	COMMON USED:
C	/DVCOM/
C		I KPAT    - NUMBER OF CURRENTLY ACTIVE TONE PATTERN
C		L VSFLAG  - .TRUE. IFF STRIPPING IN THE Y-DIRECTION
C		            IS NECESSARY
C		I XNIPS   - NUMBER OF NIBS PER PAGE IN THE X-DIRECTION
C		I YNIPS   - NIBS PER SCAN
C	/VRFCOM/
C		R BYTKNT()- BYTE COUNT FOR EACH COLOR
C		I IBXMAX  - MAXIMUM X VALUE (USED FOR BANDING)
C		R VRFKNT()- COUNTER FOR RANDOM ELEMENTS
C		R OBJKNT()- NUMBER OF EACH TYPE OF OBJECT OUTPUT
C			    OBJKNT(1) - VECTORS
C			    OBJKNT(2) - POLYGONS
C			    OBJKNT(3) - CIRCLES
C			    OBJKNT(4) - CHARACTERS
C		I PRECIS  - COORDINATE PRECISION FOR THE VRF
C		            OUTPUT FILE (16 OR 32-BIT PRECISION)
C       /CLRCOM/
C               I ICLRDF()- ARRAY CONTAINING COLOR DEFINITIONS
C		I ITNCLR  - CURRENT TONE COLOR INDEX
C		I ITNFLG  - USE PEN OR TONE COLOR FOR AREAS
C		I ITNSEQ()- TONING SEQUENCE FOR OUTPUT
C		I NCPASS  - NUMBER OF COLOR PASSES
C
C	/PRMCOM/
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C		I KREP    - TARGET OUTPUT CONTROLLER
C			    = 0 - UNKNOWN
C		            = 1 - REP CONTROLLER
C		            = 4 - RPM CONTROLLER
C	/KLCOM/
C		L KFLAG   - FLAG INDICATING REP OUTPUT AND .GT. 13.65'
C		            PLOTTING REQUIRED.
C		I KSIZE   - VARIABLE DEFINING 13.65' IN SCANS, USED TO
C		            DETERMINE IF ELEMENT CROSSES A 13.65' PAGE
C		            BOUNDARY.
C
C	LOCAL:
C
C	I CONVEX   - DRAW-POLYGON COMMAND (X'8801')
C	R DLTY1,   - DELTA Y OF THE SIDES OF THE TRAPEZOID
C	  DLTY2	     FOR A DELTA X OF SIZE KSIZE
C	I ICOM	   - DRAW-POLYGON COMMAND INCLUDING A DATA WORD COUNT
C	I IPAGE1,  - PAGE NUMBERS FOR THE TOP AND BOTTOM OF THE
C	  IPAGE2     TRAPEZOID, USED FOR X-STRIPPING
C	I IRTN,    - RETURN FLAGS FOR INLINE SUBROUTINES
C	  JRTN
C	I IX1,IX2, - THE TRAPEZOID TO BE OUTPUT
C	  IY1,IY2,
C	  IY3,IY4
C	I IX2SAV,  - SAVED VALUES FOR IX2,IY2,IY4
C	  IY2SAV,
C	  IY4SAV
C	I NTNSEQ() - SAVED VALUE OF ITNSEQ()
C	L SAVED    - .TRUE. IFF A TRAPEZOID HAS BEEN SAVED
C	R SLOPE1,  - SLOPES OF THE SIDES OF THE TRAPEZOID
C	  SLOPE2
C	I X1,X2,   - THE CURRENT TRAPEZOID
C	  Y1,Y2,     X1 - X ORDINATE OF THE LOWER SCANLINE
C	  Y3,Y4      X2 - X ORDINATE OF THE UPPER SCANLINE
C		     Y1,Y3 - Y ORDINATES OF THE LOWER SCANLINE
C		     Y2,Y4 - Y ORDINATES OF THE UPPER SCANLINE
C	I X1SAVE,X2SAVE,Y1SAVE, - THE SAVED TRAPEZOID
C	  Y2SAVE,Y3SAVE,Y4SAVE
C	I XSPLIT - X ORDINATE OF THE NEXT TRAPEZOID SPLIT
C	I YSPLIT - Y ORDINATE OF THE TRAPEZOID SPLIT FOR EITHER
C		   EDGE 1 OR EDGE 2
C
C
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'VRFCOM.CMN'
C
C
	INCLUDE 'CLRCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
	INCLUDE 'KLCOM.CMN'
C
C
	LOGICAL SAVED
	INTEGER T(6),NTNSEQ(4)
	INTEGER X1,X2,Y1,Y2,Y3,Y4,XSPLIT,YSPLIT,TMP
	INTEGER X1SAVE,X2SAVE,Y1SAVE,Y2SAVE,Y3SAVE,Y4SAVE
C
C...	DRAW-POLYGON COMMAND (X'8801')
	INTEGER CONVEX
	DATA CONVEX/34817/
C
C
C	*********************************
C	* DEFINE INTERSECTION FUNCTIONS *
C	*********************************
C
C...	IXINT -- RETURN X ORDINATE OF THE POINT LYING ON THE SEGMENT
C	      (IAX,IAY),(IBX,IBY) WHOSE Y ORDINATE IS IC.
C	THIS FUNCTION IS DERIVED BY TAKING THE TWO POINT FORMULA FOR A
C	LINE AND SOLVING FOR X.
C
	IXINT(IAX,IAY,IBX,IBY,IC) = (IC-IAY) * (IBX-IAX) / (IBY-IAY) + IAX
C
C
C...	IYINT -- RETURN Y ORDINATE OF THE POINT LYING ON THE SEGMENT
C	      (IAX,IAY),(IBX,IBY) WHOSE X ORDINATE IS IC.
C	THIS FUNCTION IS DERIVED BY TAKING THE TWO POINT FORMULA FOR A
C	LINE AND SOLVING FOR Y.
C
	IYINT(IAX,IAY,IBX,IBY,IC) = (IC-IAX) * (IBY-IAY) / (IBX-IAX) + IAY
C
C
C	*************************
C	* BEGIN EXECUTABLE CODE *
C	*************************
C
C...	CALCULATE THE POLYGON COMMAND
	ICOM = 6
	IF (PRECIS .EQ. 32) ICOM = 12
	ICOM = ICOM + CONVEX
C
C...	INITIALIZE THE CURRENT TRAPEZOID -
	X1 = T(1)
	X2 = T(2)
	Y1 = T(3)
	Y2 = T(5)
	Y3 = T(4)
	Y4 = T(6)
C
C...	CHECK THAT THE TRAPEZOID IS ORDERED X1 TO X2
C
	IF ( X1 .LE. X2 ) GOTO 10
C
C...	  SWAP THE UPPER AND LOWER LINES OF THE TRAPEZOID
	  TMP = X1
	  X1  = X2
	  X2  = TMP
	  TMP = Y1
	  Y1  = Y2
	  Y2  = TMP
	  TMP = Y3
	  Y3  = Y4
	  Y4  = TMP
C
C...	VERIFY THAT THE Y-VALUES ARE IN INCREASING ORDER
   10	IF (Y1 .LE. Y3) GOTO 11
	  TMP = Y1
	  Y1  = Y3
	  Y3  = TMP
   11	IF (Y2 .LE. Y4) GOTO 12
	  TMP = Y2
	  Y2  = Y4
	  Y4  = TMP
   12	CONTINUE
C
C...	CHECK WHETHER THE TRAPEZOID NEEDS TO BE STRIPPED
	IF ( .NOT. VSFLAG ) GO TO 110
  100	IF ( Y3 .GE. YNIPS .OR. Y4 .GE. YNIPS ) GO TO 200
C
C...	  THE CURRENT TRAPEZOID DOES NOT NEED TO BE STRIPPED
  110	    IRTN = 999
	    GO TO 900
C
C...	THE CURRENT TRAPEZOID EXTENDS INTO THE NEXT STRIP.
C	CHECK WHETHER IT CROSSES THE STRIPPING BOUNDARY
  200	IF ( Y1 .LT. YNIPS .OR. Y2 .LT. YNIPS ) GO TO 300
C
C...	  THE CURRENT TRAPEZOID IS OUTSIDE OF THE CURRENT STRIP,
C	  ADJUST THE TRAPEZOID TO THE NEXT STRIP AND TRY AGAIN
	  X1 = X1 + XNIPS
	  X2 = X2 + XNIPS
	  Y1 = Y1 - YNIPS
	  Y2 = Y2 - YNIPS
	  Y3 = Y3 - YNIPS
	  Y4 = Y4 - YNIPS
	  GO TO 100
C
C...	THE CURRENT TRAPEZOID CROSSES THE CURRENT STRIPPING BOUNDARY.
C	THIS TEST AND THE ONE AT LABEL 400 CHECK WHETHER EDGE 1
C	CROSSES THE STRIPPING BOUNDARY.
C
  300	SAVED = .FALSE.
	IF ( Y1 .LT. YNIPS ) GO TO 400
C
C...	  EDGE 1 CROSSES THE STRIPPING BOUNDARY - SPLIT THE TRAPEZOID
	  XSPLIT = IXINT( X1, Y1, X2, Y2, YNIPS )
	  YSPLIT = IYINT( X1, Y3, X2, Y4, XSPLIT )
C
C...	  SAVE THE UPPER TRAPEZOID - IT IS OUTSIDE OF THE CURRENT STRIP
	  X1SAVE = X1 + XNIPS
	  X2SAVE = XSPLIT + XNIPS
	  Y1SAVE = Y1 - YNIPS
	  Y2SAVE = 0
	  Y3SAVE = Y3 - YNIPS
	  Y4SAVE = YSPLIT - YNIPS
	  SAVED  = .TRUE.
C
C...	  UPDATE THE CURRENT TRAPEZOID AND CONTINUE PROCESSING
	  X1 = XSPLIT
	  Y1 = YNIPS - 1
	  Y3 = YSPLIT
	  GO TO 600
C
  400	IF ( Y2 .LT. YNIPS ) GO TO 500
C
C...	  EDGE 1 CROSSES THE STRIPPING BOUNDARY - SPLIT THE TRAPEZOID
	  XSPLIT = IXINT( X1, Y1, X2, Y2, YNIPS )
	  YSPLIT = IYINT( X1, Y3, X2, Y4, XSPLIT )
C
C...	  SAVE THE LOWER TRAPEZOID - IT IS OUTSIDE OF THE CURRENT STRIP
	  X1SAVE = XSPLIT + XNIPS
	  X2SAVE = X2 + XNIPS
	  Y1SAVE = 0
	  Y2SAVE = Y2 - YNIPS
	  Y3SAVE = YSPLIT - YNIPS
	  Y4SAVE = Y4 - YNIPS
	  SAVED  = .TRUE.
C
C...	  UPDATE THE CURRENT TRAPEZOID AND CONTINUE PROCESSING
	  X2 = XSPLIT
	  Y2 = YNIPS - 1
	  Y4 = YSPLIT
C
C...	THIS TEST AND THE ONE AT LABEL 600 CHECK WHETHER EDGE 2
C	CROSSES THE STRIPPING BOUNDARY
  500	IF ( Y3 .GE. YNIPS ) GO TO 600
C
C...	  EDGE 2 CROSSES THE STRIPPING BOUNDARY - SPLIT THE TRAPEZOID
	  XSPLIT = IXINT( X1, Y3, X2, Y4, YNIPS )
	  YSPLIT = IYINT( X1, Y1, X2, Y2, XSPLIT )
C
C...	  OUTPUT THE UPPER TRAPEZOID - IT IS ENTIRELY
C	  WITHIN THE CURRENT STRIP
	  IX1 = X1
	  IX2 = XSPLIT
	  IY1 = Y1
	  IY2 = YSPLIT
	  IY3 = Y3
	  IY4 = YNIPS - 1
	  IRTN = 1
	  GO TO 920
C
C...	  UPDATE THE CURRENT TRAPEZOID AND CONTINUE PROCESSING
  550	  X1 = XSPLIT
	  Y1 = YSPLIT
	  Y3 = YNIPS
	  GO TO 700
C
  600	IF ( Y4 .GE. YNIPS ) GO TO 700
C
C...	  EDGE 2 CROSSES THE STRIPPING BOUNDARY - SPLIT THE TRAPEZOID
	  XSPLIT = IXINT( X1, Y3, X2, Y4, YNIPS )
	  YSPLIT = IYINT( X1, Y1, X2, Y2, XSPLIT )
C
C...	  OUTPUT THE LOWER TRAPEZOID - IT IS ENTIRELY
C	  WITHIN THE CURRENT STRIP
	  IX1 = XSPLIT
	  IX2 = X2
	  IY1 = YSPLIT
	  IY2 = Y2
	  IY3 = YNIPS - 1
	  IY4 = Y4
	  IRTN = 2
	  GO TO 920
C
C...	  UPDATE THE CURRENT TRAPEZOID AND CONTINUE PROCESSING
  650	  X2 = XSPLIT
	  Y2 = YSPLIT
	  Y4 = YNIPS
C
  700	CONTINUE
C
C...	NOW WE KNOW THAT EDGE 1 IS LESS THAN THE BOUNDARY
C	AND EDGE 2 IS GREATER THAN THE BOUNDARY.
C	WE SPLIT THE TRAPEZOID AT THE BOUNDARY.
C
C	THE FIRST TRAPEZOID IS TO BE OUTPUT
	IX1 = X1
	IX2 = X2
	IY1 = Y1
	IY2 = Y2
	IY3 = YNIPS - 1
	IY4 = YNIPS - 1
	IRTN = 3
	GO TO 920
C
C...	UPDATE THE CURRENT TRAPEZOID
  750	X1 = X1 + XNIPS
	X2 = X2 + XNIPS
	Y1 = 0
	Y2 = 0
	Y3 = Y3 - YNIPS
	Y4 = Y4 - YNIPS
C
C...	CHECK WHETHER THE CURRENT TRAPEZOID EXTENDS INTO THE NEXT STRIP
	IF ( Y3 .GE. YNIPS .OR. Y4 .GE. YNIPS ) GO TO 500
C
C...	OUTPUT THE CURRENT TRAPEZOID
	IRTN = 4
	GO TO 900
C
C...	CHECK WHETHER A TRAPEZOID HAS BEEN SAVED
  770	IF ( .NOT. SAVED ) RETURN
	X1 = X1SAVE
	X2 = X2SAVE
	Y1 = Y1SAVE
	Y2 = Y2SAVE
	Y3 = Y3SAVE
	Y4 = Y4SAVE
	GO TO 100
C
C...	OUTPUT THE CURRENT TRAPEZOID USING THE INLINE SUBROUTINE
  900	IX1 = X1
	IX2 = X2
	IY1 = Y1
	IY2 = Y2
	IY3 = Y3
	IY4 = Y4
C
  920	CONTINUE
C
C...	CHECK IF X-STRIPPING CHECK REQUIRED
	IF ( .NOT. KFLAG ) GO TO 999
C
C...	CHECK IF STRIPPING REQUIRED
	IPAGE1 = (IX1 + 8)/KSIZE
	IPAGE2 = (IX2 + 8)/KSIZE
	IF ((IX2 - IX1) .GE. KSIZE) GO TO 950
	IF (KREP .EQ. 4) GO TO 999
	IF (IPAGE1 .EQ. IPAGE2) GO TO 999
C
C...	STRIPPING REQUIRED - FIND THE FIRST STRIPPING BOUNDARY
  950	IX2SAV = IX2
	IY2SAV = IY2
	IY4SAV = IY4
	IX2 = (IPAGE1 + 1) * KSIZE - 9
C
C...	CALCULATE THE SLOPE FOR EACH SIDE OF THE TRAPEZOID
	SLOPE1 = FLOAT(IY2-IY1)/FLOAT(IX2SAV - IX1)
	SLOPE2 = FLOAT(IY4-IY3)/FLOAT(IX2SAV - IX1)
	DLTY1 = SLOPE1 * KSIZE
	DLTY2 = SLOPE2 * KSIZE
C
C...	DETERMINE Y-VALUES OF INTERSECTION WITH FIRST BOUNDARY
	YY2 = IY1 + 0.5
	YY4 = IY3 + 0.5
	YY2 = YY2 + SLOPE1 * (IX2 - IX1)
	YY4 = YY4 + SLOPE2 * (IX2 - IX1)
C
  975	CONTINUE
C
C...	OUTPUT CURRENT TRAPEZOID
	IY2 = YY2
	IY4 = YY4
	JRTN = 1
	GO TO 1000
  980	IX1 = IX2 + 1
	IY1 = IY2
	IY3 = IY4
	IX2 = IX2 + KSIZE
	IF (IX2 .GE. IX2SAV) GO TO 990
C
C...	UPDATE CURRENT TRAPEZOID
	YY2 = YY2 + DLTY1
	YY4 = YY4 + DLTY2
	GO TO 975
C
  990	IX2 = IX2SAV
	IY2 = IY2SAV
	IY4 = IY4SAV
C
  999	JRTN = 0
C
C...	INLINE SUBROUTINE: OUTPUT A TRAPEZOID.
C	THE TRAPEZOID STORED IN THE VARIABLES IX1, IX2, IY1, IY2,
C	IY3, AND IY4 IS OUTPUT.
C
C...	OUTPUT FIRST POINT AS A MOVE COMMAND
 1000	CALL OCHUNK(IX1,-1)
	CALL OCHUNK(IY1,-1)
C
C...	OUTPUT DRAW-POLYGON HEADER
	CALL OCHUNK(ICOM,0)
C
C...	CHECK IF TONE COLOR
	IF (ITNFLG .EQ. 0) GO TO 1100
C
C...	** TONE COLOR **
C
C...	SAVE ITNSEQ AND TURN OFF ITNSEQ FOR ALL TONERS
	DO 1025 IBND = 1,NCPASS
	  NTNSEQ(IBND) = ITNSEQ(IBND)
	  ITNSEQ(IBND) = IABS(ITNSEQ(IBND))
 1025	CONTINUE
C
C...	FOR EACH TONER, OUTPUT THE ASSOCIATED PATTERN
	DO 1050 IBND = 1,NCPASS
C
C...	  CHECK IF THE TRAPEZOID IS BEING FILLED WITH THIS TONER
	  IF ( NTNSEQ(IBND) .GE. 0 ) GO TO 1050
C
C...	    TURN ON THIS TONER, OUTPUT THE PATTERN, AND
C	    TURN OFF THE TONER
	      ITNSEQ(IBND) = -ITNSEQ(IBND)
	      CALL OCHUNK( ICLRDF( -ITNSEQ(IBND), ITNCLR ), 0)
	      ITNSEQ(IBND) = -ITNSEQ(IBND)
C
C...	    COUNT BYTES FOR THIS TONER
	      VRFKNT(IBND) = VRFKNT(IBND) + 5.0
	      BYTKNT(IBND) = BYTKNT(IBND) + 24.0
C
 1050	CONTINUE
C
C...	RESET ITNSEQ
	DO 1060 IBND=1,NCPASS
	  ITNSEQ(IBND) = NTNSEQ(IBND)
 1060	CONTINUE
C
	GO TO 1200
C
C...	** HATCH PATTERN AND PEN COLOR **
C
C...	OUTPUT FILL PATTERN INDEX
 1100	CALL OCHUNK(KPAT,0)
C
C...	COUNT BYTES
	DO 1150 IBND=1,NCPASS
	  IF (ITNSEQ(IBND) .GE. 0) GO TO 1150
	  VRFKNT(IBND) = VRFKNT(IBND) + 5.0
	  BYTKNT(IBND) = BYTKNT(IBND) + 24.0
 1150	CONTINUE
C
C...	OUTPUT THE TRAPEZOID
 1200	CALL OCHUNK(IX1,-1)
	CALL OCHUNK(IY3,-1)
	CALL OCHUNK(IX2,-1)
	CALL OCHUNK(IY4,-1)
	CALL OCHUNK(IX2,-1)
	CALL OCHUNK(IY2,-1)
C
C...	COUNT ANOTHER POLYGON
	OBJKNT(2) = OBJKNT(2) + 1.0
C
C...	CHECK IF RETURN TO X-STRIPPING INLINE SUBROUTINE
	IF (JRTN .EQ. 1) GO TO 980
C
C...	UPDATE IBXMAX
	IF (IX2 .GT. IBXMAX) IBXMAX = IX2
C
C...	RETURN FROM INLINE SUBROUTINE
	GO TO ( 550, 650, 750, 770 ), IRTN
	RETURN
	END
