	SUBROUTINE VPORT(VVXMIN,VVXMAX,VVYMIN,VVYMAX)
C
C	NAME: VPORT
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	REVISION HISTORY
C		REV. C
C		2/21/85		CHECK WHETHER VIEWPORT MINIMUMS ARE
C				GREATER THAN PAPER MAXIMUMS ADDED.
C				(NECESSARY IN CASE OF MIRRORING)
C				THE CODE THAT CHECKED THIS IF THE
C				PLOT WAS ROTATED HAS BEEN DISCARDED.
C
C				CODE TO CALCULATE VSFLAG AND VSMAX
C				INCLUDED.
C	VPORT - DEFINE PLOTTING VIEWPORT
C
C	SUBROUTINE VPORT IS CALLED BY A VERSAPLOT RANDOM USER TO DEFINE
C	A RECTANGULAR AREA ON THE PAPER WHERE THE CONTENTS OF THE CLIP-
C	PING WINDOW IS TO BE DISPLAYED.  THE VIEWPORT MAY BE DEFINED
C	AT ANY TIME.  CHANGING THE VIEWPORT HAS NO EFFECT UPON VECTOR
C	OR POLYGON CLIPPING.  THE VIEWPORT IS REINITIALIZED FOR EACH
C	PLOT.
C
C	ENTRY:  CALL VPORT(VVXMIN,VVXMAX,VVYMIN,VVYMAX)
C
C		VVXMIN - X-MINIMUM EDGE OF VIEWPORT
C		VVXMAX - X-MAXIMUM EDGE OF VIEWPORT
C		VVYMIN - Y-MINIMUM EDGE OF VIEWPORT
C		VVYMAX - Y-MAXIMUM EDGE OF VIEWPORT
C
C		NOTE: ALL ARGUMENTS MUST BE POSITIVE VALUES IN THE
C			CURRENT UNITS OF MEASURE AND WITHIN THE
C			BOUNDARIES OF THE PLOTTING AREA.  VALUES OUT-
C			SIDE THE BOUNDARIES ARE IGNORED AND THE ROUTINE
C			RETURNS IMMEDIATELY AFTER OUTPUTTING A MESSAGE.
C			SEE SUBROUTINE PAPER FOR SETTING PAPER LIMITS.
C
C	EXIT:  SUBSEQUENT PLOTTING WILL DISPLAYED IN THE NEW VIEWPORT.
C
C	NOTES:
C
C	IF THE 90 DEGREE PLOT ROTATION OPTION IS IN EFFECT, THE VIEWPORT
C	WILL AUTOMATICALLY BE ROTATED TOO.
C
C	CALLS: CWTV
C
C	CALLED BY: PLOTS, USER PROGRAMS
C
C	COMMON USED:
C	/DVCOM/
C		I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C		I PXMAX   - PAPER MAXIMUM 'X' DIMENSION
C		I PXMIN   - PAPER MINIMUM 'X' DIMENSION
C		I PYMAX   - PAPER MAXIMUM 'Y' DIMENSION
C		I PYMIN   - PAPER MINIMUM 'Y' DIMENSION
C		L ROT90   - IF ROT90 = .TRUE. THEN ROTATE THE PLOT
C		            COUNTERCLOCKWISE 90 DEGREES
C		R VP()    - THE PLOTTING VIEWPORT IN UNITS OF MEASURE
C		L VSFLAG  - .TRUE. IFF STRIPPING IN THE Y-DIRECTION
C		            IS NECESSARY
C		I VSMAX   - MAXIMUM Y-VALUE FOR A STRIPPED VECTOR
C		R XDEN    - NUMBER OF NIBS PER VIEWPORT UNIT IN THE X
C		            DIRECTION
C		R YDEN    - THE NUMBER OF NIBS PER VIEWPORT UNIT IN
C		            THE Y DIRECTION.
C		I YNIPS   - NIBS PER SCAN
C
C	/PRMCOM/
C		I IFONT   - DEFAULT FONT PATTERN NUMBER.
C		L VSTRP   - .TRUE. IFF Y-STRIPPING ENABLED
C
C	/MSGCOM/
C		R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C
C
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'PRMCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C
C
C-D
C...	OUTPUT USER ARGUMENTS
C	 RELARG(1)=VVXMIN
C	 RELARG(2)=VVXMAX
C	 RELARG(3)=VVYMIN
C	 RELARG(4)=VVYMAX
C	 CALL MSGLG1(103)
C-D
C
C	CHECK IF PLOTS HAS BEEN CALLED
	IF (IOPEN .NE. 0) GO TO 10
C
C	PLOTS MUST INITIALIZE BEFORE CALLING; IGNORE THE CALL
	RELARG(1)=VVXMIN
	RELARG(2)=VVXMAX
	RELARG(3)=VVYMIN
	RELARG(4)=VVYMAX
	CALL MSGLG1(103)
	CALL MSGLG1(104)
	GO TO 999
C
C
C...	CHECK FOR VALID CALL
C	ALL VIEWPORT COORDINATES MUST BE POSITIVE.
 10	IF ((VVXMIN .LT. PXMIN) .OR. (VVYMIN .LT. PYMIN)) GO TO 900
	IF ((VVXMAX .LT. PXMIN) .OR. (VVYMAX .LT. PYMIN)) GO TO 900
C
C...	MAXIMUM ORDINATES MUST NOT BE EQUAL TO THE MINIMUM ORDINATES.
	IF ((VVXMAX .EQ. VVXMIN) .OR. (VVYMAX .EQ. VVYMIN)) GO TO 900
C
C...	CHECK IF VPORT GREATER THAN MAXIMUM PLOTTING AREA
	IF ((VVXMAX .GT. PXMAX) .OR. (VVYMAX .GT. PYMAX)) GO TO 900
	IF ((VVXMIN .GT. PXMAX) .OR. (VVYMIN .GT. PYMAX)) GO TO 900
C
C...	CHECK FOR PLOT ROTATION
	IF (ROT90) GO TO 60
C
C...	   SET VIEWPORT
	   VP(1) = VVXMIN
	   VP(2) = VVYMIN
	   VP(3) = VVXMAX
	   VP(4) = VVYMAX
	   GO TO 70
   60	   VP(1) = PYMAX - VVYMAX
	   VP(2) = VVXMIN
	   VP(3) = PYMAX - VVYMIN
	   VP(4) = VVXMAX
C
   70	CALL CWTV
C
C...	DETERMINE IF THE VIEWPORT IS ENTIRELY WITHIN THE FIRST STRIP
C	(WILL Y-STRIPPING BE NECESSARY?)
	VSFLAG = .FALSE.
	IF (.NOT. VSTRP) GO TO 999
	TEMP = VP(4)
	IF (VP(2) .GT. VP(4)) TEMP = VP(2)
	ITEMP = TEMP * YDEN
	IF (ROT90) ITEMP = TEMP * XDEN
	IF (ITEMP .GE. YNIPS) VSFLAG = .TRUE.
	VSMAX = (1+ITEMP/YNIPS)*YNIPS-1
C
	GO TO 999
C
C...	ILLEGAL CALLING ARGUMENTS
C-I
  900	RELARG(1)=VVXMIN
	RELARG(2)=VVXMAX
	RELARG(3)=VVYMIN
	RELARG(4)=VVYMAX
	CALL MSGLG1(103)
	RELARG(1)=PXMIN
	RELARG(2)=PXMAX
	RELARG(3)=PYMIN
	RELARG(4)=PYMAX
	CALL MSGLG1(105)
C-I
C
  999	RETURN
	END
