	SUBROUTINE WINDOW(WMINX,WMAXX,WMINY,WMAXY)
C
C	NAME: WINDOW
C
C	LANGUAGE:  FORTRAN
C
C	OPERATING SYSTEM:  DEC VAX/VMS
C
C	ORDER NUMBER:  5448-SE
C
C	PART NUMBER:  000-025522-001  OCTOBER 1985
C
C	PRODUCT:  DEC VAX/VMS VERSAPLOT COLOR RANDOM 2.0
C
C	VERSATEC, INC., SANTA CLARA, CALIFORNIA 95051
C	A XEROX COMPANY
C
C	Copyright (C) 1985 by Xerox Corporation.  All rights reserved.
C
C	"NOTICE. THIS PROGRAM IS THE EXCLUSIVE PROPERTY OF VERSATEC,
C	INC. AND IS ISSUED IN STRICT CONFIDENCE UNDER A PREARRANGED
C	LICENSE AGREEMENT AND IS NOT TO BE DISCLOSED IN ANY MANNER TO
C	PERSONS OUTSIDE THE LICENSED ORGANIZATION AND SHALL NOT BE
C	REPRODUCED OR DISSEMINATED, IN WHOLE OR PART, TO ANYONE OUTSIDE
C	THE LICENSED ORGANIZATION WITHOUT THE PRIOR WRITTEN APPROVAL OF
C	VERSATEC, INC. UNLESS OTHERWISE PROVIDED FOR BY SUCH LICENSE
C	AGREEMENT.  THIS WORK IS PROTECTED AS AN UNPUBLISHED WORK UNDER
C	THE COPYRIGHT ACT OF 1976."
C
C	WINDOW - DEFINE PLOTTING WINDOW
C
C	WINDOW IS CALLED BY A VERSAPLOT USER TO DEFINE A PLOTTING
C	WINDOW.  VERSAPLOT CLIPS ALL VECTORS AND POLYGONS TO THIS
C	RECTANGULAR VIEWING REGION.  THE VIEWING WINDOW MAY BE REDEFINED
C	AT ANY TIME.
C
C	THE VIEWING WINDOW IS SCALED BY COMMON VARIABLE 'FACT' (SEE
C	SUBROUTINE FACTOR). FOR EXAMPLE, IF FACTOR=2 WHEN WINDOW
C	IS CALLED, THE WINDOW PARAMETERS (WMINX,WMAXX,WMINY,WMAXY)
C	ARE DIVIDED BY 2. THIS HAS THE EFFECT OF ENLARGING THE PLOT
C	WITHIN THE VIEWPORT BY A FACTOR OF TWO.
C
C	ENTRY:  CALL WINDOW(WMINX,WMAXX,WMINY,WMAXY)
C
C		WMINX - X-MINIMUM CLIPPING EDGE
C		WMAXX - X-MAXIMUM CLIPPING EDGE
C		WMINY - Y-MINIMUM CLIPPING EDGE
C		WMAXY - Y-MAXIMUM CLIPPING EDGE
C
C	EXIT:  CURRENT SOFTWARE ORIGIN AND CURRENT PEN POSITION ARE
C	       (0.0,0.0) WITH RESPECT TO THE NEW WINDOW.
C
C	CALLED BY: PLOTS, USER PROGRAMS
C
C	CALLS: CWTV
C
C	COMMON USED:
C	/DVCOM/
C		R FACT    - CURRENT SCALING FACTOR. USED BY *FACTOR*
C		I IOPEN   - SUBROUTINE PLOTS FIRST CALL FLAG
C		L PMOVE   - STATUS OF LAST PLOT CALL (.TRUE.=MOVE)
C		R RORG()  - AN X,Y PAIR WHICH DEFINES THE CURRENT
C		            SOFTWARE ORIGIN. SET BY REORIGIN CALL
C			    TO *PLOT*
C		L ROT90   - IF ROT90 = .TRUE. THEN ROTATE THE PLOT
C		            COUNTERCLOCKWISE 90 DEGREES
C		R VCP()   - CURRENT POINT IN COMPUTATIONAL COORDINATES
C		R WIN()   - THE CURRENT VIEW WINDOW IN COMPUTATIONAL
C		            COORDINATES
C		R WX()    - ARRAY OF X ORDINATES FOR REPRESENTING THE
C		            VIEW WINDOW AS POLYGONS.
C		R WY()    - ARRAY OF Y ORDINATES FOR REPRESENTING THE
C		            VIEW WINDOW AS POLYGONS.
C
C	/MSGCOM/
C		R RELARG()- ARRAY FOR PASSING REAL OUTPUT ARGUMENTS
C
C
C	LOCAL: NONE
C
C	NOTES:
C
C	THE VIEW WINDOW DEFINITION IS STORED IN TWO FORMATS.  ONE IS A
C	FOUR ELEMENT WINDOW DEFINITION USED IN VECTOR CLIPPING.  THIS
C	DEFINITION IS STORED IN THE /DVCOM/ ARRAY WIN().  THE VIEW WIN-
C	DOW MUST ALSO BE STORED IN A POLYGON FORM WHICH IS USED TO CLIP
C	POLYGONS GENERATED BY THE TONE SUBROUTINE.  THE POLYGON DEFINI-
C	TION REQUIRES EIGHT REAL NUMBERS.  IT IS STORED IN THE FIRST
C	FOUR ELEMENTS OF WX() AND WY().
C
C
C
	INCLUDE 'DVCOM.CMN'
C
C
	INCLUDE 'MSGCOM.CMN'
C
C
C
C
C-D   DEBUG MESSAGE
C
C	RELARG(1)=WMINX
C	RELARG(2)=WMAXX
C	RELARG(3)=WMINY
C	RELARG(4)=WMAXY
C	CALL MSGLG1(107)
C
C-D
C
C
C	CHECK IF PLOTS HAS BEEN CALLED
	IF (IOPEN .NE. 0) GO TO 5
C
C	PLOTS MUST INITIALIZE BEFORE CALLING; IGNORE THE CALL
	RELARG(1)=WMINX
	RELARG(2)=WMAXX
	RELARG(3)=WMINY
	RELARG(4)=WMAXY
	CALL MSGLG1(107)
	CALL MSGLG1(108)
	GO TO 999
C
C
C
C...	CHECK FOR LEGAL WINDOW PARAMETERS
 5	IF (WMAXX .EQ. WMINX .OR. WMAXY .EQ. WMINY)  GO TO 900
C
C...	SCALE WINDOW BY FACTOR
	ALMT = 1.0/FACT
C
C...	CHECK FOR PLOT ROTATION
	IF (ROT90) GO TO 10
C
C...	   USE NORMAL WINDOW DEFINITION
	   WIN(1) = WMINX * ALMT
	   WIN(2) = WMINY * ALMT
	   WIN(3) = WMAXX * ALMT
	   WIN(4) = WMAXY * ALMT
	   GO TO 20
C
C...	   USE ROTATED WINDOW DEFINITION
C	   ALL USER GENERATED VECTORS AND POLYGON VERTICES ARE ROTATED
C	   TO A COMPUTATIONAL COORDINATE SYSTEM, WHICH HAS ITS X AXIS
C	   PARALLEL TO THE DIRECTION OF PLOTTER PAPER MOVEMENT.  THIS
C	   COORDINATE SYSTEM IS REFERRED TO AS THE WINDOW COORDINATE
C	   SYSTEM.
C
C	   THE ROTATED WINDOW SYSTEM IS NECESSARY BECAUSE ALL SCAN LINE
C	   PROCESSING IN VERSAPLOT (EG. POLYGON PROCESSING) ASSUMES THAT
C	   SCAN LINES ARE PARALLEL TO THE Y AXIS AND ORIENTED FROM LOW
C	   TO HIGH X VALUES.
C
C	   ALL VECTOR AND POLYGON CLIPPING TAKES PLACE IN THE WINDOW CO-
C	   ORDINATE SYSTEM SO THE VIEWING WINDOW MUST BE ROTATED.
   10	WIN(1) = -WMAXY * ALMT
	   WIN(2) = WMINX * ALMT
	   WIN(3) = -WMINY * ALMT
	   WIN(4) = WMAXX * ALMT
C
C...	RECALCULATE WINDOW TRANSFORM VARIABLES
   20	CALL CWTV
C
C...	SET WINDOW POLYGON FOR TONE PROCESSING
	WX(1) = WIN(1)
	WY(1) = WIN(2)
	WX(2) = WIN(1)
	WY(2) = WIN(4)
	WX(3) = WIN(3)
	WY(3) = WIN(4)
	WX(4) = WIN(3)
	WY(4) = WIN(2)
C
C...	RESET RE-ORIGIN AND CURRENT PEN POSITION
	RORG(1)=0.0
	RORG(2)=0.0
	VCP(1)=0.0
	VCP(2)=0.0
C
C...	SET MOVE FLAG
	PMOVE = .TRUE.
	GO TO 999
C-E
C...	ILLEGAL CALLING PARAMETER
  900	RELARG(1)=WMINX
	RELARG(2)=WMAXX
	RELARG(3)=WMINY
	RELARG(4)=WMAXY
	CALL MSGLG1(107)
	CALL MSGLG1(109)
C-E
C
  999	RETURN
	END
